/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.exception;

import com.crystaldecisions.sdk.exception.ExceptionCodeHandler;

public class SDKExceptionCode {
    public static final int Error_Undefined = SDKExceptionCode.makeSDKExceptionCode(0, 0);
    public static final int Error_SDKException_Undefined = SDKExceptionCode.makeSDKExceptionCode(Error_Undefined);
    public static final int Error_OCAFrameworkException_Undefined = SDKExceptionCode.makeOCAFrameworkExceptionCode(Error_Undefined);
    public static final int Error_SDKBatchException_Undefined = SDKExceptionCode.makeSDKBatchExceptionCode(Error_Undefined);
    public static final int Error_SecurityException_Undefined = SDKExceptionCode.makeSecurityExceptionCode(Error_Undefined);
    public static final int Error_SecurityInfoException_Undefined = SDKExceptionCode.makeSecurityInfoExceptionCode(Error_Undefined);
    public static final int Error_OCAFramework = SDKExceptionCode.makeSDKExceptionCode(42);
    public static final int Error_ServiceFailure = SDKExceptionCode.makeSDKExceptionCode(1);
    public static final int Error_CORBASystem = SDKExceptionCode.makeSDKExceptionCode(2);
    public static final int Error_CORBAUser = SDKExceptionCode.makeSDKExceptionCode(3);
    public static final int Error_URIFormat = SDKExceptionCode.makeSDKExceptionCode(4);
    public static final int Error_FileRead = SDKExceptionCode.makeSDKExceptionCode(5);
    public static final int Error_StreamRead = SDKExceptionCode.makeSDKExceptionCode(6);
    public static final int Error_FileWrite = SDKExceptionCode.makeSDKExceptionCode(7);
    public static final int Error_Unexpected = SDKExceptionCode.makeSDKExceptionCode(8);
    public static final int Error_InvalidPagingIndex = SDKExceptionCode.makeSDKExceptionCode(9);
    public static final int Error_InvalidObjectID = SDKExceptionCode.makeSDKExceptionCode(10);
    public static final int Error_PluginNotFound = SDKExceptionCode.makeSDKExceptionCode(11);
    public static final int Error_PluginNotFoundAtCMS = SDKExceptionCode.makeSDKExceptionCode(12);
    public static final int Error_PluginInitialization = SDKExceptionCode.makeSDKExceptionCode(13);
    public static final int Error_PluginCategory = SDKExceptionCode.makeSDKExceptionCode(14);
    public static final int Error_PropertyNotFound = SDKExceptionCode.makeSDKExceptionCode(15);
    public static final int Error_PropertyReadOnly = SDKExceptionCode.makeSDKExceptionCode(16);
    public static final int Error_InvalidCopyMode = SDKExceptionCode.makeSDKExceptionCode(17);
    public static final int Error_InvalidArg = SDKExceptionCode.makeSDKExceptionCode(18);
    public static final int Error_InvalidOperation = SDKExceptionCode.makeSDKExceptionCode(19);
    public static final int Error_UnexpectedValue = SDKExceptionCode.makeSDKExceptionCode(20);
    public static final int Error_ServiceNotFound = SDKExceptionCode.makeSDKExceptionCode(21);
    public static final int Error_SecurityError = SDKExceptionCode.makeSDKExceptionCode(22);
    public static final int Error_NoRight = SDKExceptionCode.makeSDKExceptionCode(23);
    public static final int Error_InvalidRightKind = SDKExceptionCode.makeSDKExceptionCode(24);
    public static final int Error_NativeError = SDKExceptionCode.makeSDKExceptionCode(25);
    public static final int Error_TimeOut = SDKExceptionCode.makeSDKExceptionCode(26);
    public static final int Error_PageServerError = SDKExceptionCode.makeSDKExceptionCode(27);
    public static final int Error_ConfigurationError = SDKExceptionCode.makeSDKExceptionCode(28);
    public static final int Error_Serialization = SDKExceptionCode.makeSDKExceptionCode(29);
    public static final int Error_UnsupportedEnterpriseVersion = SDKExceptionCode.makeSDKExceptionCode(30);
    public static final int Error_DifferentEnterpriseVersion = SDKExceptionCode.makeSDKExceptionCode(31);
    public static final int Error_DifferentDeployment = SDKExceptionCode.makeSDKExceptionCode(32);
    public static final int Error_NotImplemented = SDKExceptionCode.makeSDKExceptionCode(33);
    public static final int Error_NoRightChildren = SDKExceptionCode.makeSDKExceptionCode(34);
    public static final int Error_ObjectNotFound = SDKExceptionCode.makeSDKExceptionCode(35);
    public static final int Error_SameDeployment = SDKExceptionCode.makeSDKExceptionCode(36);
    public static final int Error_EndOfFile = SDKExceptionCode.makeSDKExceptionCode(37);
    public static final int Error_InvalidCMSSyntax = SDKExceptionCode.makeSDKExceptionCode(38);
    public static final int Error_OutOfRange = SDKExceptionCode.makeSDKExceptionCode(39);
    public static final int Error_ContradictingValues = SDKExceptionCode.makeSDKExceptionCode(40);
    public static final int Error_MultiplePublicationDocumentsNotSupported = SDKExceptionCode.makeSDKExceptionCode(41);
    public static final int Error_AmbiguousDestinationUpdate = SDKExceptionCode.makeSDKExceptionCode(43);
    public static final int Error_TrustedPrincipalConfigError = SDKExceptionCode.makeSDKExceptionCode(44);
    public static final int Error_EncryptionError = SDKExceptionCode.makeSDKExceptionCode(44);
    public static final int Error_SerializationError = SDKExceptionCode.makeSDKExceptionCode(45);
    public static final int Error_InvalidFileError = SDKExceptionCode.makeSDKExceptionCode(46);
    public static final int Error_OriginalObjectHasChanged = SDKExceptionCode.makeSDKExceptionCode(48);
    public static final int Error_InvalidNewPropertyValueNonNegativeOnly = SDKExceptionCode.makeSDKExceptionCode(49);
    public static final int Error_ServerError = SDKExceptionCode.makeOCAFrameworkExceptionCode(15);
    public static final int Error_LogonFailover = SDKExceptionCode.makeOCAFrameworkExceptionCode(1);
    public static final int Error_NotFoundInDirectory = SDKExceptionCode.makeOCAFrameworkExceptionCode(2);
    public static final int Error_InvalidCMSPort = SDKExceptionCode.makeOCAFrameworkExceptionCode(3);
    public static final int Error_CMSSocket = SDKExceptionCode.makeOCAFrameworkExceptionCode(4);
    public static final int Error_ServiceConnection = SDKExceptionCode.makeOCAFrameworkExceptionCode(5);
    public static final int Error_ServiceListing = SDKExceptionCode.makeOCAFrameworkExceptionCode(6);
    public static final int Error_ClusterDown = SDKExceptionCode.makeOCAFrameworkExceptionCode(7);
    public static final int Error_CMSNotUnique = SDKExceptionCode.makeOCAFrameworkExceptionCode(8);
    public static final int Error_AllServersDown = SDKExceptionCode.makeOCAFrameworkExceptionCode(9);
    public static final int Error_CommunicationError = SDKExceptionCode.makeOCAFrameworkExceptionCode(10);
    public static final int Error_ServerGroupNotFound = SDKExceptionCode.makeOCAFrameworkExceptionCode(11);
    public static final int Error_OCAFramework_ServiceNotFound = SDKExceptionCode.makeOCAFrameworkExceptionCode(12);
    public static final int Error_SSLMissingArgument = SDKExceptionCode.makeOCAFrameworkExceptionCode(13);
    public static final int Error_SSLFileOpenError = SDKExceptionCode.makeOCAFrameworkExceptionCode(14);
    public static final int Error_AllServicesDown = SDKExceptionCode.makeOCAFrameworkExceptionCode(16);
    public static final int Error_SecurityInfo_NoRight = SDKExceptionCode.makeSecurityInfoExceptionCode(1);
    public static final int Error_BatchState = SDKExceptionCode.makeSecurityExceptionCode(1);
    public static final int Error_BatchFailure = SDKExceptionCode.makeSecurityExceptionCode(2);

    private static int makeSDKExceptionCode(int baseErrorCode) {
        return SDKExceptionCode.makeSDKExceptionCode(1, baseErrorCode);
    }

    private static int makeOCAFrameworkExceptionCode(int baseErrorCode) {
        return SDKExceptionCode.makeSDKExceptionCode(2, baseErrorCode);
    }

    private static int makeSDKBatchExceptionCode(int baseErrorCode) {
        return SDKExceptionCode.makeSDKExceptionCode(3, baseErrorCode);
    }

    private static int makeSecurityExceptionCode(int baseErrorCode) {
        return SDKExceptionCode.makeSDKExceptionCode(4, baseErrorCode);
    }

    private static int makeSecurityInfoExceptionCode(int baseErrorCode) {
        return SDKExceptionCode.makeSDKExceptionCode(5, baseErrorCode);
    }

    private static int makeSDKExceptionCode(int exceptionClass, int baseErrorCode) {
        return ExceptionCodeHandler.makeCode(false, exceptionClass, baseErrorCode);
    }

    public class ExceptionClasses {
        public static final int UNSPECIFIED = 0;
        public static final int SDKException = 1;
        public static final int OCAFrameworkException = 2;
        public static final int SDKBatchException = 3;
        public static final int SecurityException = 4;
        public static final int SecurityInfoException = 5;
    }
}

