/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.exception;

import com.businessobjects.foundation.exception.IInternalException;
import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.message_id;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.message_type;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.message_union;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.internal.ServerExceptionMap;
import com.crystaldecisions.sdk.exception.internal.ServerMsgResourcesBundle;
import com.crystaldecisions.sdk.holder.internal.IntHolder;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class SDKServerException
extends SDKException
implements IInternalException {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.exception.SDKServerException");
    private static final String RESOURCES = "com/crystaldecisions/sdk/exception/SDKServerExceptionResources";
    private static final String SVRMSG_RESOURCES = "com/crystaldecisions/sdk/exception/internal/ServerMsgResources";
    private String m_errorCodeString;

    protected SDKServerException(oca_abuse e) {
        super(SVRMSG_RESOURCES, null, null, (Throwable)e, ServerExceptionMap.mapServerExceptionCode(e.errCode));
    }

    public static SDKException map(oca_abuse e) {
        return new SDKServerException(e);
    }

    public int getErrorCode() {
        oca_abuse cause = (oca_abuse)this.getCause();
        if (cause != null) {
            return cause.errCode;
        }
        return 0;
    }

    public String getErrorCodeString() {
        message_type type;
        message_union[] messages;
        if (this.m_errorCodeString != null) {
            return this.m_errorCodeString;
        }
        oca_abuse cause = (oca_abuse)this.getCause();
        if (cause != null && (messages = cause.messages) != null && messages.length > 0 && (type = messages[0].discriminator()).equals(message_type.mt_id)) {
            message_id id = messages[0].msgId();
            String errorCode = ServerMsgResourcesBundle.getString(Integer.toString(id.msgId) + "_code", Locale.ENGLISH);
            if (errorCode != null) {
                this.m_errorCodeString = errorCode;
                return this.m_errorCodeString;
            }
        }
        return null;
    }

    public int getFailedObjectID() {
        return 0;
    }

    public String getMessage(Locale locale) {
        StringBuffer buffer = new StringBuffer();
        oca_abuse cause = (oca_abuse)this.getCause();
        if (cause != null) {
            IntHolder indexHolder = new IntHolder();
            indexHolder.set(0);
            message_union[] messages = cause.messages;
            while (indexHolder.get() < messages.length) {
                buffer.append(this.getString(messages, indexHolder, locale));
                buffer.append('\n');
            }
        }
        return buffer.toString();
    }

    public String getDetail() {
        return this.getDetailMessage();
    }

    public String getDetailMessage(Locale locale) {
        StringBuffer buffer = new StringBuffer(this.getMessage(locale));
        oca_abuse cause = (oca_abuse)this.getCause();
        if (cause != null && cause.details != null) {
            buffer.append("\n");
            String pattern = ResourceBundle.getBundle(RESOURCES).getString("DETAILS");
            buffer.append(MessageFormat.format(pattern, cause.details));
            buffer.append('\n');
        }
        return buffer.toString();
    }

    protected String getString(message_union[] messages, IntHolder indexHolder, Locale locale) {
        int index = indexHolder.get();
        message_type type = messages[index].discriminator();
        indexHolder.set(index + 1);
        if (type.equals(message_type.mt_id)) {
            message_id id = messages[index].msgId();
            String pattern = ServerMsgResourcesBundle.getString(Integer.toString(id.msgId), locale);
            Object[] strings = new String[id.num_strings];
            for (int i = 0; i < id.num_strings; ++i) {
                strings[i] = this.getString(messages, indexHolder, locale);
            }
            if (pattern == null) {
                pattern = ServerMsgResourcesBundle.getMissingResourcePattern(locale);
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < strings.length; ++i) {
                    Object string = strings[i];
                    buf.append(string);
                    buf.append(' ');
                }
                return MessageFormat.format(pattern, Integer.toString(id.msgId), buf.toString());
            }
            Format[] formats = new MessageFormat(pattern).getFormats();
            if (formats != null && formats.length > 0) {
                return MessageFormat.format(pattern, strings);
            }
            return pattern;
        }
        if (type.equals(message_type.mt_string)) {
            return messages[index].msgString();
        }
        return "";
    }

    public String constructErrorMessage(ResourceBundle bundle, Locale locale, String strID) {
        return this.getMessage(locale);
    }
}

