/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.audit.internal;

import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Packer;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.audit.IEventDetail;
import com.crystaldecisions.sdk.occa.audit.IEventDetails;
import com.crystaldecisions.sdk.occa.audit.IEventObject;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AuditEventHelper {
    static String toXRL3(IEventObject eventObj, String appObjCUID) throws SDKException {
        WireOb3Packer xlr3Packer = new WireOb3Packer();
        String url = xlr3Packer.pack(AuditEventHelper.toPropertyBag(eventObj, appObjCUID), 0, 0, true);
        return url;
    }

    private static PropertyBag toPropertyBag(IEventObject eventObj, String appObjCUID) throws SDKException {
        PropertyBag bags = new PropertyBag();
        bags.addItem((Object)PropertyIDs.SI_CUID, (Object)appObjCUID, 0);
        bags.addItem((Object)PropertyIDs.SI_EVENT_ID, (Object)new Integer(eventObj.getEventTypeID()), 0);
        bags.addItem((Object)PropertyIDs.SI_USER_ID, (Object)new Integer(eventObj.getUserID()), 0);
        bags.addItem((Object)PropertyIDs.SI_OBJECT_ID, (Object)new Integer(eventObj.getObjectID()), 0);
        bags.addItem((Object)PropertyIDs.SI_DURATION, (Object)new Integer(eventObj.getDuration()), 0);
        bags.addItem((Object)PropertyIDs.SI_OBJECT_CUID, (Object)eventObj.getObjectCUID(), 0);
        bags.addItem((Object)PropertyIDs.SI_ERROR_CODE, (Object)new Integer(eventObj.getErrCode()), 0);
        IEventDetails details = eventObj.getEventDetails();
        int size = details.size();
        PropertyBag detailsBag = bags.addPropertyBag((Object)PropertyIDs.SI_EVENT_DETAILS, null).getPropertyBag();
        detailsBag.addItem((Object)PropertyIDs.SI_TOTAL, (Object)new Integer(size), 0);
        for (int i = 0; i < size; ++i) {
            PropertyBag item = detailsBag.addPropertyBag((Object)PropertyIDs.nameToID(Integer.toString(i + 1)), null).getPropertyBag();
            item.addItem((Object)PropertyIDs.SI_DETAIL_TYPE_ID, (Object)new Integer(((IEventDetail)details.get(i)).getDetailTypeID()), 0);
            item.addItem((Object)PropertyIDs.SI_DETAIL_DESCRIPTION, (Object)((IEventDetail)details.get(i)).getDetailValue(), 0);
        }
        return bags;
    }

    static String toXRL3(List objs, String appObjCUID) throws SDKException {
        PropertyBag bags = new PropertyBag();
        bags.addItem((Object)PropertyIDs.SI_TOTAL, (Object)new Integer(objs.size()), 0);
        for (int i = 0; i < objs.size(); ++i) {
            bags.addItem((Object)PropertyIDs.nameToID(Integer.toString(i + 1)), (Object)AuditEventHelper.toPropertyBag((IEventObject)objs.get(i), appObjCUID), 0);
        }
        WireOb3Packer xlr3Packer = new WireOb3Packer();
        String url = xlr3Packer.pack(bags, 0, 0, true);
        return url;
    }

    static Set getEventIDs(IProperties bag) {
        HashSet IDs = new HashSet();
        if (bag != null) {
            PropertyArrayHelper arrayCol = new PropertyArrayHelper((PropertyBag)bag, PropertyIDs.SI_TOTAL);
            Iterator iter = arrayCol.iterator();
            while (iter.hasNext()) {
                IDs.add(iter.next());
            }
        }
        return IDs;
    }
}

