/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.enadmin.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.common.IConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.INameValuePairs;
import com.businessobjects.sdk.plugin.desktop.enterprisenode.IEnterpriseNode;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAa.OCAAdministrator;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAa.OCAServiceAdmin;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.enadmin.internal.IAdministrator;
import com.crystaldecisions.sdk.occa.enadmin.internal.IInternalAdminService;
import com.crystaldecisions.sdk.occa.enadmin.internal.IServiceAdmin;
import com.crystaldecisions.sdk.occa.enadmin.internal.ServiceAdmin;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.plugin.desktop.server.IServer;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Administrator
implements IAdministrator,
IInternalAdminService {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.enadmin.internal.Administrator");
    private OCAAdministrator m_admin = null;
    private String m_name = null;
    private ServiceAdmin m_svcAdm = null;
    private OCAServiceAdmin m_ocaServiceAdmin;
    private IInfoObject m_server;
    private IInternalInfoStore m_infoStore;
    private String[] m_svcNames;
    private PropertyBag m_metricsBag = null;
    private IEnterpriseNode m_enterpriseNode = null;

    public String getName() {
        return this.m_name;
    }

    public void initialize(String name, Object admin, String uri, IInfoObject serverObj, IInternalInfoStore infoStore) throws SDKException {
        if (admin != null) {
            this.m_admin = (OCAAdministrator)admin;
        }
        if (infoStore != null) {
            this.m_infoStore = infoStore;
        }
        if (this.m_admin == null && this.m_infoStore == null) {
            throw new SDKException.Unexpected();
        }
        this.m_name = name;
        this.m_server = serverObj;
    }

    public String getVersion() throws SDKException {
        String ver = null;
        try {
            ver = this.m_admin.getVersion();
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on the server", (Throwable)e);
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"Corba SystemException", (Throwable)e);
            throw new SDKException.ServerAdminError((Exception)((Object)e));
        }
        return ver;
    }

    public String[] getServiceAdminNames() throws SDKException {
        if (this.m_svcNames == null) {
            try {
                this.m_svcNames = this.m_admin.getServices();
            }
            catch (oca_abuse e) {
                LOG.info((Object)"A problem occurred on the server", (Throwable)e);
                throw SDKException.map(e);
            }
            catch (SystemException e) {
                LOG.info((Object)"Corba SystemException", (Throwable)e);
                throw new SDKException.ServerAdminError((Exception)((Object)e));
            }
        }
        return this.m_svcNames;
    }

    public IServiceAdmin getServiceAdmin() throws SDKException {
        return this.m_svcAdm;
    }

    void initServiceAdmin(String name) throws SDKException {
        block8: {
            String query = "select SI_METRICS from CI_SYSTEMOBJS where SI_KIND = 'Server' and SI_ID = " + this.m_server.getID();
            IInfoObject obj = (IInfoObject)this.m_infoStore.query(query).get(0);
            PropertyBag props = ((PropertyBag)obj.properties()).getPropertyBag((Object)PropertyIDs.SI_METRICS);
            Iterator iter = props.allIterator();
            ArrayList<String> services = new ArrayList<String>();
            while (iter.hasNext()) {
                Property prop = (Property)iter.next();
                if (!prop.isContainer()) continue;
                PropertyBag bag = prop.getPropertyBag();
                services.add(bag.getString((Object)PropertyIDs.SI_NAME));
                if (!bag.getString((Object)PropertyIDs.SI_NAME).equals(name)) continue;
                this.m_metricsBag = bag;
            }
            this.m_svcNames = services.toArray(new String[services.size()]);
            if (this.m_admin != null) {
                try {
                    this.m_ocaServiceAdmin = this.m_admin.getServiceAdmin(name);
                }
                catch (oca_abuse e) {
                    if (name.equals("AuditAdmin")) {
                        throw SDKException.map(e);
                    }
                    if (this.m_metricsBag == null) {
                        throw new SDKException.PropertyNotFound(PropertyIDs.SI_METRICS);
                    }
                }
                catch (SystemException e) {
                    if (name.equals("AuditAdmin")) {
                        throw SDKException.map(e);
                    }
                    if (this.m_metricsBag != null) break block8;
                    throw new SDKException.PropertyNotFound(PropertyIDs.SI_METRICS);
                }
            }
        }
        this.m_svcAdm = new ServiceAdmin(this.m_ocaServiceAdmin, this.m_metricsBag);
    }

    Object getOCAServiceAdmin() {
        return this.m_ocaServiceAdmin;
    }

    String getStringProp(Integer key) throws SDKException {
        String value = (String)this.m_svcAdm.getServerProperty(key);
        return this.replacePlaceHolders(value);
    }

    protected String getStringProp(String name, IConfigProperties configProps) throws SDKException {
        String value = (String)this.m_svcAdm.getServerProperty(name, configProps);
        return this.replacePlaceHolders(value);
    }

    String getStringMetric(String key) throws SDKException {
        return this.m_svcAdm.getMetric(key).toString();
    }

    int getIntProp(Integer key) throws SDKException {
        return this.m_svcAdm.getIntProp(key);
    }

    int getIntSSOProp(String key1, String key2, IConfigProperties configProps) throws SDKException {
        return this.m_svcAdm.getIntSSOProp(key1, key2, configProps);
    }

    protected int getIntProp(String name, IConfigProperties configProps) throws SDKException {
        return this.m_svcAdm.getIntProp(name, configProps);
    }

    int getIntMetric(String key) throws SDKException {
        return this.m_svcAdm.getIntMetric(key);
    }

    long getLongProp(Integer key) throws SDKException {
        return this.m_svcAdm.getLongProp(key);
    }

    long getLongMetric(String key) throws SDKException {
        return this.m_svcAdm.getLongMetric(key);
    }

    boolean getBoolProp(Integer key) throws SDKException {
        return this.m_svcAdm.getBoolProp(key);
    }

    boolean getBoolProp(String name, IConfigProperties configProps) throws SDKException {
        return this.m_svcAdm.getBoolProp(name, configProps);
    }

    boolean getBoolMetric(String key) throws SDKException {
        return this.m_svcAdm.getBoolMetric(key);
    }

    double getDoubleProp(Integer key) throws SDKException {
        return this.m_svcAdm.getDoubleProp(key);
    }

    double getDoubleMetric(String key) throws SDKException {
        return this.m_svcAdm.getDoubleMetric(key);
    }

    private String replacePlaceHolders(String value) throws SDKException {
        if (value.indexOf(37) >= 0 && this.m_server != null) {
            if (this.m_enterpriseNode == null) {
                int enterpriseNodeId = ((IServer)this.m_server).getEnterpriseNodeID();
                this.m_enterpriseNode = (IEnterpriseNode)this.m_infoStore.query("select si_placeholders from ci_systemobjs where si_id = " + enterpriseNodeId).get(0);
            }
            INameValuePairs placeHolders = this.m_enterpriseNode.getPlaceholders();
            Pattern pattern = Pattern.compile("%.+%");
            Matcher matcher = pattern.matcher(value);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                String placeHolder = matcher.group();
                placeHolder = placeHolder.split("%")[1];
                String actualValue = placeHolders.getValue(placeHolder);
                matcher.appendReplacement(buffer, actualValue);
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        return value;
    }
}

