/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.filerepository.internal;

import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqReader;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.filerepository.internal.FileTxHelper;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileTx;
import java.io.File;
import java.io.IOException;

class GetFileTx
implements IFileTx {
    private FileSeqReader m_reader;
    private File m_file;
    private String m_name;
    private String m_localFileName;
    private boolean m_notCommitted;

    GetFileTx(FileSeqReader reader, String frsPath, File file) {
        this.m_reader = reader;
        this.m_file = file;
        this.m_name = frsPath;
        this.m_notCommitted = true;
        try {
            this.m_localFileName = file.getCanonicalPath();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public Object getSource() {
        return this.m_name;
    }

    public Object getDestination() {
        return this.m_localFileName;
    }

    public Object commit() throws SDKException {
        if (this.m_notCommitted) {
            try {
                FileTxHelper.getFile(this.m_file, this.m_reader);
            }
            catch (IOException e) {
                throw new SDKException.FileRead(this.m_name, e);
            }
            FileTxHelper.cleanupTx(this.m_reader);
            this.m_reader = null;
            this.m_notCommitted = false;
        }
        if (this.m_file != null) {
            try {
                return this.m_file.getCanonicalPath();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public void destroy() throws SDKException {
        if (this.m_reader != null) {
            FileTxHelper.releaseTx(this.m_reader);
            this.m_reader = null;
            this.m_file = null;
            this.m_notCommitted = false;
        }
    }
}

