/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.filerepository.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAfs.FileStoreOperations;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileTx;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;

class RemoveFileTx
implements IFileTx {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.filerepository.internal.RemoveFileTx");
    private String m_name;
    private FileStoreOperations m_fileStore;
    private boolean m_notCommitted;

    RemoveFileTx(FileStoreOperations fileStore, String name) {
        this.m_name = name;
        this.m_fileStore = fileStore;
        this.m_notCommitted = true;
    }

    public Object getSource() {
        return this.m_name;
    }

    public Object getDestination() {
        return this.m_name;
    }

    public Object commit() throws SDKException {
        if (this.m_notCommitted) {
            try {
                this.m_fileStore.remove(this.m_name);
                this.m_notCommitted = false;
            }
            catch (oca_abuse abuse) {
                LOG.info((Object)("A problem occurred on server while removing the file " + this.m_name), (Throwable)abuse);
                throw SDKException.map(abuse);
            }
            catch (SystemException e) {
                LOG.info((Object)("A problem occurred while removing the file " + this.m_name), (Throwable)e);
                throw new SDKException.FileRemoveError(this.m_name, (Exception)((Object)e));
            }
        }
        return this.m_name;
    }

    public void destroy() throws SDKException {
        this.m_notCommitted = false;
        this.m_fileStore = null;
    }
}

