/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore;

import com.crystaldecisions.sdk.occa.infostore.IRightIDBase;
import com.crystaldecisions.sdk.occa.infostore.RightsFilterCriterion;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractFilterHelper;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class RightsFilterCriteria
extends AbstractList
implements List {
    private List m_criteria = new ArrayList();
    private Locale m_locale;
    private IFilterHelper m_helper = s_defaultFilterHelper;
    private static IFilterHelper s_defaultFilterHelper = new AbstractFilterHelper(){};

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setHelper(IFilterHelper helper) {
        this.m_helper = helper;
    }

    public IFilterHelper getHelper() {
        return this.m_helper;
    }

    public RightsFilterCriterion add(int filterIndex, int operator, Object value) {
        boolean isNotInOp;
        RightsFilterCriterion retCriterion = null;
        List existing = this.getByFilterIndex(filterIndex);
        HashSet<Object> actualColl = null;
        int actualOperator = operator;
        boolean isInOp = operator == 0 || operator == 2;
        boolean bl = isNotInOp = operator == 1 || operator == 3;
        if (isInOp || isNotInOp) {
            Iterator iterator = existing.iterator();
            while (iterator.hasNext() && retCriterion == null) {
                boolean thisIsNotInOp;
                RightsFilterCriterion criterion = (RightsFilterCriterion)iterator.next();
                int thisOperator = criterion.getOperator();
                boolean thisIsInOp = thisOperator == 0 || thisOperator == 2;
                boolean bl2 = thisIsNotInOp = thisOperator == 1 || thisOperator == 3;
                if (isInOp && thisIsInOp) {
                    if (retCriterion != null) continue;
                    retCriterion = criterion;
                    actualOperator = 2;
                    continue;
                }
                if (!isNotInOp || !thisIsNotInOp || retCriterion != null) continue;
                retCriterion = criterion;
                actualOperator = 3;
            }
        }
        if (retCriterion != null) {
            Object existValue = retCriterion.getValue();
            if (existValue != null || value != null) {
                retCriterion.setOperator(actualOperator);
                actualColl = this.addValueToCollection(existValue, value, false);
                if (actualColl == null && (actualColl = this.addValueToCollection(value, existValue, true)) == null) {
                    actualColl = new HashSet<Object>();
                    actualColl.add(existValue);
                    actualColl.add(value);
                }
                if (actualColl != null) {
                    retCriterion.setValue(actualColl);
                }
            }
        } else {
            retCriterion = new RightsFilterCriterion(filterIndex, operator, value);
            this.m_criteria.add(retCriterion);
        }
        return retCriterion;
    }

    private Collection addValueToCollection(Object valueColl, Object newValue, boolean createNewColl) {
        if (valueColl instanceof Collection) {
            HashSet<Object> actualColl = !(valueColl instanceof Set) || createNewColl ? new HashSet<Object>((Collection)valueColl) : (HashSet<Object>)valueColl;
            if (newValue instanceof Collection) {
                actualColl.addAll((Collection)newValue);
            } else {
                actualColl.add(newValue);
            }
            return actualColl;
        }
        return null;
    }

    public List getByFilterIndex(int filterIndex) {
        ArrayList<RightsFilterCriterion> matching = new ArrayList<RightsFilterCriterion>();
        Iterator iter = this.m_criteria.iterator();
        while (iter.hasNext()) {
            RightsFilterCriterion criterion = (RightsFilterCriterion)iter.next();
            if (criterion.getFilterIndex() != filterIndex) continue;
            matching.add(criterion);
        }
        return matching;
    }

    public List removeByFilterIndex(int filterIndex) {
        ArrayList<RightsFilterCriterion> matching = new ArrayList<RightsFilterCriterion>();
        Iterator iter = this.m_criteria.iterator();
        while (iter.hasNext()) {
            RightsFilterCriterion criterion = (RightsFilterCriterion)iter.next();
            if (criterion.getFilterIndex() != filterIndex) continue;
            matching.add(criterion);
            iter.remove();
        }
        return matching;
    }

    public Object get(int index) {
        return this.m_criteria.get(index);
    }

    public int size() {
        return this.m_criteria.size();
    }

    public Object remove(int index) {
        return this.m_criteria.remove(index);
    }

    public String toString() {
        String ret = "";
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ret = ret + iter.next() + ";";
        }
        return ret;
    }

    public static interface IFilterHelper {
        public boolean filter(IRightIDBase var1, RightsFilterCriterion var2, Locale var3);

        public boolean isUnspecifiedRightsIncludeTypeSpecific();
    }
}

