/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IContainer;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.ISortDimension;
import com.crystaldecisions.sdk.occa.infostore.SearchPattern;
import com.crystaldecisions.sdk.occa.infostore.SortType;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStoreFactory;
import com.crystaldecisions.sdk.occa.infostore.internal.QuerySettings;

public abstract class AbstractContainer
extends AbstractInfoObject
implements IContainer {
    public IInfoObjects getChildren() throws SDKException {
        return this.getChildren(1, null, null);
    }

    public IInfoObjects getChildren(int propertySet, SearchPattern searchPattern, SortType sortType) throws SDKException {
        if (propertySet != 7 && propertySet != 1 && propertySet != 4 && propertySet != 2) {
            throw new SDKException.InvalidArg("propertySet");
        }
        SearchPattern mySearch = new SearchPattern(searchPattern);
        mySearch.setParentID(this.getID());
        SortType mySort = new SortType(sortType);
        if (!mySort.contains(ISortDimension.NAME_ASC) && !mySort.contains(ISortDimension.NAME_DESC)) {
            mySort.addSortDimension(ISortDimension.NAME_ASC);
        }
        IInternalInfoStore is = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA("", this.getSession());
        QuerySettings query = new QuerySettings(is, "CI_INFOOBJECTS,CI_APPOBJECTS", QuerySettings.ToFields(propertySet), QuerySettings.generateWhereClause(mySearch), QuerySettings.getOrderClause(mySort));
        return query.executeQuery();
    }

    public IInfoObject add(String progid) throws SDKException {
        IInternalInfoStore is = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA("", this.getSession());
        IInfoObjects objs = is.newInfoObjectCollection();
        IInfoObject obj = objs.add(is.getPluginMgr().getPluginInfo(progid));
        obj.setParentID(this.getID());
        return obj;
    }

    public IInfoObjects getContents() throws SDKException {
        return this.getContents(1, null, null);
    }

    public IInfoObjects getContents(int propertySet, SearchPattern searchPattern, SortType sortType) throws SDKException {
        if (propertySet != 7 && propertySet != 1 && propertySet != 4 && propertySet != 2) {
            throw new SDKException.InvalidArg("propertySet");
        }
        String mySearch = "SI_PROGID != 'CrystalEnterprise.Folder' AND SI_PROGID != 'CrystalEnterprise.FavoritesFolder' AND SI_PROGID != 'CrystalEnterprise.PersonalCategory' AND SI_PROGID != 'CrystalEnterprise.Category' AND SI_PROGID != 'CrystalEnterprise.Inbox' ";
        SearchPattern mySearchPattern = new SearchPattern(searchPattern);
        SortType mySort = new SortType(sortType);
        if (!mySort.contains(ISortDimension.NAME_ASC) && !mySort.contains(ISortDimension.NAME_DESC)) {
            mySort.addSortDimension(ISortDimension.NAME_ASC);
        }
        mySearch = mySearch + "AND ";
        mySearchPattern.setParentID(this.getID());
        mySearch = mySearch + QuerySettings.generateWhereClause(mySearchPattern);
        IInternalInfoStore is = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA("", this.getSession());
        QuerySettings query = new QuerySettings(is, "CI_INFOOBJECTS,CI_APPOBJECTS", QuerySettings.ToFields(propertySet), mySearch, QuerySettings.getOrderClause(mySort));
        return query.executeQuery();
    }
}

