/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IPrincipalsBase;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRoleID;
import com.crystaldecisions.sdk.occa.infostore.ISecurityPrincipal;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractPrincipalBase;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecUpdateEvent;
import com.crystaldecisions.sdk.occa.security.ISecCacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.ISecurityResult;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

abstract class AbstractPrincipalsBase
implements IPrincipalsBase {
    protected Map m_principals;
    protected IRightID[] m_knownRights;
    protected IRightID[] m_knownLimits;
    protected IRoleID[] m_knownRoles;
    protected ISecuritySession m_session;
    protected boolean m_bGlobalFolderInheritance;
    protected int m_objID;
    protected AbstractSecEventListener m_loadListener;

    public AbstractPrincipalsBase() {
    }

    public AbstractPrincipalsBase(IRightID[] knownRights, IRightID[] knownLimits, IRoleID[] knownRoles, ISecuritySession session, int objID, ISecEventListener parentListener) {
        this.m_principals = new HashMap();
        this.m_knownRights = knownRights;
        this.m_knownLimits = knownLimits;
        this.m_knownRoles = knownRoles;
        this.m_session = session;
        this.m_bGlobalFolderInheritance = true;
        this.m_objID = objID;
        this.makeListener(parentListener);
        if (this.m_knownRights != null && this.m_knownLimits != null && this.m_knownRoles != null) {
            this.m_loadListener.setLoaded(0);
        }
    }

    protected void makeListener(ISecEventListener parentListener) {
        this.m_loadListener = new AbstractSecEventListener(){

            public void update(ISecUpdateEvent event) throws SDKException {
                int eventId;
                if (event != null && (eventId = event.getType()) == 0) {
                    AbstractPrincipalsBase.this.m_knownRights = event.getKnownRights();
                    AbstractPrincipalsBase.this.m_knownLimits = event.getKnownLimits();
                    AbstractPrincipalsBase.this.m_knownRoles = event.getKnownRoles();
                }
            }
        };
        this.m_loadListener.setParent(parentListener);
    }

    protected AbstractPrincipalBase getPrincipal(int id) {
        return (AbstractPrincipalBase)this.m_principals.get(new Integer(id));
    }

    public boolean isGlobalInheritFolders() {
        return this.m_bGlobalFolderInheritance;
    }

    public Iterator iterator() {
        return this.m_principals.values().iterator();
    }

    public int size() {
        return this.m_principals.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        Iterator iter = this.m_principals.values().iterator();
        while (iter.hasNext()) {
            AbstractPrincipalBase principal = (AbstractPrincipalBase)iter.next();
            sb.append(principal.toString());
        }
        sb.append(')');
        return sb.toString();
    }

    abstract AbstractPrincipalBase newPrincipal(int var1, String var2);

    abstract ISecurityResult queryPrincipals(ISecCacheControllerAdmin var1, ISecRightsAdmin var2, int var3, boolean var4) throws SDKException;

    AbstractPrincipalBase putPrincipal(int id, String name) {
        AbstractPrincipalBase op = this.getPrincipal(id);
        if (op == null) {
            op = this.newPrincipal(id, name);
            this.m_principals.put(new Integer(id), op);
        }
        return op;
    }

    void loadPrincipals(ISecCacheControllerAdmin cacheAdmin, ISecRightsAdmin rightsAdmin, int objectID, boolean isUseCache) throws SDKException {
        ISecurityResult result = this.queryPrincipals(cacheAdmin, rightsAdmin, objectID, isUseCache);
        if (result != null && result.getStatus() == 0) {
            ISecurityPrincipal[] principals = (ISecurityPrincipal[])result.getResult();
            for (int i = 0; i < principals.length; ++i) {
                ISecurityPrincipal principal = principals[i];
                this.importPrincipal(principal);
            }
        }
    }

    protected void importPrincipal(ISecurityPrincipal principal) throws SDKException {
        int principalID = principal.getID();
        if (principalID == 0) {
            this.m_bGlobalFolderInheritance = principal.isInheritFolders();
        } else {
            AbstractPrincipalBase op = this.putPrincipal(principalID, principal.getName());
            op.importSecurityInfo(principal);
        }
    }
}

