/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.internal.RightID;
import com.crystaldecisions.sdk.occa.security.internal.ICacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.internal.IRightsAdmin;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

abstract class AbstractRight
extends RightID {
    protected boolean m_inherited = false;
    protected boolean m_dirty;
    protected boolean m_exists;

    protected AbstractRight() {
    }

    public AbstractRight(int id, String description, String category, int collection) {
        super(id, description, category, collection);
    }

    public boolean isInherited() {
        return this.m_inherited;
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public boolean isExisting() {
        return this.m_exists;
    }

    public void setInherited(boolean inherited) {
        this.m_inherited = inherited;
        this.m_dirty = true;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.m_inherited);
        out.writeBoolean(this.m_dirty);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.m_inherited = in.readBoolean();
        this.m_dirty = in.readBoolean();
    }

    protected void update(AbstractRight right) {
        this.setInherited(right.isInherited());
    }

    abstract void loadRights(IRightsAdmin var1, int var2, int var3, String var4, int var5) throws SDKException;

    abstract void preloadRights(ICacheControllerAdmin var1, int var2, int var3, String var4) throws SDKException;

    abstract void saveRights(IRightsAdmin var1, int var2, int var3, String var4) throws SDKException;
}

