/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IRoleID;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecUpdateEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.RoleID;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityRole;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

abstract class AbstractRoleSet
implements Externalizable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.AbstractRoleSet");
    private int m_existing;
    protected Map m_values;
    protected Map m_removed;
    protected ISecuritySession m_session;
    private Map m_knownRoles;
    protected AbstractSecEventListener m_loadListener;

    protected AbstractRoleSet() {
    }

    public AbstractRoleSet(ISecuritySession session, IRoleID[] knownRoles, ISecEventListener listener) {
        this.m_existing = 0;
        this.m_removed = new HashMap();
        this.m_values = new HashMap();
        this.m_session = session;
        this.m_knownRoles = new HashMap();
        if (knownRoles != null) {
            for (int i = 0; i < knownRoles.length; ++i) {
                IRoleID role = knownRoles[i];
                this.m_knownRoles.put(new Integer(role.getID()), role);
            }
        }
        this.makeListener(listener);
        if (knownRoles != null) {
            this.m_loadListener.setLoaded(0);
        }
    }

    protected void makeListener(ISecEventListener listener) {
        this.m_loadListener = new AbstractSecEventListener(){

            public void update(ISecUpdateEvent event) throws SDKException {
                IRoleID[] knownRoles;
                int eventId;
                if (event != null && (eventId = event.getType()) == 0 && (knownRoles = event.getKnownRoles()) != null) {
                    AbstractRoleSet.this.m_knownRoles = new HashMap(knownRoles.length);
                    for (int i = 0; i < knownRoles.length; ++i) {
                        IRoleID role = knownRoles[i];
                        AbstractRoleSet.this.m_knownRoles.put(new Integer(role.getID()), role);
                    }
                }
            }
        };
        this.m_loadListener.setParent(listener);
    }

    protected IRoleID findRoleByID(int id) {
        return (IRoleID)this.m_knownRoles.get(new Integer(id));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            RoleID roleID = (RoleID)iter.next();
            sb.append(roleID);
            sb.append(' ');
        }
        sb.append(')');
        return sb.toString();
    }

    Object addValue(Object role) {
        Object key = this.getKey(role);
        if (this.m_values.put(key, role) == null) {
            ++this.m_existing;
        }
        this.m_removed.remove(key);
        return role;
    }

    Object importValue(Object role) {
        Object key = this.getKey(role);
        role = this.m_values.put(key, role);
        this.m_removed.remove(key);
        return role;
    }

    RoleID getValue(Object key) {
        RoleID value = (RoleID)this.m_values.get(key);
        if (value == null || value.isRemoved()) {
            return null;
        }
        return value;
    }

    Iterator iterator() {
        return new SecuritySetIterator();
    }

    void removeAllValues() {
        Iterator iter = this.m_values.values().iterator();
        while (iter.hasNext()) {
            Object rv = iter.next();
            iter.remove();
            this.m_removed.put(this.getKey(rv), this.createRemovedEntry(rv));
        }
    }

    void removeValue(Object key, Object removedEntry, boolean removeIfExist) {
        Object removed = this.m_values.remove(key);
        if (!removeIfExist || removed != null) {
            this.m_removed.put(key, removedEntry);
        }
    }

    abstract void saveRights(ISecRightsAdmin var1, int var2, int var3) throws SDKException;

    int size() {
        return this.m_values.size();
    }

    void copy(AbstractRoleSet src) {
        this.m_existing = src.m_existing;
        this.m_values.clear();
        this.m_removed.clear();
        this.m_values.putAll(src.m_values);
        this.m_removed.putAll(src.m_removed);
    }

    protected abstract void update(Object var1);

    protected abstract Object getKey(Object var1);

    protected abstract Object createRemovedEntry(Object var1);

    void initFromSerialization(AbstractRoleSet deltaSec) {
        Map modified = deltaSec.m_values;
        Iterator iter = modified.values().iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            this.update(next);
        }
        Set removed = deltaSec.m_removed.keySet();
        Iterator iter2 = removed.iterator();
        while (iter2.hasNext()) {
            Object key = iter2.next();
            Object existingRole = this.m_values.get(key);
            if (existingRole == null) continue;
            this.removeValue(key, this.createRemovedEntry(existingRole), false);
        }
    }

    void initFromSerialization(ISecEventListener parentListener) {
        if (this.m_loadListener == null) {
            this.makeListener(parentListener);
        }
        Iterator iter = this.m_values.values().iterator();
        while (iter.hasNext()) {
            SecurityRole next = (SecurityRole)iter.next();
            next.initFromSerialization(this.m_loadListener);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_values = (HashMap)in.readObject();
        Set removed = (Set)in.readObject();
        this.m_removed = new HashMap(removed.size());
        Iterator iter = removed.iterator();
        while (iter.hasNext()) {
            this.m_removed.put(iter.next(), null);
        }
        this.m_knownRoles = new HashMap();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        HashMap modified = new HashMap();
        Iterator iter = this.m_values.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            SecurityRole role = (SecurityRole)entry.getValue();
            if (!role.isDirty()) continue;
            modified.put(entry.getKey(), role);
        }
        out.writeObject(modified);
        out.writeObject(new HashSet(this.m_removed.keySet()));
    }

    class SecuritySetIterator
    implements Iterator {
        Iterator m_internal;
        Object m_last;

        public SecuritySetIterator() {
            this.m_internal = AbstractRoleSet.this.m_values.values().iterator();
        }

        public boolean hasNext() {
            return this.m_internal.hasNext();
        }

        public Object next() {
            this.m_last = this.m_internal.next();
            return this.m_last;
        }

        public void remove() {
            this.m_internal.remove();
            AbstractRoleSet.this.m_removed.put(AbstractRoleSet.this.getKey(this.m_last), AbstractRoleSet.this.createRemovedEntry(this.m_last));
        }
    }
}

