/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IRightBase;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRightIDBase;
import com.crystaldecisions.sdk.occa.infostore.RightDescriptor;
import com.crystaldecisions.sdk.occa.infostore.RightsFilterCriteria;
import com.crystaldecisions.sdk.occa.infostore.RightsSortCriteria;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractRight;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractRight2;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRightID;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecUpdateEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.RightID;
import com.crystaldecisions.sdk.occa.infostore.internal.RightKey;
import com.crystaldecisions.sdk.occa.infostore.internal.RightsFilterHelper;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityRight2Comparator;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ICacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.internal.IRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.SecurityValidator;
import com.crystaldecisions.sdk.occamgr.internal.OCCAMgrFactory;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class AbstractSecuritySet
implements Externalizable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecuritySet");
    private int m_existing;
    private Map m_values;
    protected Map m_removed;
    protected ISecuritySession m_session;
    protected IPluginMgr m_pluginMgr;
    private Map m_knownRights;
    private Map m_knownRightsByPlugin;
    protected int m_objID;
    protected int m_principalID;
    protected AbstractSecEventListener m_loadListener;

    protected AbstractSecuritySet() {
    }

    public AbstractSecuritySet(ISecuritySession session, IRightID[] knownRights) {
        this.m_existing = 0;
        this.m_removed = new HashMap();
        this.m_values = new HashMap();
        this.m_session = session;
        this.makePluginMgr();
        this.setKnownRightsHelper(knownRights);
    }

    public AbstractSecuritySet(ISecuritySession session, IRightID[] knownRights, int objID, int principalID, ISecEventListener eventListener) {
        this(session, null);
        this.m_objID = objID;
        this.m_principalID = principalID;
        this.makeListener(eventListener);
    }

    protected void makeListener(ISecEventListener eventListener) {
        this.m_loadListener = new AbstractSecEventListener(){

            public void update(ISecUpdateEvent event) throws SDKException {
                int eventId;
                if (event != null && (eventId = event.getType()) == 0) {
                    AbstractSecuritySet.this.m_knownRights = AbstractSecuritySet.this.getKnownRights(event);
                    AbstractSecuritySet.this.m_knownRightsByPlugin = AbstractSecuritySet.this.getKnownRightsByPlugin(event);
                }
            }
        };
        this.m_loadListener.setParent(eventListener);
    }

    private void setKnownRightsHelper(IRightID[] knownRights) {
        this.m_knownRights = new HashMap();
        if (knownRights != null) {
            for (int i = 0; i < knownRights.length; ++i) {
                IRightID right = knownRights[i];
                this.m_knownRights.put(new Integer(right.getID()), right);
            }
        }
    }

    public void setKnownRights(IRightID[] knownRights) {
        this.setKnownRightsHelper(knownRights);
    }

    protected IRightID findRightByID(int id) {
        return (IRightID)this.m_knownRights.get(new Integer(id));
    }

    protected int getRealRightID(int id, Object kind, boolean isOwner) throws SDKException {
        return SecurityValidator.getRealRightID(this.m_pluginMgr, id, kind, isOwner);
    }

    protected String getRealProgID(Object kind) throws SDKException {
        if (kind == null || kind.equals("") || kind instanceof String && "Any".equalsIgnoreCase((String)kind)) {
            return "Any";
        }
        return SecurityValidator.getRealProgID(this.m_pluginMgr, kind);
    }

    protected IRightBase getRight(RightDescriptor right) {
        try {
            String realScope = SecurityValidator.validateScope(right.scope);
            int realRightID = this.getRealRightID(right.id, right.kind, right.isOwner);
            String realKind = this.getRealProgID(right.applicableObjectType);
            return (IRightBase)((Object)this.getValue(new RightKey(realRightID, realScope, realKind)));
        }
        catch (SDKException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("AbstractSecuritySet.getRight - error getting the right(" + right.id + "," + right.kind + ")"), (Throwable)((Object)e));
            }
            return null;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            RightID rightID = (RightID)iter.next();
            sb.append(rightID);
            sb.append(' ');
        }
        sb.append(')');
        return sb.toString();
    }

    public List getView(RightsFilterCriteria filterCriteria, RightsSortCriteria sortCriteria) {
        ArrayList view = new ArrayList();
        this.filterSpecified(filterCriteria, view);
        if (RightsFilterHelper.isFilterUnspecifiedRights(filterCriteria)) {
            if (filterCriteria.getHelper().isUnspecifiedRightsIncludeTypeSpecific()) {
                this.filterUnspecifiedAll(filterCriteria, view);
            } else {
                this.filterUnspecifiedUnique(filterCriteria, view);
            }
        }
        if (sortCriteria != null) {
            Collections.sort(view, new SecurityRight2Comparator(sortCriteria));
        }
        return Collections.unmodifiableList(view);
    }

    private void filterSpecified(RightsFilterCriteria filterCriteria, List view) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            IRightBase right = (IRightBase)iter.next();
            if (right == null || !RightsFilterHelper.match(right, filterCriteria)) continue;
            view.add(right);
        }
    }

    private void filterUnspecifiedAll(RightsFilterCriteria filterCriteria, List view) {
        if (this.m_knownRights == null || this.m_knownRightsByPlugin == null) {
            AbstractSecEventListener.ensureDelayedLoad(0, this.m_loadListener);
        }
        LOG.assertNotNull((Object)this.m_knownRightsByPlugin);
        Map unspecifiedRights = this.m_knownRightsByPlugin;
        if (unspecifiedRights != null) {
            Iterator iter = unspecifiedRights.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String progID = (String)entry.getKey();
                Set pluginRights = (Set)entry.getValue();
                Iterator iter1 = pluginRights.iterator();
                while (iter1.hasNext()) {
                    IRightIDBase filterRight;
                    IPersistRightID persistID = (IPersistRightID)iter1.next();
                    String actualProgID = persistID.getRightPluginType() > 0 ? "Any" : progID;
                    IRightIDBase thisFilterRight = (IRightIDBase)this.makeUnspecifiedRight(persistID, actualProgID, "this");
                    IRightIDBase descFilterRight = (IRightIDBase)this.makeUnspecifiedRight(persistID, actualProgID, "descendants");
                    if (this.getValue(this.getKey(thisFilterRight)) != null || this.getValue(this.getKey(descFilterRight)) != null || !RightsFilterHelper.match(filterRight = (IRightIDBase)this.makeUnspecifiedRight(persistID, actualProgID, ""), filterCriteria)) continue;
                    view.add(filterRight);
                }
            }
        }
    }

    private void filterUnspecifiedUnique(RightsFilterCriteria filterCriteria, List view) {
        if (this.m_knownRights == null || this.m_knownRightsByPlugin == null) {
            AbstractSecEventListener.ensureDelayedLoad(0, this.m_loadListener);
        }
        LOG.assertNotNull((Object)this.m_knownRights);
        Map unspecifiedRights = this.m_knownRights;
        if (unspecifiedRights != null) {
            HashSet<Integer> specifiedRightIDs = new HashSet<Integer>(this.size());
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                IRightBase right = (IRightBase)iter.next();
                if (!right.isSpecified()) continue;
                specifiedRightIDs.add(new Integer(right.getID()));
            }
            iter = unspecifiedRights.values().iterator();
            while (iter.hasNext()) {
                IRightIDBase filterRight;
                IRightID persistID = (IRightID)iter.next();
                if (specifiedRightIDs.contains(new Integer(persistID.getID())) || !RightsFilterHelper.match(filterRight = (IRightIDBase)this.makeUnspecifiedRight((IPersistRightID)persistID, "Any", ""), filterCriteria)) continue;
                view.add(filterRight);
            }
        }
    }

    protected Object makeUnspecifiedRight(IPersistRightID persistID, String applicableKind, String scope) {
        return null;
    }

    Object addValue(Object right) {
        Object key = this.getKey(right);
        if (this.m_values.put(key, right) == null) {
            ++this.m_existing;
        }
        this.m_removed.remove(key);
        return right;
    }

    Object importValue(Object right) {
        Object key = this.getKey(right);
        right = this.m_values.put(key, right);
        this.m_removed.remove(key);
        return right;
    }

    int existing() {
        return this.m_existing;
    }

    public boolean isPendingRemoval() {
        return !this.m_removed.isEmpty();
    }

    RightID getValue(Object key) {
        RightID value = (RightID)this.m_values.get(key);
        if (value == null || value.isRemoved()) {
            return null;
        }
        return value;
    }

    Iterator iterator() {
        return new SecuritySetIterator();
    }

    void loadRights(IRightsAdmin rightsAdmin, int objectID, int principalID, String type, int aggrMode) throws SDKException {
        Iterator iter = this.m_values.values().iterator();
        while (iter.hasNext()) {
            AbstractRight pr = (AbstractRight)iter.next();
            pr.loadRights(rightsAdmin, objectID, principalID, type, aggrMode);
            if (!pr.isExisting()) continue;
            ++this.m_existing;
        }
    }

    void preloadRights(ICacheControllerAdmin cacheAdmin, int objectID, int principalID, String type) throws SDKException {
        Iterator iter = this.m_values.values().iterator();
        while (iter.hasNext()) {
            AbstractRight pr = (AbstractRight)iter.next();
            pr.preloadRights(cacheAdmin, objectID, principalID, type);
        }
    }

    void removeNonExistent() {
        Iterator iter = this.m_values.values().iterator();
        while (iter.hasNext()) {
            AbstractRight rv = (AbstractRight)iter.next();
            if (rv.isExisting()) continue;
            iter.remove();
        }
    }

    void removeAllValues() {
        Iterator iter = this.m_values.values().iterator();
        while (iter.hasNext()) {
            Object rv = iter.next();
            iter.remove();
            this.m_removed.put(this.getKey(rv), this.createRemovedEntry(rv));
        }
    }

    void removeLocal() {
        this.m_values.clear();
    }

    void removeAllNotSetKnownValues() {
        Iterator iter = this.m_knownRights.values().iterator();
        while (iter.hasNext()) {
            IRightID securityID = (IRightID)iter.next();
            int id = securityID.getID();
            if (this.m_values.get(new Integer(id)) != null) continue;
            this.m_removed.put(new Integer(id), new RemovedRight(id));
        }
    }

    void removeValue(Object key, Object removedEntry, boolean removeIfExist) {
        Object removed = this.m_values.remove(key);
        if (!removeIfExist || removed != null) {
            this.m_removed.put(key, removedEntry);
        }
    }

    void saveRights(ISecRightsAdmin rightsAdmin, int objectID, int principalID) throws SDKException {
        AbstractRight2 pr;
        Iterator iter = this.m_removed.values().iterator();
        while (iter.hasNext()) {
            pr = (AbstractRight2)iter.next();
            pr.saveRights(rightsAdmin, objectID, principalID);
        }
        iter = this.m_values.values().iterator();
        while (iter.hasNext()) {
            pr = (AbstractRight2)iter.next();
            pr.saveRights(rightsAdmin, objectID, principalID);
        }
    }

    void saveRights(IRightsAdmin rightsAdmin, int objectID, int principalID, String type) throws SDKException {
        AbstractRight pr;
        Iterator iter = this.m_removed.values().iterator();
        while (iter.hasNext()) {
            pr = (AbstractRight)iter.next();
            pr.saveRights(rightsAdmin, objectID, principalID, type);
        }
        iter = this.m_values.values().iterator();
        while (iter.hasNext()) {
            pr = (AbstractRight)iter.next();
            pr.saveRights(rightsAdmin, objectID, principalID, type);
        }
    }

    int size() {
        return this.m_values.size();
    }

    void copy(AbstractSecuritySet src) {
        this.m_existing = src.m_existing;
        this.m_values.clear();
        this.m_removed.clear();
        this.m_values.putAll(src.m_values);
        this.m_removed.putAll(src.m_removed);
    }

    protected abstract void update(Object var1);

    protected abstract Object getKey(Object var1);

    protected abstract Object createRemovedEntry(Object var1);

    protected Map getKnownRights(ISecUpdateEvent event) throws SDKException {
        return null;
    }

    protected Map getKnownRightsByPlugin(ISecUpdateEvent event) throws SDKException {
        return null;
    }

    void initFromSerialization(AbstractSecuritySet deltaSec) {
        Map modified = deltaSec.m_values;
        Iterator iter = modified.values().iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            this.update(next);
        }
        Map removed = deltaSec.m_removed;
        Iterator iter2 = removed.keySet().iterator();
        while (iter2.hasNext()) {
            Object key = iter2.next();
            Object existingItem = this.m_values.get(key);
            if (existingItem == null) continue;
            this.removeValue(key, this.createRemovedEntry(existingItem), false);
        }
    }

    void initFromSerialization(ISecEventListener parentListener, int objID, int principalID, ISecuritySession session) {
        if (this.m_loadListener == null) {
            this.makeListener(parentListener);
        }
        this.m_objID = objID;
        this.m_principalID = principalID;
        this.m_session = session;
        this.makePluginMgr();
        Iterator iter = this.m_values.values().iterator();
        while (iter.hasNext()) {
            RightID next = (RightID)iter.next();
            next.initFromSerialization(this.m_loadListener);
            if (this.m_pluginMgr == null) continue;
            next.setPluginMgr(this.m_pluginMgr);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_values = (HashMap)in.readObject();
        Set removed = (Set)in.readObject();
        this.m_removed = new HashMap(removed.size());
        Iterator iter = removed.iterator();
        while (iter.hasNext()) {
            this.m_removed.put(iter.next(), null);
        }
        this.m_knownRights = new HashMap();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        HashMap modified = new HashMap();
        Iterator iter = this.m_values.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object right = entry.getValue();
            if (right instanceof AbstractRight) {
                if (!((AbstractRight)right).isDirty()) continue;
                modified.put(entry.getKey(), right);
                continue;
            }
            if (!(right instanceof AbstractRight2) || !((AbstractRight2)right).isDirty()) continue;
            modified.put(entry.getKey(), right);
        }
        out.writeObject(modified);
        out.writeObject(new HashSet(this.m_removed.keySet()));
    }

    private void makePluginMgr() {
        block3: {
            if (this.m_session != null) {
                try {
                    this.m_pluginMgr = (IPluginMgr)OCCAMgrFactory.getOCCAMgr().getOCCAFactory("PluginDistribution").makeOCCA(this.m_session.getAPSName(), this.m_session);
                }
                catch (SDKException e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error((Object)"AbstractSecuritySet - error creating the plugin manager", (Throwable)((Object)e));
                }
            }
        }
    }

    static class RemovedRight2
    extends AbstractRight2 {
        private boolean m_isLimit;

        public RemovedRight2() {
        }

        public RemovedRight2(int id, String objType, String rightScope, boolean isLimit) {
            super(id, "", "", 0, null, null);
            this.m_dirty = true;
            this.m_objType = objType;
            this.m_rightScope = rightScope;
            this.m_isLimit = isLimit;
        }

        protected boolean isRemoved() {
            return true;
        }

        void saveRights(ISecRightsAdmin rightsAdmin, int objectID, int principalID) throws SDKException {
            if (this.m_isLimit) {
                rightsAdmin.removeLimit(new RightDescriptor(this.m_id, null, false, this.m_rightScope, this.m_objType), principalID, objectID);
            } else {
                rightsAdmin.removeRight(new RightDescriptor(this.m_id, null, false, this.m_rightScope, this.m_objType), principalID, objectID);
            }
        }
    }

    static class RemovedRight
    extends AbstractRight {
        public RemovedRight() {
        }

        public RemovedRight(int id) {
            super(id, "", "", 0);
            this.m_dirty = true;
        }

        protected boolean isRemoved() {
            return true;
        }

        void preloadRights(ICacheControllerAdmin cacheAdmin, int objectID, int principalID, String type) throws SDKException {
        }

        void loadRights(IRightsAdmin rightsAdmin, int objectID, int principalID, String type, int aggrMode) throws SDKException {
        }

        void saveRights(IRightsAdmin rightsAdmin, int objectID, int principalID, String type) throws SDKException {
            rightsAdmin.remove(this.m_id, "#" + principalID, "#" + objectID, type);
        }
    }

    class SecuritySetIterator
    implements Iterator {
        Iterator m_internal;
        Object m_last;

        public SecuritySetIterator() {
            this.m_internal = AbstractSecuritySet.this.m_values.values().iterator();
        }

        public boolean hasNext() {
            return this.m_internal.hasNext();
        }

        public Object next() {
            this.m_last = this.m_internal.next();
            return this.m_last;
        }

        public void remove() {
            this.m_internal.remove();
            AbstractSecuritySet.this.m_removed.put(AbstractSecuritySet.this.getKey(this.m_last), AbstractSecuritySet.this.createRemovedEntry(this.m_last));
        }
    }
}

