/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IEffectivePrincipal;
import com.crystaldecisions.sdk.occa.infostore.IEffectivePrincipals;
import com.crystaldecisions.sdk.occa.infostore.IExplicitPrincipals;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IPluginBasedRightIDs;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRoleID;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo2;
import com.crystaldecisions.sdk.occa.infostore.RightDescriptor;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecurityInfo;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRights;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoObjects;
import com.crystaldecisions.sdk.occa.security.ISecCacheController;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.IRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import java.util.Iterator;
import java.util.List;

class BatchSecurityInfo
extends AbstractSecurityInfo
implements ISecurityInfo2,
IPersistRights {
    private List m_objects;

    public BatchSecurityInfo(InfoObjects objs, ISecuritySession session) {
        super(session);
        this.m_objects = objs.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkRight(int rightID, Object rightKind, boolean useCache) throws SDKException {
        this.initializeRights();
        ISecCacheController iSecCacheController = this.m_cache;
        synchronized (iSecCacheController) {
            this.m_cache.batch(useCache);
            try {
                Iterator iter = this.m_objects.iterator();
                while (iter.hasNext()) {
                    IInfoObject object = (IInfoObject)iter.next();
                    this.m_cache.cacheRight(rightID, rightKind, object.getID());
                }
                this.m_cache.commit();
            }
            catch (SDKException e) {
                this.m_cache.rollback();
                throw e;
            }
            catch (Throwable e) {
                this.m_cache.rollback();
                SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
                throw sdke;
            }
        }
        Iterator iter = this.m_objects.iterator();
        while (iter.hasNext()) {
            IInfoObject object = (IInfoObject)iter.next();
            if (this.m_rights.checkRight(rightID, rightKind, object.getID()) == 2) continue;
            return false;
        }
        return true;
    }

    public boolean[] checkRights(int[] rights, Object[] kinds, boolean useCache) throws SDKException {
        IInfoObject object;
        Iterator iter;
        int i;
        if (rights == null || rights.length == 0 || kinds == null || rights.length != kinds.length) {
            throw new SDKException.InvalidArg();
        }
        boolean[] granted = new boolean[rights.length];
        this.initializeRights();
        this.m_cache.batch(useCache);
        try {
            for (i = 0; i < rights.length; ++i) {
                iter = this.m_objects.iterator();
                while (iter.hasNext()) {
                    object = (IInfoObject)iter.next();
                    this.m_cache.cacheRight(rights[i], kinds[i], object.getID());
                }
            }
            this.m_cache.commit();
        }
        catch (SDKException e) {
            this.m_cache.rollback();
            throw e;
        }
        catch (Throwable e) {
            this.m_cache.rollback();
            SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
            throw sdke;
        }
        block5: for (i = 0; i < rights.length; ++i) {
            iter = this.m_objects.iterator();
            while (iter.hasNext()) {
                object = (IInfoObject)iter.next();
                boolean bl = granted[i] = this.m_rights.checkRight(rights[i], kinds[i], object.getID()) == 2;
                if (granted[i]) continue;
                continue block5;
            }
        }
        return granted;
    }

    public boolean checkRight(int rightID, Object rightKind, int principalID, boolean useCache) throws SDKException {
        throw new UnsupportedOperationException();
    }

    public boolean[] checkRights(int[] rights, Object[] kinds, int principalID, boolean useCache) throws SDKException {
        throw new UnsupportedOperationException();
    }

    public IRightID[] getKnownRights() throws SDKException {
        throw new UnsupportedOperationException();
    }

    public IRightID[] getKnownLimits() throws SDKException {
        throw new UnsupportedOperationException();
    }

    public IRoleID[] getKnownRoles() throws SDKException {
        throw new UnsupportedOperationException();
    }

    public IEffectivePrincipals getEffectivePrincipals() throws SDKException {
        throw new UnsupportedOperationException();
    }

    public IEffectivePrincipal getAnyPrincipal(int PrincipalID) throws SDKException {
        throw new UnsupportedOperationException();
    }

    public IExplicitPrincipals getExplicitPrincipals() throws SDKException {
        throw new UnsupportedOperationException();
    }

    public IExplicitPrincipals newExplicitPrincipals() throws SDKException {
        throw new UnsupportedOperationException();
    }

    public IPluginBasedRightIDs getKnownRightsByPlugin() throws SDKException {
        throw new UnsupportedOperationException();
    }

    public boolean checkRight(RightDescriptor right, boolean useCache) throws SDKException {
        throw new UnsupportedOperationException();
    }

    public boolean[] checkRights(RightDescriptor[] rights, boolean useCache) throws SDKException {
        throw new UnsupportedOperationException();
    }

    public boolean checkRight(RightDescriptor right, int principalID, boolean useCache) throws SDKException {
        throw new UnsupportedOperationException();
    }

    public boolean[] checkRights(RightDescriptor[] rights, int principalID, boolean useCache) throws SDKException {
        throw new UnsupportedOperationException();
    }

    public void saveRights(IRightsAdmin dest) throws SDKException {
        throw new UnsupportedOperationException();
    }

    public void saveRights2(ISecRightsAdmin rightsAdmin) throws SDKException {
        throw new UnsupportedOperationException();
    }
}

