/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.occa.infostore.ICalendarDay;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.ISDKElement;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;

class CalendarDay
implements ICalendarDay,
ISDKElement {
    IProperties m_bag;
    private static final int CE_ALL = 0;
    private static final int CE_DAY_SUNDAY = 1;

    CalendarDay(IProperties bag) {
        this.m_bag = bag;
    }

    CalendarDay() {
        this.m_bag = new SDKPropertyBag();
    }

    public void assumeProperties(IProperties bag) {
        this.copyProperty(PropertyIDs.SI_DAYS_NTH_WEEK, bag);
        this.copyProperty(PropertyIDs.SI_DAYS_OF_WEEK, bag);
        this.copyProperty(PropertyIDs.SI_DATES_END_DAY, bag);
        this.copyProperty(PropertyIDs.SI_DATES_END_MONTH, bag);
        this.copyProperty(PropertyIDs.SI_DATES_END_YEAR, bag);
        this.copyProperty(PropertyIDs.SI_DATES_START_DAY, bag);
        this.copyProperty(PropertyIDs.SI_DATES_START_MONTH, bag);
        this.copyProperty(PropertyIDs.SI_DATES_START_YEAR, bag);
        this.m_bag = bag;
    }

    void initialize(int startDay, int startMonth, int startYear, int endDay, int endMonth, int endYear, int dayOfWeek, int weekOfMonth) {
        this.setStartYear(startYear);
        this.setStartMonth(startMonth);
        this.setStartDay(startDay);
        this.setEndYear(endYear);
        this.setEndMonth(endMonth);
        this.setEndDay(endDay);
        this.setDayOfWeek(dayOfWeek);
        this.setWeekNumber(weekOfMonth);
    }

    public int getDayOfWeek() {
        return this.toJavaDayOfWeek(this.getPropInt(PropertyIDs.SI_DAYS_OF_WEEK));
    }

    public int getEndDay() {
        return this.toJavaDay(this.getPropInt(PropertyIDs.SI_DATES_END_DAY));
    }

    public int getEndMonth() {
        return this.toJavaMonth(this.getPropInt(PropertyIDs.SI_DATES_END_MONTH));
    }

    public int getEndYear() {
        return this.toJavaYear(this.getPropInt(PropertyIDs.SI_DATES_END_YEAR));
    }

    public int getStartDay() {
        return this.toJavaDay(this.getPropInt(PropertyIDs.SI_DATES_START_DAY));
    }

    public int getStartMonth() {
        return this.toJavaMonth(this.getPropInt(PropertyIDs.SI_DATES_START_MONTH));
    }

    public int getStartYear() {
        return this.toJavaYear(this.getPropInt(PropertyIDs.SI_DATES_START_YEAR));
    }

    public int getWeekNumber() {
        return this.toJavaWeekOfMonth(this.getPropInt(PropertyIDs.SI_DAYS_NTH_WEEK));
    }

    public void setDayOfWeek(int dayOfWeek) {
        this.m_bag.setProperty((Object)PropertyIDs.SI_DAYS_OF_WEEK, this.toCeDayOfWeek(dayOfWeek));
    }

    public void setEndDay(int day) {
        this.m_bag.setProperty((Object)PropertyIDs.SI_DATES_END_DAY, new Integer(this.toCeDay(day)));
    }

    public void setEndMonth(int month) {
        this.m_bag.setProperty((Object)PropertyIDs.SI_DATES_END_MONTH, new Integer(this.toCeMonth(month)));
    }

    public void setEndYear(int year) {
        this.m_bag.setProperty((Object)PropertyIDs.SI_DATES_END_YEAR, new Integer(this.toCeYear(year)));
    }

    public void setStartDay(int day) {
        this.m_bag.setProperty((Object)PropertyIDs.SI_DATES_START_DAY, new Integer(this.toCeDay(day)));
    }

    public void setStartMonth(int month) {
        this.m_bag.setProperty((Object)PropertyIDs.SI_DATES_START_MONTH, new Integer(this.toCeMonth(month)));
    }

    public void setStartYear(int year) {
        this.m_bag.setProperty((Object)PropertyIDs.SI_DATES_START_YEAR, new Integer(this.toCeYear(year)));
    }

    public void setWeekNumber(int week) {
        this.m_bag.setProperty((Object)PropertyIDs.SI_DAYS_NTH_WEEK, new Integer(this.toCeWeekOfMonth(week)));
    }

    private int toCeDay(int javaDay) {
        if (javaDay == -1) {
            return 0;
        }
        if (javaDay >= 1 && javaDay <= 31) {
            return javaDay;
        }
        throw new IllegalArgumentException();
    }

    private int toJavaDay(int ceDay) {
        if (ceDay == 0) {
            return -1;
        }
        return ceDay;
    }

    private int toCeYear(int javaYear) {
        if (javaYear == -1) {
            return 0;
        }
        if (javaYear >= 1 && javaYear <= 0x10000000) {
            return javaYear;
        }
        throw new IllegalArgumentException();
    }

    private int toJavaYear(int ceYear) {
        if (ceYear == 0) {
            return -1;
        }
        return ceYear;
    }

    private int toCeWeekOfMonth(int javaWeekOfMonth) {
        if (javaWeekOfMonth == -1) {
            return 0;
        }
        if (javaWeekOfMonth >= 1 && javaWeekOfMonth <= 6) {
            return javaWeekOfMonth;
        }
        throw new IllegalArgumentException();
    }

    private int toJavaWeekOfMonth(int ceWeekOfMonth) {
        if (ceWeekOfMonth == 0) {
            return -1;
        }
        return ceWeekOfMonth;
    }

    private int toCeMonth(int javaMonth) {
        if (javaMonth == -1) {
            return 0;
        }
        if (javaMonth >= 0 && javaMonth <= 11) {
            return javaMonth - 0 + 1;
        }
        throw new IllegalArgumentException();
    }

    private int toJavaMonth(int ceMonth) {
        if (ceMonth == 0) {
            return -1;
        }
        return ceMonth - 1 + 0;
    }

    private int toCeDayOfWeek(int javaDayOfWeek) {
        if (javaDayOfWeek == -1) {
            return 0;
        }
        if (javaDayOfWeek >= 1 && javaDayOfWeek <= 7) {
            return javaDayOfWeek - 1 + 1;
        }
        throw new IllegalArgumentException();
    }

    private int toJavaDayOfWeek(int ceDayOfWeek) {
        if (ceDayOfWeek == 0) {
            return -1;
        }
        return ceDayOfWeek - 1 + 1;
    }

    private void copyProperty(Integer propID, IProperties bag) {
        IProperty item = this.m_bag.getProperty(propID);
        if (item != null) {
            bag.setProperty((Object)propID, item.getValue());
        }
    }

    private int getPropInt(Integer propid) {
        IProperty prop = this.m_bag.getProperty(propid);
        if (prop == null) {
            return 0;
        }
        Object value = prop.getValue();
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return integer;
        }
        throw new SDKRuntimeException.Unexpected();
    }

    public void copy(IProperties properties) {
        properties.putAll(this.m_bag);
    }
}

