/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IEffectivePrincipal;
import com.crystaldecisions.sdk.occa.infostore.IEffectivePrincipals;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRoleID;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractPrincipalBase;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractPrincipalsBase;
import com.crystaldecisions.sdk.occa.infostore.internal.EffectivePrincipal;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecEventListener;
import com.crystaldecisions.sdk.occa.security.ISecCacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.ISecurityResult;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;

class EffectivePrincipals
extends AbstractPrincipalsBase
implements IEffectivePrincipals {
    public EffectivePrincipals() {
    }

    public EffectivePrincipals(IRightID[] knownRights, IRightID[] knownLimits, IRoleID[] knownRoles, ISecuritySession session, int objID, ISecEventListener eventListener) {
        super(knownRights, knownLimits, knownRoles, session, objID, eventListener);
    }

    public IEffectivePrincipal get(int id) {
        return (IEffectivePrincipal)((Object)super.getPrincipal(id));
    }

    AbstractPrincipalBase newPrincipal(int id, String name) {
        return new EffectivePrincipal(id, name, this.m_knownRights, this.m_knownLimits, this.m_knownRoles, this.m_session, this.m_objID, this.m_loadListener);
    }

    ISecurityResult queryPrincipals(ISecCacheControllerAdmin cacheAdmin, ISecRightsAdmin rightsAdmin, int objectID, boolean isUseCache) throws SDKException {
        ISecurityResult result;
        try {
            cacheAdmin.batch(isUseCache);
            cacheAdmin.cachePrincipals(objectID);
            cacheAdmin.commit();
            result = rightsAdmin.getPrincipals(objectID);
        }
        catch (SDKException e) {
            cacheAdmin.rollback();
            throw e;
        }
        catch (Throwable e) {
            cacheAdmin.rollback();
            SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
            throw sdke;
        }
        return result;
    }
}

