/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IExplicitLimit;
import com.crystaldecisions.sdk.occa.infostore.IExplicitLimits;
import com.crystaldecisions.sdk.occa.infostore.IPluginBasedRightIDs;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.RightDescriptor;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractRight2;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecuritySet;
import com.crystaldecisions.sdk.occa.infostore.internal.ExplicitLimit;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRightID;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecUpdateEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.PluginBasedRightIDs;
import com.crystaldecisions.sdk.occa.infostore.internal.RightKey;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.SecurityValidator;
import java.util.Iterator;
import java.util.Map;

class ExplicitLimits
extends AbstractSecuritySet
implements IExplicitLimits {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.ExplicitLimits");

    public ExplicitLimits() {
    }

    public ExplicitLimits(ISecuritySession session, IRightID[] knownLimits, int objID, int principalID, ISecEventListener eventListener) {
        super(session, knownLimits, objID, principalID, eventListener);
    }

    public IExplicitLimit get(RightDescriptor request) {
        try {
            String realScope = SecurityValidator.validateScope(request.scope);
            int realRightID = this.getRealRightID(request.id, request.kind, false);
            String realKind = this.getRealProgID(request.applicableObjectType);
            AbstractSecEventListener.ensureDelayedLoad(1, this.m_loadListener);
            return (IExplicitLimit)((Object)this.getValue(new RightKey(realRightID, realScope, realKind)));
        }
        catch (SDKException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ExplicitLimits.get - error getting the limit(" + request.id + "," + request.kind + ")"), (Throwable)((Object)e));
            }
            return null;
        }
    }

    public IExplicitLimit add(RightDescriptor limit) throws SDKException {
        String realKind;
        String realScope = SecurityValidator.validateScope(limit.scope);
        int realRightID = this.getRealRightID(limit.id, limit.kind, false);
        IExplicitLimit right = (IExplicitLimit)((Object)this.getValue(new RightKey(realRightID, realScope, realKind = this.getRealProgID(limit.applicableObjectType))));
        if (right == null) {
            IRightID rightID = this.findRightByID(realRightID);
            String description = "";
            String category = "";
            int collection = 0;
            if (rightID != null) {
                IPersistRightID persistID = (IPersistRightID)rightID;
                description = persistID.getDescriptionID();
                category = persistID.getCategoryID();
                collection = persistID.getCollectionID();
            }
            ExplicitLimit newRight = new ExplicitLimit(realRightID, description, category, collection, realKind, realScope, this.m_pluginMgr, this.m_loadListener);
            newRight.m_dirty = true;
            this.addValue(newRight);
            return newRight;
        }
        return right;
    }

    public void remove(RightDescriptor limit) throws SDKException {
        String realScope = SecurityValidator.validateScope(limit.scope);
        int realRightID = this.getRealRightID(limit.id, limit.kind, false);
        String realKind = this.getRealProgID(limit.applicableObjectType);
        this.removeValue(new RightKey(realRightID, realScope, realKind), new AbstractSecuritySet.RemovedRight2(realRightID, realKind, realScope, true), false);
    }

    public Iterator iterator() {
        AbstractSecEventListener.ensureDelayedLoad(1, this.m_loadListener);
        return super.iterator();
    }

    public int size() {
        AbstractSecEventListener.ensureDelayedLoad(1, this.m_loadListener);
        return super.size();
    }

    protected Object createRemovedEntry(Object right) {
        ExplicitLimit right2 = (ExplicitLimit)right;
        return new AbstractSecuritySet.RemovedRight2(right2.getID(), right2.getObjectType(), right2.getScope(), true);
    }

    protected Object getKey(Object right) {
        IExplicitLimit right2 = (IExplicitLimit)right;
        return new RightKey(right2.getID(), right2.getScope(), right2.getObjectType());
    }

    protected void update(Object delta) {
        ExplicitLimit deltaLimit = (ExplicitLimit)delta;
        int id = deltaLimit.getID();
        ExplicitLimit limit = (ExplicitLimit)this.get(deltaLimit.getLimitDescriptor());
        if (limit == null) {
            IRightID rightID = this.findRightByID(id);
            String description = "";
            String category = "";
            int collection = 0;
            if (rightID != null) {
                IPersistRightID persistID = (IPersistRightID)rightID;
                description = persistID.getDescriptionID();
                category = persistID.getCategoryID();
                collection = persistID.getCollectionID();
            }
            ExplicitLimit newLimit = new ExplicitLimit(id, description, category, collection, "", "", this.m_pluginMgr, this.m_loadListener);
            newLimit.update(deltaLimit);
            this.addValue(newLimit);
        } else {
            limit.update(deltaLimit);
        }
    }

    public IExplicitLimit importHiddenLimit(IExplicitLimit limit) {
        ExplicitLimit newLimit = new ExplicitLimit(limit, null, null, 0, this.m_pluginMgr, (ISecEventListener)this.m_loadListener);
        this.importValue(newLimit);
        return newLimit;
    }

    void importExplicitLimit(IExplicitLimit limit) {
        Object rightKey = this.getKey(limit);
        AbstractRight2 ar = (AbstractRight2)this.getValue(rightKey);
        if (ar == null) {
            ar = (AbstractRight2)this.m_removed.get(rightKey);
        }
        if (ar == null || !ar.isDirty()) {
            IPersistRightID limitID = (IPersistRightID)this.findRightByID(limit.getID());
            if (limitID != null) {
                ExplicitLimit rightCP = new ExplicitLimit(limit, limitID.getDescriptionID(), limitID.getCategoryID(), limitID.getCollectionID(), this.m_pluginMgr, (ISecEventListener)this.m_loadListener);
                this.importValue(rightCP);
            } else {
                this.importHiddenLimit(limit);
            }
        }
    }

    void importLimit(IExplicitLimit limit) {
        AbstractRight2 ar;
        IPersistRightID persistID = (IPersistRightID)this.findRightByID(limit.getID());
        if (!(persistID == null || (ar = (AbstractRight2)this.getValue(this.getKey(limit))) != null && ar.isDirty())) {
            ExplicitLimit rightCP = new ExplicitLimit(limit, persistID.getDescriptionID(), persistID.getCategoryID(), persistID.getCollectionID(), this.m_pluginMgr, (ISecEventListener)this.m_loadListener);
            this.importValue(rightCP);
        }
    }

    public void serializeHelper(PropertyArrayHelper arrayhelper) {
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            ExplicitLimit limit = (ExplicitLimit)itr.next();
            PropertyBag bag = arrayhelper.add(null, 0x8000000).getPropertyBag();
            limit.serializeHelper(bag);
        }
    }

    protected Map getKnownRights(ISecUpdateEvent event) throws SDKException {
        IPluginBasedRightIDs rights = event.getKnownRightsByPlugin();
        if (rights != null) {
            return ((PluginBasedRightIDs)rights).getUniqueLimits();
        }
        return null;
    }

    protected Map getKnownRightsByPlugin(ISecUpdateEvent event) throws SDKException {
        IPluginBasedRightIDs rights = event.getKnownRightsByPlugin();
        if (rights != null) {
            return rights.getPluginLimits();
        }
        return null;
    }

    void initFromSerialization(ISecEventListener parentListener, int objID, int principalID, ISecuritySession session) {
        super.initFromSerialization(parentListener, objID, principalID, session);
        Iterator iter = this.m_removed.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getValue() != null) continue;
            RightKey key = (RightKey)entry.getKey();
            entry.setValue(new AbstractSecuritySet.RemovedRight2(key.getID(), key.getApplicableKind(), key.getScope(), true));
        }
    }
}

