/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IExplicitRight;
import com.crystaldecisions.sdk.occa.infostore.IExplicitRights;
import com.crystaldecisions.sdk.occa.infostore.IPluginBasedRightIDs;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRightsView;
import com.crystaldecisions.sdk.occa.infostore.RightDescriptor;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractRight2;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecuritySet;
import com.crystaldecisions.sdk.occa.infostore.internal.ExplicitRight;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRightID;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecUpdateEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.PluginBasedRightIDs;
import com.crystaldecisions.sdk.occa.infostore.internal.RightKey;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.SecurityValidator;
import java.util.Iterator;
import java.util.Map;

class ExplicitRights
extends AbstractSecuritySet
implements IExplicitRights,
IRightsView {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.ExplicitRights");

    public ExplicitRights() {
    }

    public ExplicitRights(ISecuritySession session, IRightID[] knownRights, int objID, int principalID, ISecEventListener eventListener) {
        super(session, knownRights, objID, principalID, eventListener);
    }

    public IExplicitRight get(RightDescriptor right) {
        AbstractSecEventListener.ensureDelayedLoad(1, this.m_loadListener);
        return (IExplicitRight)this.getRight(right);
    }

    public IExplicitRight add(RightDescriptor right) throws SDKException {
        String realKind;
        String realScope = SecurityValidator.validateScope(right.scope);
        int realRightID = this.getRealRightID(right.id, right.kind, right.isOwner);
        IExplicitRight existRight = (IExplicitRight)((Object)this.getValue(new RightKey(realRightID, realScope, realKind = this.getRealProgID(right.applicableObjectType))));
        if (existRight == null) {
            IRightID rightID = this.findRightByID(realRightID);
            String description = "";
            String category = "";
            int collection = 0;
            if (rightID != null) {
                IPersistRightID persistID = (IPersistRightID)rightID;
                description = persistID.getDescriptionID();
                category = persistID.getCategoryID();
                collection = persistID.getCollectionID();
            }
            ExplicitRight newRight = new ExplicitRight(realRightID, description, category, collection, realKind, realScope, this.m_pluginMgr, this.m_loadListener);
            newRight.setGranted(false);
            this.addValue(newRight);
            return newRight;
        }
        return existRight;
    }

    public void remove(RightDescriptor right) throws SDKException {
        String realScope = SecurityValidator.validateScope(right.scope);
        int realRightID = this.getRealRightID(right.id, right.kind, right.isOwner);
        String realKind = this.getRealProgID(right.applicableObjectType);
        this.removeValue(new RightKey(realRightID, realScope, realKind), new AbstractSecuritySet.RemovedRight2(realRightID, realKind, realScope, false), false);
    }

    public Iterator iterator() {
        AbstractSecEventListener.ensureDelayedLoad(1, this.m_loadListener);
        return super.iterator();
    }

    public int size() {
        AbstractSecEventListener.ensureDelayedLoad(1, this.m_loadListener);
        return super.size();
    }

    public IExplicitRight importHiddenRight(IExplicitRight right) {
        ExplicitRight newRight = new ExplicitRight(right, null, null, 0, null, this.m_pluginMgr, this.m_loadListener);
        this.importValue(newRight);
        return newRight;
    }

    protected Object makeUnspecifiedRight(IPersistRightID persistID, String applicableKind, String scope) {
        ExplicitRight unspecifiedRight = new ExplicitRight(persistID.getID(), persistID.getDescriptionID(), persistID.getCategoryID(), persistID.getCollectionID(), applicableKind, scope, this.m_pluginMgr, this.m_loadListener);
        unspecifiedRight.setSpeficied(false);
        return unspecifiedRight;
    }

    public void addHidden(IExplicitRight right) {
        this.addValue(right);
    }

    void importExplicitRight(IExplicitRight right) {
        Object rightKey = this.getKey(right);
        AbstractRight2 ar = (AbstractRight2)this.getValue(rightKey);
        if (ar == null) {
            ar = (AbstractRight2)this.m_removed.get(rightKey);
        }
        if (ar == null || !ar.isDirty()) {
            IPersistRightID rightID = (IPersistRightID)this.findRightByID(right.getID());
            if (rightID != null) {
                ExplicitRight rightCP = new ExplicitRight(right, rightID.getDescriptionID(), rightID.getCategoryID(), rightID.getCollectionID(), null, this.m_pluginMgr, this.m_loadListener);
                this.importValue(rightCP);
            } else {
                this.importHiddenRight(right);
            }
        }
    }

    public void importRight(IExplicitRight right) {
        IExplicitRight ar = this.get(new RightDescriptor(right.getBaseID(), new Integer(right.getRightPluginType()), right.isOwner(), right.getScope(), right.getObjectType()));
        if (ar == null) {
            int id = right.getID();
            IRightID rightID = this.findRightByID(id);
            String description = "";
            String category = "";
            int collection = 0;
            if (rightID != null) {
                IPersistRightID persistID = (IPersistRightID)rightID;
                description = persistID.getDescriptionID();
                category = persistID.getCategoryID();
                collection = persistID.getCollectionID();
            }
            ExplicitRight newRight = new ExplicitRight(right, description, category, collection, null, this.m_pluginMgr, this.m_loadListener);
            this.importValue(newRight);
        }
    }

    protected Object createRemovedEntry(Object right) {
        ExplicitRight right2 = (ExplicitRight)right;
        return new AbstractSecuritySet.RemovedRight2(right2.getID(), right2.getObjectType(), right2.getScope(), false);
    }

    protected Object getKey(Object right) {
        IExplicitRight right2 = (IExplicitRight)right;
        return new RightKey(right2.getID(), right2.getScope(), right2.getObjectType());
    }

    protected void update(Object delta) {
        IExplicitRight deltaRight = (IExplicitRight)delta;
        int id = deltaRight.getID();
        ExplicitRight right = (ExplicitRight)this.get(deltaRight.getRightDescriptor());
        if (right == null) {
            IRightID rightID = this.findRightByID(id);
            String description = "";
            String category = "";
            int collection = 0;
            if (rightID != null) {
                IPersistRightID persistID = (IPersistRightID)rightID;
                description = persistID.getDescriptionID();
                category = persistID.getCategoryID();
                collection = persistID.getCollectionID();
            }
            ExplicitRight newRight = new ExplicitRight(deltaRight, description, category, collection, null, this.m_pluginMgr, this.m_loadListener);
            newRight.update((AbstractRight2)((Object)deltaRight));
            this.importValue(newRight);
        } else {
            right.update((AbstractRight2)((Object)deltaRight));
        }
    }

    public void serializeHelper(PropertyArrayHelper arrayhelper) {
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            ExplicitRight right = (ExplicitRight)itr.next();
            PropertyBag bag = arrayhelper.add(null, 0x8000000).getPropertyBag();
            right.serializeHelper(bag);
        }
    }

    protected Map getKnownRights(ISecUpdateEvent event) throws SDKException {
        IPluginBasedRightIDs rights = event.getKnownRightsByPlugin();
        if (rights != null) {
            return ((PluginBasedRightIDs)rights).getUniqueRights();
        }
        return null;
    }

    protected Map getKnownRightsByPlugin(ISecUpdateEvent event) throws SDKException {
        IPluginBasedRightIDs rights = event.getKnownRightsByPlugin();
        if (rights != null) {
            return rights.getPluginRights();
        }
        return null;
    }

    void initFromSerialization(ISecEventListener parentListener, int objID, int principalID, ISecuritySession session) {
        super.initFromSerialization(parentListener, objID, principalID, session);
        Iterator iter = this.m_removed.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getValue() != null) continue;
            RightKey key = (RightKey)entry.getKey();
            entry.setValue(new AbstractSecuritySet.RemovedRight2(key.getID(), key.getApplicableKind(), key.getScope(), false));
        }
    }
}

