/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.exception.SILibException;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.uri.FrsURL;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKExceptionsCollector;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileRepository;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileRepositoryObject;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileTx;
import com.crystaldecisions.sdk.occa.infostore.IFile;
import com.crystaldecisions.sdk.occa.infostore.IFiles;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.ILocalFile;
import com.crystaldecisions.sdk.occa.infostore.IRemoteFile;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo2;
import com.crystaldecisions.sdk.occa.infostore.IStreamingUploadFile;
import com.crystaldecisions.sdk.occa.infostore.internal.FileOpRecord;
import com.crystaldecisions.sdk.occa.infostore.internal.FileOpType;
import com.crystaldecisions.sdk.occa.infostore.internal.IFileSizeListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecurityFiles;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStoreFactory;
import com.crystaldecisions.sdk.occa.infostore.internal.LocalFile;
import com.crystaldecisions.sdk.occa.infostore.internal.LocalStream;
import com.crystaldecisions.sdk.occa.infostore.internal.LocalStreamingUploadFile;
import com.crystaldecisions.sdk.occa.infostore.internal.NewRemoteFile;
import com.crystaldecisions.sdk.occa.infostore.internal.ObjectRelatives;
import com.crystaldecisions.sdk.occa.infostore.internal.RemoteFile;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityInfoException;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occamgr.internal.OCCAMgrFactory;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;

class Files
extends AbstractList
implements IFiles,
ISecurityFiles,
IFileSizeListener,
Externalizable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.Files");
    private static final String CLS_FRSFilePutID = "FRSFilePutID";
    private static final String CLS_FRSFileRemovalID = "FRSFileRemovalID";
    private static final String PROP_FRSNAME = "FRSName";
    private static final String PROP_TRANSFERID = "TransferID";
    private static final String PROP_FILEWRITERIOR = "FileWriterIOR";
    private static final String PROP_FRSURL = "FRSUrl";
    private IFileRepository m_frs;
    ISecuritySession m_session;
    private String m_destFolder;
    private String m_pathURL;
    private PropertyArrayHelper m_bag;
    private PropertyBag m_propBag;
    private List m_elements;
    private List m_removedFileURLs = null;
    private ISecurityInfo2 m_securityInfo;
    private static final String SI_VALUE = "SI_VALUE";
    private boolean m_enforceDownloadRight;
    private int m_downloadRightID;
    private List m_fileOps;
    private boolean m_bUploadContent = Boolean.getBoolean("businessobjects.object.files.uploadpromptly");
    private int m_infoObjID;
    private InfoObject m_infoObj;
    private boolean m_sharedDocs = false;

    void saveOps(SDKPropertyBag destBag) {
        PropertyArrayHelper helper = new PropertyArrayHelper((PropertyBag)destBag, PropertyIDs.SI_TOTAL);
        Iterator iter = this.m_fileOps.iterator();
        while (iter.hasNext()) {
            FileOpRecord record = (FileOpRecord)iter.next();
            record.save(helper.add(null, 0x8000000).getPropertyBag());
        }
    }

    void doOps(SDKPropertyBag fileOpBag) throws SDKException {
        PropertyArrayHelper helper = new PropertyArrayHelper((PropertyBag)fileOpBag, PropertyIDs.SI_TOTAL);
        Iterator itr = helper.iterator();
        while (itr.hasNext()) {
            PropertyBag bag = (PropertyBag)itr.next();
            FileOpRecord record = new FileOpRecord(bag);
            if (record.type == FileOpType.ADD) {
                this.addHelper(record);
                continue;
            }
            if (record.type == FileOpType.REPLACE) {
                this.replaceHelper(record);
                continue;
            }
            if (record.type == FileOpType.REMOVE) {
                this.remove(record.index);
                continue;
            }
            if (record.type != FileOpType.APPEND) continue;
            this.appendHelper(record);
        }
    }

    public void setEnforceDownloadRight(boolean enforce, int rightID) {
        this.m_enforceDownloadRight = enforce;
        this.m_downloadRightID = rightID;
    }

    public void checkDownloadRight() throws SDKException {
        if (this.m_enforceDownloadRight) {
            this.checkRight(this.m_downloadRightID);
        }
    }

    void initialize(PropertyBag bag, String pathURL, ISecuritySession session, InfoObject infoObj) {
        this.m_pathURL = pathURL;
        this.m_infoObjID = infoObj.getID();
        this.setupProperties(bag, session, true, null, false);
        this.m_infoObj = infoObj;
    }

    void readFrom(PropertyBag bag, ISecuritySession session, ISecurityInfo2 securityInfo, boolean initFiles, InfoObject infoObj, List fileOps, boolean srcIsNew) {
        this.m_infoObjID = infoObj.getID();
        this.m_securityInfo = securityInfo;
        this.m_infoObj = infoObj;
        this.m_pathURL = bag.getString((Object)PropertyIDs.SI_PATH);
        boolean isPropChanged = false;
        if (this.m_pathURL == null) {
            Property property2 = bag.getItem((Object)PropertyIDs.SI_NUM_FILES);
            if (property2 == null) {
                bag.setProperty((Object)PropertyIDs.SI_NUM_FILES, 0);
            }
            this.m_pathURL = this.m_infoObj.createFrsUrl();
            isPropChanged = true;
        }
        this.setupProperties(bag, session, initFiles, fileOps, srcIsNew);
        if (isPropChanged) {
            this.propertyChanged();
        }
    }

    void propertyChanged() {
        this.m_propBag.setProperty((Object)PropertyIDs.SI_PATH, (Object)this.m_pathURL);
    }

    public int size() {
        return this.m_elements.size();
    }

    public String getFRSPathURL() {
        return this.m_pathURL;
    }

    public boolean isUploadToFRSPromptly() {
        return this.m_bUploadContent;
    }

    public void setUploadToFRSPromptly(boolean bUploadToFRS) {
        this.m_bUploadContent = bUploadToFRS;
    }

    public IFiles copy(String destPath) throws SDKException {
        return this.copy(destPath, false);
    }

    public IFiles copy(String destPath, boolean srcIsNew) throws SDKException {
        return this.copy(destPath, srcIsNew, this.m_infoObj);
    }

    public IFiles copy(String destPath, boolean srcIsNew, InfoObject obj) throws SDKException {
        this.checkRight(61);
        PropertyBag copy = this.m_propBag.copy();
        copy.setProperty((Object)PropertyIDs.SI_PATH, (Object)destPath);
        Files result = new Files();
        result.readFrom(copy, this.m_session, this.m_securityInfo, true, obj, this.m_fileOps, srcIsNew);
        FrsURL frsURL = null;
        try {
            frsURL = new FrsURL(destPath);
        }
        catch (SILibException e) {
            throw new SDKException.URIFormat(destPath, (Exception)((Object)e));
        }
        String destFolder = frsURL.getFilePath();
        List elements = result.m_elements;
        for (int i = 0; i < elements.size(); ++i) {
            if (srcIsNew) {
                this.m_elements.add(i, elements.get(i));
                continue;
            }
            NewRemoteFile file = new NewRemoteFile();
            String fileName = (String)this.m_bag.get(i);
            String filePath = this.m_pathURL + fileName;
            String propName = SI_VALUE + (i + 1);
            long fileSize = this.m_propBag.getLong((Object)propName);
            IFileRepositoryObject fileObject = this.getFRS().get(filePath);
            file.initialize(fileObject, destFolder + fileName, fileSize);
            elements.set(i, file);
        }
        return result;
    }

    public IProperties properties() {
        return (IProperties)this.m_propBag;
    }

    public Object get(int index) {
        IFile file = (IFile)this.m_elements.get(index);
        if (file == null) {
            file = this.createCollectionObject(index);
            this.m_elements.set(index, file);
        }
        return file;
    }

    public Object remove(int index) {
        try {
            this.checkRight(6);
        }
        catch (SDKException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
        IFile oldFile = (IFile)this.m_elements.remove(index);
        if (oldFile == null) {
            oldFile = this.createCollectionObject(index);
        }
        oldFile.abort();
        if (oldFile instanceof IRemoteFile) {
            if (this.m_removedFileURLs == null) {
                this.m_removedFileURLs = new ArrayList(2);
            }
            if (!this.m_sharedDocs) {
                String url = ((IRemoteFile)oldFile).getURL();
                this.m_removedFileURLs.add(url);
            }
            if (this.m_elements.size() == 0) {
                try {
                    this.removeSharedRefCount();
                }
                catch (SDKException e) {
                    LOG.error((Object)"Remove(): error while trying to query CMS", (Throwable)((Object)e));
                }
                this.m_pathURL = this.m_infoObj.createFrsUrl();
                this.propertyChanged();
            }
        }
        this.m_bag.remove(index);
        Object nextValue = null;
        int valueIndex = index + 1;
        do {
            if ((nextValue = this.m_propBag.get((Object)(SI_VALUE + (valueIndex + 1)))) == null) continue;
            int fileSize = ((Property)nextValue).getInt();
            this.setFileSize(SI_VALUE + valueIndex, fileSize);
            ++valueIndex;
        } while (nextValue != null);
        this.m_propBag.removeLocal((Object)IDHelper.object2Integer((Object)(SI_VALUE + valueIndex)));
        if (!this.m_sharedDocs) {
            this.m_fileOps.add(new FileOpRecord(FileOpType.REMOVE, index));
        }
        return oldFile;
    }

    public ILocalFile addFile(String filePath, String prefix, String ext, String destFilename, String subDir, boolean deleteLocalFile) throws SDKException {
        return this.addHelper(filePath, null, prefix, ext, destFilename, subDir, deleteLocalFile, false);
    }

    public ILocalFile addFile(File file, String prefix, String ext, String destFilename, String subDir, boolean deleteLocalFile) throws SDKException {
        return this.addHelper(null, file, prefix, ext, destFilename, subDir, deleteLocalFile, false);
    }

    public ILocalFile addFile(String filePath, boolean deleteLocalFile) throws SDKException {
        return this.addFile(filePath, null, null, null, null, deleteLocalFile);
    }

    public ILocalFile addFile(File file, boolean deleteLocalFile) throws SDKException {
        return this.addFile(file, null, null, null, null, deleteLocalFile);
    }

    public ILocalFile addFile(String filePath) throws SDKException {
        return this.addFile(filePath, false);
    }

    public ILocalFile addFile(File file) throws SDKException {
        return this.addFile(file, false);
    }

    public ILocalFile addFile(byte[] stream, String prefix, String ext, String destFilename, String subDir) throws SDKException {
        return this.addHelper(stream, prefix, ext, destFilename, subDir, false);
    }

    public IStreamingUploadFile addStreamingFile(String prefix, String ext, String destFilename, String subDir) throws SDKException {
        return this.addStreamingFile(0L, prefix, ext, destFilename, subDir);
    }

    public IStreamingUploadFile addStreamingFile(long size, String prefix, String ext, String destFilename, String subDir) throws SDKException {
        return this.addHelper(size, prefix, ext, destFilename, subDir, false);
    }

    public ILocalFile addUniqueFile(String filePath, String prefix, String ext, String subDir, boolean deleteLocalFile) throws SDKException {
        return this.addHelper(filePath, null, prefix, ext, null, subDir, deleteLocalFile, true);
    }

    public ILocalFile addUniqueFile(File file, String prefix, String ext, String subDir, boolean deleteLocalFile) throws SDKException {
        return this.addHelper(null, file, prefix, ext, null, subDir, deleteLocalFile, true);
    }

    public ILocalFile addUniqueFile(String filePath, boolean deleteLocalFile) throws SDKException {
        return this.addUniqueFile(filePath, null, null, null, deleteLocalFile);
    }

    public ILocalFile addUniqueFile(File file, boolean deleteLocalFile) throws SDKException {
        return this.addUniqueFile(file, null, null, null, deleteLocalFile);
    }

    public ILocalFile addUniqueFile(String filePath) throws SDKException {
        return this.addUniqueFile(filePath, false);
    }

    public ILocalFile addUniqueFile(File file) throws SDKException {
        return this.addUniqueFile(file, false);
    }

    public ILocalFile addUniqueFile(byte[] stream, String prefix, String ext, String subDir) throws SDKException {
        return this.addHelper(stream, prefix, ext, null, subDir, true);
    }

    public ILocalFile addUniqueFile(byte[] stream) throws SDKException {
        return this.addUniqueFile(stream, null, null, null);
    }

    public IStreamingUploadFile addUniqueStreamingFile(String prefix, String ext, String subDir) throws SDKException {
        return this.addUniqueStreamingFile(0L, prefix, ext, subDir);
    }

    public IStreamingUploadFile addUniqueStreamingFile(long size, String prefix, String ext, String subDir) throws SDKException {
        return this.addHelper(size, prefix, ext, null, subDir, true);
    }

    public IFile replace(int index, String filePath, String prefix, String ext, String destFilename, String subDir, boolean deleteLocalFile) throws SDKException {
        return this.replaceHelper(index, filePath, null, prefix, ext, destFilename, subDir, deleteLocalFile, false);
    }

    public IFile replace(int index, File file, String prefix, String ext, String destFilename, String subDir, boolean deleteLocalFile) throws SDKException {
        return this.replaceHelper(index, null, file, prefix, ext, destFilename, subDir, deleteLocalFile, false);
    }

    public IFile replace(int index, String filePath, boolean deleteLocalFile) throws SDKException {
        return this.replace(index, filePath, null, null, null, null, deleteLocalFile);
    }

    public IFile replace(int index, File file, boolean deleteLocalFile) throws SDKException {
        return this.replace(index, file, null, null, null, null, deleteLocalFile);
    }

    public IFile replace(int index, String filePath) throws SDKException {
        return this.replace(index, filePath, false);
    }

    public IFile replace(int index, File file) throws SDKException {
        return this.replace(index, file, false);
    }

    public IFile replace(int index, byte[] stream, String prefix, String ext, String destFilename, String subDir) throws SDKException {
        return this.replaceHelper(index, stream, prefix, ext, destFilename, subDir, false);
    }

    public IFile replaceWithStreamingFile(int index, String prefix, String ext, String destFilename, String subDir) throws SDKException {
        return this.replaceWithStreamingFile(index, 0L, prefix, ext, destFilename, subDir);
    }

    public IFile replaceWithStreamingFile(int index, long size, String prefix, String ext, String destFilename, String subDir) throws SDKException {
        return this.replaceHelper(index, size, prefix, ext, destFilename, subDir, false);
    }

    public IFile replaceUnique(int index, String filePath, String prefix, String ext, String subDir, boolean deleteLocalFile) throws SDKException {
        return this.replaceHelper(index, filePath, null, prefix, ext, null, subDir, deleteLocalFile, true);
    }

    public IFile replaceUnique(int index, File file, String prefix, String ext, String subDir, boolean deleteLocalFile) throws SDKException {
        return this.replaceHelper(index, null, file, prefix, ext, null, subDir, deleteLocalFile, true);
    }

    public IFile replaceUnique(int index, String filePath, boolean deleteLocalFile) throws SDKException {
        return this.replaceUnique(index, filePath, null, null, null, deleteLocalFile);
    }

    public IFile replaceUnique(int index, File file, boolean deleteLocalFile) throws SDKException {
        return this.replaceUnique(index, file, null, null, null, deleteLocalFile);
    }

    public IFile replaceUnique(int index, String filePath) throws SDKException {
        return this.replaceUnique(index, filePath, false);
    }

    public IFile replaceUnique(int index, File file) throws SDKException {
        return this.replaceUnique(index, file, false);
    }

    public IFile replaceUnique(int index, byte[] stream, String prefix, String ext, String subDir) throws SDKException {
        return this.replaceHelper(index, stream, prefix, ext, null, subDir, true);
    }

    public IFile replaceUnique(int index, byte[] stream) throws SDKException {
        return this.replaceUnique(index, stream, null, null, null);
    }

    public IFile replaceUniqueWithStreamingFile(int index, String prefix, String ext, String subDir) throws SDKException {
        return this.replaceUniqueWithStreamingFile(index, 0L, prefix, ext, subDir);
    }

    public IFile replaceUniqueWithStreamingFile(int index, long size, String prefix, String ext, String subDir) throws SDKException {
        return this.replaceHelper(index, size, prefix, ext, null, subDir, true);
    }

    public IFile append(int index, File file, boolean deleteLocalFile) throws SDKException {
        return this.appendHelper(index, null, file, deleteLocalFile);
    }

    public IFile append(int index, String filepath, boolean deleteLocalFile) throws SDKException {
        return this.appendHelper(index, filepath, null, deleteLocalFile);
    }

    public IFile append(int index, byte[] stream) throws SDKException {
        return this.appendHelper(index, stream);
    }

    public void commit() throws SDKException {
        SDKExceptionsCollector collector = new SDKExceptionsCollector();
        int size = this.m_elements.size();
        for (int i = 0; i < size; ++i) {
            IFile file = (IFile)this.m_elements.get(i);
            if (file == null) continue;
            try {
                file.commit();
                this.m_elements.set(i, null);
                continue;
            }
            catch (SDKException e) {
                collector.collect(e);
            }
        }
        if (this.m_removedFileURLs != null) {
            ListIterator itr = this.m_removedFileURLs.listIterator(this.m_removedFileURLs.size());
            while (itr.hasPrevious()) {
                String fileURL = (String)itr.previous();
                try {
                    this.getFRS().remove(fileURL).commit();
                    itr.remove();
                }
                catch (SDKException e) {
                    collector.collect(e);
                }
            }
        }
        this.m_fileOps.clear();
        collector.close();
    }

    public void abort() {
        for (int i = 0; i < this.m_elements.size(); ++i) {
            IFile fileObject = (IFile)this.m_elements.get(i);
            if (fileObject == null) continue;
            fileObject.abort();
        }
        if (this.m_removedFileURLs != null) {
            this.m_removedFileURLs.clear();
        }
        this.m_fileOps.clear();
    }

    public void checkRight(int right) throws SDKException {
        if (this.m_securityInfo != null && !this.m_infoObj.isNew()) {
            SecurityInfoException.checkThrow(this.m_securityInfo, right);
        }
    }

    public int updateSize(int index, IFile file, long newSize) {
        IFile f;
        int adjustedIndex = index >= 0 && index < this.m_elements.size() ? (!file.equals(f = (IFile)this.m_elements.get(index)) ? this.m_elements.indexOf(file) : index) : this.m_elements.lastIndexOf(file);
        if (adjustedIndex != -1) {
            this.updateSize(adjustedIndex, newSize);
            return adjustedIndex;
        }
        return index;
    }

    private void setupProperties(PropertyBag bag, ISecuritySession session, boolean initFiles, List fileOps, boolean srcIsNew) {
        int i;
        String[] pathTokens;
        int fileDir;
        this.m_propBag = bag;
        this.m_bag = new PropertyArrayHelper(bag, PropertyIDs.SI_NUM_FILES, PropertyIDs.SI_FILE0);
        int SIZE = this.m_bag.size();
        FrsURL frsURL = null;
        try {
            frsURL = new FrsURL(this.m_pathURL);
        }
        catch (SILibException e) {
            throw new SDKRuntimeException.UnexpectedCause((Exception)((Object)e));
        }
        this.m_destFolder = frsURL.getFilePath();
        if (!this.m_destFolder.endsWith("/")) {
            this.m_destFolder = this.m_destFolder + "/";
        }
        this.m_sharedDocs = (fileDir = Integer.parseInt((pathTokens = this.m_destFolder.split("/"))[pathTokens.length - 1])) != this.m_infoObjID && !srcIsNew;
        this.m_session = session;
        if (initFiles) {
            this.m_elements = new ArrayList(SIZE);
            for (i = 0; i < SIZE; ++i) {
                this.m_elements.add(null);
            }
        } else {
            int size = this.m_elements.size();
            for (i = 0; i < size; ++i) {
                IFile file = (IFile)this.m_elements.get(i);
                try {
                    if (file instanceof LocalStreamingUploadFile) {
                        ((LocalStreamingUploadFile)file).initFromSerialization(this, this.getFRS());
                        continue;
                    }
                    if (file instanceof LocalStream) {
                        ((LocalStream)file).initFromSerialization(this.getFRS());
                        continue;
                    }
                    if (file instanceof LocalFile) {
                        ((LocalFile)file).initFromSerialization(this.getFRS());
                        continue;
                    }
                    if (!(file instanceof RemoteFile)) continue;
                    ((RemoteFile)file).initFromSerialization(this, this, this, this.getFRS());
                    continue;
                }
                catch (SDKException e) {
                    this.m_elements.set(i, null);
                }
            }
        }
        if (this.m_fileOps == null) {
            if (fileOps != null && fileOps.size() > 0) {
                this.m_fileOps = new ArrayList(fileOps.size());
                Iterator iter = fileOps.iterator();
                while (iter.hasNext()) {
                    FileOpRecord rec = (FileOpRecord)iter.next();
                    String destPath = rec.destPath;
                    if (destPath == null) continue;
                    int last = destPath.lastIndexOf(47);
                    rec.destPath = this.m_destFolder + rec.destPath.substring(last + 1);
                    this.m_fileOps.add(rec);
                }
            } else {
                this.m_fileOps = new ArrayList(SIZE == 0 ? 2 : SIZE);
            }
        }
    }

    private IFile createCollectionObject(int index) {
        String fileName = (String)this.m_bag.get(index);
        String fileURL = this.m_pathURL + fileName;
        try {
            RemoteFile result = new RemoteFile(this.getFRS(), fileURL, this, this, this.getFileSize(index), index, this.m_bUploadContent, this, this.m_sharedDocs);
            return result;
        }
        catch (SDKException e) {
            throw new SDKRuntimeException.UnexpectedCause((Exception)((Object)e));
        }
    }

    private long getFileSize(int index) {
        return this.m_propBag.getInt((Object)(SI_VALUE + (index + 1)));
    }

    private void setFileSize(String propname, long filesize) {
        LOG.assertTrue(filesize <= Integer.MAX_VALUE, "File size " + filesize + " exceeds supported size " + Integer.MAX_VALUE);
        this.m_propBag.setProperty((Object)propname, (int)filesize);
    }

    private ILocalFile addHelper(String filePath, File file, String prefix, String ext, String destFileName, String subDir, boolean deleteLocalFile, boolean makeUniqueName) throws SDKException {
        if (filePath == null && file == null) {
            throw new SDKException.InvalidArg("null");
        }
        if (filePath != null && file != null) {
            throw new SDKException.InvalidArg();
        }
        if (this.m_sharedDocs) {
            this.sharedFilesHelper();
        }
        this.checkRight(6);
        filePath = filePath == null ? file.getAbsolutePath() : filePath;
        File file2 = file = file == null ? new File(filePath) : file;
        if (!file.canRead()) {
            throw new SDKException.FileNotFound(filePath);
        }
        String destPath = this.getDestPath(filePath, prefix, ext, destFileName, subDir, makeUniqueName);
        FileOpRecord rec = new FileOpRecord(FileOpType.ADD, this.m_elements.size(), filePath, file.toURI().toString(), prefix, ext, destFileName, subDir, deleteLocalFile, makeUniqueName, destPath);
        LocalFile localFile = new LocalFile(this.getFRS(), file, rec, this.m_bUploadContent);
        this.m_bag.add((Object)localFile.getName());
        this.updateSize(this.m_elements.size(), localFile.getSize());
        this.m_elements.add(localFile);
        this.m_fileOps.add(rec);
        return localFile;
    }

    private ILocalFile addHelper(FileOpRecord rec) throws SDKException {
        URI absoluteURI;
        if (rec.fileURI != null && rec.fileURI.length() > 0 && (absoluteURI = URI.create(rec.fileURI)).isAbsolute()) {
            return this.addHelper(null, new File(absoluteURI), rec.prefix, rec.ext, rec.destFileName, rec.subDir, rec.deleteLocalFile, rec.makeUniqueName);
        }
        return this.addHelper(rec.filePath, null, rec.prefix, rec.ext, rec.destFileName, rec.subDir, rec.deleteLocalFile, rec.makeUniqueName);
    }

    public ILocalFile addHelper(byte[] stream, String prefix, String ext, String destFilename, String subDir, boolean makeUniqueName) throws SDKException {
        if (stream == null) {
            throw new SDKException.InvalidArg("null");
        }
        if (makeUniqueName) {
            this.checkRight(6);
        } else {
            this.checkRightAndFileName(destFilename);
        }
        String destPath = this.getDestPath(null, prefix, ext, destFilename, subDir, makeUniqueName);
        LocalStream localStream = new LocalStream(this.getFRS(), stream, destPath, prefix, ext, subDir, makeUniqueName, this.m_bUploadContent);
        if (this.m_sharedDocs) {
            this.sharedFilesHelper();
        }
        this.updateSize(this.m_elements.size(), stream.length);
        this.m_bag.add((Object)localStream.getName());
        this.m_elements.add(localStream);
        return localStream;
    }

    private IStreamingUploadFile addHelper(long size, String prefix, String ext, String destFilename, String subDir, boolean makeUniqueName) throws SDKException {
        if (size < 0L) {
            throw new SDKException.InvalidArg(size);
        }
        if (makeUniqueName) {
            this.checkRight(6);
        } else {
            this.checkRightAndFileName(destFilename);
        }
        String destPath = this.getDestPath(null, prefix, ext, destFilename, subDir, makeUniqueName);
        LocalStreamingUploadFile uploadStream = new LocalStreamingUploadFile(this.getFRS(), size, destPath, prefix, ext, subDir, this, this.m_elements.size(), makeUniqueName);
        if (this.m_sharedDocs) {
            this.sharedFilesHelper();
        }
        this.m_bag.add((Object)uploadStream.getName());
        this.m_elements.add(uploadStream);
        return uploadStream;
    }

    private IFile replaceHelper(int index, String filePath, File file, String prefix, String ext, String destFileName, String subDir, boolean deleteLocalFile, boolean makeUniqueName) throws SDKException {
        if (filePath == null && file == null) {
            throw new SDKException.InvalidArg("null");
        }
        if (filePath != null && file != null) {
            throw new SDKException.InvalidArg();
        }
        this.checkRight(6);
        IFile oldFile = (IFile)this.get(index);
        oldFile.abort();
        if (prefix == null) {
            if (oldFile instanceof LocalFile) {
                prefix = ((LocalFile)oldFile).getDestPrefix();
            } else if (oldFile instanceof LocalStream) {
                prefix = ((LocalStream)oldFile).getDestPrefix();
            } else if (oldFile instanceof LocalStreamingUploadFile) {
                prefix = ((LocalStreamingUploadFile)oldFile).getDestPrefix();
            }
        }
        if (subDir == null) {
            if (oldFile instanceof LocalFile) {
                subDir = ((LocalFile)oldFile).getDestSubDir();
            } else if (oldFile instanceof LocalStream) {
                subDir = ((LocalStream)oldFile).getDestSubDir();
            } else if (oldFile instanceof LocalStreamingUploadFile) {
                subDir = ((LocalStreamingUploadFile)oldFile).getDestSubDir();
            }
        }
        filePath = filePath == null ? file.getAbsolutePath() : filePath;
        File file2 = file = file == null ? new File(filePath) : file;
        if (!file.canRead()) {
            throw new SDKException.FileNotFound(filePath);
        }
        if (this.m_sharedDocs) {
            this.getOwnFiles();
            this.removeSharedRefCount();
        }
        String destPath = this.getDestPath(filePath, prefix, ext, destFileName, subDir, makeUniqueName);
        FileOpRecord rec = new FileOpRecord(FileOpType.REPLACE, index, filePath, file.toURI().toString(), prefix, ext, destFileName, subDir, deleteLocalFile, makeUniqueName, destPath);
        this.m_fileOps.add(rec);
        if (this.m_sharedDocs) {
            this.m_sharedDocs = false;
        } else if (oldFile instanceof IRemoteFile) {
            IRemoteFile oldRemoteFile = (IRemoteFile)oldFile;
            if (this.handleOverwriteRemote(oldRemoteFile, filePath, destPath)) {
                return oldRemoteFile;
            }
            rec.oldFileURL = oldRemoteFile.getURL();
        }
        LocalFile localFile = new LocalFile(this.getFRS(), file, rec, this.m_bUploadContent);
        this.m_bag.set(index, (Object)localFile.getName());
        this.updateSize(index, localFile.getSize());
        this.m_elements.set(index, localFile);
        return oldFile;
    }

    private IFile replaceHelper(FileOpRecord rec) throws SDKException {
        return this.replaceHelper(rec.index, null, new File(URI.create(rec.fileURI)), rec.prefix, rec.ext, rec.destFileName, rec.subDir, rec.deleteLocalFile, rec.makeUniqueName);
    }

    public IFile replaceHelper(int index, byte[] stream, String prefix, String ext, String destFilename, String subDir, boolean makeUniqueName) throws SDKException {
        if (stream == null) {
            throw new SDKException.InvalidArg("null");
        }
        if (makeUniqueName) {
            this.checkRight(6);
        } else {
            this.checkRightAndFileName(destFilename);
        }
        IFile oldFile = (IFile)this.get(index);
        oldFile.abort();
        if (this.m_sharedDocs) {
            this.getOwnFiles();
            this.removeSharedRefCount();
        }
        String destPath = this.getDestPath(null, prefix, ext, destFilename, subDir, makeUniqueName);
        String oldFileURL = null;
        if (this.m_sharedDocs) {
            this.m_sharedDocs = false;
        } else if (oldFile instanceof IRemoteFile) {
            IRemoteFile oldRemoteFile = (IRemoteFile)oldFile;
            if (this.handleOverwriteRemote(oldRemoteFile, stream, destPath)) {
                return oldRemoteFile;
            }
            oldFileURL = oldRemoteFile.getURL();
        }
        LocalStream localStream = new LocalStream(this.getFRS(), stream, destPath, prefix, ext, subDir, makeUniqueName, oldFileURL, this.m_bUploadContent);
        this.updateSize(index, stream.length);
        this.m_bag.set(index, (Object)localStream.getName());
        this.m_elements.set(index, localStream);
        return oldFile;
    }

    public IFile replaceHelper(int index, long size, String prefix, String ext, String destFilename, String subDir, boolean makeUniqueName) throws SDKException {
        if (size < 0L) {
            throw new SDKException.InvalidArg(size);
        }
        if (makeUniqueName) {
            this.checkRight(6);
        } else {
            this.checkRightAndFileName(destFilename);
        }
        IFile oldFile = (IFile)this.get(index);
        oldFile.abort();
        if (this.m_sharedDocs) {
            this.sharedFilesHelper();
        }
        String destPath = this.getDestPath(null, prefix, ext, destFilename, subDir, makeUniqueName);
        String oldFileURL = null;
        if (oldFile instanceof IRemoteFile) {
            IRemoteFile oldRemoteFile = (IRemoteFile)oldFile;
            if (this.comparePath(oldRemoteFile, destPath)) {
                this.m_elements.set(index, oldRemoteFile.getStreamingUploadFile());
                return oldRemoteFile;
            }
            oldFileURL = oldRemoteFile.getURL();
        }
        LocalStreamingUploadFile newFile = new LocalStreamingUploadFile(this.getFRS(), size, destPath, prefix, ext, subDir, this, index, makeUniqueName, oldFileURL);
        this.m_bag.set(index, (Object)newFile.getName());
        this.m_elements.set(index, newFile);
        return oldFile;
    }

    private IFile appendHelper(int index, String appendFilePath, File appendFile, boolean deleteLocalFile) throws SDKException {
        if (appendFilePath == null && appendFile == null) {
            throw new SDKException.InvalidArg("null");
        }
        if (appendFilePath != null && appendFile != null) {
            throw new SDKException.InvalidArg();
        }
        this.checkRight(6);
        IRemoteFile oldRemoteFile = null;
        oldRemoteFile = (IRemoteFile)this.get(index);
        oldRemoteFile.abort();
        appendFilePath = appendFilePath == null ? appendFile.getAbsolutePath() : appendFilePath;
        File file = appendFile = appendFile == null ? new File(appendFilePath) : appendFile;
        if (!appendFile.canRead()) {
            throw new SDKException.FileNotFound(appendFilePath);
        }
        if (this.m_sharedDocs) {
            String existingFileURL = this.m_pathURL;
            this.sharedFilesHelper();
            this.processSharedAppend(index, existingFileURL, appendFile, null, deleteLocalFile);
        } else {
            String destPath = oldRemoteFile.getFilePath();
            FileOpRecord rec = new FileOpRecord(FileOpType.APPEND, index, appendFilePath, appendFile.toURI().toString(), null, null, null, null, deleteLocalFile, false, destPath);
            this.m_fileOps.add(rec);
            this.handleAppendRemote(oldRemoteFile, appendFilePath, destPath);
        }
        return oldRemoteFile;
    }

    private IFile appendHelper(FileOpRecord rec) throws SDKException {
        return this.appendHelper(rec.index, null, new File(URI.create(rec.fileURI)), rec.deleteLocalFile);
    }

    private IFile appendHelper(int index, byte[] stream) throws SDKException {
        if (stream == null) {
            throw new SDKException.InvalidArg("null");
        }
        IRemoteFile oldRemoteFile = null;
        oldRemoteFile = (IRemoteFile)this.get(index);
        oldRemoteFile.abort();
        if (!this.m_sharedDocs) {
            String destPath = oldRemoteFile.getFilePath();
            this.handleAppendRemote(oldRemoteFile, stream, destPath);
        } else {
            String existingFilePath = this.m_pathURL;
            this.sharedFilesHelper();
            this.processSharedAppend(index, existingFilePath, null, stream, false);
        }
        return oldRemoteFile;
    }

    private void processSharedAppend(int index, String sourceDir, File appendFile, byte[] appendData, boolean deleteLocalFile) throws SDKException {
        String fileName = (String)this.m_bag.get(index);
        String filePath = sourceDir + fileName;
        String propName = SI_VALUE + (index + 1);
        long fileSize = this.m_propBag.getLong((Object)propName);
        fileSize = appendFile != null ? (fileSize += appendFile.length()) : (fileSize += (long)appendData.length);
        this.m_propBag.setProperty((Object)propName, fileSize);
        IFileRepositoryObject fileObject = this.getFRS().get(filePath);
        Random random = new Random();
        String tempFileName = String.valueOf(random.nextInt());
        File tempFile = null;
        try {
            tempFile = File.createTempFile(tempFileName, null);
            IFileTx tx = fileObject.download(tempFile.getPath());
            tx.commit();
            FileOutputStream fos = new FileOutputStream(tempFile.getPath(), true);
            FileInputStream fis = null;
            if (appendFile != null) {
                fis = new FileInputStream(appendFile);
                byte[] data = new byte[512];
                while (fis.read(data) != -1) {
                    fos.write(data);
                }
                fis.close();
            } else {
                fos.write(appendData);
            }
            fos.close();
        }
        catch (IOException e) {
            throw new SDKException.FileWriterError(e);
        }
        FileOpRecord rec = new FileOpRecord(FileOpType.ADD, this.m_elements.size(), tempFile.getAbsolutePath(), tempFile.toURI().toString(), null, null, fileName, null, deleteLocalFile, false, this.m_destFolder + fileName);
        LocalFile file = new LocalFile(this.getFRS(), tempFile, rec, this.m_bUploadContent);
        this.m_elements.set(index, file);
        tempFile.deleteOnExit();
    }

    private String getDestPath(String localFilePath, String prefix, String ext, String destFileName, String destSubDir, boolean makeUniqueName) {
        StringBuffer destPath = new StringBuffer(this.m_destFolder);
        if (destSubDir != null) {
            destPath.append(destSubDir);
            if (destPath.charAt(destPath.length() - 1) != '/') {
                destPath.append("/");
            }
        }
        if (destFileName != null) {
            if (prefix != null) {
                destPath.append(prefix);
            }
            destPath.append(destFileName);
            if (ext != null) {
                destPath.append(".");
                destPath.append(ext);
            }
        } else if (localFilePath != null && !makeUniqueName) {
            destPath.append(new File(localFilePath).getName());
        }
        return destPath.toString();
    }

    private void updateSize(int index, long newSize) {
        this.setFileSize(SI_VALUE + (index + 1), newSize);
    }

    private boolean handleOverwriteRemote(IRemoteFile remoteFile, Object source, String destPath) throws SDKException {
        if (this.comparePath(remoteFile, destPath)) {
            remoteFile.abort();
            if (source instanceof String) {
                return remoteFile.overwrite((String)source);
            }
            if (source instanceof byte[]) {
                return remoteFile.overwrite((byte[])source);
            }
        }
        return false;
    }

    private boolean handleAppendRemote(IRemoteFile remoteFile, Object source, String destPath) throws SDKException {
        remoteFile.abort();
        if (source instanceof String) {
            return remoteFile.append((String)source);
        }
        if (source instanceof byte[]) {
            return remoteFile.append((byte[])source);
        }
        return true;
    }

    private boolean comparePath(IRemoteFile remoteFile, String destPath) throws SDKException {
        FrsURL url;
        String remoteFileURL = remoteFile.getURL();
        if (destPath.indexOf(58) != -1) {
            return remoteFileURL.equalsIgnoreCase(destPath);
        }
        try {
            url = new FrsURL(remoteFileURL);
        }
        catch (SILibException e) {
            throw new SDKException.URIFormat(remoteFileURL, (Exception)((Object)e));
        }
        return url.getFilePath().equalsIgnoreCase(destPath);
    }

    private IFileRepository getFRS() throws SDKException {
        if (this.m_frs == null) {
            this.m_frs = this.getFRSviaFrsURI(this.m_pathURL);
        }
        return this.m_frs;
    }

    private IFileRepository getFRSviaFrsURI(String uri) throws SDKException {
        try {
            FrsURL frsUrl = new FrsURL(uri);
            return this.getFRSviaName(frsUrl.getHost());
        }
        catch (SILibException e) {
            throw new SDKException.Unexpected((Exception)((Object)e));
        }
    }

    private IFileRepository getFRSviaName(String name) throws SDKException {
        String frsServerName = name + ".";
        return (IFileRepository)OCCAMgrFactory.getOCCAMgr().getOCCAFactory("FileStoreV2").makeOCCA(frsServerName, this.m_session);
    }

    private void checkRightAndFileName(String destFilename) throws SDKException {
        this.checkRight(6);
        if (destFilename == null) {
            throw new SDKException.InvalidArg(destFilename);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.m_bUploadContent);
        out.writeInt(this.m_elements.size());
        Iterator iter = this.m_elements.iterator();
        while (iter.hasNext()) {
            IFile file = (IFile)iter.next();
            out.writeObject(file);
        }
        out.writeObject(this.m_removedFileURLs);
        out.writeBoolean(this.m_enforceDownloadRight);
        out.writeInt(this.m_downloadRightID);
        out.writeObject(this.m_fileOps);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_bUploadContent = in.readBoolean();
        int size = in.readInt();
        this.m_elements = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.m_elements.add((IFile)in.readObject());
        }
        this.m_removedFileURLs = (List)in.readObject();
        this.m_enforceDownloadRight = in.readBoolean();
        this.m_downloadRightID = in.readInt();
        this.m_fileOps = (List)in.readObject();
    }

    public void serializeHelper(PropertyArrayHelper bagHelper) throws SDKException {
        for (int i = 0; i < this.m_fileOps.size(); ++i) {
            PropertyBag pBag = new PropertyBag();
            ((FileOpRecord)this.m_fileOps.get(i)).save(pBag);
            bagHelper.add((Object)pBag);
        }
    }

    private void getOwnFiles() throws SDKException {
        this.m_elements = ((Files)this.copy((String)this.m_infoObj.createFrsUrl())).m_elements;
        this.m_pathURL = this.m_infoObj.createFrsUrl();
        this.m_destFolder = "/" + this.m_infoObj.getDefaultDestFRSDirPath();
        this.m_propBag.setProperty((Object)PropertyIDs.SI_PATH, (Object)this.m_pathURL);
    }

    private void removeSharedRefCount() throws SDKException {
        Property sharedDocProp = (Property)this.m_infoObj.getProperty(PropertyIDs.SI_SHARED_DOC);
        if (sharedDocProp == null || !sharedDocProp.isContainer()) {
            IInternalInfoStore infoStore = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA(this.m_session.getAPSName(), this.m_session);
            IInfoObjects col = infoStore.query("select SI_SHARED_DOC from CI_INFOOBJECTS where SI_ID = " + this.m_infoObjID);
            if (col.size() > 0) {
                InfoObject infoObj = (InfoObject)col.get(0);
                PropertyBag sharedDocBag = ((Property)infoObj.getProperty(PropertyIDs.SI_SHARED_DOC)).getPropertyBag();
                this.m_infoObj.addProperty(PropertyIDs.SI_SHARED_DOC, sharedDocBag, 0);
            } else {
                LOG.error((Object)("removeSharedRefCount(): cannot find obj with SI_ID = " + this.m_infoObjID + " in CMS"));
            }
        }
        ObjectRelatives sharedDocs = new ObjectRelatives();
        sharedDocs.initialize((Object)PropertyIDs.SI_SHARED_DOC, this.m_infoObj.properties(), false, false);
        Iterator iter = sharedDocs.iterator();
        while (iter.hasNext()) {
            Integer id = (Integer)iter.next();
            sharedDocs.remove(id);
        }
    }

    private void sharedFilesHelper() throws SDKException {
        this.getOwnFiles();
        this.removeSharedRefCount();
        this.m_sharedDocs = false;
    }
}

