/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.holder.IntHolder;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Packer;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Unpacker;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.info_wire_ob3;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKExceptionsCollector;
import com.crystaldecisions.sdk.occa.infostore.IBatchSecurityItems;
import com.crystaldecisions.sdk.occa.infostore.IFiles;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo2;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjectEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.BatchSecurityInfo;
import com.crystaldecisions.sdk.occa.infostore.internal.BatchSecurityItems;
import com.crystaldecisions.sdk.occa.infostore.internal.CategoryContentInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.INewID;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRights;
import com.crystaldecisions.sdk.occa.infostore.internal.IProxyHandler;
import com.crystaldecisions.sdk.occa.infostore.internal.IProxySupport;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoStoreFactory;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStoreFactory;
import com.crystaldecisions.sdk.occa.infostore.internal.OCASizeOf;
import com.crystaldecisions.sdk.occa.infostore.internal.SchedulableCategoryContentInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.SchedulableInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityInfoException;
import com.crystaldecisions.sdk.occa.infostore.internal.SerializableInfoObjects;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginInfo;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.IRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.SecurityFactory;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class InfoObjects
extends AbstractList
implements IInfoObjects,
IInternalInfoObjects,
IPersistInfoObjects,
IPersistRights,
Serializable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.InfoObjects");
    private static final int UNINITIALIZED = -1;
    private List m_list = null;
    private ISecuritySession m_session;
    protected IInternalInfoStore m_infoStore;
    private int m_resultSize = -1;
    private Iterator m_nextIter;
    private BatchSecurityInfo m_securityInfo;
    private int m_commitLevel = 0;

    InfoObjects() {
    }

    List getList() {
        return this.m_list;
    }

    public void cleanupChanges() {
        Iterator iter = this.m_list.iterator();
        while (iter.hasNext()) {
            IPersistInfoObject obj = (IPersistInfoObject)iter.next();
            if (!obj.isDirty()) continue;
            obj.cleanupChanges();
        }
        LOG.debug((Object)"cleanupChanges(): exit");
    }

    public void initialize(ISecuritySession session, IInternalInfoStore infoStore) {
        this.m_session = session;
        this.m_infoStore = infoStore;
        this.m_list = new ArrayList();
    }

    public boolean isDirty() {
        Iterator iter = this.m_list.iterator();
        while (iter.hasNext()) {
            IPersistInfoObject obj = (IPersistInfoObject)iter.next();
            if (!obj.isDirty()) continue;
            return true;
        }
        return false;
    }

    public info_wire_ob3[] startPack(int maxPackSize, boolean dirtyOnly, int flag) throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("startPack(): dirtyOnly=" + dirtyOnly + ",forSchedule=" + flag + ",maxPackSize=" + maxPackSize));
        }
        this.m_nextIter = this.m_list.iterator();
        return this.continuePack(maxPackSize, dirtyOnly, flag);
    }

    public info_wire_ob3[] continuePack(int maxPackSize, boolean dirtyOnly, int flag) throws SDKException {
        if (!this.m_nextIter.hasNext()) {
            return null;
        }
        ArrayList<info_wire_ob3> wire = new ArrayList<info_wire_ob3>(this.m_list.size());
        int packedSize = 0;
        if (flag == 1 || flag == 5) {
            if (flag == 1) {
                this.packForNonCommitOperation(dirtyOnly, wire, maxPackSize, packedSize, 3, 0x1000000);
            } else {
                int scheduleOnSelfFlag = 0x1400000;
                this.packForNonCommitOperation(dirtyOnly, wire, maxPackSize, packedSize, 3, scheduleOnSelfFlag);
            }
        } else if (flag == 2) {
            this.packForNonCommitOperation(dirtyOnly, wire, maxPackSize, packedSize, 7, 0x4000000);
        } else if (flag == 0 || flag == 3 || flag == 6 || flag == 4) {
            while (this.m_nextIter.hasNext()) {
                IInfoObjectEventListener listenerDeliverToInbox;
                IInfoObjectEventListener listenerImport;
                final IInternalInfoObject obj = (IInternalInfoObject)this.m_nextIter.next();
                if (((InfoObject)obj).isReadOnly() || dirtyOnly && !obj.isDirty()) continue;
                IInfoObjectEventListener listener = obj.isFlagSet(0x200000) ? obj.getInfoObjectEventListener(4) : obj.getInfoObjectEventListener(2);
                if (listener != null) {
                    listener.process(new AbstractInfoObjectEvent(){

                        public IPersistInfoObject getInfoObject() {
                            return obj;
                        }

                        public IInternalInfoStore getInfoStore() {
                            return InfoObjects.this.m_infoStore;
                        }
                    });
                }
                if ((flag == 3 || flag == 6) && (listenerImport = obj.getInfoObjectEventListener(9)) != null) {
                    listenerImport.process(new AbstractInfoObjectEvent(){

                        public IPersistInfoObject getInfoObject() {
                            return obj;
                        }

                        public IInternalInfoStore getInfoStore() {
                            return InfoObjects.this.m_infoStore;
                        }
                    });
                }
                if (flag == 4 && (listenerDeliverToInbox = obj.getInfoObjectEventListener(10)) != null) {
                    listenerDeliverToInbox.process(new AbstractInfoObjectEvent(){

                        public IPersistInfoObject getInfoObject() {
                            return obj;
                        }

                        public IInternalInfoStore getInfoStore() {
                            return InfoObjects.this.m_infoStore;
                        }
                    });
                }
                if (dirtyOnly && !obj.isDirty()) continue;
                info_wire_ob3 packed = obj.pack(dirtyOnly);
                if (flag == 3) {
                    packed.options |= 0x20000000;
                } else if (flag == 6) {
                    packed.options |= 0x60000000;
                } else if (flag == 4) {
                    packed.options |= 0x40000000;
                }
                wire.add(packed);
                if (!this.m_nextIter.hasNext() || maxPackSize <= 0 || (packedSize = (int)((long)packedSize + OCASizeOf.sizeof(packed))) <= maxPackSize) continue;
                break;
            }
        } else {
            throw new SDKException.OutOfRange(flag, 0, 2);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("pack(): packed size=" + wire.size()));
        }
        return wire.toArray(new info_wire_ob3[wire.size()]);
    }

    private void packForNonCommitOperation(boolean dirtyOnly, List wire, int maxPackSize, int packedSize, int beforeEvent, int persistFlag) throws SDKException {
        while (this.m_nextIter.hasNext()) {
            final IInternalInfoObject obj = (IInternalInfoObject)this.m_nextIter.next();
            IInfoObjectEventListener listener = obj.getInfoObjectEventListener(beforeEvent);
            if (listener != null) {
                listener.process(new AbstractInfoObjectEvent(){

                    public IPersistInfoObject getInfoObject() {
                        return obj;
                    }

                    public IInternalInfoStore getInfoStore() {
                        return InfoObjects.this.m_infoStore;
                    }
                });
            }
            info_wire_ob3 packed = obj.pack(dirtyOnly);
            packed.options |= persistFlag;
            wire.add(packed);
            if (!this.m_nextIter.hasNext() || maxPackSize <= 0 || (packedSize = (int)((long)packedSize + OCASizeOf.sizeof(packed))) <= maxPackSize) continue;
            break;
        }
    }

    void afterCommit() throws SDKException {
        this.m_nextIter = this.m_list.iterator();
        if (!this.m_nextIter.hasNext()) {
            return;
        }
        while (this.m_nextIter.hasNext()) {
            IInfoObjectEventListener listener;
            final IInternalInfoObject obj = (IInternalInfoObject)this.m_nextIter.next();
            if (obj.isFlagSet(0x200000)) {
                listener = obj.getInfoObjectEventListener(6);
                if (listener == null) continue;
                listener.process(new AbstractInfoObjectEvent(){

                    public IPersistInfoObject getInfoObject() {
                        return obj;
                    }

                    public IInternalInfoStore getInfoStore() {
                        return InfoObjects.this.m_infoStore;
                    }
                });
                continue;
            }
            listener = obj.getInfoObjectEventListener(5);
            if (listener == null) continue;
            listener.process(new AbstractInfoObjectEvent(){

                public IPersistInfoObject getInfoObject() {
                    return obj;
                }

                public IInternalInfoStore getInfoStore() {
                    return InfoObjects.this.m_infoStore;
                }

                public ISecuritySession getSecuritySession() {
                    return InfoObjects.this.m_session;
                }
            });
        }
    }

    public void startUnpack(ISecuritySession session, IInternalInfoStore infoStore, info_wire_ob3[] wireObjs) throws SDKException {
        this.m_session = session;
        this.m_infoStore = infoStore;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("startUnpack(): wire objects size=" + wireObjs.length));
        }
        this.m_list = new ArrayList(wireObjs.length);
        this.continueUnpack(wireObjs);
        LOG.debug((Object)"startUnpack(): exit");
    }

    public void continueUnpack(info_wire_ob3[] wireObjs) throws SDKException {
        LOG.debug((Object)"continueUnpack(): enter");
        LOG.assertNotNull((Object)this.m_list, "m_list is null.");
        for (int i = 0; i < wireObjs.length; ++i) {
            if (wireObjs[i].uid == 0) {
                IProperty countProp;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"continueUnpack(): handling ID=0 object");
                }
                IInfoObject obj = (IInfoObject)this.newInfoObject();
                IPersistInfoObject persistInfoObject = (IPersistInfoObject)((Object)obj);
                persistInfoObject.unpack(this.m_session, this, wireObjs[i]);
                persistInfoObject.cleanupChanges();
                IProperty prop = obj.properties().getProperty(PropertyIDs.SI_RESULT_SIZE);
                if (prop != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("continueUnpack(): result size=" + prop.getValue()));
                    }
                    this.m_resultSize = (Integer)prop.getValue();
                    obj.properties().setProperty((Object)PropertyIDs.SI_RESULT_SIZE, null);
                }
                if ((countProp = obj.properties().getProperty(PropertyIDs.SI_AGGREGATE_COUNT)) == null || !(countProp.getValue() instanceof IProperties)) continue;
                LOG.debug((Object)"SI_AGGREGATE_COUNT found");
                this.m_list.add(obj);
                continue;
            }
            int type = wireObjs[i].objType & Short.MAX_VALUE;
            IPersistInfoObject obj = null;
            try {
                obj = (IPersistInfoObject)this.m_infoStore.getPluginMgr().getPluginInterface(new Integer(type), "desktop");
            }
            catch (SDKException.PluginNotFound e) {
                LOG.warn((Object)("continueUnpack(): plugin not found, type=" + type), (Throwable)((Object)e));
                obj = (IPersistInfoObject)this.newInfoObject(new Integer(type));
            }
            catch (SDKException.PluginNotFoundAtCMS e) {
                obj = (IPersistInfoObject)this.newInfoObject();
            }
            obj.unpack(this.m_session, this, wireObjs[i]);
            obj.cleanupChanges();
            this.m_list.add(obj);
        }
        LOG.debug((Object)"continueUnpack(): exit");
    }

    protected Object newInfoObject() {
        return new InfoObject();
    }

    protected Object newInfoObject(Object plgKey) {
        Object obj;
        block9: {
            obj = null;
            try {
                IPluginInfo pi = plgKey instanceof IPluginInfo ? (IPluginInfo)plgKey : this.m_infoStore.getPluginMgr().getPluginInfo(plgKey);
                boolean hasjavaplugin = pi.hasPlugin();
                if (hasjavaplugin) {
                    LOG.assertTrue(false, "Java plugin for " + pi.getKind() + " is not loaded.");
                }
                boolean isSupportCategoryContent = pi.isSupportCategoryContent();
                boolean isSchedulable = pi.isSchedulable();
                if (isSchedulable && isSupportCategoryContent) {
                    obj = new SchedulableCategoryContentInfoObject();
                } else if (isSchedulable) {
                    obj = new SchedulableInfoObject();
                } else if (isSupportCategoryContent) {
                    obj = new CategoryContentInfoObject();
                }
            }
            catch (Throwable e) {
                if (!LOG.isWarnEnabled()) break block9;
                LOG.warn((Object)("newInfoObject(): plugin info not found, type=" + plgKey), e);
            }
        }
        if (obj == null) {
            obj = this.newInfoObject();
        }
        return obj;
    }

    public void finishUnpack() throws SDKException {
    }

    public void merge(info_wire_ob3[] wireObjs) throws SDKException {
        if (wireObjs.length == 0) {
            return;
        }
        HashMap<Integer, info_wire_ob3> objs = new HashMap<Integer, info_wire_ob3>();
        for (int i = 0; i < wireObjs.length; ++i) {
            info_wire_ob3 wireObj = wireObjs[i];
            objs.put(new Integer(wireObj.uid), wireObj);
        }
        Iterator iter = this.m_list.iterator();
        while (iter.hasNext()) {
            IPersistInfoObject obj;
            info_wire_ob3 wire_ob;
            Object object = iter.next();
            if (!(object instanceof IPersistInfoObject) || (wire_ob = (info_wire_ob3)objs.get(new Integer(((IInfoObject)((Object)(obj = (IPersistInfoObject)object))).getID()))) == null) continue;
            obj.merge(wire_ob);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"merge(): exit");
        }
    }

    public void saveRights(IRightsAdmin rightsAdmin) throws SDKException {
        Iterator iter = this.m_list.iterator();
        while (iter.hasNext()) {
            IInternalInfoObject obj = (IInternalInfoObject)iter.next();
            if (obj.isFlagSet(0x200000)) continue;
            obj.saveRights(rightsAdmin);
        }
    }

    public void saveRights2(ISecRightsAdmin rightsAdmin) throws SDKException {
        Iterator iter = this.m_list.iterator();
        while (iter.hasNext()) {
            IInternalInfoObject obj = (IInternalInfoObject)iter.next();
            if (obj.isFlagSet(0x200000)) continue;
            obj.saveRights2(rightsAdmin);
        }
    }

    public Object get(int index) {
        return InfoObjects.proxyElement(this.m_list.get(index));
    }

    public int size() {
        return this.m_list.size();
    }

    public IInfoObject add(IPluginInfo info) throws SDKException {
        IPersistInfoObject obj;
        try {
            obj = (IPersistInfoObject)this.m_infoStore.getPluginMgr().getPluginInterface(info.getProgID(), "desktop");
        }
        catch (SDKException.PluginNotFound e) {
            LOG.warn((Object)("add(): plugin not found, progid=" + info.getProgID()), (Throwable)((Object)e));
            obj = (IPersistInfoObject)this.newInfoObject(info);
        }
        obj.initialize(this.m_session, this, ((INewID)((Object)this.m_infoStore)).newID(), info.getType());
        if (this.m_commitLevel == 1) {
            ((IInfoObject)((Object)obj)).setCommitLevel(1);
        }
        this.m_list.add(obj);
        return (IInfoObject)((Object)obj);
    }

    public void delete(IInfoObject object) throws SDKException {
        ((IPersistInfoObject)((Object)object)).delete();
    }

    public void add(int index, Object element) {
        if (!(element instanceof IInfoObject)) {
            if (element != null) {
                throw new ClassCastException(element.getClass().toString());
            }
            throw new UnsupportedOperationException();
        }
        this.m_list.add(index, InfoObjects.unproxyElement(element));
    }

    public Object remove(int index) {
        return InfoObjects.proxyElement(this.m_list.remove(index));
    }

    public Object set(int index, Object element) {
        if (!(element instanceof IInfoObject)) {
            if (element != null) {
                throw new ClassCastException(element.getClass().toString());
            }
            throw new UnsupportedOperationException();
        }
        return this.m_list.set(index, InfoObjects.unproxyElement(element));
    }

    public boolean addAll(int index, Collection c) {
        Collection col = this.ensureIInfoObjectTypeAndUnproxy(c);
        return this.m_list.addAll(index, col);
    }

    public void clear() {
        this.m_list.clear();
    }

    public boolean addAll(Collection c) {
        Collection col = this.ensureIInfoObjectTypeAndUnproxy(c);
        return this.m_list.addAll(col);
    }

    private Collection ensureIInfoObjectTypeAndUnproxy(Collection c) {
        ArrayList<Object> unProxyElements = new ArrayList<Object>(c.size());
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof IInfoObject)) {
                if (obj != null) {
                    throw new ClassCastException(obj.getClass().toString());
                }
                throw new UnsupportedOperationException();
            }
            unProxyElements.add(InfoObjects.unproxyElement(obj));
        }
        return unProxyElements;
    }

    public IInfoObject copy(IInfoObject source, int mode) throws SDKException {
        IInfoObjectEventListener listener = ((IPersistInfoObject)((Object)(source = (IInfoObject)InfoObjects.unproxyElement(source)))).getInfoObjectEventListener(1);
        if (listener != null) {
            final int iMode = mode;
            final IInternalInfoObject obj = (IInternalInfoObject)source;
            listener.process(new AbstractInfoObjectEvent(){

                public IPersistInfoObject getInfoObject() {
                    return obj;
                }

                public ISecuritySession getSecuritySession() {
                    return InfoObjects.this.m_session;
                }

                public int getMode() {
                    return iMode;
                }
            });
        }
        ObjectID_Ex id = InfoObjects.isCopyNewObject(mode) ? ((INewID)((Object)this.m_infoStore)).newID() : new ObjectID_Ex(source.getID(), null);
        boolean copyWithinCluster = this.isObjFromSameDeployment(source);
        IPersistInfoObject obj = this.doCopy(source, id, mode, copyWithinCluster);
        if (mode == 2) {
            this.deepCopy(source, id.id, copyWithinCluster);
        }
        return (IInfoObject)InfoObjects.proxyElement(obj);
    }

    static boolean isCopyNewObject(int copyMode) {
        return copyMode == 3 || copyMode == 2;
    }

    private IPersistInfoObject doCopy(IInfoObject source, ObjectID_Ex id, int mode, boolean inCluster) throws SDKException {
        IPersistInfoObject obj;
        Object plgKey;
        int obType = ((IInternalInfoObject)source).getObjType();
        if (inCluster) {
            plgKey = new Integer(((IInternalInfoObject)source).getObjType() & Short.MAX_VALUE);
        } else {
            plgKey = ((InfoObject)source).getProgID();
            IPluginInfo plgInfo = this.m_infoStore.getPluginMgr().getPluginInfo(plgKey);
            obType = plgInfo.getType();
        }
        try {
            obj = (IPersistInfoObject)this.m_infoStore.getPluginMgr().getPluginInterface(plgKey, "desktop");
        }
        catch (SDKException.PluginNotFound e) {
            LOG.warn((Object)("add(): plugin not found, progid=" + plgKey), (Throwable)((Object)e));
            obj = (IPersistInfoObject)this.newInfoObject(plgKey);
        }
        obj.copy(this.m_session, this, id, source, mode);
        ((IInternalInfoObject)obj).setObjType(obType);
        this.m_list.add(obj);
        return obj;
    }

    private void deepOperation(IInfoObject source, int parentId, boolean isUpdate, boolean inCluster) throws SDKException {
        if (((IPersistInfoObject)((Object)source)).isDeepCopySupported()) {
            String query;
            IInfoObjects nextCol;
            int nextBatchStartId = 0;
            IInternalInfoStore srcInfoStore = this.getInfoStore(source);
            List children = null;
            while ((nextCol = srcInfoStore.query(query = "select * from ci_infoobjects where selectUsingProperty(" + source.getID() + ", si_package_components, si_cuid)  and si_id > " + nextBatchStartId + " order by si_id")) != null && nextCol.size() != 0) {
                if (children == null) {
                    children = nextCol;
                } else {
                    children.merge(nextCol);
                }
                IInfoObject lastChild = (IInfoObject)nextCol.get(nextCol.size() - 1);
                nextBatchStartId = children.getResultSize() > children.size() && lastChild != null ? lastChild.getID() : 0;
                if (nextBatchStartId > 0) continue;
            }
            if (children == null || children.size() == 0) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("source object " + source.getID() + " contains no component objects"));
                }
                return;
            }
            if (!((InfoObjects)children).getSecurityInfo().checkRight(61, null, false)) {
                throw new SDKException.NoRightChildren(61, parentId);
            }
            ObjectID_Ex[] ids = ((INewID)((Object)this.m_infoStore)).newIDs(children.size());
            ((ArrayList)this.m_list).ensureCapacity(this.m_list.size() + children.size());
            int indx = 0;
            IInfoObject nextObj = null;
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                nextObj = (IInfoObject)InfoObjects.unproxyElement(iter.next());
                IPersistInfoObject obj = null;
                if (isUpdate) {
                    obj = this.getUpdateCopy(nextObj.getCUID());
                }
                if (obj == null) {
                    obj = this.doCopy(nextObj, ids[indx++], 3, inCluster);
                    ((IInfoObject)((Object)obj)).properties().setProperty((Object)PropertyIDs.SI_PARENTID, parentId);
                    if (nextObj.getRUID() == null) continue;
                    ((IInfoObject)((Object)obj)).properties().setProperty((Object)PropertyIDs.SI_RUID, nextObj.getRUID());
                    continue;
                }
                obj.update(this.m_session, nextObj);
            }
        }
    }

    public IInfoObject update(IInfoObject source) throws SDKException {
        if (this.isObjFromSameDeployment(source = (IInfoObject)InfoObjects.unproxyElement(source))) {
            throw new SDKException.SameDeployment();
        }
        ISecurityInfo2 securityInfo = source.getSecurityInfo2();
        if (!securityInfo.checkRight(61, null, true)) {
            throw new SecurityInfoException.NoRight(61, source.getID(), source.getTitle());
        }
        IPersistInfoObject obj = null;
        obj = this.getUpdateCopy(source.getCUID());
        if (obj == null) {
            throw new SDKException.ObjectNotFound(source.getCUID());
        }
        obj.update(this.m_session, source);
        this.deepUpdate(source, ((IInfoObject)((Object)obj)).getID());
        return (IInfoObject)InfoObjects.proxyElement(obj);
    }

    public IBatchSecurityItems getBatchSecurityItems() throws SDKException {
        return new BatchSecurityItems(this.m_session);
    }

    private boolean isObjFromSameDeployment(IInfoObject source) {
        return ((IInternalInfoObject)source).getSession().getClusterName().equalsIgnoreCase(this.m_session.getClusterName());
    }

    private IPersistInfoObject getUpdateCopy(String srcCUID) throws SDKException {
        IPersistInfoObject existingObj = null;
        Iterator iter = this.m_list.iterator();
        while (iter.hasNext()) {
            IInfoObject nextObj = (IInfoObject)iter.next();
            if (!nextObj.getCUID().equals(srcCUID)) continue;
            existingObj = (IPersistInfoObject)((Object)nextObj);
            break;
        }
        return existingObj;
    }

    private void deepCopy(IInfoObject source, int parentId, boolean inCluster) throws SDKException {
        this.deepOperation(source, parentId, false, inCluster);
    }

    private void deepUpdate(IInfoObject source, int parentId) throws SDKException {
        this.deepOperation(source, parentId, true, false);
    }

    private IInternalInfoStore getInfoStore(IInfoObject obj) throws SDKException {
        ISecuritySession sec = ((IInternalInfoObject)obj).getSession();
        return (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA(sec.getAPSName(), sec);
    }

    public void merge(IInfoObjects sourceObjects) throws SDKException {
        String srcClusterName;
        int srcAPSVersion;
        int destAPSVersion = this.m_session.getAPSVersion(true);
        if (destAPSVersion != (srcAPSVersion = ((InfoObjects)sourceObjects).m_session.getAPSVersion(true))) {
            throw new SDKException.DifferentEnterpriseVersion(destAPSVersion, srcAPSVersion);
        }
        String destClusterName = this.m_session.getClusterName();
        if (!destClusterName.equals(srcClusterName = ((InfoObjects)sourceObjects).m_session.getClusterName())) {
            throw new SDKException.DifferentDeployment(destClusterName, srcClusterName);
        }
        HashSet<Integer> destIDs = new HashSet<Integer>(this.size(), 0.9f);
        for (int destIndex = 0; destIndex < this.m_list.size(); ++destIndex) {
            IInfoObject destObj = (IInfoObject)this.m_list.get(destIndex);
            int destObjID = destObj.getID();
            destIDs.add(new Integer(destObjID));
        }
        List sourceList = ((InfoObjects)sourceObjects).m_list;
        for (int srcIndex = 0; srcIndex < sourceList.size(); ++srcIndex) {
            IInfoObject srcObj = (IInfoObject)sourceList.get(srcIndex);
            int srcObjID = srcObj.getID();
            if (destIDs.contains(new Integer(srcObjID))) continue;
            this.m_list.add(srcObj);
        }
    }

    SDKExceptionsCollector commitFileChanges(Set skippedIDs) throws SDKException {
        SDKExceptionsCollector collector = new SDKExceptionsCollector();
        Iterator iter = this.m_list.iterator();
        while (iter.hasNext()) {
            IInfoObject obj;
            Object element = iter.next();
            if (!(element instanceof IInfoObject) || (obj = (IInfoObject)element).isReadOnly() || skippedIDs != null && skippedIDs.contains(new Integer(obj.getID()))) continue;
            IFiles files = null;
            if (obj instanceof IInternalInfoObject) {
                files = ((IInternalInfoObject)obj).getFileObjects();
            } else {
                try {
                    files = obj.getFiles();
                }
                catch (SDKException e) {
                    collector.collect(new SDKException.FileCommitError(obj.getID(), (Throwable)((Object)e)));
                    continue;
                }
            }
            if (files == null) continue;
            try {
                files.commit();
            }
            catch (SDKException e) {
                collector.collect(new SDKException.FileCommitError(obj.getID(), (Throwable)((Object)e)));
            }
        }
        return collector;
    }

    void abortFileChanges(Set skippedIDs) throws SDKException {
        SDKExceptionsCollector collector = new SDKExceptionsCollector();
        Iterator iter = this.m_list.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IInfoObject)) continue;
            IInfoObject obj = (IInfoObject)element;
            if (skippedIDs != null && skippedIDs.contains(new Long(obj.getID()))) continue;
            IFiles files = null;
            if (obj instanceof IInternalInfoObject) {
                IInternalInfoObject infoObject = (IInternalInfoObject)obj;
                files = infoObject.getFileObjects();
            } else {
                try {
                    files = obj.getFiles();
                }
                catch (SDKException e) {
                    collector.collect(e);
                    continue;
                }
            }
            if (files == null) continue;
            files.abort();
        }
        collector.close();
    }

    public int getResultSize() {
        if (this.m_resultSize != -1) {
            return this.m_resultSize;
        }
        return this.size();
    }

    void cleanUpChanges(Set skippedIDs) {
        Iterator iter = this.m_list.iterator();
        while (iter.hasNext()) {
            IPersistInfoObject obj = (IPersistInfoObject)iter.next();
            IInfoObject infoObject = (IInfoObject)((Object)obj);
            if (skippedIDs != null && skippedIDs.contains(new Integer(infoObject.getID())) || !obj.isDirty()) continue;
            obj.cleanupChanges();
        }
    }

    private ISecurityInfo2 getSecurityInfo() {
        if (this.m_securityInfo == null) {
            this.m_securityInfo = new BatchSecurityInfo(this, this.m_session);
        }
        return this.m_securityInfo;
    }

    public IInfoObject add(String kind) throws SDKException {
        IPluginInfo info = this.m_infoStore.getPluginMgr().getPluginInfo(kind);
        IInfoObject obj = this.add(info);
        return obj;
    }

    protected final Object writeReplace() throws ObjectStreamException {
        return new SerializableInfoObjects(this.m_list, this.m_infoStore, this.m_resultSize, this.getProgID());
    }

    public void setSerializedInfoObjects(String packedRootProps) throws SDKException {
        WireOb3Unpacker unpacker = new WireOb3Unpacker();
        unpacker.initialize(packedRootProps);
        SDKPropertyBag rootBag = new SDKPropertyBag();
        rootBag.merge(unpacker);
        String sess = rootBag.getString(PropertyIDs.SI_SESSION_ID);
        this.m_session = SecurityFactory.getFactory().makeSecuritySession(sess);
        InfoStore infostore = (InfoStore)InfoStoreFactory.getFactory().makeOCCA(this.m_session.getAPSName(), this.m_session);
        this.m_infoStore = infostore.getInternalInfoStore();
        Property objsbagProp = rootBag.getItem(PropertyIDs.SI_OBJECTS);
        SDKPropertyBag infoobjectBag = (SDKPropertyBag)objsbagProp.getPropertyBag();
        PropertyArrayHelper bagh = new PropertyArrayHelper((PropertyBag)infoobjectBag, PropertyIDs.SI_TOTAL);
        int size = infoobjectBag.getInt(PropertyIDs.SI_TOTAL);
        for (int i = 0; i < size; ++i) {
            String objStr = (String)bagh.get(i);
            IInfoObject obj = InfoObject.getDeserializedInfoObject(this.m_session, objStr);
            this.m_list.add(obj);
        }
    }

    public String getSerializedInfoObjects(IProperties extraProps, int startIndex, int count, IntHolder nextIndex) throws SDKException {
        int size = this.size();
        if (startIndex < 0 || startIndex > size) {
            throw new SDKException.InvalidArg("startIndex");
        }
        if (startIndex + count - 1 >= size) {
            throw new SDKException.InvalidArg("count");
        }
        SDKPropertyBag rbag = new SDKPropertyBag();
        if (extraProps != null) {
            SDKPropertyBag extraPropBag = (SDKPropertyBag)rbag.addPropertyBag(PropertyIDs.SI_EXTRA_PROPS, null).getPropertyBag();
            extraPropBag.putAll(extraProps);
        }
        rbag.add(PropertyIDs.SI_SESSION_ID, this.m_session.getSessionID(), 0);
        SDKPropertyBag infoobjectBag = (SDKPropertyBag)rbag.addPropertyBag(PropertyIDs.SI_OBJECTS, null).getPropertyBag();
        PropertyArrayHelper bagh = new PropertyArrayHelper((PropertyBag)infoobjectBag, PropertyIDs.SI_TOTAL);
        int actualCount = 0;
        int i = 0;
        for (i = startIndex; i < size && actualCount < count; ++i) {
            InfoObject obj = (InfoObject)this.m_list.get(i);
            IProperty ignoreProp = obj.getProperty(PropertyIDs.SI_IGNORE);
            if (ignoreProp != null) continue;
            String str = obj.getSerializedInfoObject();
            bagh.add(actualCount, (Object)str);
            ++actualCount;
        }
        if (i == size) {
            nextIndex.set(-1);
        } else {
            nextIndex.set(i);
        }
        WireOb3Packer packer = new WireOb3Packer();
        String packedString = packer.pack(rbag, 0, 0, false, 0, 0);
        return packedString;
    }

    public String getSerializedInfoObjects(IProperties extraProps) throws SDKException {
        IntHolder nextIndex = new IntHolder(0);
        return this.getSerializedInfoObjects(extraProps, 0, this.size(), nextIndex);
    }

    protected String getProgID() {
        return null;
    }

    public void initFromSerialization(List list, IInternalInfoStore infoStore, int resultSize) {
        this.m_list = list;
        this.m_infoStore = infoStore;
        this.m_resultSize = resultSize;
        this.m_session = ((InternalInfoStore)this.m_infoStore).getSecuritySession();
    }

    public void setCommitLevel(int cl) throws SDKException {
        if (cl == 0 || cl == 1) {
            this.m_commitLevel = cl;
            Iterator objIter = this.m_list.iterator();
            while (objIter.hasNext()) {
                InfoObject infoObj = (InfoObject)objIter.next();
                infoObj.setCommitLevel(cl);
            }
        } else {
            throw new SDKException.InvalidArg();
        }
    }

    static Object unproxyElement(Object element) {
        InvocationHandler invocationHandler;
        if (element != null && Proxy.isProxyClass(element.getClass()) && (invocationHandler = Proxy.getInvocationHandler(element)) instanceof IProxyHandler) {
            return ((IProxyHandler)invocationHandler).getObject();
        }
        return element;
    }

    static Object proxyElement(Object element) {
        if (element instanceof IProxySupport) {
            return ((IProxySupport)element).getProxy();
        }
        return element;
    }

    public boolean hasMoreToPack() {
        return this.m_nextIter.hasNext();
    }
}

