/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.category.ICategory;
import com.businessobjects.sdk.plugin.desktop.category.internal.Categories;
import com.businessobjects.sdk.plugin.desktop.inbox.IInbox;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.CommitMode;
import com.crystaldecisions.sdk.occa.infostore.ICategoryPager;
import com.crystaldecisions.sdk.occa.infostore.ICommitResult;
import com.crystaldecisions.sdk.occa.infostore.IFolderPager;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.IInfoStore;
import com.crystaldecisions.sdk.occa.infostore.IPagingQuery;
import com.crystaldecisions.sdk.occa.infostore.SearchPattern;
import com.crystaldecisions.sdk.occa.infostore.SortType;
import com.crystaldecisions.sdk.occa.infostore.internal.CategoryPager;
import com.crystaldecisions.sdk.occa.infostore.internal.FolderPager;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoStoreSecurity;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStoreFactory;
import com.crystaldecisions.sdk.occa.infostore.internal.QuerySettings;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.plugin.desktop.folder.IFolder;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.uri.IPageResult;
import com.crystaldecisions.sdk.uri.IStatelessPageInfo;
import com.crystaldecisions.sdk.uri.PagingQueryOptions;
import com.crystaldecisions.sdk.uri.internal.URIPageFactory;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class InfoStore
implements IInfoStore,
IInfoStoreSecurity,
Externalizable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.InfoStore");
    private IInternalInfoStore m_infostore;
    private ISecuritySession m_secSession;

    private void pagingSetup(int propSet, SearchPattern searchPattern, SortType sortType, String progid, String table, boolean bTopLevel) throws SDKException {
        if (propSet != 7 && propSet != 1 && propSet != 4 && propSet != 2) {
            throw new SDKException.InvalidArg();
        }
        if (bTopLevel) {
            this.modifySearchPattern(searchPattern, 0);
        } else {
            this.modifySearchPattern(searchPattern, progid);
        }
    }

    private void modifySearchPattern(SearchPattern pattern, String progid) throws SDKException {
        int parentid = pattern.getParentID();
        if (parentid > 0) {
            return;
        }
        int rootFolderID = this.m_infostore.getPluginMgr().getPluginInfo(progid).getRootFolderID();
        pattern.setParentID(rootFolderID);
    }

    private void modifySearchPattern(SearchPattern pattern, int parentID) {
        int parentid = pattern.getParentID();
        if (parentid > 0) {
            return;
        }
        pattern.setParentID(parentID);
    }

    public InfoStore() {
    }

    InfoStore(String svr, ISecuritySession session) throws SDKException {
        this.m_infostore = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA(svr, session);
        this.m_secSession = session;
    }

    public ISecuritySession getSecuritySession() {
        InternalInfoStore istore = (InternalInfoStore)this.m_infostore;
        return istore.getSecuritySession();
    }

    public IPageResult getPagingQuery(String uri, PagingQueryOptions options) throws SDKException {
        return URIPageFactory.pageResult(this, uri, options);
    }

    public IStatelessPageInfo getStatelessPageInfo(String uri, PagingQueryOptions options) throws SDKException {
        return URIPageFactory.fetchPage(this, uri, options);
    }

    public IPagingQuery getPagingQuery() throws SDKException {
        return this.m_infostore.getPagingQuery();
    }

    public void commit(IInfoObjects objects) throws SDKException {
        this.m_infostore.commit(objects);
    }

    public void commit(IInfoObjects objects, boolean atomic) throws SDKException {
        this.m_infostore.commit(objects, atomic);
    }

    public ICommitResult commit(IInfoObjects objects, boolean atomic, CommitMode mode) {
        return this.m_infostore.commit(objects, atomic, mode);
    }

    public IInfoObjects newInfoObjectCollection() {
        return this.m_infostore.newInfoObjectCollection();
    }

    public IProperties newPropertyCollection() {
        return this.m_infostore.newPropertyCollection();
    }

    public IPluginMgr getPluginMgr() {
        return this.m_infostore.getPluginMgr();
    }

    public IInfoObjects query(String query) throws SDKException {
        return this.m_infostore.query(query);
    }

    public IInfoObjects[] query(String[] queries) throws SDKException {
        return this.m_infostore.query(queries);
    }

    public void schedule(IInfoObjects objects) throws SDKException {
        this.m_infostore.schedule(objects);
    }

    public void sendTo(IInfoObjects objects) throws SDKException {
        this.m_infostore.sendTo(objects);
    }

    public void deliverToInbox(IInfoObjects objects) throws SDKException {
        this.m_infostore.deliverToInbox(objects);
    }

    public IInfoObjects find(int propertySet, SearchPattern searchPattern, SortType sortType) throws SDKException {
        if (propertySet != 7 && propertySet != 1 && propertySet != 4 && propertySet != 2) {
            throw new SDKException.InvalidArg("propertySet");
        }
        QuerySettings query = new QuerySettings(this.m_infostore, "CI_INFOOBJECTS, CI_SYSTEMOBJECTS, CI_APPOBJECTS", QuerySettings.ToFields(propertySet), QuerySettings.generateWhereClause(searchPattern), QuerySettings.getOrderClause(sortType));
        return query.executeQuery();
    }

    public IFolderPager getTopFolders() throws SDKException {
        return this.getTopFolders(1, null, null);
    }

    public IFolderPager getTopFolders(int propertySet, SearchPattern searchPattern, SortType sortType) throws SDKException {
        String progid = "CrystalEnterprise.Folder";
        String table = "CI_INFOOBJECTS";
        SearchPattern topSearch = new SearchPattern(searchPattern);
        topSearch.setObjectKind("Folder");
        topSearch.setParentID(0);
        SortType topSortType = new SortType(sortType);
        this.pagingSetup(propertySet, topSearch, topSortType, progid, table, true);
        FolderPager ans = new FolderPager();
        ans.initialize(this.m_infostore, table, propertySet, topSearch, topSortType);
        return ans;
    }

    public IFolder getMyFavoritesFolder() throws SDKException {
        StringBuffer whereClause = new StringBuffer(50);
        whereClause.append("SI_PARENTID=");
        whereClause.append(18);
        whereClause.append(" AND SI_OWNERID=");
        whereClause.append(this.m_secSession.getUserInfo().getUserID());
        QuerySettings query = new QuerySettings(this.m_infostore, "CI_INFOOBJECTS", "SI_ID, SI_CUID, SI_NAME, SI_PARENTID, SI_PARENT_CUID, SI_KIND, SI_INSTANCE", whereClause.toString());
        IInfoObjects fldrs = query.executeQuery();
        if (fldrs.size() == 0) {
            LOG.error((Object)"Couldn't get my favoritefolder");
            throw new SDKException.ObjectNotFound("");
        }
        return (IFolder)fldrs.get(0);
    }

    public IInternalInfoStore getInternalInfoStore() {
        return this.m_infostore;
    }

    public int getSessionFolderID() throws SDKException {
        return this.m_infostore.getSessionFolderID();
    }

    public ICategoryPager getTopCategories() throws SDKException {
        return this.getTopCategories(1, null, null);
    }

    public ICategoryPager getTopCategories(int propertySet, SearchPattern searchPattern, SortType sortType) throws SDKException {
        String progid = "CrystalEnterprise.Category";
        String table = "CI_INFOOBJECTS";
        SearchPattern mySearch = new SearchPattern(searchPattern);
        mySearch.setParentID(45);
        mySearch.setObjectKind("Category");
        this.pagingSetup(propertySet, mySearch, sortType, progid, table, false);
        CategoryPager ans = new CategoryPager();
        ans.initialize(this.m_infostore, table, propertySet, mySearch, sortType);
        return ans;
    }

    public ICategory getMyPersonalCategory() throws SDKException {
        StringBuffer whereClause = new StringBuffer(50);
        whereClause.append("SI_PARENTID=");
        whereClause.append(47);
        whereClause.append(" AND SI_OWNERID=");
        whereClause.append(this.m_secSession.getUserInfo().getUserID());
        Categories cats = new Categories(null);
        QuerySettings query = new QuerySettings(this.m_infostore, "CI_INFOOBJECTS", "SI_ID, SI_CUID, SI_NAME, SI_PARENTID, SI_PARENT_CUID, SI_KIND, SI_INSTANCE", whereClause.toString());
        cats = (Categories)query.executeQuery(cats);
        return cats.getCategory(0);
    }

    public IInbox getMyInbox() throws SDKException {
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("SI_PARENTID=");
        whereClause.append(48);
        whereClause.append(" AND SI_OWNERID=");
        whereClause.append(this.m_secSession.getUserInfo().getUserID());
        QuerySettings query = new QuerySettings(this.m_infostore, "CI_INFOOBJECTS", "SI_ID, SI_CUID, SI_NAME, SI_PARENTID, SI_PARENT_CUID, SI_KIND, SI_INSTANCE", whereClause.toString());
        IInfoObjects fldrs = query.executeQuery();
        if (fldrs.size() == 0) {
            LOG.error((Object)"Couldn't get my inbox");
            throw new SDKException.ObjectNotFound("");
        }
        return (IInbox)fldrs.get(0);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.m_infostore);
        out.writeObject(this.m_secSession);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_infostore = (IInternalInfoStore)in.readObject();
        this.m_secSession = (ISecuritySession)in.readObject();
    }
}

