/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoStorePackage.BatchError;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoStorePackage.BatchErrorHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.message_id;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.message_type;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.message_union;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKServerException;
import com.crystaldecisions.sdk.exception.internal.ServerMsgResourcesBundle;
import com.crystaldecisions.sdk.holder.internal.IntHolder;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Any;
import java.text.MessageFormat;
import java.util.Locale;

public class InfoStoreException
extends SDKServerException {
    private static final int IDS_ERR_I_UNDEFINED = 48160;
    private static final int E_OCA_I_INFOSTORE_UNDEFINED = 7680;
    private static final int IDS_ERR_I_COMMIT = 48162;

    protected InfoStoreException(oca_abuse e) {
        super(e);
    }

    public static SDKException map(oca_abuse e) {
        return new InfoStoreException(e);
    }

    public String getErrorCodeString() {
        String errorCode = super.getErrorCodeString();
        oca_abuse oca_abuse2 = (oca_abuse)this.getCause();
        Any errInfo = oca_abuse2.supplErrInfo;
        message_union[] messages = oca_abuse2.messages;
        if (errInfo == null || errInfo.type().kind().value() != 15 || !errInfo.type().equivalent(BatchErrorHelper.type()) || messages.length != 1) {
            return errorCode;
        }
        message_type type = messages[0].discriminator();
        if (type.equals(message_type.mt_id)) {
            message_id id = messages[0].msgId();
            if (id.num_strings != 0 || id.msgId != 48162) {
                return errorCode;
            }
            BatchError batchError = BatchErrorHelper.extract((Any)errInfo);
            for (int i = 0; i < batchError.failureCodes.length; ++i) {
                int code = this.getResourceID(batchError.failureCodes[i]);
                String codeKey = code + "_code";
                String temp = ServerMsgResourcesBundle.getString(codeKey, Locale.ENGLISH);
                if (temp == null) continue;
                errorCode = temp;
            }
        }
        return errorCode;
    }

    protected String getString(message_union[] messages, IntHolder indexHolder, Locale locale) {
        Any errInfo = ((oca_abuse)this.getCause()).supplErrInfo;
        if (errInfo == null || errInfo.type().kind().value() != 15 || !errInfo.type().equivalent(BatchErrorHelper.type()) || messages.length != 1) {
            return super.getString(messages, indexHolder, locale);
        }
        message_type type = messages[0].discriminator();
        indexHolder.set(indexHolder.get() + 1);
        if (type.equals(message_type.mt_id)) {
            message_id id = messages[0].msgId();
            if (id.num_strings != 0 || id.msgId != 48162) {
                indexHolder.set(0);
                return super.getString(messages, indexHolder, locale);
            }
            String pattern = ServerMsgResourcesBundle.getString(Integer.toString(48162), locale);
            BatchError batchError = BatchErrorHelper.extract((Any)errInfo);
            String[] strings = new String[batchError.failedItems.length];
            for (int i = 0; i < batchError.failureCodes.length; ++i) {
                strings[i] = this.convertToString(batchError.failureCodes[i], locale);
            }
            MessageFormat format = new MessageFormat(pattern);
            format.setLocale(locale);
            return format.format(strings);
        }
        if (type.equals(message_type.mt_string)) {
            return messages[0].msgString();
        }
        return "";
    }

    public int getFailedObjectID() {
        Any errInfo = ((oca_abuse)this.getCause()).supplErrInfo;
        if (errInfo.type().kind().value() == 15 && errInfo.type().equivalent(BatchErrorHelper.type())) {
            BatchError batchError = BatchErrorHelper.extract((Any)errInfo);
            return batchError.failedItems[0];
        }
        return super.getFailedObjectID();
    }

    public int[] getBatchErrorIDs() {
        oca_abuse oca_abuse2 = (oca_abuse)this.getCause();
        int failureCode = this.getResourceID(oca_abuse2.errCode);
        return new int[]{failureCode};
    }

    private String convertToString(int errorCode, Locale locale) {
        Integer id = new Integer(this.getResourceID(errorCode));
        String desc = ServerMsgResourcesBundle.getString(id.toString(), locale);
        if (desc == null) {
            String pattern = ServerMsgResourcesBundle.getMissingResourcePattern(locale);
            desc = pattern != null && pattern.indexOf("{0}") != -1 ? MessageFormat.format(pattern, id.toString(), "") : pattern;
        }
        return desc;
    }

    private int getResourceID(int errorCode) {
        return errorCode - 7680 + 48160;
    }
}

