/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileRepository;
import com.crystaldecisions.sdk.occa.filerepository.internal.IPutStreamTx;
import com.crystaldecisions.sdk.occa.infostore.ILocalFile;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

class LocalStream
implements ILocalFile,
Externalizable {
    private IFileRepository m_fileRepository;
    private IPutStreamTx m_fileTx;
    private InputStream m_in;
    private String m_name;
    private String m_destSubDir;
    private String m_destPrefix;
    private String m_oldFileURL;

    public LocalStream() {
    }

    public LocalStream(IFileRepository frs, byte[] stream, String destPath, String prefix, String ext, String subDir, boolean makeUniqueName, String oldFileURL, boolean bUploadContent) throws SDKException {
        this.m_fileRepository = frs;
        if (makeUniqueName) {
            this.m_fileTx = (IPutStreamTx)frs.putUnique(stream, destPath, prefix, ext);
            destPath = (String)this.m_fileTx.getDestination();
        } else {
            this.m_fileTx = frs.put(stream, destPath);
        }
        this.initialize(destPath, prefix, subDir);
        this.m_oldFileURL = oldFileURL;
        if (bUploadContent && this.m_fileTx != null) {
            this.m_fileTx.uploadContent();
        }
    }

    public LocalStream(IFileRepository frs, byte[] stream, String destPath, String prefix, String ext, String subDir, boolean makeUniqueName, boolean bUploadContent) throws SDKException {
        this(frs, stream, destPath, prefix, ext, subDir, makeUniqueName, null, bUploadContent);
    }

    public LocalStream(IFileRepository frs, long size, InputStream stream, String destPath, String prefix, String ext, String subDir, boolean makeUniqueName, String oldFileURL, boolean bUploadContent) throws SDKException {
        this.m_fileRepository = frs;
        this.m_fileTx = makeUniqueName ? this.m_fileRepository.putUnique(size, stream, destPath, prefix, ext) : this.m_fileRepository.put(size, stream, destPath);
        this.initialize(destPath, prefix, subDir);
        this.m_oldFileURL = oldFileURL;
        if (bUploadContent && this.m_fileTx != null) {
            this.m_fileTx.uploadContent();
        }
    }

    public File getFile() {
        throw new UnsupportedOperationException();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public InputStream getInputStream() throws IOException {
        if (this.m_in == null) {
            this.m_in = (InputStream)this.m_fileTx.getSource();
        }
        return this.m_in;
    }

    public String getLocalFile() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.m_name;
    }

    public long getSize() throws SDKException {
        throw new UnsupportedOperationException();
    }

    public void commit() throws SDKException {
        if (this.m_fileTx != null) {
            this.m_fileTx.commit();
            this.m_fileTx = null;
            if (this.m_oldFileURL != null) {
                this.m_fileRepository.remove(this.m_oldFileURL).commit();
                this.m_oldFileURL = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        if (this.m_fileTx != null) {
            try {
                this.m_fileTx.destroy();
            }
            catch (SDKException sDKException) {
            }
            finally {
                this.m_fileTx = null;
                this.m_oldFileURL = null;
            }
        }
    }

    String getDestSubDir() {
        return this.m_destSubDir;
    }

    String getDestPrefix() {
        return this.m_destPrefix;
    }

    void initFromSerialization(IFileRepository fileRepository) {
        this.m_fileRepository = fileRepository;
    }

    private void initialize(String destPath, String prefix, String subDir) {
        String shortName;
        this.m_destSubDir = null;
        this.m_destPrefix = null;
        int delim = destPath.lastIndexOf("/");
        if (delim == -1) {
            this.m_name = shortName = destPath;
        } else {
            this.m_name = shortName = destPath.substring(delim + 1);
            String dir = destPath.substring(0, delim);
            if (subDir != null && !subDir.equals("") && dir.endsWith(subDir = subDir.toLowerCase())) {
                this.m_destSubDir = subDir;
                this.m_name = subDir + '/' + this.m_name;
            }
        }
        if (prefix != null && !prefix.equals("") && shortName.startsWith(prefix = prefix.toLowerCase())) {
            this.m_destPrefix = prefix;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.m_fileTx);
        out.writeObject(this.m_name);
        out.writeObject(this.m_destSubDir);
        out.writeObject(this.m_destPrefix);
        out.writeObject(this.m_oldFileURL);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_fileTx = (IPutStreamTx)in.readObject();
        this.m_name = (String)in.readObject();
        this.m_destSubDir = (String)in.readObject();
        this.m_destPrefix = (String)in.readObject();
        this.m_oldFileURL = (String)in.readObject();
        this.m_in = null;
    }
}

