/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.FlagHelper;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ObjectRelatives
extends AbstractSet
implements Set {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.ObjectRelatives");
    private PropertyBag m_topLevelBag;
    protected Integer m_groupBagID;
    protected Integer m_addBagID;
    protected Integer m_remBagID;
    protected Integer m_updateBagID;
    private PropertyArrayHelper m_groupBagHelper;
    private PropertyArrayHelper m_addBagHelper;
    private PropertyArrayHelper m_remBagHelper;
    private PropertyArrayHelper m_updateBagHelper;
    protected boolean m_isCommitMainBag;
    protected static final String SI_ADM_ADD = "SI_ADM_ADD_";
    protected static final String SI_ADM_DEL = "SI_ADM_DEL_";
    protected static final String SI_ADM_UPD = "SI_ADM_UPD_";
    protected String m_deltaSuffix = null;
    private Map m_attrMap = new HashMap();
    private Map m_origAttrMap = new HashMap();

    public void initialize(Object mainBagKey, String deltaSuffix, AbstractInfoObject parent, boolean isOrderedList) throws SDKException {
        this.m_deltaSuffix = deltaSuffix;
        this.initialize(mainBagKey, parent.properties(), isOrderedList, parent.isNew());
        if (!parent.isNew() && parent.getObjectRelatives() != null) {
            parent.getObjectRelatives().add(this);
        }
        Set keys = this.m_attrMap.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Integer key = (Integer)iter.next();
            PropertyBag bagCopy = ((PropertyBag)this.m_attrMap.get(key)).copy();
            this.m_origAttrMap.put(key, bagCopy);
        }
    }

    public void initialize(Object mainBagkey, String deltaSuffix, IProperties topLevelBag, boolean isOrderedList, boolean isNewObj) throws SDKException {
        this.m_deltaSuffix = deltaSuffix;
        this.initialize(mainBagkey, topLevelBag, isOrderedList, isNewObj);
    }

    protected void initializeAddBag() {
        PropertyArrayHelper groupBagHelper;
        int size;
        if (this.findPropertyBag(this.m_groupBagID, false, this.m_isCommitMainBag) != null && (size = (groupBagHelper = this.getGroupBagHelper()).size()) > 0) {
            PropertyArrayHelper addBagHelper = this.getAddBagHelper();
            for (int i = 0; i < size; ++i) {
                Object groupId = groupBagHelper.get(i);
                addBagHelper.add(groupId);
            }
        }
    }

    public void initialize(Object key, IProperties topLevelBag, boolean isOrderedList, boolean isNewObj) throws SDKException {
        PropertyBag origBag;
        PropertyArrayHelper groupBagHelper;
        int size;
        this.m_topLevelBag = (PropertyBag)topLevelBag;
        this.m_isCommitMainBag = isOrderedList;
        if (this.m_deltaSuffix == null) {
            this.m_deltaSuffix = PropertyIDs.idToName((Integer)key);
        }
        this.setBagIDs(key);
        if (this.findPropertyBag(this.m_groupBagID, false, this.m_isCommitMainBag) != null && (size = (groupBagHelper = this.getGroupBagHelper()).size()) > 0) {
            for (int i = 0; i < size; ++i) {
                Object groupId = groupBagHelper.get(i);
                if (!(groupId instanceof PropertyBag)) continue;
                PropertyBag bag = (PropertyBag)groupId;
                this.m_attrMap.put(new Integer(bag.getInt((Object)PropertyIDs.SI_ID)), groupId);
            }
        }
        if (isNewObj) {
            this.initializeAddBag();
        }
        if (!isNewObj && isOrderedList && (origBag = this.findPropertyBag(key, false, true)) != null) {
            PropertyBag bag = this.m_topLevelBag.getPropertyBag((Object)PropertyIDs.SI_ADM_ORIG_EDGE_INFO);
            if (bag == null) {
                bag = this.m_topLevelBag.addItem((Object)PropertyIDs.SI_ADM_ORIG_EDGE_INFO, null, 0x8000000).getPropertyBag();
            }
            if (origBag.size() > 0) {
                PropertyBag subBag = bag.addItem(key, null, 0x8000000).getPropertyBag();
                Iterator iter = origBag.allIterator();
                while (iter.hasNext()) {
                    Property prop = (Property)iter.next();
                    if (prop.getID() == PropertyIDs.SI_TOTAL) {
                        subBag.addItem((Object)prop.getID(), prop.getValue(), 0);
                        continue;
                    }
                    if (prop.isContainer()) {
                        subBag.addItem((Object)prop.getID(), (Object)new Integer(prop.getPropertyBag().getInt((Object)PropertyIDs.SI_ID)), 0);
                        continue;
                    }
                    subBag.addItem((Object)prop.getID(), prop.getValue(), 0);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            if (this.m_isCommitMainBag) {
                LOG.debug((Object)("ObjectRelatives.initialize(): the main bag " + PropertyIDs.idToName(this.m_groupBagID) + " will be committed"));
            } else {
                LOG.debug((Object)("ObjectRelatives.initialize(): the delta bags " + PropertyIDs.idToName(this.m_addBagID) + " and " + PropertyIDs.idToName(this.m_remBagID) + " will be committed"));
            }
        }
    }

    public Set keySet() {
        return this.m_attrMap.keySet();
    }

    public boolean add(Object groupId) {
        PropertyArrayHelper bagHelper;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ObjectRelatives.add(): adding = " + groupId + " from relation " + PropertyIDs.idToName(this.m_groupBagID)));
        }
        if ((bagHelper = this.getGroupBagHelper()).indexOf(groupId) == -1) {
            bagHelper.add(groupId);
            if (!this.m_isCommitMainBag) {
                boolean wasRemoved = false;
                if (this.findPropertyBag(this.m_remBagID, false, !this.m_isCommitMainBag) != null) {
                    PropertyArrayHelper remBagHelper = this.getRemBagHelper();
                    wasRemoved = remBagHelper.remove(groupId);
                }
                if (!wasRemoved) {
                    PropertyArrayHelper addBagHelper = this.getAddBagHelper();
                    addBagHelper.add(groupId);
                }
            }
            return true;
        }
        return false;
    }

    public PropertyBag add(Object groupId, Object bagId) {
        PropertyArrayHelper bagHelper;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ObjectRelatives.add(): adding = " + groupId + " from relation " + PropertyIDs.idToName(this.m_groupBagID)));
        }
        if ((bagHelper = this.getGroupBagHelper()).indexOf(groupId) == -1) {
            Property prop = bagHelper.add(groupId, 0x8000000);
            PropertyBag pb = prop.getPropertyBag();
            pb.addItem((Object)PropertyIDs.SI_ID, groupId, 0);
            if (bagId != null) {
                pb.addItem(bagId, null, 0x8000000);
            }
            if (!this.m_isCommitMainBag) {
                boolean wasRemoved = false;
                if (this.findPropertyBag(this.m_remBagID, false, !this.m_isCommitMainBag) != null) {
                    PropertyArrayHelper remBagHelper = this.getRemBagHelper();
                    wasRemoved = remBagHelper.remove(groupId);
                }
                if (!wasRemoved) {
                    PropertyArrayHelper addBagHelper = this.getAddBagHelper();
                    Property p = addBagHelper.add(groupId, 0x8000000);
                    pb = p.getPropertyBag();
                    pb.addItem((Object)PropertyIDs.SI_ID, groupId, 0);
                    if (bagId != null) {
                        pb.addItem(bagId, null, 0x8000000);
                    }
                }
            }
            this.m_attrMap.put(groupId, pb);
            return pb;
        }
        int i = bagHelper.indexOf(groupId);
        return (PropertyBag)bagHelper.get(i);
    }

    public int size() {
        PropertyArrayHelper bagHelper = this.getGroupBagHelper();
        return bagHelper.size();
    }

    public Iterator iterator() {
        return new AssociatesIterator();
    }

    public Iterator attributedIter() {
        return new AttributedIterator();
    }

    private Object get(int index) {
        PropertyArrayHelper bagHelper = this.getGroupBagHelper();
        return bagHelper.get(index);
    }

    private Object remove(int index) {
        PropertyArrayHelper bagHelper;
        Object idToBeDeleted;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ObjectRelatives.add(): removing = " + index + " from relation " + PropertyIDs.idToName(this.m_groupBagID)));
        }
        if ((idToBeDeleted = (bagHelper = this.getGroupBagHelper()).remove(index)) instanceof PropertyBag) {
            index = ((PropertyBag)idToBeDeleted).getInt((Object)PropertyIDs.SI_ID);
        }
        this.m_attrMap.remove(new Integer(index));
        if (!this.m_isCommitMainBag) {
            Object wasAdded = null;
            if (this.findPropertyBag(this.m_addBagID, false, !this.m_isCommitMainBag) != null) {
                int currIndex;
                PropertyArrayHelper addBagHelper = this.getAddBagHelper();
                int size = addBagHelper.size();
                for (currIndex = 0; currIndex < size; ++currIndex) {
                    Object bagElement = addBagHelper.get(currIndex);
                    Integer indexVal = null;
                    if (bagElement instanceof PropertyBag) {
                        PropertyBag addBagContent = (PropertyBag)bagElement;
                        if (addBagContent.getInt((Object)PropertyIDs.SI_ID) != index) continue;
                        break;
                    }
                    indexVal = (Integer)bagElement;
                }
                if (currIndex < size) {
                    wasAdded = addBagHelper.remove(currIndex);
                }
            }
            if (wasAdded == null) {
                PropertyArrayHelper remBagHelper = this.getRemBagHelper();
                if (idToBeDeleted instanceof PropertyBag) {
                    Integer toBeDeleted = new Integer(((PropertyBag)idToBeDeleted).getInt((Object)PropertyIDs.SI_ID));
                    remBagHelper.add((Object)toBeDeleted);
                } else {
                    remBagHelper.add(idToBeDeleted);
                }
            }
        }
        return idToBeDeleted;
    }

    protected void setBagIDs(Object mainbagkey) {
        if (mainbagkey != null) {
            this.m_groupBagID = (Integer)mainbagkey;
            this.m_addBagID = this.defineDeltaAddProp();
            this.m_remBagID = this.defineDeltaDelProp();
            this.m_updateBagID = this.defineDeltaUpdateProp();
        }
    }

    protected PropertyArrayHelper getGroupBagHelper() {
        if (this.m_groupBagHelper == null) {
            this.m_groupBagHelper = new PropertyArrayHelper(this.findPropertyBag(this.m_groupBagID, true, this.m_isCommitMainBag), PropertyIDs.SI_TOTAL);
        }
        return this.m_groupBagHelper;
    }

    protected PropertyArrayHelper getAddBagHelper() {
        if (this.m_addBagHelper == null) {
            this.m_addBagHelper = new PropertyArrayHelper(this.findPropertyBag(this.m_addBagID, true, !this.m_isCommitMainBag), PropertyIDs.SI_TOTAL);
        }
        return this.m_addBagHelper;
    }

    protected PropertyArrayHelper getRemBagHelper() {
        if (this.m_remBagHelper == null) {
            this.m_remBagHelper = new PropertyArrayHelper(this.findPropertyBag(this.m_remBagID, true, !this.m_isCommitMainBag), PropertyIDs.SI_TOTAL);
        }
        return this.m_remBagHelper;
    }

    protected PropertyArrayHelper getUpdateBagHelper() {
        if (this.m_updateBagHelper == null) {
            this.m_updateBagHelper = new PropertyArrayHelper(this.findPropertyBag(this.m_updateBagID, true, !this.m_isCommitMainBag), PropertyIDs.SI_TOTAL);
        }
        return this.m_updateBagHelper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectRelatives)) {
            return false;
        }
        Iterator e1 = this.iterator();
        Iterator e2 = ((ObjectRelatives)o).iterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    protected PropertyBag findPropertyBag(Object id, boolean createIfNotFound, boolean bagWillBeCommitted) {
        Property prop = this.m_topLevelBag.getItem(id);
        if (prop == null) {
            if (createIfNotFound) {
                prop = this.m_topLevelBag.addItem(id, null, 0x8000000 | (bagWillBeCommitted ? 0 : 0x2000000));
                return (PropertyBag)prop.getValue();
            }
            return null;
        }
        int origFlags = prop.getFlags();
        if (bagWillBeCommitted == FlagHelper.isFlagSet((int)origFlags, (int)0x2000000)) {
            if (bagWillBeCommitted) {
                prop.cleanFlag(0x2000000);
            } else {
                prop.setFlag(0x2000000);
            }
        }
        return (PropertyBag)prop.getValue();
    }

    protected Integer defineDeltaAddProp() {
        return PropertyIDs.define(SI_ADM_ADD + this.m_deltaSuffix);
    }

    protected Integer defineDeltaDelProp() {
        return PropertyIDs.define(SI_ADM_DEL + this.m_deltaSuffix);
    }

    protected Integer defineDeltaUpdateProp() {
        return PropertyIDs.define(SI_ADM_UPD + this.m_deltaSuffix);
    }

    protected Map getMap() {
        return this.m_attrMap;
    }

    protected boolean isExplicitListUpdate() {
        return this.m_isCommitMainBag;
    }

    protected void processUpdateBag() {
        if (!this.m_isCommitMainBag) {
            Set idProps = this.keySet();
            Iterator iter = idProps.iterator();
            while (iter.hasNext()) {
                PropertyBag orig;
                Integer id = (Integer)iter.next();
                PropertyBag relationBag = (PropertyBag)this.m_attrMap.get(id);
                if (!relationBag.isDirty() || (orig = (PropertyBag)this.m_origAttrMap.get(id)) == null) continue;
                this.processUpdateBagHelper(relationBag, (PropertyBag)this.m_origAttrMap.get(id));
            }
        }
    }

    private void processUpdateBagHelper(PropertyBag updatedBag, PropertyBag origBag) {
        Iterator iter = updatedBag.allIterator();
        PropertyBag newBag = new PropertyBag();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            Property origProp = origBag.getItem((Object)prop.getID());
            if (origProp == null) {
                newBag.addItem((Object)prop.getID(), prop.getValue(), prop.getFlags() & 0xF7FFFFFF);
                continue;
            }
            if (prop.isDeleted()) {
                newBag.addItem((Object)prop.getID(), null, prop.getFlags() & 0xF7FFFFFF);
                continue;
            }
            if (!prop.isDirty()) continue;
            if (prop.isContainer()) {
                newBag.addItem((Object)prop.getID(), prop.getValue(), prop.getFlags() & 0xF7FFFFFF);
                continue;
            }
            if (prop.getValue().equals(origProp.getValue())) continue;
            newBag.addItem((Object)prop.getID(), prop.getValue(), prop.getFlags());
        }
        newBag.addItem((Object)PropertyIDs.SI_ID, (Object)new Integer(origBag.getInt((Object)PropertyIDs.SI_ID)), 0);
        newBag.addItem((Object)PropertyIDs.SI_OBJ_VERSION, (Object)new Integer(origBag.getInt((Object)PropertyIDs.SI_OBJ_VERSION)), 0);
        newBag.setTopLevel(true);
        this.getUpdateBagHelper().add((Object)newBag);
    }

    private class AttributedIterator
    extends AssociatesIterator {
        private AttributedIterator() {
        }

        public Object next() {
            return ObjectRelatives.this.m_attrMap.get(super.next());
        }
    }

    private class AssociatesIterator
    implements Iterator {
        private int m_pos = 0;
        private int m_last = -1;

        private AssociatesIterator() {
        }

        public boolean hasNext() {
            return this.m_pos < ObjectRelatives.this.size();
        }

        public Object next() {
            if (this.hasNext()) {
                this.m_last = this.m_pos++;
                return ObjectRelatives.this.get(this.m_last);
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.m_last < 0) {
                throw new IllegalStateException();
            }
            ObjectRelatives.this.remove(this.m_last);
            if (this.m_last < this.m_pos) {
                --this.m_pos;
            }
            this.m_last = -1;
        }
    }
}

