/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.IPagingQuery;
import com.crystaldecisions.sdk.occa.infostore.SearchPattern;
import com.crystaldecisions.sdk.occa.infostore.SortType;
import com.crystaldecisions.sdk.occa.infostore.internal.PageIndex;
import com.crystaldecisions.sdk.occa.infostore.internal.QueryBaseImpl;
import com.crystaldecisions.sdk.occa.infostore.internal.QuerySettings;

class PagingQuery
extends QueryBaseImpl
implements IPagingQuery {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.PagingQuery");

    PagingQuery() {
    }

    public void setParameters(String tables, int propSet, SearchPattern pattern, SortType sortBy) throws SDKException {
        if (propSet != 7 && propSet != 1 && propSet != 4 && propSet != 2) {
            throw new SDKException.InvalidArg();
        }
        this.m_tables = tables;
        if (this.m_tables.length() == 0) {
            throw new SDKException.InvalidArg();
        }
        this.m_fields = QuerySettings.ToFields(propSet);
        this.m_searchPattern = new SearchPattern(pattern);
        this.m_sortBy = sortBy;
    }

    public IInfoObjects getPage() throws SDKException {
        block5: {
            IInfoObjects results;
            LOG.assertTrue(this.m_loadedPagingState == null, "Pagging state must exist.");
            int retries = 0;
            do {
                QuerySettings querySettings;
                if (!this.m_loadedPagingState.ensureCurrPage()) {
                    return this.m_infoStore.newInfoObjectCollection();
                }
                String whereClause = new String();
                PageIndex currPageIndex = this.m_loadedPagingState.getCurrPageIndex();
                whereClause = this.m_loadedPagingState.getCurrPageNumber() > 1 ? this.getImposePagingFilter(currPageIndex.getQueryFilter(), true) : this.getWhereClause();
                String orderClause = this.getOrderByClause();
                int numToRetrieve = this.m_itemsPerPage;
                if (!this.m_loadedPagingState.hasNextPage()) {
                    ++numToRetrieve;
                }
                if ((querySettings = new QuerySettings(this.m_infoStore, this.m_tables, this.m_fields, whereClause, orderClause, numToRetrieve)) == null) {
                    throw new SDKException.Unexpected();
                }
                results = querySettings.executeQuery();
                if (currPageIndex.isValid(results, this.m_itemsPerPage)) {
                    return results;
                }
                if (retries >= 2) break block5;
                ++retries;
                int currPageNumber = this.m_loadedPagingState.getCurrPageNumber();
                this.m_loadedPagingState.reset();
                this.m_loadedPagingState.setCurrPageNumber(currPageNumber);
            } while (results.size() != 0);
            return this.m_infoStore.newInfoObjectCollection();
        }
        LOG.error((Object)"Could not reload valid page indices after 2");
        throw new SDKException.InvalidPagingIndex();
    }
}

