/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.PageIndex;
import com.crystaldecisions.sdk.occa.infostore.internal.QueryBaseImpl;
import com.crystaldecisions.sdk.occa.infostore.internal.QuerySettings;
import java.util.ArrayList;
import java.util.List;

public class PagingState {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.PagingState");
    private static final int INVALID_PAGE_NUMBER = -1;
    private static final int INVALID_RANGE_NUMBER = -1;
    private int m_currRangeNumber = -1;
    private int m_currPageNumber = -1;
    private List m_pageIndices;
    private List m_morePageIndicesFilter;
    QueryBaseImpl m_pagingQuery;

    public PagingState(QueryBaseImpl pagingQuery) {
        this.m_pagingQuery = pagingQuery;
        this.m_pageIndices = new ArrayList();
        this.m_morePageIndicesFilter = new ArrayList();
    }

    public boolean hasMorePageIndices() {
        return this.m_morePageIndicesFilter.size() > 0;
    }

    public int getCurrPageNumber() {
        return this.m_currPageNumber;
    }

    void setCurrPageNumber(int value) throws SDKException {
        this.m_currPageNumber = value;
        this.ensureCurrPage();
    }

    public int getCurrRangeNumber() {
        return this.m_currRangeNumber;
    }

    public void setCurrRangeNumber(int value) throws SDKException {
        this.m_currRangeNumber = value;
        this.ensureCurrRange();
        this.m_currPageNumber = this.getRangeLastPageNumber();
    }

    public PageIndex getCurrPageIndex() {
        LOG.assertTrue(this.m_currPageNumber >= 0 && this.m_currPageNumber < this.m_pageIndices.size(), "Current page number is invalid.");
        return (PageIndex)this.m_pageIndices.get(this.m_currPageNumber - 1);
    }

    public boolean hasPrevPage() {
        return this.m_currPageNumber > 1;
    }

    public boolean hasNextPage() throws SDKException {
        boolean ret = true;
        ret = this.ensureCurrPage();
        if (!ret) {
            return ret;
        }
        int lastPageNum = this.getRangeLastPageNumber();
        if (this.m_currPageNumber < lastPageNum) {
            return true;
        }
        if (this.m_currPageNumber == lastPageNum) {
            return this.hasNextRange();
        }
        return false;
    }

    public int numOfRangesLoaded() {
        int indicesCount = this.m_pageIndices.size();
        int pagesPerRange = this.m_pagingQuery.getPagesPerRange();
        int numRanges = indicesCount / pagesPerRange;
        if (indicesCount % pagesPerRange > 0) {
            ++numRanges;
        }
        return numRanges;
    }

    boolean hasPrevRange() {
        return this.m_currRangeNumber > 1;
    }

    boolean hasNextRange() throws SDKException {
        boolean ret = true;
        ret = this.ensureCurrRange();
        if (!ret) {
            return ret;
        }
        int numOfRanges = this.numOfRangesLoaded();
        if (numOfRanges <= 0) {
            return false;
        }
        if (this.m_currRangeNumber < numOfRanges) {
            return true;
        }
        return this.hasMorePageIndices();
    }

    int getRangeFirstPageNumber() {
        return (this.m_currRangeNumber - 1) * this.m_pagingQuery.getPagesPerRange() + 1;
    }

    int getRangeLastPageNumber() {
        int indicesCount;
        int rangePageNumberLast = this.getRangeFirstPageNumber() + this.m_pagingQuery.getPagesPerRange() - 1;
        if (rangePageNumberLast > (indicesCount = this.m_pageIndices.size())) {
            rangePageNumberLast = indicesCount;
        }
        return rangePageNumberLast;
    }

    boolean loadNextRange() throws SDKException {
        boolean ret = true;
        ret = this.hasMorePageIndices();
        if (this.numOfRangesLoaded() > 0 && !ret) {
            return false;
        }
        ret = true;
        int everyN = this.m_pagingQuery.getItemsPerPage();
        int topN = everyN * this.m_pagingQuery.getPagesPerRange();
        String tables = this.m_pagingQuery.getTables();
        String fields = this.m_pagingQuery.getOrderByFields();
        String orderBy = this.m_pagingQuery.getOrderByClause();
        String newWhereClause = new String();
        newWhereClause = this.m_morePageIndicesFilter.size() > 0 ? this.m_pagingQuery.getImposePagingFilter(this.m_morePageIndicesFilter, false) : this.m_pagingQuery.getWhereClause();
        IInternalInfoStore infostore = this.m_pagingQuery.getInfoStore();
        if (infostore == null) {
            throw new SDKException.Unexpected();
        }
        QuerySettings querySettings = new QuerySettings(infostore, tables, fields, newWhereClause, orderBy, topN, everyN);
        if (querySettings == null) {
            throw new SDKException.Unexpected();
        }
        IInfoObjects pageIndicesInfo = querySettings.executeQuery();
        int objCount = pageIndicesInfo.size();
        if (objCount == 0) {
            return false;
        }
        this.m_pagingQuery.populatePageIndices(pageIndicesInfo, this.m_pageIndices);
        LOG.assertTrue(this.m_pageIndices.size() >= 0 && this.m_currPageNumber < this.m_pageIndices.size(), "Current page number is invalid.");
        this.m_morePageIndicesFilter.clear();
        int resultCount = pageIndicesInfo.getResultSize();
        if (resultCount > topN) {
            IInfoObject lastPageIndexInfo = (IInfoObject)pageIndicesInfo.get(objCount - 1);
            this.m_morePageIndicesFilter = this.m_pagingQuery.populatePageIndexFilter(lastPageIndexInfo);
            LOG.assertTrue(this.m_morePageIndicesFilter.size() >= 0, "Page-index filter must have at least one value.");
        }
        return true;
    }

    boolean ensureCurrRange() throws SDKException {
        boolean ret = true;
        if (this.m_currRangeNumber < 1) {
            this.m_currRangeNumber = 1;
        }
        int numPendingRanges = this.m_currRangeNumber - this.numOfRangesLoaded();
        for (int i = 0; i < numPendingRanges && (ret = this.loadNextRange()); ++i) {
        }
        int numOfRanges = this.numOfRangesLoaded();
        if (this.m_currRangeNumber > numOfRanges) {
            this.m_currRangeNumber = numOfRanges;
        }
        return this.m_currRangeNumber >= 1;
    }

    boolean ensureCurrPage() throws SDKException {
        boolean ret = true;
        if (this.m_currPageNumber < 1) {
            this.m_currPageNumber = 1;
        }
        this.m_currRangeNumber = (this.m_currPageNumber - 1) / this.m_pagingQuery.getPagesPerRange() + 1;
        ret = this.ensureCurrRange();
        if (!ret) {
            this.m_currPageNumber = -1;
            return false;
        }
        int lastPageNum = this.getRangeLastPageNumber();
        if (this.m_currPageNumber > lastPageNum) {
            this.m_currPageNumber = lastPageNum;
        }
        return this.m_currPageNumber >= 1;
    }

    void reset() {
        this.m_pageIndices.clear();
        this.m_morePageIndicesFilter.clear();
        this.m_currRangeNumber = -1;
        this.m_currPageNumber = -1;
    }

    boolean moveFirstPage() throws SDKException {
        this.m_currPageNumber = 1;
        return this.ensureCurrPage();
    }

    boolean movePreviousPage() throws SDKException {
        if (!this.hasPrevPage()) {
            return false;
        }
        --this.m_currPageNumber;
        return this.ensureCurrPage();
    }

    boolean movePreviousRange() throws SDKException {
        boolean ret = true;
        if (!this.hasPrevRange()) {
            return false;
        }
        --this.m_currRangeNumber;
        ret = this.ensureCurrRange();
        if (!ret) {
            return ret;
        }
        this.m_currPageNumber = this.getRangeLastPageNumber();
        return true;
    }

    boolean moveNextRange() throws SDKException {
        boolean ret = true;
        ret = this.hasNextRange();
        if (!ret) {
            return ret;
        }
        ++this.m_currRangeNumber;
        ret = this.ensureCurrRange();
        if (!ret) {
            return ret;
        }
        this.m_currPageNumber = this.getRangeFirstPageNumber();
        return true;
    }

    boolean moveNextPage() throws SDKException {
        boolean ret = true;
        ret = this.hasNextPage();
        if (!ret) {
            return ret;
        }
        ++this.m_currPageNumber;
        return this.ensureCurrPage();
    }

    boolean moveLastPage() throws SDKException {
        this.m_currPageNumber = Integer.MAX_VALUE;
        return this.ensureCurrPage();
    }
}

