/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.sdk.occa.infostore.IPluginBasedRightIDs;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.internal.PluginRightsMap;
import com.crystaldecisions.sdk.occa.infostore.internal.RightID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PluginBasedRightIDs
implements IPluginBasedRightIDs {
    IRightID[] m_metaPluginRights;
    IRightID[] m_metaPluginLimits;
    Map m_pluginRights;
    Map m_pluginLimits;
    IRightID[] m_systemRights;
    Map m_rights;
    Map m_limits;
    Map m_uniqueRights;
    Map m_uniqueLimits;

    public PluginBasedRightIDs(IRightID[] metaPluginRights, IRightID[] metaPluginLimits, HashMap pluginRights, HashMap pluginLimits) {
        this.m_metaPluginRights = metaPluginRights;
        this.m_metaPluginLimits = metaPluginLimits;
        this.m_pluginRights = Collections.unmodifiableMap(pluginRights);
        this.m_pluginLimits = Collections.unmodifiableMap(pluginLimits);
    }

    public PluginBasedRightIDs(IPluginBasedRightIDs src) {
        this.m_metaPluginRights = this.copyRightIDs(src.getMetaPluginRights());
        this.m_metaPluginLimits = this.copyRightIDs(src.getMetaPluginLimits());
        Map pluginRights = src.getPluginCustomRights();
        HashMap newPluginRights = new HashMap(pluginRights.size());
        Iterator iter = pluginRights.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            IRightID[] valueCopy = this.copyRightIDs((IRightID[])entry.getValue());
            newPluginRights.put(key, valueCopy);
        }
        Map pluginLimits = src.getPluginCustomLimits();
        HashMap newpluginLimits = new HashMap(pluginLimits.size());
        Iterator iter2 = pluginLimits.entrySet().iterator();
        while (iter2.hasNext()) {
            Map.Entry entry = iter2.next();
            Object key = entry.getKey();
            IRightID[] valueCopy = this.copyRightIDs((IRightID[])entry.getValue());
            newpluginLimits.put(key, valueCopy);
        }
        this.m_pluginRights = Collections.unmodifiableMap(newPluginRights);
        this.m_pluginLimits = Collections.unmodifiableMap(newpluginLimits);
        if (src instanceof PluginBasedRightIDs || ((PluginBasedRightIDs)src).m_systemRights != null) {
            this.m_systemRights = new IRightID[((PluginBasedRightIDs)src).m_systemRights.length];
            System.arraycopy(((PluginBasedRightIDs)src).m_systemRights, 0, this.m_systemRights, 0, ((PluginBasedRightIDs)src).m_systemRights.length);
        }
    }

    private IRightID[] copyRightIDs(IRightID[] rightIDs) {
        IRightID[] rightIDsCopy = new RightID[rightIDs.length];
        System.arraycopy(rightIDs, 0, rightIDsCopy, 0, rightIDs.length);
        return rightIDsCopy;
    }

    public IRightID[] getMetaPluginRights() {
        return this.m_metaPluginRights;
    }

    public IRightID[] getMetaPluginLimits() {
        return this.m_metaPluginLimits;
    }

    public Map getPluginCustomRights() {
        return this.m_pluginRights;
    }

    public Map getPluginCustomLimits() {
        return this.m_pluginLimits;
    }

    public Map getPluginRights() {
        if (this.m_rights == null) {
            List<Object> metaRights = this.m_metaPluginRights == null ? new ArrayList() : Arrays.asList(this.m_metaPluginRights);
            List<Object> systemRights = this.m_systemRights == null ? new ArrayList() : Arrays.asList(this.m_systemRights);
            this.m_rights = Collections.unmodifiableMap(new PluginRightsMap(metaRights, systemRights, this.m_pluginRights));
        }
        return this.m_rights;
    }

    public Map getPluginLimits() {
        if (this.m_limits == null) {
            List<Object> metaRights = this.m_metaPluginLimits == null ? new ArrayList() : Arrays.asList(this.m_metaPluginLimits);
            List<Object> systemRights = this.m_systemRights == null ? new ArrayList() : Arrays.asList(this.m_systemRights);
            this.m_limits = Collections.unmodifiableMap(new PluginRightsMap(metaRights, systemRights, this.m_pluginLimits));
        }
        return this.m_limits;
    }

    public Map getUniqueRights() {
        if (this.m_uniqueRights == null) {
            Map uniqueIDs = this.makeUniqueIDs(this.m_metaPluginRights, this.m_systemRights, this.m_pluginRights);
            this.m_uniqueRights = Collections.unmodifiableMap(uniqueIDs);
        }
        return this.m_uniqueRights;
    }

    public Map getUniqueLimits() {
        if (this.m_uniqueLimits == null) {
            Map uniqueIDs = this.makeUniqueIDs(this.m_metaPluginLimits, this.m_systemRights, this.m_pluginLimits);
            this.m_uniqueLimits = Collections.unmodifiableMap(uniqueIDs);
        }
        return this.m_uniqueLimits;
    }

    private Map makeUniqueIDs(IRightID[] metaArray, IRightID[] systemArray, Map pluginMap) {
        IRightID rightID;
        boolean isContainer;
        HashMap<Integer, IRightID> uniqueIDs = new HashMap<Integer, IRightID>();
        boolean bl = isContainer = pluginMap != null && pluginMap.size() > 1;
        if (pluginMap != null) {
            Iterator iter = pluginMap.values().iterator();
            while (iter.hasNext()) {
                IRightID[] rightIDs = (IRightID[])iter.next();
                if (rightIDs == null) continue;
                for (int i = 0; i < rightIDs.length; ++i) {
                    IRightID rightID2 = rightIDs[i];
                    uniqueIDs.put(new Integer(rightID2.getID()), rightID2);
                }
            }
        }
        if (metaArray != null) {
            for (int i = 0; i < metaArray.length; ++i) {
                rightID = metaArray[i];
                if (!isContainer && uniqueIDs.containsKey(new Integer(rightID.getID()))) continue;
                uniqueIDs.put(new Integer(rightID.getID()), rightID);
            }
        }
        if (isContainer && systemArray != null) {
            for (int i = 0; i < systemArray.length; ++i) {
                rightID = systemArray[i];
                Integer key = new Integer(rightID.getID());
                if (!uniqueIDs.containsKey(key)) continue;
                uniqueIDs.put(key, rightID);
            }
        }
        return uniqueIDs;
    }

    public void setSystemRights(IRightID[] rights) {
        this.m_systemRights = rights;
    }
}

