/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.CePropertyID;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.SearchPattern;
import com.crystaldecisions.sdk.occa.infostore.SortType;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.SortDimension;
import java.util.Iterator;

public class QuerySettings {
    private String m_orderBy;
    private String m_whereClause;
    private String m_fields;
    private String m_table;
    private int m_topN;
    private int m_everyN;
    public static final String defaultProperties = "SI_ID, SI_CUID, SI_NAME, SI_PARENTID, SI_PARENT_CUID, SI_KIND, SI_INSTANCE";
    public static final String standardProperties = "SI_CUID, SI_PARENT_CUID, SI_OWNER, SI_DESCRIPTION";
    public static final String scheduleProperties = "SI_SCHEDULEINFO";
    public static final String allProperties = "*";
    private static final boolean SHOW_QUERY = false;
    private IInternalInfoStore m_infoStore;

    public QuerySettings(IInternalInfoStore infoStore, String table, String fields) {
        this(infoStore, table, fields, null, null, -1, -1);
    }

    public QuerySettings(IInternalInfoStore infoStore, String table, String fields, String whereClause) {
        this(infoStore, table, fields, whereClause, null, -1, -1);
    }

    public QuerySettings(IInternalInfoStore infoStore, String table, String fields, String whereClause, String orderBy) {
        this(infoStore, table, fields, whereClause, orderBy, -1, -1);
    }

    public QuerySettings(IInternalInfoStore infoStore, String table, String fields, String whereClause, String orderBy, int topN) {
        this(infoStore, table, fields, whereClause, orderBy, topN, -1);
    }

    public QuerySettings(IInternalInfoStore infoStore, String table, String fields, String whereClause, String orderBy, int topN, int everyN) {
        this.m_infoStore = infoStore;
        this.m_table = table;
        this.m_fields = fields;
        this.m_whereClause = whereClause;
        this.m_orderBy = orderBy;
        this.m_topN = topN;
        this.m_everyN = everyN;
    }

    public IInfoObjects executeQuery(AbstractInfoObjects objects) throws SDKException {
        String query = this.buildQuery();
        InternalInfoStore ist = (InternalInfoStore)this.m_infoStore;
        IInfoObjects objs = ist.queryHelper(query, objects);
        return objects;
    }

    public IInfoObjects executeQuery() throws SDKException {
        String query = this.buildQuery();
        return this.m_infoStore.query(query);
    }

    private String buildQuery() {
        StringBuffer query = new StringBuffer();
        query.append("SELECT ");
        if (this.m_topN > 0) {
            query.append(" TOP ");
            query.append(this.m_topN);
            query.append(" ");
        }
        if (this.m_everyN > 0) {
            query.append(" EVERY ");
            query.append(this.m_everyN);
            query.append(" ");
        }
        query.append(this.m_fields);
        query.append(" FROM ");
        query.append(this.m_table);
        if (this.m_whereClause != null && this.m_whereClause.length() > 0) {
            query.append(" WHERE ");
            query.append(this.m_whereClause);
        }
        if (this.m_orderBy != null && this.m_orderBy.length() > 0) {
            query.append(" ORDER BY ");
            query.append(this.m_orderBy);
        }
        return query.toString();
    }

    public static String ToFields(int propertySet) {
        switch (propertySet) {
            case 1: {
                return defaultProperties;
            }
            case 2: {
                return "SI_ID, SI_CUID, SI_NAME, SI_PARENTID, SI_PARENT_CUID, SI_KIND, SI_INSTANCE,SI_CUID, SI_PARENT_CUID, SI_OWNER, SI_DESCRIPTION";
            }
            case 4: {
                return "SI_ID, SI_CUID, SI_NAME, SI_PARENTID, SI_PARENT_CUID, SI_KIND, SI_INSTANCE,SI_CUID, SI_PARENT_CUID, SI_OWNER, SI_DESCRIPTION,SI_SCHEDULEINFO";
            }
            case 7: {
                return allProperties;
            }
        }
        return defaultProperties;
    }

    public static String generateWhereClause(SearchPattern searchPattern) {
        int id;
        int parentID;
        String cuid;
        String parentCUID;
        String objectKind;
        String owner;
        String whereClause = "";
        if (searchPattern == null) {
            return whereClause;
        }
        String name = searchPattern.getName();
        if (name != null && name.length() > 0) {
            if (whereClause.length() > 0) {
                whereClause = whereClause + " and ";
            }
            whereClause = whereClause + "( SI_NAME like '" + name + "' )";
        }
        if ((owner = searchPattern.getOwner()) != null && owner.length() > 0) {
            if (whereClause.length() > 0) {
                whereClause = whereClause + " and ";
            }
            whereClause = whereClause + "( SI_OWNER like '" + owner + "' )";
        }
        if ((objectKind = searchPattern.getObjectKind()) != null && objectKind.length() > 0) {
            if (whereClause.length() > 0) {
                whereClause = whereClause + " and ";
            }
            whereClause = whereClause + "( SI_KIND = '" + objectKind + "' )";
        }
        if ((parentCUID = searchPattern.getParentCUID()) != null && parentCUID.length() > 0) {
            if (whereClause.length() > 0) {
                whereClause = whereClause + " and ";
            }
            whereClause = whereClause + "( SI_PARENT_CUID = '" + parentCUID + "' )";
        }
        if ((cuid = searchPattern.getCUID()) != null && cuid.length() > 0) {
            if (whereClause.length() > 0) {
                whereClause = whereClause + " and ";
            }
            whereClause = whereClause + "( SI_CUID = '" + cuid + "' )";
        }
        if ((parentID = searchPattern.getParentID()) >= 0) {
            if (whereClause.length() > 0) {
                whereClause = whereClause + " and ";
            }
            whereClause = whereClause + "( SI_PARENTID = " + parentID + ")";
        }
        if ((id = searchPattern.getID()) >= 0) {
            if (whereClause.length() > 0) {
                whereClause = whereClause + " and ";
            }
            whereClause = whereClause + "( SI_ID = " + id + ")";
        }
        return whereClause;
    }

    public static String getOrderClause(SortType sorts) {
        String sortClause = "";
        if (sorts == null) {
            return sortClause;
        }
        if (sorts.size() == 0) {
            return sortClause;
        }
        Iterator iter = sorts.iterator();
        while (iter.hasNext()) {
            SortDimension sd = (SortDimension)iter.next();
            if (sortClause.length() > 0) {
                sortClause = sortClause + ",";
            }
            sortClause = sortClause + QuerySettings.toSortClause(sd);
        }
        return sortClause;
    }

    private static String toSortClause(SortDimension sort) {
        return CePropertyID.idToName(new Integer(sort.getPropertyId())) + (sort.getDirection() == 0 ? " ASC" : " DESC");
    }
}

