/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.exception.internal.ServerMsgResourcesBundle;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRightID;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoStoreResourceBundle;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.security.internal.SecurityIDs;
import com.crystaldecisions.sdk.occa.security.internal.SecurityValidator;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Locale;

public class RightID
implements IRightID,
IPersistRightID,
Externalizable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.RightID");
    protected int m_id;
    private String m_descriptionID;
    private String m_categoryID;
    private IPluginMgr m_pluginMgr;
    private static final String IDS_GENERAL = "general";
    private static final String IDS_UNKNOWN = "unknown";
    private static final String IDS_OWNER = "owner";
    private String m_rightKind;

    public RightID() {
    }

    public RightID(int id, String description, String category, int collection) {
        this.m_categoryID = category;
        this.m_descriptionID = description;
        this.m_id = id;
    }

    public RightID(int id) {
        this.m_id = id;
    }

    public boolean equals(Object object) {
        if (object instanceof IRightID) {
            return this.m_id == ((IRightID)object).getID();
        }
        return false;
    }

    public int hashCode() {
        return this.m_id;
    }

    public String getDescription(Locale locale) {
        String description = null;
        if (this.m_descriptionID != null && this.m_descriptionID.length() != 0) {
            description = ServerMsgResourcesBundle.getString(this.m_descriptionID, locale);
        } else {
            int rawID;
            description = InfoStoreResourceBundle.getString(Integer.toString(this.m_id, 16), locale);
            if (description == null && this.isOwner() && (description = InfoStoreResourceBundle.getString(Integer.toString(rawID = this.m_id & 0xDFFFFFFF, 16), locale)) != null) {
                description = description + InfoStoreResourceBundle.getString(IDS_OWNER, locale);
            }
        }
        if (description == null && (description = ServerMsgResourcesBundle.getString(String.valueOf(61208), locale)) == null) {
            description = InfoStoreResourceBundle.getString(IDS_UNKNOWN, locale);
        }
        return description;
    }

    public String getCategory(Locale locale) {
        return this.getCategory(locale, new Integer(this.getRightPluginType()));
    }

    public String getCategory(Locale locale, Object type) {
        if (this.m_categoryID != null && this.m_categoryID.length() > 0) {
            return ServerMsgResourcesBundle.getString(this.m_categoryID, locale);
        }
        if (RightID.isSpecificType(type)) {
            block6: {
                if (this.m_pluginMgr != null) {
                    try {
                        IPluginInfo pluginInfo = this.m_pluginMgr.getPluginInfo(type);
                        if (pluginInfo != null) {
                            return pluginInfo.getName(locale);
                        }
                    }
                    catch (SDKException e) {
                        if (!LOG.isDebugEnabled()) break block6;
                        LOG.debug((Object)"RightID::getCategory() failed", (Throwable)((Object)e));
                    }
                }
            }
            return InfoStoreResourceBundle.getString(IDS_UNKNOWN, locale);
        }
        return InfoStoreResourceBundle.getString(IDS_GENERAL, locale);
    }

    public String getCollection(Locale locale) {
        return InfoStoreResourceBundle.getString(IDS_GENERAL, locale);
    }

    public String getCollection(Locale locale, Object type) {
        String resID;
        if (RightID.isSpecificType(type)) {
            block6: {
                if (this.m_pluginMgr != null) {
                    try {
                        IPluginInfo pluginInfo = this.m_pluginMgr.getPluginInfo(type);
                        if (pluginInfo != null) {
                            return pluginInfo.getTypeCollection(locale);
                        }
                    }
                    catch (SDKException e) {
                        if (!LOG.isDebugEnabled()) break block6;
                        LOG.debug((Object)"RightID::getRightPluginKind() failed", (Throwable)((Object)e));
                    }
                }
            }
            resID = IDS_UNKNOWN;
        } else {
            resID = IDS_GENERAL;
        }
        return InfoStoreResourceBundle.getString(resID, locale);
    }

    public static boolean isSpecificType(Object type) {
        return !SecurityValidator.isEmptyType(type) && (!(type instanceof String) || !"Any".equalsIgnoreCase((String)type));
    }

    public String getDescriptionID() {
        return this.m_descriptionID;
    }

    public String getCategoryID() {
        return this.m_categoryID;
    }

    public int getCollectionID() {
        return 1;
    }

    public int getCollectionID(Object type) {
        if (RightID.isSpecificType(type)) {
            block9: {
                if (this.m_pluginMgr != null) {
                    try {
                        IPluginInfo pluginInfo = this.m_pluginMgr.getPluginInfo(type);
                        if (pluginInfo != null) {
                            int typeCollection = pluginInfo.getTypeCollectionID();
                            if (typeCollection == 2) {
                                return 2;
                            }
                            if (typeCollection == 3) {
                                return 3;
                            }
                            if (typeCollection == 4) {
                                return 4;
                            }
                            if (typeCollection == 0) {
                                return 0;
                            }
                        }
                    }
                    catch (SDKException e) {
                        if (!LOG.isDebugEnabled()) break block9;
                        LOG.debug((Object)"RightID::getCollectionID() failed", (Throwable)((Object)e));
                    }
                }
            }
            return 0;
        }
        return 1;
    }

    public void setDescriptionID(String description) {
        this.m_descriptionID = description;
    }

    public void setCategoryID(String category) {
        this.m_categoryID = category;
    }

    public void setCollectionID(int collection) {
    }

    public void setPluginMgr(IPluginMgr pluginMgr) {
        this.m_pluginMgr = pluginMgr;
    }

    protected IPluginMgr getPluginMgr() {
        return this.m_pluginMgr;
    }

    public int getID() {
        return this.m_id;
    }

    public int getBaseID() {
        return SecurityIDs.getBaseRightID(this.m_id);
    }

    public String getRightPluginKind() {
        if (this.m_rightKind == null) {
            if (this.m_pluginMgr != null) {
                try {
                    this.m_rightKind = SecurityIDs.getRightKind(this.m_id, this.m_pluginMgr);
                }
                catch (SDKException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"RightID::getRightPluginKind() failed", (Throwable)((Object)e));
                    }
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"RightID::getRightPluginKind() failed because plugin manager is null");
                }
                throw new SDKRuntimeException.InvalidOperation();
            }
        }
        return this.m_rightKind;
    }

    public int getRightPluginType() {
        return SecurityIDs.getPluginType(this.m_id);
    }

    public boolean isOwner() {
        return SecurityIDs.isOwnerRight(this.m_id);
    }

    protected boolean isRemoved() {
        return false;
    }

    public String toString() {
        return this.getDescription(Locale.ENGLISH);
    }

    void initFromSerialization(ISecEventListener parentListener) {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.m_id);
        out.writeObject(this.m_descriptionID);
        out.writeObject(this.m_categoryID);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_id = in.readInt();
        this.m_descriptionID = (String)in.readObject();
        this.m_categoryID = (String)in.readObject();
    }

    protected void serializeHelper(PropertyBag bag) {
        bag.addItem((Object)PropertyIDs.SI_ID, (Object)new Integer(this.m_id), 0);
    }
}

