/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.celib.misc.ObjectUtils;
import com.crystaldecisions.sdk.occa.infostore.IRightIDBase;
import com.crystaldecisions.sdk.occa.infostore.IRightsView;
import com.crystaldecisions.sdk.occa.infostore.RightsFilterCriteria;
import com.crystaldecisions.sdk.occa.infostore.RightsFilterCriterion;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;

public class RightsFilterHelper {
    public static boolean isFilterUnspecifiedRights(RightsFilterCriteria criteria) {
        if (criteria == null) {
            return true;
        }
        Iterator iter = criteria.iterator();
        while (iter.hasNext()) {
            RightsFilterCriterion criterion = (RightsFilterCriterion)iter.next();
            if (criterion.getFilterIndex() != 7) continue;
            int operator = criterion.getOperator();
            Object value = criterion.getValue();
            if (operator == 0 || operator == 1) {
                return operator == 0 == ObjectUtils.equals((Object)value, (Object)IRightsView.RightState.UNSPECIFIED);
            }
            if (operator != 2 && operator != 3) continue;
            if (value instanceof Collection) {
                return operator == 2 == ((Collection)value).contains(IRightsView.RightState.UNSPECIFIED);
            }
            return false;
        }
        return true;
    }

    public static boolean match(IRightIDBase right, RightsFilterCriteria criteria) {
        if (criteria == null) {
            return true;
        }
        boolean isMatch = true;
        Locale locale = criteria.getLocale();
        RightsFilterCriteria.IFilterHelper helper = criteria.getHelper();
        Iterator iter = criteria.iterator();
        while (iter.hasNext() && isMatch) {
            RightsFilterCriterion criterion = (RightsFilterCriterion)iter.next();
            isMatch = helper.filter(right, criterion, locale);
        }
        return isMatch;
    }
}

