/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRole;
import com.crystaldecisions.sdk.occa.infostore.ISecurityRight;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractRight;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRole;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoStoreResourceBundle;
import com.crystaldecisions.sdk.occa.infostore.internal.RightID;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityRights;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Role
implements IRole,
IPersistRole,
Externalizable {
    private static final int[] OTHER_RIGHTS = new int[]{536870977, 0x20000003, 0x20000008, 536870934, 64, 63};
    private int m_id;
    private String m_description;
    private Set m_rights;

    static Role getRoleForRights(Map knownRoles, SecurityRights rightValues, SecurityRights effectiveValues, boolean rightsAreFromParent, boolean principal0IF) {
        boolean inheritGroups;
        ISecurityRight noInheritFoldersRight = rightValues.get(64);
        boolean inheritFolders = noInheritFoldersRight == null || !noInheritFoldersRight.isGranted();
        ISecurityRight noInheritGroupRight = rightValues.get(63);
        boolean bl = inheritGroups = noInheritGroupRight == null || !noInheritGroupRight.isGranted();
        if (!rightsAreFromParent && (inheritGroups || inheritFolders && principal0IF)) {
            return (Role)IRole.ADVANCED;
        }
        Iterator iterator = knownRoles.values().iterator();
        while (iterator.hasNext()) {
            IRole role = (IRole)iterator.next();
            IRightID[] roleRights = role.toArray();
            int matched = 0;
            int ignored = 0;
            if (effectiveValues.get(64) != null) {
                ++ignored;
            }
            if (effectiveValues.get(63) != null) {
                ++ignored;
            }
            if (roleRights.length + ignored > effectiveValues.size()) continue;
            for (int i = 0; i < roleRights.length; ++i) {
                IRightID right = roleRights[i];
                AbstractRight effectiveValue = (AbstractRight)((Object)effectiveValues.get(right.getID()));
                if (effectiveValue == null || !((ISecurityRight)((Object)effectiveValue)).isGranted()) continue;
                ++matched;
            }
            if (matched != roleRights.length || matched + ignored != effectiveValues.size()) continue;
            return (Role)role;
        }
        return (Role)IRole.ADVANCED;
    }

    public static IRole makeRole(int id, String descrption) {
        IRole[] allRoles = IRole.ALL_ROLES;
        for (int i = 0; i < allRoles.length; ++i) {
            Role role = (Role)allRoles[i];
            if (role.m_id != id) continue;
            return new Role(id, descrption, new int[0]);
        }
        throw new IllegalArgumentException(Integer.toString(id));
    }

    public static IRole getRole(int id) {
        IRole[] allRoles = IRole.ALL_ROLES;
        for (int i = 0; i < allRoles.length; ++i) {
            Role role = (Role)allRoles[i];
            if (role.m_id != id) continue;
            return role;
        }
        throw new IllegalArgumentException(Integer.toString(id));
    }

    public Role() {
    }

    public Role(int id, String description, int[] rights) {
        this.m_id = id;
        this.m_description = description;
        this.m_rights = new HashSet(rights.length);
        this.initRights(rights);
    }

    public int getID() {
        return this.m_id;
    }

    public String getDescriptionID() {
        return this.m_description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRights(int[] rights) {
        Set set = this.m_rights;
        synchronized (set) {
            for (int i = 0; i < rights.length; ++i) {
                int right = rights[i];
                this.m_rights.add(new RightID(right));
            }
        }
    }

    public void addRights(int[] rights) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginRights(IRightID[] rights) {
        Set set = this.m_rights;
        synchronized (set) {
            this.m_rights.addAll(Arrays.asList(rights));
        }
    }

    public String getDescription(Locale locale) {
        String desc = InfoStoreResourceBundle.getString(this.m_description, locale);
        if (desc == null) {
            desc = InfoStoreResourceBundle.getString("unknown", locale);
        }
        return desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateRights() {
        Set set = this.m_rights;
        synchronized (set) {
            return this.m_rights.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Set set = this.m_rights;
        synchronized (set) {
            return this.m_rights.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRightID[] toArray() {
        Set set = this.m_rights;
        synchronized (set) {
            return this.m_rights.toArray(new IRightID[this.m_rights.size()]);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Role) {
            Role other = (Role)obj;
            return other.m_id == this.m_id;
        }
        return false;
    }

    public int hashCode() {
        return this.m_id;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        sb.append(this.m_id);
        sb.append(' ');
        sb.append(this.m_description);
        sb.append(' ');
        Iterator iter = this.m_rights.iterator();
        while (iter.hasNext()) {
            RightID rightID = (RightID)iter.next();
            sb.append(rightID);
            sb.append(' ');
        }
        sb.append(')');
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.m_id);
        out.writeObject(this.m_description);
        out.writeObject(this.m_rights);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_id = in.readInt();
        this.m_description = (String)in.readObject();
        this.m_rights = (Set)in.readObject();
    }
}

