/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.conversion.TimeZoneConversion;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.IPropertyChangeListener;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.exception.internal.ServerMsgResourcesBundle;
import com.crystaldecisions.sdk.occa.infostore.ICalendarDay;
import com.crystaldecisions.sdk.occa.infostore.ICalendarRunDays;
import com.crystaldecisions.sdk.occa.infostore.IDestination;
import com.crystaldecisions.sdk.occa.infostore.IDestinations;
import com.crystaldecisions.sdk.occa.infostore.IEvents;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.INotifications;
import com.crystaldecisions.sdk.occa.infostore.ISchedulingInfo;
import com.crystaldecisions.sdk.occa.infostore.ISupportJobServer;
import com.crystaldecisions.sdk.occa.infostore.internal.CalendarRunDays;
import com.crystaldecisions.sdk.occa.infostore.internal.Destination;
import com.crystaldecisions.sdk.occa.infostore.internal.Destinations;
import com.crystaldecisions.sdk.occa.infostore.internal.Events;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.Notifications;
import com.crystaldecisions.sdk.occa.infostore.internal.ObjectRelatives;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;

class SchedulingInfo
implements ISchedulingInfo,
Serializable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.SchedulingInfo");
    private IInfoObject m_infoObject;
    private ISecuritySession m_session;
    private TimeZone m_timeZone;
    private Date m_defaultEndtime;
    private Date m_defaultStartTime;
    private transient boolean m_isOwerIDSet;
    private IDestinations m_destinations;
    private IDestinations m_distributedDestinations;
    private IDestination m_backwardDestination;
    private final SDKPropertyBag m_bag;
    private static final String APS_ERR_SCHED_FAIL_JOBSVRPLUGIN = Integer.toString(47250);
    private static final String APS_ERR_SCHED_FAIL_JOBSVR = Integer.toString(47251);
    private static final String APS_ERR_SCHED_FAIL_SECURITY = Integer.toString(47252);
    private static final String APS_ERR_SCHED_FAIL_ENDTIME = Integer.toString(47253);
    private static final String APS_ERR_SCHED_FAIL = Integer.toString(47254);
    private static final String APS_ERR_SCHED_FAIL_COMPONENT = Integer.toString(47256);
    private static final String APS_ERR_SCHED_FAIL_OBJECTPACKAGE = Integer.toString(47257);
    private static final String APS_ERR_SCHED_FAIL_CONSTRAINTS = Integer.toString(65241);
    private static final int DEFAULT_RETRY_INTERVAL = 1800;
    private static final Integer ENDTIME = PropertyIDs.SI_ENDTIME;
    private static final Integer RUN_ON_TEMPLATE = PropertyIDs.SI_RUN_ON_TEMPLATE;
    private static final Integer STARTTIME = PropertyIDs.SI_STARTTIME;
    private static final Integer SCHED_NOW = PropertyIDs.SI_SCHED_NOW;
    private static final Integer SUBMITTERID = PropertyIDs.SI_SUBMITTERID;
    private static final Integer OWNERID = PropertyIDs.SI_OWNERID;
    private static final Integer SCHEDULE_TYPE = PropertyIDs.SI_SCHEDULE_TYPE;
    private static final Integer TIMEZONE_ID = PropertyIDs.SI_TIMEZONE_ID;
    private static final Integer INTERVAL_MINUTES = PropertyIDs.SI_SCHEDULE_INTERVAL_MINUTES;
    private static final Integer INTERVAL_HOURS = PropertyIDs.SI_SCHEDULE_INTERVAL_HOURS;
    private static final Integer INTERVAL_MONTHS = PropertyIDs.SI_SCHEDULE_INTERVAL_MONTHS;
    private static final Integer INTERVAL_NDAYS = PropertyIDs.SI_SCHEDULE_INTERVAL_NDAYS;
    private static final Integer INTERVAL_NTHDAY = PropertyIDs.SI_SCHEDULE_INTERVAL_NTHDAY;
    private static final Integer ZERO = new Integer(0);
    private static final int MAXIMUM_YEAR = 10;
    private static final Integer DEFAULT_SCHEDULE_TYPE = new Integer(0);
    private static final Set SENDTO_REQUIRED_PROPS = new HashSet();

    SchedulingInfo(SDKPropertyBag propBag) {
        this.m_bag = propBag;
    }

    void initialize(IInfoObject infoObject, ISecuritySession session, boolean fillProps) {
        this.m_infoObject = infoObject;
        this.m_session = session;
        this.setupDefaultProperties();
        if (fillProps) {
            this.fillRequiredProperties();
        }
    }

    void unpack(IBagUnpacker unpacker, IInfoObject infoObject, ISecuritySession session) {
        this.m_bag.unpack(unpacker);
        this.initialize(infoObject, session, false);
    }

    private void setupDefaultProperties() {
        this.m_timeZone = TimeZone.getDefault();
        GregorianCalendar c = new GregorianCalendar(this.m_timeZone);
        this.m_defaultStartTime = c.getTime();
        ((Calendar)c).add(1, 10);
        this.m_defaultEndtime = c.getTime();
    }

    private void fillRequiredProperties() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"enter: fillRequiredProperties()");
        }
        this.setPropertyWithoutOverwrite(INTERVAL_MINUTES, ZERO);
        this.setPropertyWithoutOverwrite(INTERVAL_HOURS, ZERO);
        this.setPropertyWithoutOverwrite(INTERVAL_MONTHS, ZERO);
        this.setPropertyWithoutOverwrite(INTERVAL_NDAYS, ZERO);
        this.setPropertyWithoutOverwrite(INTERVAL_NTHDAY, ZERO);
        this.setPropertyWithoutOverwrite(ENDTIME, this.m_defaultEndtime);
        this.setPropertyWithoutOverwrite(STARTTIME, this.m_defaultStartTime);
        this.setPropertyWithoutOverwrite(SCHEDULE_TYPE, DEFAULT_SCHEDULE_TYPE);
        this.setPropertyWithoutOverwrite(TIMEZONE_ID, new Integer(TimeZoneConversion.convertToID((TimeZone)this.m_timeZone)));
        this.setPropertyWithoutOverwrite(SCHED_NOW, Boolean.TRUE);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"exit: fillRequiredProperties()");
        }
    }

    void prepareSchedule() throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"enter: prepareSchedule()");
        }
        this.fillRequiredProperties();
        this.fixupScheduleOnBehalfOf();
        this.updateTemplatesByType();
        this.updateDestination(PropertyIDs.SI_ALERT_DESTINATION);
        this.updateDestinations(PropertyIDs.SI_DESTINATIONS);
        this.validateProperties();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"exit: prepareSchedule()");
        }
    }

    void prepareSendTo() throws SDKException {
        Set ids = this.m_bag.keySet();
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            if (SENDTO_REQUIRED_PROPS.contains(key)) continue;
            this.m_bag.remove(key);
        }
        this.setType(0);
        this.setRightNow(true);
        this.fillRequiredProperties();
        this.fixupScheduleOnBehalfOf();
        this.setPropertyWithoutOverwrite(PropertyIDs.SI_CLEANUP, Boolean.TRUE);
    }

    private void validateProperties() throws SDKException {
        if (this.getEndDate().compareTo(this.getBeginDate()) < 0) {
            throw new SDKException.ContradictingValues((Object)PropertyIDs.idToName(PropertyIDs.SI_ENDTIME), this.getEndDate(), PropertyIDs.idToName(PropertyIDs.SI_STARTTIME), this.getBeginDate());
        }
    }

    private void updateDestination(Integer id) {
        Object name;
        PropertyBag destBag = this.m_bag.getPropertyBag(id);
        if (destBag == null) {
            return;
        }
        Property nameProp = destBag.getItem((Object)Destination.SI_PROGID);
        if (nameProp != null && nameProp.isDirty() && ((name = nameProp.getValue()) == null || ((String)name).length() == 0)) {
            this.m_bag.remove(id);
            this.setCleanup(false);
        }
    }

    private void updateDestinations(Integer id) {
        PropertyBag destBag = this.m_bag.getPropertyBag(id);
        if (destBag == null) {
            return;
        }
        if (destBag.isDirty()) {
            boolean clearDestinationBag = false;
            if (this.m_destinations != null) {
                for (int i = this.m_destinations.size() - 1; i >= 0; --i) {
                    IDestination dest = (IDestination)this.m_destinations.get(i);
                    if (dest != null && dest.getName() != null && dest.getName().length() != 0) continue;
                    this.m_destinations.remove(i);
                }
                clearDestinationBag = this.m_destinations.size() <= 0;
            } else if (this.m_backwardDestination != null) {
                boolean bl = clearDestinationBag = this.m_backwardDestination.getName() == null || this.m_backwardDestination.getName().length() == 0;
            }
            if (clearDestinationBag) {
                this.m_bag.remove(id);
                this.setCleanup(false);
            }
        }
    }

    private void fixupScheduleOnBehalfOf() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"enter: fixupScheduleOnBehalfOf()");
        }
        Integer userID = null;
        try {
            userID = new Integer(this.m_session.getUserInfo().getUserID());
        }
        catch (SDKException sDKException) {
            // empty catch block
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("User ID:" + userID));
        }
        this.m_bag.setProperty(SUBMITTERID, userID);
        if (!this.m_isOwerIDSet) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Setting ower ID");
            }
            this.m_infoObject.properties().setProperty((Object)OWNERID, userID);
        } else {
            this.m_isOwerIDSet = false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"exit: fixupScheduleOnBehalfOf()");
        }
    }

    private void updateTemplatesByType() {
        int type = this.getType();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Schedule Type:" + type));
        }
        switch (type) {
            case 0: {
                this.clearTemplates(RUN_ON_TEMPLATE);
                this.clearIntervals();
                break;
            }
            case 1: {
                this.setupCalendarHourly();
                break;
            }
            case 2: {
                this.setupCalendarDaily();
                break;
            }
            case 3: {
                this.setupCalendarWeekly();
                break;
            }
            case 4: {
                this.setupCalendarMonthly();
                break;
            }
            case 5: {
                this.setupCalendarNthDay();
                break;
            }
            case 6: {
                this.setupCalendar1stMonday();
                break;
            }
            case 7: {
                this.setupCalendarLastDay();
                break;
            }
            case 8: {
                this.clearIntervals();
                this.clearCalendarTemplate();
                break;
            }
            case 9: {
                this.clearIntervals();
                break;
            }
            default: {
                LOG.warn((Object)("Invalid schedule type: " + type));
                throw new SDKRuntimeException.UnexpectedValue(SCHEDULE_TYPE, type);
            }
        }
    }

    private void setupCalendarLastDay() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"enter: setupCalendarLastDay()");
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.getBeginDate());
        this.fixupStartTime(cal);
        this.clearIntervals();
        this.clearCalendarTemplate();
        ICalendarRunDays days = this.getCalendarRunDays();
        days.clear();
        int thisYear = cal.get(1);
        for (int month = cal.getActualMinimum(2); month <= cal.getActualMaximum(2); ++month) {
            cal.set(5, 1);
            cal.set(2, month);
            if (month == 1) {
                for (int year = thisYear; year < thisYear + 10; ++year) {
                    cal.set(1, year);
                    int lastDay = cal.getActualMaximum(5);
                    days.add(lastDay, month, year, lastDay, month, year, -1, -1);
                }
                continue;
            }
            int lastDay = cal.getActualMaximum(5);
            days.add(lastDay, month, -1, lastDay, month, -1, -1, -1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"exit: setupCalendarLastDay()");
        }
    }

    private void setupCalendar1stMonday() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"enter: setupCalendar1stMonday()");
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.getBeginDate());
        this.fixupStartTime(cal);
        this.clearIntervals();
        this.clearCalendarTemplate();
        ICalendarRunDays days = this.getCalendarRunDays();
        days.clear();
        ICalendarDay day = days.add();
        day.setStartDay(1);
        day.setEndDay(7);
        day.setDayOfWeek(2);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"exit: setupCalendar1stMonday()");
        }
    }

    private void setupCalendarNthDay() {
        int nthDay;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"enter: setupCalendarNthDay()");
        }
        nthDay = (nthDay = this.getIntervalNthDay()) == 0 ? 1 : nthDay;
        this.clearIntervals();
        this.clearCalendarTemplate();
        this.setIntervalNthDay(nthDay);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.getBeginDate());
        this.fixupStartTime(cal);
        ICalendarRunDays days = this.getCalendarRunDays();
        days.clear();
        ICalendarDay day = days.add();
        day.setStartDay(nthDay);
        day.setEndDay(nthDay);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"exit: setupCalendarNthDay()");
        }
    }

    private void setupCalendarMonthly() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"enter: setupCalendarMonthly()");
        }
        this.clearTemplates(RUN_ON_TEMPLATE);
        int months = this.getIntervalMonths();
        this.clearIntervals();
        this.setIntervalMonths(months == 0 ? 1 : months);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"exit: setupCalendarMonthly()");
        }
    }

    private void setupCalendarDaily() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"enter: setupCalendarDaily()");
        }
        this.clearTemplates(RUN_ON_TEMPLATE);
        int days = this.getIntervalDays();
        this.clearIntervals();
        this.setIntervalDays(days == 0 ? 1 : days);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"exit: setupCalendarDaily()");
        }
    }

    private void setupCalendarHourly() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"enter: setupCalendarHourly()");
        }
        this.clearTemplates(RUN_ON_TEMPLATE);
        int hours = this.getIntervalHours();
        int minutes = this.getIntervalMinutes();
        this.clearIntervals();
        if (hours == 0 && minutes == 0) {
            this.setIntervalHours(1);
        } else {
            this.setIntervalHours(hours);
            this.setIntervalMinutes(minutes);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"exit: setupCalendarHourly()");
        }
    }

    private void setupCalendarWeekly() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"enter: setupCalendarWeekly()");
        }
        this.clearIntervals();
        this.clearCalendarTemplate();
        ICalendarRunDays runDays = this.getCalendarRunDays();
        Date beginDate = this.getBeginDate();
        GregorianCalendar beginCal = new GregorianCalendar();
        beginCal.setTime(beginDate);
        runDays.clear();
        ICalendarDay day = runDays.add();
        day.setDayOfWeek(beginCal.get(7));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"exit: setupCalendarWeekly()");
        }
    }

    private void clearIntervals() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"enter: clearIntervals()");
        }
        this.m_bag.setProperty(INTERVAL_MINUTES, ZERO);
        this.m_bag.setProperty(INTERVAL_HOURS, ZERO);
        this.m_bag.setProperty(INTERVAL_MONTHS, ZERO);
        this.m_bag.setProperty(INTERVAL_NDAYS, ZERO);
        this.m_bag.setProperty(INTERVAL_NTHDAY, ZERO);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"exit: clearIntervals()");
        }
    }

    private void setPropertyWithoutOverwrite(Integer id, Object value) {
        if (this.m_bag.getProperty(id) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Overriding property " + IDHelper.idToName((Integer)id) + " with value " + value));
            }
            this.m_bag.setProperty(id, value);
        }
    }

    private void clearTemplates(Integer id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"enter: clearTemplates()");
        }
        Property prop = this.m_bag.getItem(id);
        PropertyBag props = null;
        props = prop != null ? this.m_bag.getPropertyBag(id) : (PropertyBag)this.m_bag.addItem(id, null, 0x8000000).getValue();
        PropertyArrayHelper days = new PropertyArrayHelper(props, PropertyIDs.SI_NUM_TEMPLATE_DAYS, PropertyIDs.SI_TEMPLATE_DAY0);
        days.clear();
        this.clearCalendarTemplate();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"exit: clearTemplates()");
        }
    }

    private void clearCalendarTemplate() {
        this.m_bag.setProperty(PropertyIDs.SI_CALENDAR_TEMPLATE_ID, new Integer(0));
        this.m_bag.remove(PropertyIDs.SI_CALENDAR_TEMPLATE_ID);
    }

    public Date getBeginDate() {
        if (this.m_bag.getProperty(STARTTIME) == null) {
            return this.m_defaultStartTime;
        }
        return this.m_bag.getDate(STARTTIME);
    }

    public void setBeginDate(Date dtBeginDate) {
        if (dtBeginDate == null) {
            throw new NullPointerException();
        }
        GregorianCalendar startTime = new GregorianCalendar(this.m_timeZone);
        startTime.setTime(dtBeginDate);
        this.fixupStartTime(startTime);
        this.m_bag.setProperty(SCHED_NOW, Boolean.FALSE);
    }

    public IEvents getDependants() {
        Property prop = this.m_bag.getItem(PropertyIDs.SI_DEPENDANTS);
        if (prop == null) {
            prop = this.m_bag.addArray(PropertyIDs.SI_DEPENDANTS);
        }
        return new Events(prop.getPropertyBag());
    }

    public IEvents getDependencies() {
        Property prop = this.m_bag.getItem(PropertyIDs.SI_DEPENDENCIES);
        if (prop == null) {
            prop = this.m_bag.addArray(PropertyIDs.SI_DEPENDENCIES);
        }
        return new Events(prop.getPropertyBag());
    }

    public Date getEndDate() {
        if (this.m_bag.getProperty(ENDTIME) == null) {
            return this.m_defaultEndtime;
        }
        return this.m_bag.getDate(ENDTIME);
    }

    public void setEndDate(Date dtEndDate) {
        if (dtEndDate == null) {
            throw new NullPointerException();
        }
        this.m_bag.setProperty(ENDTIME, dtEndDate);
    }

    public int getFlags() {
        return this.m_bag.getInt(PropertyIDs.SI_SCHEDULE_FLAGS);
    }

    public void setFlags(int lFlags) {
        if (lFlags != 1 && lFlags != 0 && lFlags != 8) {
            throw new SDKRuntimeException.UndefinedValue(lFlags, ISchedulingInfo.ScheduleFlags.class.getName());
        }
        this.m_bag.setProperty(PropertyIDs.SI_SCHEDULE_FLAGS, new Integer(lFlags));
    }

    public int getIntervalHours() {
        return this.m_bag.getInt(INTERVAL_HOURS);
    }

    public void setIntervalHours(int newVal) {
        if (newVal < 0) {
            throw new IllegalArgumentException();
        }
        this.m_bag.setProperty(INTERVAL_HOURS, new Integer(newVal));
    }

    public int getIntervalMinutes() {
        return this.m_bag.getInt(INTERVAL_MINUTES);
    }

    public void setIntervalMinutes(int newVal) {
        if (newVal < 0) {
            throw new IllegalArgumentException();
        }
        this.m_bag.setProperty(INTERVAL_MINUTES, new Integer(newVal));
    }

    public int getIntervalMonths() {
        return this.m_bag.getInt(INTERVAL_MONTHS);
    }

    public void setIntervalMonths(int newVal) {
        if (newVal < 0) {
            throw new IllegalArgumentException();
        }
        this.m_bag.setProperty(INTERVAL_MONTHS, new Integer(newVal));
    }

    public int getIntervalNthDay() {
        return this.m_bag.getInt(PropertyIDs.SI_SCHEDULE_INTERVAL_NTHDAY);
    }

    public void setIntervalNthDay(int newVal) {
        if (newVal < 0) {
            throw new IllegalArgumentException();
        }
        this.m_bag.setProperty(PropertyIDs.SI_SCHEDULE_INTERVAL_NTHDAY, new Integer(newVal));
    }

    public int getRetriesAllowed() {
        return this.m_bag.getInt(PropertyIDs.SI_RETRIES_ALLOWED);
    }

    public void setRetriesAllowed(int newVal) {
        if (newVal < 0 || newVal > 1000) {
            throw new IllegalArgumentException();
        }
        this.m_bag.setProperty(PropertyIDs.SI_RETRIES_ALLOWED, new Integer(newVal));
    }

    public int getRetryInterval() {
        IProperty prop = this.m_bag.getProperty(PropertyIDs.SI_RETRY_INTERVAL);
        if (prop == null) {
            return 1800;
        }
        return (Integer)prop.getValue();
    }

    public void setRetryInterval(int newVal) {
        if (newVal < 0 || newVal > 0x1000000) {
            throw new IllegalArgumentException();
        }
        this.m_bag.setProperty(PropertyIDs.SI_RETRY_INTERVAL, new Integer(newVal));
    }

    public boolean isRightNow() {
        if (this.m_bag.getProperty(SCHED_NOW) == null) {
            return true;
        }
        return this.m_bag.getBoolean(SCHED_NOW);
    }

    public void setRightNow(boolean rightNow) {
        if (rightNow && this.getType() == 0) {
            GregorianCalendar fakeStartTime = new GregorianCalendar(this.m_timeZone);
            ((Calendar)fakeStartTime).add(11, -1);
            this.m_bag.setProperty(STARTTIME, fakeStartTime.getTime());
            this.clearTemplates(RUN_ON_TEMPLATE);
            this.clearIntervals();
        }
        this.m_bag.setProperty(SCHED_NOW, rightNow ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getServerGroupChoice() {
        Property prop = this.m_bag.getItem(PropertyIDs.SI_MACHINECHOICE);
        if (prop != null) {
            return (Integer)prop.getValue();
        }
        return 0;
    }

    public void setServerGroupChoice(int newVal) {
        if (newVal < 0 || newVal > 2) {
            throw new IllegalArgumentException("argument must be between 0 and 2");
        }
        this.m_bag.setProperty(PropertyIDs.SI_MACHINECHOICE, new Integer(newVal));
    }

    public int getServerGroup() {
        return this.m_bag.getInt(PropertyIDs.SI_MACHINE);
    }

    public void setServerGroup(int newVal) {
        this.m_bag.setProperty(PropertyIDs.SI_MACHINE, new Integer(newVal));
    }

    public int getType() {
        if (this.m_bag.getProperty(SCHEDULE_TYPE) == null) {
            return 0;
        }
        return this.m_bag.getInt(SCHEDULE_TYPE);
    }

    public void setType(int newVal) {
        if (newVal < 0 || newVal > 9) {
            throw new IllegalArgumentException();
        }
        this.m_bag.setProperty(SCHEDULE_TYPE, new Integer(newVal));
        GregorianCalendar startTime = new GregorianCalendar(this.m_timeZone);
        startTime.setTime(this.getBeginDate());
        this.fixupStartTime(startTime);
    }

    public int getIntervalDays() {
        return this.m_bag.getInt(INTERVAL_NDAYS);
    }

    public void setIntervalDays(int newIntervalDays) {
        if (newIntervalDays < 0) {
            throw new IllegalArgumentException();
        }
        this.m_bag.setProperty(INTERVAL_NDAYS, new Integer(newIntervalDays));
    }

    public ICalendarRunDays getCalendarRunDays() {
        PropertyBag bag = this.m_bag.getPropertyBag(RUN_ON_TEMPLATE);
        if (bag == null) {
            bag = this.m_bag.addItem(RUN_ON_TEMPLATE, null, 0x8000000).getPropertyBag();
        }
        return new CalendarRunDays(bag);
    }

    public IDestination getDestination() {
        if (this.m_destinations != null) {
            throw new SDKRuntimeException.DeprecatedMethodAccessed("getDestination", "getDestinations");
        }
        if (this.m_backwardDestination == null) {
            PropertyBag destBag = this.m_bag.getPropertyBag(PropertyIDs.SI_DESTINATIONS);
            if (destBag == null) {
                destBag = this.m_bag.addItem(PropertyIDs.SI_DESTINATIONS, null, 0x8000000).getPropertyBag();
                PropertyArrayHelper arrayHelper = new PropertyArrayHelper(destBag, PropertyIDs.SI_TOTAL);
                Property newItem = arrayHelper.add(null, 0x8000000);
                this.m_backwardDestination = new Destination((PropertyBag)newItem.getValue(), this);
                ((Destination)this.m_backwardDestination).initialize();
            } else {
                PropertyArrayHelper arrayHelper = new PropertyArrayHelper(destBag, PropertyIDs.SI_TOTAL);
                PropertyBag firstItem = arrayHelper.size() <= 0 ? arrayHelper.add(null, 0x8000000).getPropertyBag() : (PropertyBag)arrayHelper.get(0);
                this.m_backwardDestination = new Destination(firstItem, this);
            }
        }
        return this.m_backwardDestination;
    }

    public IDestinations getDestinations() {
        if (this.m_backwardDestination != null) {
            throw new SDKRuntimeException.DeprecatedMethodAccessed("getDestination", "getDestinations");
        }
        if (this.m_destinations == null) {
            PropertyBag destBag = this.m_bag.getPropertyBag(PropertyIDs.SI_DESTINATIONS);
            if (destBag == null) {
                destBag = this.m_bag.addArray(PropertyIDs.SI_DESTINATIONS).getPropertyBag();
            }
            this.m_destinations = new Destinations(destBag, this);
        }
        return this.m_destinations;
    }

    public IDestinations getDistributedDestinations() {
        if (this.m_distributedDestinations == null) {
            PropertyBag destBag = this.m_bag.getPropertyBag(PropertyIDs.SI_DISTRIBUTEDDESTINATIONS);
            if (destBag == null) {
                destBag = this.m_bag.addArray(PropertyIDs.SI_DISTRIBUTEDDESTINATIONS).getPropertyBag();
            }
            this.m_distributedDestinations = new Destinations(destBag, this);
        }
        return this.m_distributedDestinations;
    }

    public int getOutcome() {
        return this.m_bag.getInt(PropertyIDs.SI_OUTCOME);
    }

    public int getStatus() throws SDKException {
        if (this.m_infoObject.properties().getProperty(PropertyIDs.SI_SCHEDULE_STATUS) != null) {
            return (Integer)this.m_infoObject.properties().getProperty(PropertyIDs.SI_SCHEDULE_STATUS).getValue();
        }
        throw new SDKException.PropertyNotFound(PropertyIDs.SI_SCHEDULE_STATUS);
    }

    public String getErrorMessage() {
        return this.getErrorMessage(Locale.getDefault());
    }

    public String getErrorMessage(Locale locale) {
        int outcome = this.getOutcome();
        String errorMsg = null;
        switch (outcome) {
            case 1: {
                errorMsg = "";
                break;
            }
            case 3: {
                errorMsg = ServerMsgResourcesBundle.getString(APS_ERR_SCHED_FAIL_JOBSVR, locale);
                break;
            }
            case 4: {
                errorMsg = ServerMsgResourcesBundle.getString(APS_ERR_SCHED_FAIL_SECURITY, locale);
                break;
            }
            case 5: {
                errorMsg = ServerMsgResourcesBundle.getString(APS_ERR_SCHED_FAIL_ENDTIME, locale);
                break;
            }
            case 6: {
                errorMsg = ServerMsgResourcesBundle.getString(APS_ERR_SCHED_FAIL, locale);
                break;
            }
            case 0: {
                errorMsg = "";
            }
            case 2: {
                IProperties statusProps;
                IProperty statusProp = this.m_infoObject.properties().getProperty(PropertyIDs.SI_STATUSINFO);
                if (statusProp == null || (statusProps = (IProperties)statusProp.getValue()).size() == 0 || !(this.m_infoObject instanceof ISupportJobServer)) break;
                errorMsg = ((ISupportJobServer)((Object)this.m_infoObject)).formatJobServerError(locale, statusProps);
                break;
            }
            case 8: {
                errorMsg = ServerMsgResourcesBundle.getString(APS_ERR_SCHED_FAIL_COMPONENT, locale);
                break;
            }
            case 9: {
                errorMsg = ServerMsgResourcesBundle.getString(APS_ERR_SCHED_FAIL_OBJECTPACKAGE, locale);
                break;
            }
            case 10: {
                errorMsg = ServerMsgResourcesBundle.getString(APS_ERR_SCHED_FAIL_CONSTRAINTS, locale);
            }
        }
        if (errorMsg == null) {
            errorMsg = ServerMsgResourcesBundle.getString(APS_ERR_SCHED_FAIL_JOBSVRPLUGIN, locale);
        }
        return errorMsg;
    }

    public TimeZone getTimeZone() {
        if (this.m_bag.getProperty(TIMEZONE_ID) == null) {
            return this.m_timeZone;
        }
        return TimeZoneConversion.convertToTimeZone((int)this.m_bag.getInt(TIMEZONE_ID));
    }

    public int getScheduleOnBehalfOf() {
        IProperty ownerId = this.m_infoObject.properties().getProperty(OWNERID);
        if (ownerId == null) {
            try {
                return this.m_session.getUserInfo().getUserID();
            }
            catch (SDKException e) {
                LOG.error((Object)"getScheduleOnBehalfOf(): should never happen", (Throwable)((Object)e));
                return 0;
            }
        }
        return ((Property)ownerId).getInt();
    }

    public void setScheduleOnBehalfOf(int owerID) throws SDKException {
        this.m_infoObject.properties().setProperty((Object)OWNERID, owerID);
        this.m_isOwerIDSet = true;
    }

    private void fixupStartTime(Calendar startTime) {
        int currentType = this.getType();
        GregorianCalendar currentTime = new GregorianCalendar(this.m_timeZone);
        if ((currentType == 5 || currentType == 6 || currentType == 7 || currentType == 8 || currentType == 9) && startTime.before(currentTime)) {
            startTime.set(1, currentTime.get(1));
            startTime.set(2, currentTime.get(2));
            startTime.set(5, currentTime.get(5));
        }
        this.m_bag.setProperty(STARTTIME, startTime.getTime());
    }

    public void setTimeZone(TimeZone timezone) {
        this.m_timeZone = timezone;
        this.m_bag.setProperty(TIMEZONE_ID, new Integer(TimeZoneConversion.convertToID((TimeZone)timezone)));
    }

    public IProperties properties() {
        return this.m_bag;
    }

    public IDestination getAlertDestination() {
        PropertyBag destBag = this.m_bag.getPropertyBag(PropertyIDs.SI_ALERT_DESTINATION);
        if (destBag == null) {
            destBag = this.m_bag.addItem(PropertyIDs.SI_ALERT_DESTINATION, null, 0x8000000).getPropertyBag();
        }
        Destination dest = new Destination(destBag, this);
        dest.initialize();
        return dest;
    }

    public int getCalendarTemplate() {
        return this.m_bag.getInt(PropertyIDs.SI_CALENDAR_TEMPLATE_ID);
    }

    public void setCalendarTemplate(int templateId) {
        this.m_bag.setProperty(PropertyIDs.SI_CALENDAR_TEMPLATE_ID, new Integer(templateId));
    }

    public INotifications getNotifications() throws SDKException {
        Notifications notifications = new Notifications();
        PropertyBag notifcationBag = this.m_bag.getPropertyBag(PropertyIDs.SI_NOTIFICATION);
        if (notifcationBag == null) {
            notifcationBag = this.m_bag.addItem(PropertyIDs.SI_NOTIFICATION, null, 0x8000000).getPropertyBag();
            notifications.init((IProperties)notifcationBag, this);
        } else {
            notifications.update((IProperties)notifcationBag, this);
        }
        return notifications;
    }

    public void prepareCommit() throws SDKException {
        this.updateDestination(PropertyIDs.SI_ALERT_DESTINATION);
        this.updateDestinations(PropertyIDs.SI_DESTINATIONS);
    }

    public void setCleanup(boolean cleanup) {
        this.m_bag.setProperty(PropertyIDs.SI_CLEANUP, cleanup ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isCleanup() {
        return this.m_bag.getBoolean(PropertyIDs.SI_CLEANUP);
    }

    public Set getMultiPassObjects() throws SDKException {
        IProperty prop = this.properties().getProperty(PropertyIDs.SI_MULTIPASS);
        if (prop == null) {
            this.properties().add(PropertyIDs.SI_MULTIPASS, null, 0x8000000);
        }
        ObjectRelatives multiPassObjs = new ObjectRelatives();
        multiPassObjs.initialize((Object)PropertyIDs.SI_MULTIPASS, this.properties(), true, ((IInternalInfoObject)this.m_infoObject).isNew());
        return multiPassObjs;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.m_bag.addPropertyChangeListener(listener);
    }

    public void cleanupChanges() {
        this.m_bag.cleanupChanges();
    }

    public void merge(IBagUnpacker unpacker) {
        this.m_bag.merge(unpacker);
    }

    public void merge(IBagUnpacker unpacker, boolean notifyChange, boolean isTopLevelOnly) {
        this.m_bag.merge(unpacker, notifyChange, isTopLevelOnly);
    }

    public boolean getRunOnOriginatingCluster() {
        return this.m_bag.getBoolean(PropertyIDs.SI_SCHEDULE_REMOTELY);
    }

    public void setRunOnOriginatingCluster(boolean run) {
        this.m_bag.setProperty(PropertyIDs.SI_SCHEDULE_REMOTELY, run);
    }

    public boolean getRunRemotely() throws SDKException {
        String originCUID;
        return this.getRunOnOriginatingCluster() && (originCUID = this.m_infoObject.properties().getString(PropertyIDs.SI_ORIGINATING_CLUSTER)) != null && originCUID.length() != 0;
    }

    public SDKPropertyBag getSchedulingInfoBag() {
        return this.m_bag;
    }

    protected boolean isDirty() {
        return this.m_bag.isDirty();
    }

    static {
        SENDTO_REQUIRED_PROPS.add(SUBMITTERID);
        SENDTO_REQUIRED_PROPS.add(INTERVAL_HOURS);
        SENDTO_REQUIRED_PROPS.add(INTERVAL_MONTHS);
        SENDTO_REQUIRED_PROPS.add(INTERVAL_NDAYS);
        SENDTO_REQUIRED_PROPS.add(INTERVAL_MINUTES);
        SENDTO_REQUIRED_PROPS.add(INTERVAL_NTHDAY);
        SENDTO_REQUIRED_PROPS.add(SCHEDULE_TYPE);
        SENDTO_REQUIRED_PROPS.add(STARTTIME);
        SENDTO_REQUIRED_PROPS.add(RUN_ON_TEMPLATE);
        SENDTO_REQUIRED_PROPS.add(PropertyIDs.SI_CLEANUP);
        SENDTO_REQUIRED_PROPS.add(PropertyIDs.SI_DESTINATION);
        SENDTO_REQUIRED_PROPS.add(PropertyIDs.SI_DESTINATIONS);
        SENDTO_REQUIRED_PROPS.add(ENDTIME);
        SENDTO_REQUIRED_PROPS.add(PropertyIDs.SI_NAME);
        SENDTO_REQUIRED_PROPS.add(TIMEZONE_ID);
        SENDTO_REQUIRED_PROPS.add(SCHED_NOW);
    }
}

