/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.holder.internal.ArrayHolder;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IObjectPrincipal;
import com.crystaldecisions.sdk.occa.infostore.IObjectPrincipals;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRole;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRights;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRole;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStoreFactory;
import com.crystaldecisions.sdk.occa.infostore.internal.ObjectPrincipal;
import com.crystaldecisions.sdk.occa.infostore.internal.ObjectPrincipals;
import com.crystaldecisions.sdk.occa.infostore.internal.Role;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginRole;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginSecurityInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.internal.IInternalPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.internal.PluginMgrFactory;
import com.crystaldecisions.sdk.occa.security.ISecCacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ICacheController;
import com.crystaldecisions.sdk.occa.security.internal.ICacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.internal.IRights;
import com.crystaldecisions.sdk.occa.security.internal.IRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.SecurityIDs;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class SecurityInfo
implements ISecurityInfo,
IPersistRights,
ObjectPrincipal.IRightsHelper,
Externalizable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.SecurityInfo");
    protected static final String Any_TYPE = "Any";
    protected static final String This_TYPE = "";
    protected ISecuritySession m_session;
    protected IRights m_rights;
    protected IRightsAdmin m_rightsAdmin;
    protected ICacheController m_cache;
    protected ICacheControllerAdmin m_cacheAdmin;
    protected ISecRightsAdmin m_rightsAdmin2;
    protected ISecCacheControllerAdmin m_cacheAdmin2;
    private IInfoObject m_object;
    private String m_myProgID;
    private IRightID[] m_knownRights;
    private IRightID[] m_knownLimits;
    private HashMap m_knownRoles;
    private String[] m_progIDs;
    private ObjectPrincipals m_principals;

    IInfoObject getObject() {
        return this.m_object;
    }

    public SecurityInfo() {
    }

    public SecurityInfo(IInfoObject obj, ISecuritySession session) {
        this.m_session = session;
        this.m_object = obj;
        try {
            this.m_myProgID = this.m_object.getProgID();
        }
        catch (SDKException sDKException) {
            // empty catch block
        }
    }

    public boolean checkRight(int right) throws SDKException {
        this.initializeRights();
        return this.m_rights.checkBool(right, "#" + this.m_object.getID(), This_TYPE) == 2;
    }

    public boolean checkSystemRight(int right) throws SDKException {
        if (SecurityIDs.isPluginSpecificRight(right)) {
            throw new SDKException.InvalidRightKind(right);
        }
        return this.checkRight(right);
    }

    public boolean checkCustomRight(int right, String kind) throws SDKException {
        int obtype = SecurityInfo.getObjectType(this.m_session, kind);
        int realRightID = right;
        if (SecurityIDs.isPluginSpecificRight(right)) {
            int _obtype = SecurityIDs.getPluginType(right);
            if (obtype != _obtype) {
                throw new SDKException.InvalidRightKind(right);
            }
        } else {
            realRightID = SecurityIDs.getAuthenticRightID(right, obtype);
        }
        return this.checkRight(realRightID);
    }

    public boolean[] checkRights(int[] rights) throws SDKException {
        return this.checkRights(rights, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] checkRights(int[] rights, boolean useCache) throws SDKException {
        if (rights == null || rights.length == 0) {
            throw new SDKException.InvalidArg();
        }
        boolean[] granted = new boolean[rights.length];
        this.initializeRights();
        String objectID = "#" + this.m_object.getID();
        ICacheController iCacheController = this.m_cache;
        synchronized (iCacheController) {
            this.m_cache.batch(useCache);
            try {
                for (int i = 0; i < rights.length; ++i) {
                    this.m_cache.cacheBool(rights[i], objectID, This_TYPE);
                }
                this.m_cache.commit();
            }
            catch (SDKException e) {
                this.m_cache.rollback();
                throw e;
            }
            catch (Throwable e) {
                this.m_cache.rollback();
                SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
                throw sdke;
            }
        }
        for (int i = 0; i < rights.length; ++i) {
            granted[i] = this.m_rights.checkBool(rights[i], objectID, This_TYPE) == 2;
        }
        return granted;
    }

    public boolean[] checkSystemRights(int[] rights, boolean useCache) throws SDKException {
        for (int i = 0; i < rights.length; ++i) {
            if (!SecurityIDs.isPluginSpecificRight(rights[i])) continue;
            throw new SDKException.InvalidRightKind(rights[i]);
        }
        return this.checkRights(rights, useCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] checkCustomRights(int[] rights, String[] kinds, boolean useCache) throws SDKException {
        if (rights == null || rights.length == 0) {
            throw new SDKException.InvalidArg();
        }
        if (rights.length != kinds.length) {
            throw new SDKException.InvalidArg();
        }
        boolean[] granted = new boolean[rights.length];
        this.initializeRights();
        String objectID = "#" + this.m_object.getID();
        int[] realRights = new int[rights.length];
        ICacheController iCacheController = this.m_cache;
        synchronized (iCacheController) {
            this.m_cache.batch(useCache);
            try {
                int i;
                for (i = 0; i < realRights.length; ++i) {
                    realRights[i] = SecurityIDs.getAuthenticRightID(rights[i], SecurityInfo.getObjectType(this.m_session, kinds[i]));
                }
                for (i = 0; i < realRights.length; ++i) {
                    this.m_cache.cacheBool(realRights[i], objectID, This_TYPE);
                }
                this.m_cache.commit();
            }
            catch (SDKException e) {
                this.m_cache.rollback();
                throw e;
            }
            catch (Throwable e) {
                this.m_cache.rollback();
                SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
                throw sdke;
            }
        }
        for (int i = 0; i < realRights.length; ++i) {
            granted[i] = this.m_rights.checkBool(realRights[i], objectID, This_TYPE) == 2;
        }
        return granted;
    }

    public IObjectPrincipals getObjectPrincipals() throws SDKException {
        return this.getObjectPrincipals(2);
    }

    public IObjectPrincipals getObjectPrincipals(int flag) throws SDKException {
        if (this.m_principals == null) {
            this.loadRights(flag);
        } else if (flag > this.m_principals.getType()) {
            this.loadRights(flag);
        }
        return this.m_principals;
    }

    public IObjectPrincipals newObjectPrincipals() throws SDKException {
        if (this.m_principals == null) {
            this.m_principals = new ObjectPrincipals(this.getKnownRights(), this.getKnownLimits(), this.getKnownRoles(), this.m_session, 1, this, true);
        }
        return this.m_principals;
    }

    public IObjectPrincipal getAnyPrincipal(int id) throws SDKException {
        this.initializeRights();
        ObjectPrincipal op = new ObjectPrincipal(id, This_TYPE, this.getKnownRights(), this.getKnownLimits(), this.getKnownRoles(), this.m_session, this, true);
        this.m_cacheAdmin.batch();
        try {
            op.preloadRights(this.m_cacheAdmin, this.m_object.getID(), this.m_myProgID);
            this.m_cacheAdmin.commit();
            op.loadRights(this.m_rightsAdmin, this.m_object.getID(), this.m_myProgID);
        }
        catch (SDKException e) {
            this.m_cacheAdmin.rollback();
            throw e;
        }
        catch (Throwable e) {
            this.m_cacheAdmin.rollback();
            SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
            throw sdke;
        }
        return op;
    }

    public void saveRights(IRightsAdmin dest) throws SDKException {
        if (this.m_principals != null) {
            this.m_principals.saveRights(dest, this.m_object.getID(), Any_TYPE);
            this.m_principals.saveRights(dest, this.m_object.getID(), This_TYPE);
        }
    }

    public void saveRights2(ISecRightsAdmin rightsAdmin) throws SDKException {
        if (this.m_principals != null) {
            this.m_principals.saveRights2(rightsAdmin, this.m_object.getID(), Any_TYPE);
            this.m_principals.saveRights2(rightsAdmin, this.m_object.getID(), This_TYPE);
        }
    }

    public IRightID[] getKnownRights() throws SDKException {
        this.initializeRights();
        if (this.m_knownRights == null) {
            HashSet result = new HashSet();
            HashSet unAddedSystemRights = new HashSet();
            String[] progIDs = this.getProgIDsWithCustomRights();
            IPluginMgr pluginMgr = (IPluginMgr)PluginMgrFactory.getFactory().makeOCCA(This_TYPE, this.m_session);
            for (int i = 0; i < progIDs.length; ++i) {
                String progID = progIDs[i];
                IPluginInfo pluginInfo = pluginMgr.getPluginInfo(progID);
                IInternalPluginInfo internal = (IInternalPluginInfo)((Object)pluginInfo);
                IPluginSecurityInfo pluginSecurityInfo = pluginInfo.getSecurityInfo();
                IRightID[] knownRights = pluginSecurityInfo.getKnownRights();
                boolean useOnlyOwnRight = internal.isUseOnlyOwnRights();
                for (int j = 0; j < knownRights.length; ++j) {
                    IRightID knownRight = knownRights[j];
                    this.addRightToResult(progID, result, knownRight, useOnlyOwnRight, unAddedSystemRights);
                }
            }
            SecurityInfo.addToResult(result, unAddedSystemRights);
            this.m_knownRights = result.toArray(new IRightID[result.size()]);
        }
        return this.m_knownRights;
    }

    public IRightID[] getKnownLimits() throws SDKException {
        this.initializeRights();
        if (this.m_knownLimits == null) {
            HashSet result = new HashSet();
            HashSet unAddedSystemLimits = new HashSet();
            String[] progIDs = this.getProgIDsWithCustomRights();
            IPluginMgr pluginMgr = (IPluginMgr)PluginMgrFactory.getFactory().makeOCCA(This_TYPE, this.m_session);
            for (int i = 0; i < progIDs.length; ++i) {
                String progID = progIDs[i];
                IPluginInfo pluginInfo = pluginMgr.getPluginInfo(progID);
                IInternalPluginInfo internal = (IInternalPluginInfo)((Object)pluginInfo);
                IPluginSecurityInfo pluginSecurityInfo = pluginInfo.getSecurityInfo();
                IRightID[] knownLimits = pluginSecurityInfo.getKnownLimits();
                boolean useOnlyOwnRight = internal.isUseOnlyOwnRights();
                for (int j = 0; j < knownLimits.length; ++j) {
                    IRightID knownLimit = knownLimits[j];
                    this.addRightToResult(progID, result, knownLimit, useOnlyOwnRight, unAddedSystemLimits);
                }
            }
            SecurityInfo.addToResult(result, unAddedSystemLimits);
            this.m_knownLimits = result.toArray(new IRightID[result.size()]);
        }
        return this.m_knownLimits;
    }

    private void addRightToResult(String progID, Set result, IRightID rightToBeAdded, boolean useOnlyOwnRight, Set unAddedSystemLimits) {
        if (progID.equals(this.m_myProgID)) {
            result.add(rightToBeAdded);
        } else if (!useOnlyOwnRight) {
            if (!result.contains(rightToBeAdded)) {
                result.add(rightToBeAdded);
            }
        } else if (SecurityIDs.isPluginSpecificRight(rightToBeAdded.getID())) {
            result.add(rightToBeAdded);
        } else {
            unAddedSystemLimits.add(rightToBeAdded);
        }
    }

    private HashMap getKnownRoles() throws SDKException {
        this.initializeRights();
        if (this.m_knownRoles == null) {
            this.m_knownRoles = new HashMap(IRole.ALL_ROLES.length);
            String[] progIDs = this.getProgIDsWithCustomRights();
            IPluginMgr pluginMgr = (IPluginMgr)PluginMgrFactory.getFactory().makeOCCA(This_TYPE, this.m_session);
            for (int progIDCount = 0; progIDCount < progIDs.length; ++progIDCount) {
                String progID = progIDs[progIDCount];
                IPluginInfo pluginInfo = pluginMgr.getPluginInfo(progID);
                IPluginSecurityInfo pluginSecurityInfo = pluginInfo.getSecurityInfo();
                IPluginRole[] pluginRoles = pluginSecurityInfo.getPluginRoles();
                for (int pluginRolesCount = 0; pluginRolesCount < pluginRoles.length; ++pluginRolesCount) {
                    IRole pluginRole = pluginRoles[pluginRolesCount].getRole();
                    IPersistRole persistRole = (IPersistRole)((Object)pluginRole);
                    IRightID[] rightIDs = pluginRoles[pluginRolesCount].getRights();
                    IRole customRole = (IRole)this.m_knownRoles.get(pluginRole);
                    if (customRole == null) {
                        customRole = Role.makeRole(persistRole.getID(), persistRole.getDescriptionID());
                        this.m_knownRoles.put(pluginRole, customRole);
                    }
                    IInternalPluginInfo internal = (IInternalPluginInfo)((Object)pluginInfo);
                    HashSet effectiveRights = new HashSet();
                    HashSet unAddedSystemRights = new HashSet();
                    for (int i = 0; i < rightIDs.length; ++i) {
                        IRightID rightID = rightIDs[i];
                        this.addRightToResult(progID, effectiveRights, rightID, internal.isUseOnlyOwnRights(), unAddedSystemRights);
                    }
                    SecurityInfo.addToResult(effectiveRights, unAddedSystemRights);
                    IPersistRole customPersistRole = (IPersistRole)((Object)customRole);
                    customPersistRole.addPluginRights(effectiveRights.toArray(new IRightID[effectiveRights.size()]));
                }
            }
        }
        return this.m_knownRoles;
    }

    private static void addToResult(Set result, Set unadded) {
        Iterator iter = unadded.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (result.contains(o)) continue;
            result.add(o);
        }
    }

    private String[] getProgIDsWithCustomRights() throws SDKException {
        if (this.m_progIDs == null) {
            ArrayHolder holder = new ArrayHolder();
            IInternalInfoObject obj = (IInternalInfoObject)this.m_object;
            int id = obj.isNew() ? obj.getSecuritySurrogate() : obj.getID();
            this.m_rightsAdmin.getProgIdsWithCustomRights("#" + id, This_TYPE, holder);
            this.m_progIDs = (String[])holder.get();
        }
        return this.m_progIDs;
    }

    private void loadRights(int rightsMode) throws SDKException {
        this.initializeRights();
        if (this.m_principals == null) {
            this.m_principals = new ObjectPrincipals(this.getKnownRights(), this.getKnownLimits(), this.getKnownRoles(), this.m_session, rightsMode, this, false);
        } else {
            this.m_principals.setType(rightsMode);
        }
        int id = this.m_object.getID();
        if (rightsMode == 1) {
            this.m_principals.loadExplicitRights(this.m_cacheAdmin, this.m_rightsAdmin, id);
            this.m_principals.loadExplicitCALs(this.m_cacheAdmin2, this.m_rightsAdmin2, id);
        } else {
            this.m_principals.preloadRights(this.m_cacheAdmin, this.m_rightsAdmin, id, this.m_myProgID);
            this.m_principals.loadRights(this.m_rightsAdmin, id, this.m_myProgID);
        }
    }

    public boolean checkPluginRight(int rightID) throws SDKException {
        boolean checkThisObjType;
        IInternalInfoObject obj = (IInternalInfoObject)this.m_object;
        boolean bl = checkThisObjType = !SecurityIDs.isPluginSpecificRight(rightID) || obj.getNonInstanceObjType() == SecurityIDs.getPluginType(rightID);
        if (checkThisObjType) {
            return this.checkRight(rightID);
        }
        return true;
    }

    public static int getObjectType(ISecuritySession session, String kind) throws SDKException {
        IInternalInfoStore infoStore = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA(session.getAPSName(), session);
        IPluginMgr pluginMgr = infoStore.getPluginMgr();
        IPluginInfo pluginInfo = pluginMgr.getPluginInfo(kind);
        return pluginInfo.getType();
    }

    public void loadRights(ObjectPrincipal principal) throws SDKException {
        if (!principal.isEffectiveRightsLoaded()) {
            this.m_cacheAdmin.batch();
            try {
                principal.preloadRights(this.m_cacheAdmin, this.m_object.getID(), this.m_myProgID);
                this.m_cacheAdmin.commit();
                principal.loadRights(this.m_rightsAdmin, this.m_object.getID(), this.m_myProgID);
            }
            catch (SDKException e) {
                this.m_cacheAdmin.rollback();
                throw e;
            }
            catch (Throwable e) {
                this.m_cacheAdmin.rollback();
                SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
                throw sdke;
            }
        }
        if (!((InfoObject)this.m_object).isNew()) {
            this.m_cacheAdmin2.batch();
            try {
                principal.preloadRights2(this.m_cacheAdmin2, this.m_object.getID());
                this.m_cacheAdmin2.commit();
                principal.loadRights2(this.m_rightsAdmin2, this.m_object.getID());
            }
            catch (SDKException e) {
                this.m_cacheAdmin2.rollback();
                throw e;
            }
            catch (Throwable e) {
                this.m_cacheAdmin2.rollback();
                SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
                throw sdke;
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.m_principals);
        out.writeObject(this.m_knownRights);
        out.writeObject(this.m_knownLimits);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_principals = (ObjectPrincipals)in.readObject();
        this.m_knownRights = (IRightID[])in.readObject();
        this.m_knownLimits = (IRightID[])in.readObject();
    }

    void initFromSerialization(ISecurityInfo deltaSecurityInfo) throws SDKException {
        ObjectPrincipals deltaPrincipals = ((SecurityInfo)deltaSecurityInfo).m_principals;
        this.m_knownRights = ((SecurityInfo)deltaSecurityInfo).m_knownRights;
        this.m_knownLimits = ((SecurityInfo)deltaSecurityInfo).m_knownLimits;
        if (deltaPrincipals != null) {
            ObjectPrincipals objPrincipals = ((IInternalInfoObject)this.m_object).isNew() || deltaPrincipals.isNewObjectPrincipals() ? (ObjectPrincipals)this.newObjectPrincipals() : (ObjectPrincipals)this.getObjectPrincipals(deltaPrincipals.getType());
            objPrincipals.initFromSerialization(deltaPrincipals, this.m_knownRights, this.m_knownLimits);
        }
    }

    private void initializeRights() throws SDKException {
        if (this.m_rights == null) {
            this.m_rights = this.m_session.getRights();
            this.m_rightsAdmin = this.m_session.getRightsAdmin();
            this.m_cacheAdmin = this.m_session.getSecCacheAdmin();
            this.m_cache = this.m_session.getSecCache();
            this.m_cacheAdmin2 = this.m_session.getSecurityInfoMgr().getSecCacheAdmin();
            this.m_rightsAdmin2 = this.m_session.getSecurityInfoMgr().getRightsAdmin();
        }
    }
}

