/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKExceptionCode;
import com.crystaldecisions.sdk.exception.internal.ServerMsgResourcesBundle;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo2;
import com.crystaldecisions.sdk.occa.infostore.internal.RightID;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityInfo;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityInfo2;
import com.crystaldecisions.sdk.occa.security.internal.SecurityIDs;
import java.util.Locale;

public class SecurityInfoException
extends SDKException {
    public SecurityInfoException(String resourceID, String locID, String[] messageParams, Exception cause, int errorCode) {
        super(resourceID, locID, messageParams, (Throwable)cause, errorCode);
    }

    public SecurityInfoException(String[] msgParams, Exception cause, int errorCode) {
        super(msgParams, cause, errorCode);
    }

    public static void checkThrow(ISecurityInfo securityInfo, int rightID) throws SDKException {
        SecurityInfo info = (SecurityInfo)securityInfo;
        if (!info.checkPluginRight(rightID)) {
            SecurityInfoException.throwNoRightException(securityInfo.getKnownRights(), ((SecurityInfo)securityInfo).getObject(), rightID);
        }
    }

    public static void checkThrow(ISecurityInfo securityInfo, int rightID, int objType) throws SDKException {
        int customRightID = SecurityIDs.getAuthenticRightID(rightID, objType);
        if (!securityInfo.checkRight(customRightID)) {
            SecurityInfoException.throwNoRightException(securityInfo.getKnownRights(), ((SecurityInfo)securityInfo).getObject(), customRightID);
        }
    }

    public static void checkThrow(ISecurityInfo2 securityInfo, int rightID) throws SDKException {
        SecurityInfo2 info = (SecurityInfo2)securityInfo;
        if (!info.checkPluginRight(rightID)) {
            SecurityInfoException.throwNoRightException(securityInfo.getKnownRights(), ((SecurityInfo2)securityInfo).getObject(), rightID);
        }
    }

    private static void throwNoRightException(IRightID[] rights, IInfoObject obj, int rightID) throws SDKException {
        for (int i = 0; i < rights.length; ++i) {
            IRightID right = rights[i];
            if (right.getID() != rightID) continue;
            throw new NoRight(right, obj.getID(), obj.getTitle());
        }
        throw new NoRight(rightID, obj.getID(), obj.getTitle());
    }

    public static class ErrorCode {
        public static final int Error_Unknown = 0;
        public static final int Error_NoRight = 1;
    }

    public static class NoRight
    extends SecurityInfoException {
        private int m_secID;
        private IRightID m_secRightID;
        private static final String LOC_ID = Integer.toString(49926);

        public NoRight(int secID, int id, String title) {
            super(ServerMsgResourcesBundle.getBaseName(), LOC_ID, new String[]{null, Integer.toString(secID), title, Integer.toString(id)}, null, SDKExceptionCode.Error_SecurityInfo_NoRight);
            this.m_secID = secID;
            this.m_secRightID = null;
        }

        public NoRight(IRightID right, int id, String title) {
            super(ServerMsgResourcesBundle.getBaseName(), LOC_ID, new String[]{null, Integer.toString(right.getID()), title, Integer.toString(id)}, null, SDKExceptionCode.Error_SecurityInfo_NoRight);
            this.m_secID = right.getID();
            this.m_secRightID = right;
        }

        public String getDetailMessage(Locale locale) {
            Object[] params = super.getCheckedExceptionMessageParams();
            if (this.m_secRightID == null) {
                this.m_secRightID = new RightID(this.m_secID);
            }
            params[0] = this.m_secRightID.getDescription(locale);
            return super.getDetailMessage(locale);
        }

        public String getMessage(Locale locale) {
            Object[] params = super.getCheckedExceptionMessageParams();
            if (this.m_secRightID == null) {
                this.m_secRightID = new RightID(this.m_secID);
            }
            params[0] = this.m_secRightID.getDescription(locale);
            return super.getMessage(locale);
        }
    }
}

