/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IRightBase;
import com.crystaldecisions.sdk.occa.infostore.RightDescriptor;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractRight2;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecEventListener;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

abstract class SecurityRight2
extends AbstractRight2 {
    private boolean m_value;

    public SecurityRight2() {
    }

    public SecurityRight2(int id, String description, String category, int collection, String type, String scope, IPluginMgr pluginMgr, ISecEventListener eventListener) {
        super(id, description, category, collection, type, scope, null, pluginMgr, eventListener);
        this.m_value = false;
    }

    public SecurityRight2(IRightBase copy, String description, String category, int collection, List sources, IPluginMgr pluginMgr, ISecEventListener eventListener) {
        super(copy.getID(), description, category, collection, copy.getObjectType(), copy.getScope(), sources, pluginMgr, eventListener);
        this.m_value = copy.isGranted();
    }

    public boolean isGranted() {
        return this.m_value;
    }

    public void setGranted(boolean newValue) {
        this.m_value = newValue;
        this.m_dirty = true;
    }

    public RightDescriptor getRightDescriptor() {
        return super.getRightDescriptor();
    }

    public void saveRights(ISecRightsAdmin rightsAdmin, int objectID, int principalID) throws SDKException {
        if (this.m_dirty) {
            rightsAdmin.setRight(new RightDescriptor(this.getBaseID(), new Integer(this.getRightPluginType()), this.isOwner(), this.m_rightScope, this.m_objType), principalID, objectID, this.m_value);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.m_value);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.m_value = in.readBoolean();
    }

    protected void update(AbstractRight2 right) {
        super.update(right);
        this.setGranted(((SecurityRight2)right).isGranted());
    }

    protected void serializeHelper(PropertyBag bag) {
        super.serializeHelper(bag);
        bag.addItem((Object)PropertyIDs.SI_VALUE, (Object)new Boolean(this.m_value), 0);
    }
}

