/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.ISecurityRight;
import com.crystaldecisions.sdk.occa.infostore.ISecurityRights;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractRight;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecuritySet;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRightID;
import com.crystaldecisions.sdk.occa.infostore.internal.RightID;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityInfo;
import com.crystaldecisions.sdk.occa.security.internal.ICacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.internal.IRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.SecurityIDs;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;

class SecurityRights
extends AbstractSecuritySet
implements ISecurityRights {
    public SecurityRights() {
    }

    public SecurityRights(ISecuritySession session, IRightID[] knownRights) {
        super(session, knownRights);
    }

    public ISecurityRight add(int id) {
        return this.addInternal(id, false);
    }

    ISecurityRight importRight(int id) {
        return this.addInternal(id, true);
    }

    private ISecurityRight addInternal(int id, boolean isImported) {
        ISecurityRight right = this.get(id);
        if (right == null) {
            IRightID rightID = this.findRightByID(id);
            if (rightID != null) {
                IPersistRightID persistID = (IPersistRightID)rightID;
                SecurityRight newRight = new SecurityRight(id, persistID.getDescriptionID(), persistID.getCategoryID(), persistID.getCollectionID());
                if (!isImported) {
                    newRight.setGranted(false);
                    newRight.m_exists = true;
                    this.addValue(newRight);
                } else {
                    this.importValue(newRight);
                }
                return newRight;
            }
            return null;
        }
        return right;
    }

    public ISecurityRight importHiddenRight(int id) {
        SecurityRight newRight = new SecurityRight(id, null, null, 0);
        this.importValue(newRight);
        return newRight;
    }

    public void addHidden(AbstractRight right) {
        this.addValue(right);
    }

    void importExplicitRight(ISecurityRight right) {
        IPersistRightID rightID = (IPersistRightID)this.findRightByID(right.getID());
        if (rightID != null) {
            AbstractRight ar = (AbstractRight)this.getValue(new Integer(right.getID()));
            if (ar == null || !ar.isDirty()) {
                SecurityRight rightCP = new SecurityRight(right, rightID.getDescriptionID(), rightID.getCategoryID(), rightID.getCollectionID());
                rightCP.setCategoryID(rightID.getCategoryID());
                rightCP.setDescriptionID(rightID.getDescriptionID());
                this.importValue(rightCP);
            }
        } else {
            ISecurityRight newRight = this.importHiddenRight(right.getID());
            newRight.setGranted(right.isGranted());
        }
    }

    protected Object createRemovedEntry(Object right) {
        RightID rightId = (RightID)right;
        return new AbstractSecuritySet.RemovedRight(rightId.getID());
    }

    protected Object getKey(Object right) {
        return new Integer(((IRightID)right).getID());
    }

    protected void update(Object delta) {
        SecurityRight deltaRight = (SecurityRight)delta;
        int id = deltaRight.getID();
        SecurityRight right = (SecurityRight)this.get(id);
        if (right == null) {
            IRightID rightID = this.findRightByID(id);
            String description = "";
            String category = "";
            int collection = 0;
            if (rightID != null) {
                IPersistRightID persistID = (IPersistRightID)rightID;
                description = persistID.getDescriptionID();
                category = persistID.getCategoryID();
                collection = persistID.getCollectionID();
            }
            SecurityRight newRight = new SecurityRight(id, description, category, collection);
            newRight.update(deltaRight);
            this.importValue(newRight);
        } else {
            right.update(deltaRight);
        }
    }

    public ISecurityRight addSystemRight(int id) throws SDKException {
        if (SecurityIDs.isPluginSpecificRight(id)) {
            throw new SDKException.InvalidRightKind(id);
        }
        return this.add(id);
    }

    public ISecurityRight addCustomRight(int id, String kind) throws SDKException {
        int obtype = SecurityInfo.getObjectType(this.m_session, kind);
        int realRightID = id;
        if (SecurityIDs.isPluginSpecificRight(id)) {
            int _obtype = SecurityIDs.getPluginType(id);
            if (obtype != _obtype) {
                throw new SDKException.InvalidRightKind(id);
            }
        } else {
            realRightID = SecurityIDs.getAuthenticRightID(id, obtype);
        }
        return this.add(realRightID);
    }

    public ISecurityRight get(int id) {
        return (ISecurityRight)((Object)this.getValue(new Integer(id)));
    }

    public ISecurityRight get(int id, String kind) throws SDKException {
        if (id < 1) {
            throw new SDKException.InvalidArg();
        }
        if (kind == null || kind.length() == 0) {
            throw new SDKException.InvalidArg();
        }
        int obtype = SecurityInfo.getObjectType(this.m_session, kind);
        int realRightID = id;
        if (SecurityIDs.isPluginSpecificRight(id)) {
            int _obtype = SecurityIDs.getPluginType(id);
            if (_obtype != obtype) {
                throw new SDKException.InvalidRightKind(id);
            }
        } else {
            realRightID = SecurityIDs.getAuthenticRightID(id, obtype);
        }
        return this.get(realRightID);
    }

    public Iterator iterator() {
        return super.iterator();
    }

    public void remove(int id) {
        super.removeValue(new Integer(id), new AbstractSecuritySet.RemovedRight(id), true);
    }

    public int size() {
        return super.size();
    }

    public void serializeHelper(PropertyArrayHelper arrayhelper) {
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            SecurityRight right = (SecurityRight)itr.next();
            PropertyBag bag = arrayhelper.add(null, 0x8000000).getPropertyBag();
            right.serializeHelper(bag);
        }
    }

    static class SecurityRight
    extends AbstractRight
    implements ISecurityRight {
        private boolean m_value;

        public SecurityRight() {
        }

        public SecurityRight(int id, String description, String category, int collection) {
            super(id, description, category, collection);
            this.m_value = false;
        }

        public SecurityRight(ISecurityRight copy, String description, String category, int collection) {
            super(copy.getID(), description, category, collection);
            this.m_value = copy.isGranted();
        }

        public boolean isGranted() {
            return this.m_value;
        }

        public void setGranted(boolean newValue) {
            if (!this.m_inherited) {
                this.m_value = newValue;
                this.m_dirty = true;
            }
        }

        public void preloadRights(ICacheControllerAdmin cacheAdmin, int objectID, int principalID, String type) throws SDKException {
            if (!this.m_dirty) {
                cacheAdmin.cacheBool(this.m_id, "#" + principalID, "#" + objectID, type);
            }
        }

        public void loadRights(IRightsAdmin rightsAdmin, int objectID, int principalID, String type, int aggrMode) throws SDKException {
            if (!this.m_dirty) {
                int status = rightsAdmin.checkBool(this.m_id, "#" + principalID, "#" + objectID, type, aggrMode);
                this.m_inherited = aggrMode != 1;
                this.m_exists = status != 4;
                this.m_value = status == 2;
            }
        }

        public void saveRights(IRightsAdmin rightsAdmin, int objectID, int principalID, String type) throws SDKException {
            if (this.m_dirty) {
                rightsAdmin.setRightBool(this.m_id, "#" + principalID, "#" + objectID, type, this.m_value);
            }
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeBoolean(this.m_value);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.m_value = in.readBoolean();
        }

        protected void update(AbstractRight right) {
            super.update(right);
            this.setGranted(((ISecurityRight)((Object)right)).isGranted());
        }

        protected void serializeHelper(PropertyBag bag) {
            super.serializeHelper(bag);
            bag.addItem((Object)PropertyIDs.SI_VALUE, (Object)new Boolean(this.m_value), 0);
        }
    }
}

