/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IRoleID;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecUpdateEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.RoleID;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

class SecurityRole
extends RoleID {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.SecurityRole");
    protected boolean m_dirty;
    protected List m_sources;
    private boolean m_isInherited;
    protected AbstractSecEventListener m_loadListener;

    public SecurityRole() {
    }

    public SecurityRole(int id, String title, String cuid, String desc, ISecEventListener eventListener) {
        this(id, title, cuid, desc, null, false, eventListener);
    }

    public SecurityRole(int id, String title, String cuid, String desc, List sources, boolean isInherited, ISecEventListener eventListener) {
        super(id, title, desc, cuid);
        this.m_sources = sources;
        this.m_isInherited = isInherited;
        this.makeListener(eventListener);
        if (cuid != null && !cuid.equals("")) {
            this.m_loadListener.setLoaded(0);
        }
    }

    protected void makeListener(ISecEventListener eventListener) {
        this.m_loadListener = new AbstractSecEventListener(){

            public void update(ISecUpdateEvent event) throws SDKException {
                IRoleID[] knownRoles;
                int eventId;
                if (event != null && (eventId = event.getType()) == 0 && (knownRoles = event.getKnownRoles()) != null && knownRoles.length > 0) {
                    for (int i = 0; i < knownRoles.length; ++i) {
                        IRoleID knownRole = knownRoles[i];
                        if (knownRole.getID() != SecurityRole.this.getID()) continue;
                        SecurityRole.this.m_title = knownRole.getTitle();
                        SecurityRole.this.m_description = knownRole.getDescription();
                        SecurityRole.this.m_cuid = knownRole.getCUID();
                        break;
                    }
                }
            }
        };
        this.m_loadListener.setParent(eventListener);
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public String getTitle() {
        AbstractSecEventListener.ensureDelayedLoad(0, this.m_loadListener);
        return super.getTitle();
    }

    public String getDescription() {
        AbstractSecEventListener.ensureDelayedLoad(0, this.m_loadListener);
        return super.getDescription();
    }

    public String getCUID() {
        AbstractSecEventListener.ensureDelayedLoad(0, this.m_loadListener);
        return super.getCUID();
    }

    public List getSources() {
        return this.m_sources;
    }

    public boolean isInherited() {
        return this.m_isInherited;
    }

    void saveRights(ISecRightsAdmin rightsAdmin, int objectID, int principalID) throws SDKException {
        if (this.m_dirty) {
            rightsAdmin.setRole(this.getID(), principalID, objectID);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.m_dirty);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.m_dirty = in.readBoolean();
    }

    public void serializeHelper(PropertyBag bag) {
        bag.addItem((Object)PropertyIDs.SI_ID, (Object)new Integer(this.getID()), 0);
    }

    void initFromSerialization(ISecEventListener parentListener) {
        if (this.m_loadListener == null) {
            this.makeListener(parentListener);
        }
    }
}

