/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Packer;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Unpacker;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IExplicitPrincipals;
import com.crystaldecisions.sdk.occa.infostore.IObjectPrincipals;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo2;
import com.crystaldecisions.sdk.occa.infostore.internal.CategoryContentInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.ExplicitPrincipals;
import com.crystaldecisions.sdk.occa.infostore.internal.Files;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.ObjectPrincipals;
import com.crystaldecisions.sdk.occa.infostore.internal.SchedulableCategoryContentInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.SchedulableInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityInfo;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityInfo2;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occamgr.internal.OCCAMgrFactory;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;

final class SerializableInfoObject
implements Serializable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.SerializableInfoObject");
    private int m_objType;
    private ISecuritySession m_session;
    private PropertyBag m_rootBag;
    private PropertyBag m_serBag;
    private String m_packedRoot;
    private String m_packedSer;
    private Files m_files;
    private ISecurityInfo m_securityInfo;
    private ISecurityInfo2 m_securityInfo2;
    private SDKPropertyBag m_schedulingInfo;
    private SDKPropertyBag m_processingInfo;
    private String m_frsName;
    private PropertyBag m_origFilesProps;

    SerializableInfoObject(int objType, ISecuritySession session, PropertyBag rootBag, PropertyBag serBag, SDKPropertyBag schedulingInfo, SDKPropertyBag processingInfo, Files files, ISecurityInfo securityInfo, ISecurityInfo2 securityInfo2, String frsName, PropertyBag origFilesProps) {
        this.m_objType = objType;
        this.m_session = session;
        this.m_rootBag = rootBag;
        this.m_serBag = serBag;
        this.m_files = files;
        this.m_packedRoot = null;
        this.m_packedSer = null;
        this.m_securityInfo = securityInfo;
        this.m_securityInfo2 = securityInfo2;
        this.m_schedulingInfo = schedulingInfo;
        this.m_processingInfo = processingInfo;
        this.m_frsName = frsName;
        this.m_origFilesProps = origFilesProps;
    }

    Object readResolve() throws ObjectStreamException {
        IPersistInfoObject obj = null;
        IPluginInfo info = null;
        try {
            IPluginMgr pluginMgr = (IPluginMgr)OCCAMgrFactory.getOCCAMgr().getOCCAFactory("PluginDistribution").makeOCCA("", this.m_session);
            info = pluginMgr.getPluginInfo(new Integer(this.m_objType));
            obj = (IPersistInfoObject)pluginMgr.getPluginInterface(info.getProgID(), "desktop");
        }
        catch (SDKException.PluginNotFound ex) {
            LOG.warn((Object)("Could not find plugin with SI_OBTYPE=" + this.m_objType), (Throwable)((Object)ex));
            if (info.isSchedulable()) {
                obj = info.isSupportCategoryContent() ? new SchedulableCategoryContentInfoObject() : new SchedulableInfoObject();
            } else if (info.isSupportCategoryContent()) {
                obj = new CategoryContentInfoObject();
            }
        }
        catch (SDKException.PluginNotFoundAtCMS ex) {
            LOG.warn((Object)("Could not find plugin with SI_OBTYPE=" + this.m_objType + " at the CMS."), (Throwable)((Object)ex));
        }
        catch (SDKException ex) {
            LOG.error((Object)"Unable to get Plugin Manager", (Throwable)((Object)ex));
        }
        if (obj == null) {
            obj = new InfoObject();
        }
        try {
            obj.initFromSerialization(this.m_session, this.m_packedRoot, this.m_packedSer, this.m_files, this.m_securityInfo, this.m_securityInfo2);
            ((InfoObject)obj).setOriginalFilesProperties(this.m_origFilesProps);
        }
        catch (SDKException sdke) {
            throw new SDKException.Serialization(sdke);
        }
        return obj;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.m_objType);
        out.writeObject(this.m_session);
        WireOb3Packer packer = new WireOb3Packer();
        this.m_packedRoot = packer.pack(this.m_rootBag, 0, 0, true, 0, 0);
        this.m_packedSer = packer.pack(this.m_serBag, 0, 0, true, 0, 0);
        out.writeObject(this.m_packedRoot);
        out.writeObject(this.m_packedSer);
        out.writeObject(this.m_files);
        out.writeObject(this.m_securityInfo);
        out.writeObject(this.m_securityInfo2);
        if (this.m_origFilesProps != null) {
            String packedOrigFilesProps = packer.pack(this.m_origFilesProps, 0, 0, true, 0, 0);
            out.writeObject(packedOrigFilesProps);
        } else {
            out.writeObject(null);
        }
    }

    public String getSerializedInfoObject() {
        Property prop;
        SDKPropertyBag rbag = new SDKPropertyBag();
        rbag.add(PropertyIDs.SI_SESSION_ID, this.m_session.getSessionID(), 0);
        rbag.add(PropertyIDs.SI_OBTYPE, new Integer(this.m_objType), 0);
        PropertyBag mainBag = ((Property)this.m_rootBag.get((Object)PropertyIDs.SI_MAINBAG)).getPropertyBag();
        WireOb3Packer packer = new WireOb3Packer();
        if (this.m_schedulingInfo != null) {
            prop = mainBag.addPropertyBag((Object)PropertyIDs.SI_SCHEDULEINFO, null);
            prop.getPropertyBag().putAll((Map)this.m_schedulingInfo);
        }
        if (this.m_processingInfo != null) {
            prop = mainBag.addPropertyBag((Object)PropertyIDs.SI_PROCESSINFO, null);
            prop.getPropertyBag().putAll((Map)this.m_processingInfo);
        }
        if (this.m_files != null) {
            PropertyBag filesPropBag = mainBag.addPropertyBag((Object)PropertyIDs.SI_FRSFILES, null).getPropertyBag();
            PropertyArrayHelper filesHelper = new PropertyArrayHelper(filesPropBag, PropertyIDs.SI_TOTAL);
            try {
                this.m_files.serializeHelper(filesHelper);
            }
            catch (SDKException e) {
                // empty catch block
            }
        }
        IObjectPrincipals objectPrincipals = null;
        try {
            if (this.m_securityInfo != null) {
                objectPrincipals = this.m_securityInfo.newObjectPrincipals();
            }
            if (objectPrincipals != null) {
                PropertyBag principalsBag = mainBag.addPropertyBag((Object)PropertyIDs.SI_SECURITYINFO, null).getPropertyBag();
                ((ObjectPrincipals)objectPrincipals).serializeHelper(principalsBag);
            }
        }
        catch (SDKException e) {
            LOG.info((Object)"Can't get explicit principals, security info are not serialized", (Throwable)((Object)e));
        }
        IExplicitPrincipals exlicitPrincipals = null;
        try {
            if (this.m_securityInfo2 != null) {
                exlicitPrincipals = this.m_securityInfo2.newExplicitPrincipals();
            }
            if (exlicitPrincipals != null) {
                PropertyBag principalsBag = mainBag.addPropertyBag((Object)PropertyIDs.SI_SECURITYINFO2, null).getPropertyBag();
                ((ExplicitPrincipals)exlicitPrincipals).serializeHelper(principalsBag);
            }
        }
        catch (SDKException e) {
            LOG.info((Object)"Can't get explicit principals, security info2 are not serialized", (Throwable)((Object)e));
        }
        this.m_packedRoot = packer.pack(this.m_rootBag, 0, 0, false, 0, 0);
        if (this.m_schedulingInfo != null) {
            mainBag.removeLocal((Object)PropertyIDs.SI_SCHEDULEINFO);
        }
        if (this.m_processingInfo != null) {
            mainBag.removeLocal((Object)PropertyIDs.SI_PROCESSINFO);
        }
        if (this.m_files != null && this.m_files.size() != 0) {
            mainBag.removeLocal((Object)PropertyIDs.SI_FRSFILES);
        }
        if (exlicitPrincipals != null) {
            mainBag.removeLocal((Object)PropertyIDs.SI_SECURITYINFO2);
        }
        if (objectPrincipals != null) {
            mainBag.removeLocal((Object)PropertyIDs.SI_SECURITYINFO);
        }
        rbag.add(PropertyIDs.SI_OBJ_PROPS, this.m_packedRoot, 0);
        this.m_packedSer = packer.pack(this.m_serBag, 0, 0, false, 0, 0);
        rbag.add(PropertyIDs.SI_EXTRA_PROPS, this.m_packedSer, 0);
        WireOb3Packer packer2 = new WireOb3Packer();
        String str = packer2.pack(rbag, 0, 0, false, 0, 0);
        return str;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_objType = in.readInt();
        this.m_session = (ISecuritySession)in.readObject();
        this.m_packedRoot = (String)in.readObject();
        this.m_packedSer = (String)in.readObject();
        this.m_files = (Files)in.readObject();
        this.m_securityInfo = (SecurityInfo)in.readObject();
        this.m_securityInfo2 = (SecurityInfo2)in.readObject();
        Object origFilesProps = in.readObject();
        if (origFilesProps == null) {
            this.m_origFilesProps = null;
        } else if (origFilesProps instanceof String) {
            String strOrigFilesProps = (String)origFilesProps;
            if (strOrigFilesProps.length() == 0) {
                this.m_origFilesProps = null;
            } else {
                WireOb3Unpacker unpacker = new WireOb3Unpacker();
                unpacker.initialize(strOrigFilesProps);
                this.m_origFilesProps = new SDKPropertyBag();
                this.m_origFilesProps.merge((IBagUnpacker)unpacker);
            }
        }
    }
}

