/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileRepositoryObject;
import com.crystaldecisions.sdk.occa.filerepository.internal.IStreamingSupport;
import com.crystaldecisions.sdk.occa.infostore.IStreamingDownloadFile;

class StreamingDownloadFile
implements IStreamingDownloadFile {
    private final IFileRepositoryObject m_frsObject;
    private IStreamingSupport m_streaming;
    private int m_chunkSize;

    StreamingDownloadFile(IFileRepositoryObject frsObject, int chunkSize) {
        this.m_frsObject = frsObject;
        this.m_chunkSize = chunkSize;
    }

    public void openFile() throws SDKException {
        this.m_streaming = this.m_frsObject.getStreamingSupport(this.m_chunkSize);
    }

    public boolean hasNextChunk() throws SDKException {
        return this.m_streaming.hasNext();
    }

    public byte[] nextChunk() throws SDKException {
        return this.m_streaming.next();
    }

    public void closeFile() throws SDKException {
        if (this.m_streaming != null) {
            this.m_streaming.close();
            this.m_streaming = null;
        }
    }

    public long getSize() throws SDKException {
        return this.m_streaming.getSize();
    }

    public long skip(long num) throws SDKException {
        return this.m_streaming.skip(num);
    }
}

