/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.pluginmgr.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.classloader.ClassLoaderHelper;
import com.crystaldecisions.celib.conversion.EncodeUtils;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.properties.URLUnpacker;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Unpacker;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginFactory;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginSecurityInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.internal.IInternalPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.internal.PluginMgrResourceBundle;
import com.crystaldecisions.sdk.occa.pluginmgr.internal.PluginSecurityInfo;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.WeakHashMap;

class PluginInfo
implements IPluginInfo,
IInternalPluginInfo {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.pluginmgr.internal.PluginInfo");
    private PropertyBag m_properties = new PropertyBag();
    private Map m_factoryByClassLoader;
    private IPluginSecurityInfo m_securityInfo;
    private static final PropertyBag EMPTY_BAG = new PropertyBag();
    private static final String IDS_INVALID = "invalid";
    private static final String IDS_APPLICATION = "application";
    private static final String IDS_CONTENT = "content";
    private static final String IDS_SYSTEM = "system";
    private static final String IDS_UNKNOWN = "unknown";
    private String m_resourceid;

    public PluginInfo(String url) {
        PluginUnpacker unpacker = new PluginUnpacker();
        unpacker.initialize(url);
        this.m_properties.unpack((IBagUnpacker)unpacker);
        this.m_factoryByClassLoader = new WeakHashMap(1);
    }

    public String getCategory() {
        int cat = this.m_properties.getInt((Object)PropertyIDs.SI_PLUGIN_CAT);
        switch (cat) {
            case 1: {
                return "desktop";
            }
            case 2: {
                return "admin";
            }
            case 3: {
                return "auth";
            }
            case 4: {
                return "dest";
            }
        }
        return IDS_UNKNOWN;
    }

    int getCategoryInt() {
        return this.m_properties.getInt((Object)PropertyIDs.SI_PLUGIN_CAT);
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public String getDescription(Locale locale) {
        String localizedDesc = null;
        IPluginFactory factory = this.getPluginFactory();
        if (factory != null) {
            localizedDesc = factory.getLocalizedDescription(locale);
        }
        if (localizedDesc != null) {
            return localizedDesc;
        }
        return "";
    }

    public IPluginFactory getFactory() {
        return this.getPluginFactory();
    }

    public String getName() {
        return this.getName(null);
    }

    public String getName(Locale locale) {
        String localizedName = null;
        IPluginFactory factory = this.getPluginFactory();
        if (factory != null) {
            localizedName = factory.getLocalizedName(locale);
        }
        if (localizedName != null) {
            return localizedName;
        }
        return this.getKind();
    }

    public String getObjectTypeName() {
        return this.m_properties.getString((Object)PropertyIDs.SI_PLUGIN_OBJECTTYPENAME);
    }

    public String getProgID() {
        return this.m_properties.getString((Object)PropertyIDs.SI_PLUGIN_PROGID);
    }

    public String getPropertyIndex() {
        return this.m_properties.getString((Object)PropertyIDs.SI_PLUGIN_PROPINDEX);
    }

    public short getType() {
        return (short)this.m_properties.getInt((Object)PropertyIDs.SI_PLUGIN_TYPE);
    }

    public String getKind() {
        return this.m_properties.getString((Object)PropertyIDs.SI_PLUGIN_KIND);
    }

    public String getVersion() {
        return this.m_properties.getString((Object)PropertyIDs.SI_PLUGIN_VERSION);
    }

    public int getTypeCollectionID() {
        return this.m_properties.getInt((Object)PropertyIDs.SI_RIGHTS_COLLECTION);
    }

    public String getTypeCollection(Locale locale) {
        int collection = this.getTypeCollectionID();
        String resID = IDS_UNKNOWN;
        switch (collection) {
            case 2: {
                resID = IDS_APPLICATION;
                break;
            }
            case 4: {
                resID = IDS_CONTENT;
                break;
            }
            case 3: {
                resID = IDS_SYSTEM;
                break;
            }
            case 0: {
                resID = IDS_INVALID;
            }
        }
        return PluginMgrResourceBundle.getString(resID, locale);
    }

    private synchronized IPluginFactory getPluginFactory() {
        IPluginFactory factory = (IPluginFactory)this.m_factoryByClassLoader.get(Thread.currentThread().getContextClassLoader());
        if (factory != null) {
            return factory;
        }
        try {
            Properties infoProperties = this.getInfoProperties();
            if (infoProperties != null) {
                String factoryName = infoProperties.getProperty("factory");
                LOG.assertNotNull((Object)factoryName, "factoryName is null.");
                if (factoryName != null) {
                    Class clazz = ClassLoaderHelper.loadClass((String)factoryName);
                    factory = (IPluginFactory)clazz.newInstance();
                    this.m_factoryByClassLoader.put(Thread.currentThread().getContextClassLoader(), factory);
                    String resourceid = factoryName.replace('.', '/');
                    int slashindex = resourceid.lastIndexOf(47);
                    if (slashindex != -1) {
                        resourceid = resourceid.substring(0, slashindex + 1);
                        resourceid = resourceid + this.getKind();
                        if ((resourceid = resourceid + "Resources") != null && resourceid.length() != 0) {
                            this.m_resourceid = resourceid;
                        }
                    }
                    return factory;
                }
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"initializeFactory(): should never happen", (Throwable)e);
        }
        return null;
    }

    public synchronized IPluginSecurityInfo getSecurityInfo() {
        if (this.m_securityInfo == null) {
            PropertyBag rolesBag = this.m_properties.getPropertyBag((Object)PropertyIDs.SI_PLUGIN_ROLES);
            rolesBag = rolesBag == null ? EMPTY_BAG : rolesBag;
            PropertyBag rightsBag = this.m_properties.getPropertyBag((Object)PropertyIDs.SI_PLUGIN_RIGHTS);
            rightsBag = rightsBag == null ? EMPTY_BAG : rightsBag;
            PropertyBag limitsBag = this.m_properties.getPropertyBag((Object)PropertyIDs.SI_PLUGIN_LIMITS);
            limitsBag = limitsBag == null ? EMPTY_BAG : limitsBag;
            boolean isMetaPlugin = false;
            int[] rootFolders = this.getRootFolderIDs();
            for (int i = 0; i < rootFolders.length; ++i) {
                if (30 != rootFolders[i]) continue;
                isMetaPlugin = true;
                break;
            }
            this.m_securityInfo = new PluginSecurityInfo(rolesBag, rightsBag, limitsBag, this.getType(), isMetaPlugin, this);
        }
        return this.m_securityInfo;
    }

    public int getRootFolderID() {
        return this.m_properties.getInt((Object)PropertyIDs.SI_PLUGIN_ROOTFOLDERID);
    }

    public int[] getRootFolderIDs() {
        String ids = this.m_properties.getString((Object)PropertyIDs.SI_PLUGIN_ROOTFOLDERIDS);
        URLUnpacker unpacker = new URLUnpacker();
        unpacker.initialize((Object)ids);
        PropertyBag idBag = new PropertyBag();
        idBag.unpack((IBagUnpacker)unpacker);
        PropertyArrayHelper helper = new PropertyArrayHelper(idBag);
        int[] ret = new int[helper.size()];
        int i = 0;
        Iterator iter = helper.iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            ret[i++] = Integer.parseInt(id);
        }
        return ret;
    }

    public boolean isWebAppContent() {
        return this.m_properties.getInt((Object)PropertyIDs.SI_PLUGIN_IS_WEBAPP_CONTENT) != 0;
    }

    public boolean isSchedulable() {
        return this.m_properties.getInt((Object)PropertyIDs.SI_PLUGIN_OBJECTS_CAN_BE_SCHEDULED) != 0;
    }

    public boolean isSendable() {
        return this.m_properties.getInt((Object)PropertyIDs.SI_PLUGIN_OBJECTS_CAN_BE_SENT_TO_DEST) != 0;
    }

    public boolean hasPlugin() {
        return this.m_properties.getInt((Object)PropertyIDs.SI_HAS_JAVA_PLUGIN) != 0;
    }

    public boolean isManagedDestination() {
        return this.m_properties.getInt((Object)PropertyIDs.SI_MANAGED_DEST) != 0;
    }

    public boolean isUseOnlyOwnRights() {
        return this.m_properties.getInt((Object)PropertyIDs.SI_PLUGIN_USEONLYOWNRIGHTS) != 0;
    }

    public boolean hasTypeSpecificRights() {
        return this.m_properties.getBoolean((Object)PropertyIDs.SI_PLUGIN_CAN_USE_TYPE_SPECIFIC_RIGHTS);
    }

    public String toString() {
        return "PluginInfo[m_properties=" + this.m_properties + ",m_factory=" + this.m_factoryByClassLoader + "]";
    }

    InputStream getPictureFromCMS(int pid) {
        String stringValue = this.m_properties.getString((Object)new Integer(pid));
        if (stringValue == null || stringValue.length() == 0) {
            return null;
        }
        byte[] decoded = EncodeUtils.base64DecodeCxlib((String)stringValue);
        ByteArrayInputStream istream = new ByteArrayInputStream(decoded);
        return istream;
    }

    public InputStream getPicture(String pictureName) {
        InputStream result = null;
        if (pictureName.compareToIgnoreCase("SI_PLUGIN_ICON_1") == 0 || pictureName.compareToIgnoreCase("SI_PLUGIN_ICON_1_A") == 0) {
            result = this.getPictureFromCMS(PropertyIDs.SI_PLUGIN_ICON_1_A);
        } else if (pictureName.compareToIgnoreCase("SI_PLUGIN_ICON_2") == 0 || pictureName.compareToIgnoreCase("SI_PLUGIN_ICON_2_A") == 0) {
            result = this.getPictureFromCMS(PropertyIDs.SI_PLUGIN_ICON_2_A);
        } else {
            Properties infoProperties = this.getInfoProperties();
            IPluginFactory factory = this.getPluginFactory();
            if (infoProperties != null && factory != null) {
                String realPictureName = null;
                realPictureName = infoProperties.getProperty(pictureName);
                if (realPictureName != null && realPictureName.length() > 0) {
                    result = factory.getClass().getResourceAsStream(realPictureName);
                }
            }
        }
        return result;
    }

    public InputStream getPicture() {
        return this.getPictureFromCMS(PropertyIDs.SI_PLUGIN_ICON_1_A);
    }

    public boolean isSupportCategoryContent() {
        return this.m_properties.getInt((Object)PropertyIDs.SI_PLUGIN_OBJECTS_SUPPORT_CATEGORY) != 0;
    }

    public String getStringDescription(String descID, Locale locale) {
        block4: {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            try {
                if (this.m_resourceid != null && this.m_resourceid.length() != 0) {
                    ResourceBundle bundle = ResourceBundle.getBundle(this.m_resourceid, locale, Thread.currentThread().getContextClassLoader());
                    return bundle.getString(descID);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)("PluginInfo getStringDescription couldn't load resource bundle m_resourceid =" + this.m_resourceid));
            }
        }
        return null;
    }

    private Properties getInfoProperties() {
        String propFileName = "META-INF/CrystalEnterprise.Plugins/" + this.getProgID() + ".properties";
        InputStream propertyStream = ClassLoaderHelper.getResourceAsStream((String)propFileName);
        Properties infoProperties = null;
        if (propertyStream != null) {
            try {
                infoProperties = new Properties();
                infoProperties.load(propertyStream);
                propertyStream.close();
            }
            catch (IOException ex) {
                infoProperties = null;
            }
        }
        return infoProperties;
    }

    public boolean equals(Object obj) {
        return obj instanceof PluginInfo && ((PluginInfo)obj).getKind().equalsIgnoreCase(this.getKind());
    }

    private static class PluginUnpacker
    extends URLUnpacker {
        private static final IBagUnpacker.IBagUnpackerFactory s_unpackerFactory = new WireOb3UnpackerFactory();

        private PluginUnpacker() {
        }

        public IBagUnpacker.IBagUnpackerFactory getNestedUnpackerFactory() {
            return s_unpackerFactory;
        }

        private static class WireOb3UnpackerFactory
        implements IBagUnpacker.IBagUnpackerFactory {
            private WireOb3UnpackerFactory() {
            }

            public IBagUnpacker makeUnpacker() {
                return new WireOb3Unpacker();
            }
        }
    }
}

