/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.pluginmgr.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.AbstractStubHelper;
import com.crystaldecisions.enterprise.ocaframework.IManagedService;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAd.PluginDistributionExPackage.Platform;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAd.PluginDistributionPackage.plugin_category;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAd.PluginDistributionVerHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAd.PluginDistributionVerOperations;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginFactory;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.pluginmgr.internal.PluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.internal._PluginDistributionVerProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class PluginMgr
implements IPluginMgr {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.pluginmgr.internal.PluginMgr");
    private String m_svr;
    private String m_aps;
    private String m_uri;
    private String m_cluster;
    private String m_token;
    private static final Map s_cache = new HashMap();
    private PluginDistributionVerOperations m_stub;
    private static final IManagedService.IHelperFactory s_helperFactory = new PluginMgrHelperFactory();
    private static final Map s_nonExisting = new HashMap();
    private static final int s_version = PluginMgr.getSDKVersion();

    public PluginMgr(String svr, String aps, String cluster, String uri, String token) throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PluginMgr(): svr=" + svr + ",aps=" + aps + ",uri=" + uri));
        }
        this.m_svr = svr;
        this.m_aps = aps;
        this.m_uri = uri;
        this.m_token = token;
        this.m_cluster = cluster;
    }

    private void loadKnownPluginsForCluster() throws SDKException {
        Boolean dummy = (Boolean)s_cache.get(new PluginInfoKey(this.m_cluster, ""));
        if (dummy == null) {
            this.getPlugins("unknown");
            s_cache.put(new PluginInfoKey(this.m_cluster, ""), Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginDistributionVerOperations getStub() throws SDKException {
        PluginDistributionVerOperations stub;
        PluginMgr pluginMgr = this;
        synchronized (pluginMgr) {
            stub = this.m_stub;
        }
        if (stub == null) {
            LOG.debug((Object)"getStub(): called!");
            try {
                IManagedService handler = ServiceMgrFactory.getServiceMgr().getManagedService("NO_ID", "PluginDistribution", new ServerSpec(this.m_svr, "aps", this.m_aps, this.m_cluster), this.m_uri, this.m_token, s_helperFactory);
                LOG.assertNotNull((Object)handler, "handler");
                stub = new _PluginDistributionVerProxy(handler);
                PluginMgr pluginMgr2 = this;
                synchronized (pluginMgr2) {
                    if (this.m_stub == null) {
                        this.m_stub = stub;
                    }
                }
            }
            catch (OCAFrameworkException e) {
                LOG.warn((Object)("getStub(): failed to initialize plugin manager,svr=" + this.m_svr + ", aps=" + this.m_aps + ",uri=" + this.m_uri), (Throwable)((Object)e));
                throw SDKException.map(e);
            }
        }
        return this.m_stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPluginInfo[] getWebAppContentPlugins() throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getWebAppContentPlugins()");
        }
        IPluginInfo[] info = null;
        PluginInfoKey cacheKey = new PluginInfoKey(this.m_cluster, "SI_PLUGIN_IS_WEBAPP_CONTENT");
        Map map = s_cache;
        synchronized (map) {
            this.loadKnownPluginsForCluster();
            ArrayList isWebAppContentInfo = (ArrayList)s_cache.get(cacheKey);
            if (isWebAppContentInfo != null) {
                info = new IPluginInfo[isWebAppContentInfo.size()];
                isWebAppContentInfo.toArray(info);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPluginInfo[] getPluginsWithTypeSpecificRights() throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getPluginsWithTypeSpecificRights()");
        }
        IPluginInfo[] info = null;
        PluginInfoKey cacheKey = new PluginInfoKey(this.m_cluster, "SI_PLUGIN_CAN_USE_TYPE_SPECIFIC_RIGHTS");
        Map map = s_cache;
        synchronized (map) {
            this.loadKnownPluginsForCluster();
            ArrayList canUseTypeSpecificRights = (ArrayList)s_cache.get(cacheKey);
            if (canUseTypeSpecificRights != null) {
                info = new IPluginInfo[canUseTypeSpecificRights.size()];
                canUseTypeSpecificRights.toArray(info);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPluginInfo getPluginInfo(Object key) throws SDKException {
        if (key == null) {
            throw new SDKException.InvalidArg("null");
        }
        if (key.toString().length() == 0) {
            throw new SDKException.InvalidArg(key.toString());
        }
        PluginInfoKey cacheKey = new PluginInfoKey(this.m_cluster, key);
        IPluginInfo info = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getPluginInfo(): key=" + key));
        }
        Map map = s_cache;
        synchronized (map) {
            this.loadKnownPluginsForCluster();
            info = (IPluginInfo)s_cache.get(cacheKey);
        }
        if (info == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"getPluginInfo(): PluginInfo not found in cache");
            }
            map = s_nonExisting;
            synchronized (map) {
                if (s_nonExisting.get(cacheKey) == Boolean.TRUE) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"(getPluginInfo:161): plugin found in the non existing map");
                    }
                    throw new SDKException.PluginNotFoundAtCMS(key.toString(), null);
                }
            }
            String xrl = null;
            try {
                if (key instanceof Integer) {
                    xrl = this.getStub().getPluginInfoByTypeVer(s_version, Platform.PLATFORM_INDEPENDENT, (short)((Integer)key).intValue());
                } else if (key instanceof String) {
                    String theKey = (String)key;
                    xrl = this.getStub().getPluginInfoVer(s_version, Platform.PLATFORM_INDEPENDENT, theKey);
                } else {
                    LOG.assertTrue(false, "key must be either Integer or String");
                }
            }
            catch (oca_abuse e) {
                Map map2 = s_nonExisting;
                synchronized (map2) {
                    s_nonExisting.put(cacheKey, Boolean.TRUE);
                }
                LOG.warn((Object)("getPluginInfo(): Failed to get plugin:key=" + cacheKey), (Throwable)e);
                throw new SDKException.PluginNotFoundAtCMS(key.toString(), (Exception)((Object)e));
            }
            PluginInfo newInfo = new PluginInfo(xrl);
            Map map3 = s_cache;
            synchronized (map3) {
                info = (IPluginInfo)s_cache.get(cacheKey);
                if (info == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"getPluginInfo(): PluginInfo still not found in cache");
                    }
                    info = newInfo;
                    s_cache.put(new PluginInfoKey(this.m_cluster, new Integer(info.getType())), info);
                    s_cache.put(new PluginInfoKey(this.m_cluster, info.getProgID()), info);
                    s_cache.put(new PluginInfoKey(this.m_cluster, info.getKind()), info);
                }
            }
        }
        LOG.debug((Object)"getPluginInfo(): exit");
        return info;
    }

    public Object getPluginInterface(Object plgkey, String type) throws SDKException {
        PluginInfo info;
        IPluginFactory factory;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getPluginProcessingInterface(): key=" + plgkey + ",category=" + type));
        }
        if ((factory = (info = (PluginInfo)this.getPluginInfo(plgkey)).getFactory()) != null) {
            return factory.makePlugin(type);
        }
        throw new SDKException.PluginNotFound(plgkey.toString());
    }

    public IPluginInfo[] getPlugins(String cat) throws SDKException {
        if (cat.equals("unknown")) {
            return this.getPluginsUnknown();
        }
        return this.getPluginsHelper(cat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPluginInfo[] getPluginsHelper(String cat) throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getPlugins(): category=" + cat));
        }
        try {
            plugin_category pc = null;
            if (cat.equals("desktop")) {
                pc = plugin_category.Desktop;
            } else if (cat.equals("admin")) {
                pc = plugin_category.Admin;
            } else if (cat.equals("auth")) {
                pc = plugin_category.Auth;
            } else if (cat.equals("dest")) {
                pc = plugin_category.Dest;
            } else if (cat.equals("meta")) {
                pc = plugin_category.Meta;
            } else {
                if (cat.equals("unknown")) {
                    return this.getPluginsUnknown();
                }
                LOG.warn((Object)("Category not recognized:" + cat));
                throw new SDKException.PluginCategory(cat);
            }
            IPluginInfo[] info = null;
            PluginInfoKey cacheKey = new PluginInfoKey(this.m_cluster, pc);
            Map map = s_cache;
            synchronized (map) {
                info = (IPluginInfo[])s_cache.get(cacheKey);
            }
            if (info == null) {
                LOG.info((Object)"Not loaded");
                String[] xrls = this.getStub().getPluginInfosVer(s_version, Platform.PLATFORM_INDEPENDENT, pc);
                IPluginInfo[] newInfos = new IPluginInfo[xrls.length];
                for (int i = 0; i < xrls.length; ++i) {
                    try {
                        newInfos[i] = new PluginInfo(xrls[i]);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"(getPlugins:292): unexpected exception", (Throwable)e);
                    }
                }
                Map map2 = s_cache;
                synchronized (map2) {
                    info = this.fillCacheHelper(cacheKey, newInfos);
                }
            }
            LOG.assertNotNull((Object)info, "info");
            LOG.debug((Object)"getPlugins(): exit");
            return info;
        }
        catch (oca_abuse e) {
            LOG.warn((Object)("getPlugins(): Failed to load plugins, category=" + cat), (Throwable)e);
            throw new SDKException.PluginCategory(cat, (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPluginInfo[] getPluginsUnknown() throws SDKException {
        String cat = "unknown";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getPlugins(): category=" + cat));
        }
        try {
            plugin_category pc = plugin_category.Unknown;
            IPluginInfo[] info = null;
            PluginInfoKey cacheKey = new PluginInfoKey(this.m_cluster, pc);
            IPluginInfo[] infoDesktop = null;
            IPluginInfo[] infoAdmin = null;
            IPluginInfo[] infoAuth = null;
            IPluginInfo[] infoDest = null;
            IPluginInfo[] infoMeta = null;
            PluginInfoKey cacheKeyDesktop = new PluginInfoKey(this.m_cluster, plugin_category.Desktop);
            PluginInfoKey cacheKeyAdmin = new PluginInfoKey(this.m_cluster, plugin_category.Admin);
            PluginInfoKey cacheKeyAuth = new PluginInfoKey(this.m_cluster, plugin_category.Auth);
            PluginInfoKey cacheKeyDest = new PluginInfoKey(this.m_cluster, plugin_category.Dest);
            PluginInfoKey cacheKeyMeta = new PluginInfoKey(this.m_cluster, plugin_category.Meta);
            Map map = s_cache;
            synchronized (map) {
                info = (IPluginInfo[])s_cache.get(cacheKey);
                infoDesktop = (IPluginInfo[])s_cache.get(cacheKeyDesktop);
                infoAdmin = (IPluginInfo[])s_cache.get(cacheKeyAdmin);
                infoAuth = (IPluginInfo[])s_cache.get(cacheKeyAuth);
                infoDest = (IPluginInfo[])s_cache.get(cacheKeyDest);
                infoMeta = (IPluginInfo[])s_cache.get(cacheKeyMeta);
            }
            if (info == null) {
                LOG.info((Object)"Not loaded");
                ArrayList<IPluginInfo> infoDesktopArr = null;
                ArrayList<IPluginInfo> infoAdminArr = null;
                ArrayList<IPluginInfo> infoAuthArr = null;
                ArrayList<IPluginInfo> infoDestArr = null;
                ArrayList<IPluginInfo> infoMetaArr = null;
                if (infoDesktop == null) {
                    infoDesktopArr = new ArrayList<IPluginInfo>();
                }
                if (infoAdmin == null) {
                    infoAdminArr = new ArrayList<IPluginInfo>();
                }
                if (infoAuth == null) {
                    infoAuthArr = new ArrayList<IPluginInfo>();
                }
                if (infoDest == null) {
                    infoDestArr = new ArrayList<IPluginInfo>();
                }
                if (infoMeta == null) {
                    infoMetaArr = new ArrayList<IPluginInfo>();
                }
                String[] xrls = this.getStub().getPluginInfosVer(s_version, Platform.PLATFORM_INDEPENDENT, pc);
                IPluginInfo[] newInfos = new IPluginInfo[xrls.length];
                for (int i = 0; i < xrls.length; ++i) {
                    try {
                        newInfos[i] = new PluginInfo(xrls[i]);
                        int infoCat = ((PluginInfo)newInfos[i]).getCategoryInt();
                        if (infoCat == 1 && infoDesktop == null) {
                            infoDesktopArr.add(newInfos[i]);
                            continue;
                        }
                        if (infoCat == 2 && infoAdmin == null) {
                            infoAdminArr.add(newInfos[i]);
                            continue;
                        }
                        if (infoCat == 3 && infoAuth == null) {
                            infoAuthArr.add(newInfos[i]);
                            continue;
                        }
                        if (infoCat == 4 && infoDest == null) {
                            infoDestArr.add(newInfos[i]);
                            continue;
                        }
                        if (infoCat != 5 || infoMeta != null) continue;
                        infoMetaArr.add(newInfos[i]);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"(getPlugins:292): unexpected exception", (Throwable)e);
                    }
                }
                if (infoDesktop == null) {
                    infoDesktop = new IPluginInfo[infoDesktopArr.size()];
                    infoDesktopArr.toArray(infoDesktop);
                }
                if (infoAdmin == null) {
                    infoAdmin = new IPluginInfo[infoAdminArr.size()];
                    infoAdminArr.toArray(infoAdmin);
                }
                if (infoAuth == null) {
                    infoAuth = new IPluginInfo[infoAuthArr.size()];
                    infoAuthArr.toArray(infoAuth);
                }
                if (infoDest == null) {
                    infoDest = new IPluginInfo[infoDestArr.size()];
                    infoDestArr.toArray(infoDest);
                }
                if (infoMeta == null) {
                    infoMeta = new IPluginInfo[infoMetaArr.size()];
                    infoMetaArr.toArray(infoMeta);
                }
                Map map2 = s_cache;
                synchronized (map2) {
                    if (s_cache.get(cacheKeyDesktop) == null) {
                        s_cache.put(cacheKeyDesktop, infoDesktop);
                    }
                    if (s_cache.get(cacheKeyAdmin) == null) {
                        s_cache.put(cacheKeyAdmin, infoAdmin);
                    }
                    if (s_cache.get(cacheKeyAuth) == null) {
                        s_cache.put(cacheKeyAuth, infoAuth);
                    }
                    if (s_cache.get(cacheKeyDest) == null) {
                        s_cache.put(cacheKeyDest, infoDest);
                    }
                    if (s_cache.get(cacheKeyMeta) == null) {
                        s_cache.put(cacheKeyMeta, infoMeta);
                    }
                    info = this.fillCacheHelper(cacheKey, newInfos);
                }
            }
            LOG.assertNotNull((Object)info, "info");
            LOG.debug((Object)"getPlugins(): exit");
            return info;
        }
        catch (oca_abuse e) {
            LOG.warn((Object)("getPlugins(): Failed to load plugins, category=" + cat), (Throwable)e);
            throw new SDKException.PluginCategory(cat, (Exception)((Object)e));
        }
    }

    private IPluginInfo[] fillCacheHelper(Object cacheKey, IPluginInfo[] newInfos) {
        IPluginInfo[] info = (IPluginInfo[])s_cache.get(cacheKey);
        if (info == null) {
            info = newInfos;
            s_cache.put(cacheKey, info);
            for (int i = 0; i < newInfos.length; ++i) {
                IPluginInfo newInfo = newInfos[i];
                if (newInfo == null) continue;
                s_cache.put(new PluginInfoKey(this.m_cluster, newInfo.getProgID()), newInfo);
                s_cache.put(new PluginInfoKey(this.m_cluster, newInfo.getKind()), newInfo);
                s_cache.put(new PluginInfoKey(this.m_cluster, new Integer(newInfo.getType())), newInfo);
                if (newInfo.getProgID().equals("CrystalEnterprise.CMSAdmin")) {
                    s_cache.put(new PluginInfoKey(this.m_cluster, "CrystalEnterprise.APSAdmin"), newInfo);
                    s_cache.put(new PluginInfoKey(this.m_cluster, "APSAdmin"), newInfo);
                }
                if (newInfo.isWebAppContent()) {
                    PluginInfoKey isWebAppContentKey = new PluginInfoKey(this.m_cluster, "SI_PLUGIN_IS_WEBAPP_CONTENT");
                    ArrayList<IPluginInfo> isWebAppContentInfo = (ArrayList<IPluginInfo>)s_cache.get(isWebAppContentKey);
                    if (isWebAppContentInfo == null) {
                        isWebAppContentInfo = new ArrayList<IPluginInfo>();
                        s_cache.put(isWebAppContentKey, isWebAppContentInfo);
                    }
                    if (!isWebAppContentInfo.contains(newInfo)) {
                        isWebAppContentInfo.add(newInfo);
                    }
                }
                if (!newInfo.hasTypeSpecificRights()) continue;
                PluginInfoKey canUseTypeSpecificRightsKey = new PluginInfoKey(this.m_cluster, "SI_PLUGIN_CAN_USE_TYPE_SPECIFIC_RIGHTS");
                ArrayList<IPluginInfo> canUseTypeSpecificRightsInfo = (ArrayList<IPluginInfo>)s_cache.get(canUseTypeSpecificRightsKey);
                if (canUseTypeSpecificRightsInfo == null) {
                    canUseTypeSpecificRightsInfo = new ArrayList<IPluginInfo>();
                    s_cache.put(canUseTypeSpecificRightsKey, canUseTypeSpecificRightsInfo);
                }
                if (canUseTypeSpecificRightsInfo.contains(newInfo)) continue;
                canUseTypeSpecificRightsInfo.add(newInfo);
            }
        }
        return info;
    }

    private static int getSDKVersion() {
        String versionStr = System.getProperty("bobj.sdk.version");
        if (versionStr == null) {
            return 1200;
        }
        return Integer.parseInt(versionStr);
    }

    private static class PluginMgrHelperFactory
    implements IManagedService.IHelperFactory {
        private PluginMgrHelperFactory() {
        }

        public IManagedService.IStubHelper makeHelper() {
            return new StubHelper();
        }

        private static class StubHelper
        extends AbstractStubHelper {
            private StubHelper() {
            }

            public Object narrow(com.crystaldecisions.thirdparty.org.omg.CORBA.Object object) {
                return PluginDistributionVerHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)object);
            }

            public void release(Object object) {
                ((PluginDistributionVerOperations)object).free();
            }
        }
    }

    static class PluginInfoKey {
        private String m_clusterName;
        private Object m_realKey;

        public PluginInfoKey(String clusterName, Object realKey) {
            this.m_clusterName = clusterName;
            this.m_realKey = realKey instanceof String ? realKey.toString().toUpperCase() : realKey;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PluginInfoKey) {
                PluginInfoKey inputKey = (PluginInfoKey)obj;
                return this.m_clusterName.equalsIgnoreCase(inputKey.m_clusterName) && this.m_realKey.equals(inputKey.m_realKey);
            }
            return false;
        }

        public int hashCode() {
            return this.m_clusterName.hashCode() + this.m_realKey.hashCode();
        }

        public String toString() {
            return this.m_clusterName + ":" + this.m_realKey;
        }
    }
}

