/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.pluginmgr.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.internal.RightID;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginRole;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginSecurityInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.internal.IInternalPluginSecurityInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.internal.PluginRole;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.Arrays;
import java.util.HashSet;

class PluginSecurityInfo
implements IInternalPluginSecurityInfo,
IPluginSecurityInfo {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.pluginmgr.internal.PluginSecurityInfo");
    private IPluginRole[] m_customRights;
    private IRightID[] m_knownRights;
    private IRightID[] m_knownLimits;

    PluginSecurityInfo(PropertyBag properties, PropertyBag rightsBag, PropertyBag limitsBag, int obType, boolean isMetaPlugin, IPluginInfo pluginInfo) {
        this.loadPluginRoles(properties, obType, isMetaPlugin, pluginInfo);
        this.loadKnownLimits(limitsBag, obType, isMetaPlugin);
        this.loadKnownRights(rightsBag, obType, isMetaPlugin);
    }

    public IRightID[] getKnownLimits() {
        return this.m_knownLimits;
    }

    public IRightID[] getKnownRights() {
        return this.m_knownRights;
    }

    public IPluginRole[] getPluginRoles() {
        return this.m_customRights;
    }

    private void loadPluginRoles(PropertyBag rolesBag, int obType, boolean metaPlugin, IPluginInfo info) {
        PropertyArrayHelper helper = new PropertyArrayHelper(rolesBag, PropertyIDs.SI_TOTAL);
        HashSet<PluginRole> result = new HashSet<PluginRole>(helper.size());
        for (int i = 0; i < helper.size(); ++i) {
            PropertyBag bag = (PropertyBag)helper.get(i);
            if (bag == null) {
                LOG.warn((Object)"Bad plugin xml, SI_TOTAL is different from the actual size.");
                continue;
            }
            result.add(new PluginRole(bag, obType, metaPlugin, info));
        }
        if (helper.size() != result.size()) {
            LOG.warn((Object)("Bad plugin xml, SI_TOTAL is different from the actual size. SI_TOTAL=" + helper.size() + " actual size=" + result.size()));
        }
        this.m_customRights = result.toArray(new IPluginRole[result.size()]);
    }

    private void loadKnownRights(PropertyBag rightsBag, int obType, boolean metaPlugin) {
        PropertyArrayHelper helper = new PropertyArrayHelper(rightsBag, PropertyIDs.SI_TOTAL);
        HashSet<IRightID> result = new HashSet<IRightID>(helper.size());
        for (int i = 0; i < helper.size(); ++i) {
            PropertyBag bag = (PropertyBag)helper.get(i);
            if (bag == null) {
                LOG.warn((Object)"Bad plugin xml, SI_TOTAL is different from the actual size.");
                continue;
            }
            int rightMask = PluginRole.getRightMask(obType, metaPlugin);
            IRightID rightID = PluginSecurityInfo.makeRightID(bag, rightMask);
            result.add(rightID);
        }
        if (helper.size() != result.size()) {
            LOG.warn((Object)("Bad plugin xml, SI_TOTAL is different from the actual size. SI_TOTAL=" + helper.size() + " actual size=" + result.size()));
        }
        IPluginRole[] infos = this.getPluginRoles();
        for (int i = 0; i < infos.length; ++i) {
            IPluginRole info = infos[i];
            IRightID[] rightIDs = info.getRights();
            result.addAll(Arrays.asList(rightIDs));
        }
        this.m_knownRights = result.toArray(new IRightID[result.size()]);
    }

    public static IRightID makeRightID(PropertyBag bag, int rightMask) {
        boolean isOwner;
        String description = "";
        Property descProp = bag.getItem((Object)PropertyIDs.SI_DESCRIPTION);
        if (descProp != null) {
            description = descProp.getValue().toString();
        }
        String category = "";
        Property prop = bag.getItem((Object)PropertyIDs.SI_CATEGORY);
        if (prop != null) {
            category = prop.getValue().toString();
        }
        int id = bag.getInt((Object)PropertyIDs.SI_ID);
        boolean isSystemRight = bag.getBoolean((Object)PropertyIDs.SI_SYSTEM_RIGHT);
        if (!isSystemRight) {
            id = rightMask | id;
        }
        if (isOwner = bag.getBoolean((Object)PropertyIDs.SI_OWNER_RIGHT)) {
            id |= 0x20000000;
        }
        RightID rightID = new RightID(id, description, category, 0);
        return rightID;
    }

    private void loadKnownLimits(PropertyBag limitsBag, int obType, boolean metaPlugin) {
        PropertyArrayHelper helper = new PropertyArrayHelper(limitsBag, PropertyIDs.SI_TOTAL);
        HashSet<IRightID> result = new HashSet<IRightID>(helper.size());
        for (int i = 0; i < helper.size(); ++i) {
            PropertyBag bag = (PropertyBag)helper.get(i);
            if (bag == null) {
                LOG.warn((Object)"Bad plugin xml, SI_TOTAL is different from the actual size.");
                continue;
            }
            int rightMask = PluginRole.getRightMask(obType, metaPlugin);
            IRightID rightID = PluginSecurityInfo.makeRightID(bag, rightMask);
            result.add(rightID);
        }
        if (helper.size() != result.size()) {
            LOG.warn((Object)("Bad plugin xml, SI_TOTAL is different from the actual size. SI_TOTAL=" + helper.size() + " actual size=" + result.size()));
        }
        this.m_knownLimits = result.toArray(new IRightID[result.size()]);
    }

    public void updateRoles() {
        IPluginRole[] infos = this.getPluginRoles();
        for (int i = 0; i < infos.length; ++i) {
            PluginRole info = (PluginRole)infos[i];
            info.updateRole();
        }
    }
}

