/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.ras21;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.AbstractStubHelper;
import com.crystaldecisions.enterprise.ocaframework.IManagedService;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.OSCAUnmanagedSimpleFactoryMgr;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAras21.BlockingDocumentConnection;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAras21.BlockingDocumentConnectionHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAras21.BlockingDocumentConnectionHolder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAras21.BlockingDocumentConnectionOperations;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAras21.BlockingDocumentConnectionRepositoryHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAras21.BlockingDocumentConnectionRepositoryOperations;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.SeqOctetHolder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStoreFactory;
import com.crystaldecisions.sdk.occa.ras21.IRASConnection;
import com.crystaldecisions.sdk.occa.ras21.IRASConnectionInitService;
import com.crystaldecisions.sdk.occa.ras21.RAS21ResourceBundle;
import com.crystaldecisions.sdk.occa.ras21.RASConnectionException;
import com.crystaldecisions.sdk.occa.ras21.RASFactoryListenerImpl;
import com.crystaldecisions.sdk.occa.ras21._BlockingDocumentConnectionProxy;
import com.crystaldecisions.sdk.occa.ras21._BlockingDocumentConnectionRepositoryProxy;
import com.crystaldecisions.sdk.occa.ras21.messages.FullRequest;
import com.crystaldecisions.sdk.occa.ras21.messages.FullResult;
import com.crystaldecisions.sdk.occa.ras21.messages.GetConnection;
import com.crystaldecisions.sdk.occa.ras21.messages.Result;
import com.crystaldecisions.sdk.occa.ras21.serialization.IServerDeserializer;
import com.crystaldecisions.sdk.occa.ras21.serialization.IServerDeserializerFactory;
import com.crystaldecisions.sdk.occa.ras21.serialization.IServerSerializer;
import com.crystaldecisions.sdk.occa.ras21.serialization.IServerSerializerFactory;
import com.crystaldecisions.sdk.occa.ras21.serialization.SerializationException;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORB;
import com.crystaldecisions.thirdparty.org.omg.CORBA.StringHolder;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Locale;
import java.util.Map;

class RASConnection
implements IRASConnection {
    private static final ILogger LOG = LoggerManager.getLogger((Class)RASConnection.class);
    private static final String DOC_REPOSITORY_SERVICE = "BlockingDocumentConnectionRepository";
    private static final String DOC_CONNECTION_SERVICE = "BlockingDocumentConnectionRepository";
    private static final Object s_mutex = new Object();
    private static long s_nextKey = 0L;
    private final String m_sServerKind;
    private GetConnection m_getConnection;
    private final InputStream m_documentStream;
    private final InetSocketAddress[] m_unmanagedServers;
    private final IServerDeserializerFactory m_deserializerFactory;
    private final IServerSerializerFactory m_serializerFactory;
    private BlockingDocumentConnectionOperations m_docConnection;
    private ConnectionServiceHelper m_connServiceHelper;
    private OSCAUnmanagedSimpleFactoryMgr m_oscaUnmanagedMgr;
    static /* synthetic */ Class class$com$crystaldecisions$sdk$occa$ras21$RASConnection$RepositoryServiceHelper;
    static /* synthetic */ Class class$com$crystaldecisions$sdk$occa$ras21$RASConnection$ConnectionServiceHelper;

    public static IRASConnectionInitService getEmptyInitService() {
        return new RASConnectionInitService();
    }

    RASConnection(String i_sServerKind, GetConnection i_getConnection, InetSocketAddress[] i_unmanagedServers, InputStream i_documentStream, IRASConnectionInitService i_initService, IServerDeserializerFactory i_deserializerFactory, IServerSerializerFactory i_serializerFactory) throws RASConnectionException {
        if (null == i_sServerKind) {
            String sMessage = "i_sServerKind is null";
            LOG.error((Object)"i_sServerKind is null");
            throw new IllegalArgumentException("i_sServerKind is null");
        }
        if (null == i_getConnection) {
            String sMessage = "i_getConnection is null";
            LOG.error((Object)"i_getConnection is null");
            throw new IllegalArgumentException("i_getConnection is null");
        }
        if (null == i_deserializerFactory) {
            String sMessage = "i_deserializerFactory is null";
            LOG.error((Object)"i_deserializerFactory is null");
            throw new IllegalArgumentException("i_deserializerFactory is null");
        }
        if (null == i_serializerFactory) {
            String sMessage = "i_serializerFactory is null";
            LOG.error((Object)"i_serializerFactory is null");
            throw new IllegalArgumentException("i_serializerFactory is null");
        }
        if (null != i_unmanagedServers) {
            if (null != i_getConnection.getSecuritySession()) {
                String sMessage = "can only pass in CMS or i_unmanagedServers into RASConnection";
                LOG.error((Object)"can only pass in CMS or i_unmanagedServers into RASConnection");
                throw new IllegalArgumentException("can only pass in CMS or i_unmanagedServers into RASConnection");
            }
            int numServers = i_unmanagedServers.length;
            if (numServers <= 0) {
                String sMessage = "i_unmanagedServers array length must be > 0";
                LOG.error((Object)"i_unmanagedServers array length must be > 0");
                throw new IllegalArgumentException("i_unmanagedServers array length must be > 0");
            }
        }
        this.m_getConnection = new GetConnection(i_getConnection);
        this.m_sServerKind = i_sServerKind;
        this.m_documentStream = i_documentStream;
        this.m_deserializerFactory = i_deserializerFactory;
        this.m_serializerFactory = i_serializerFactory;
        this.m_unmanagedServers = i_unmanagedServers;
        this.m_oscaUnmanagedMgr = null;
        this.init(i_initService, this.m_getConnection.getConfiguration());
    }

    public void processRequest(FullRequest i_fullRequest, FullResult io_fullResult) throws RASConnectionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"ENTER: processRequest()");
        }
        if (null == i_fullRequest) {
            String sMessage = "i_fullRequest is null";
            LOG.error((Object)"i_fullRequest is null");
            throw new IllegalArgumentException("i_fullRequest is null");
        }
        if (null == io_fullResult) {
            String sMessage = "io_fullResult is null";
            LOG.error((Object)"io_fullResult is null");
            throw new IllegalArgumentException("io_fullResult is null");
        }
        if (null == i_fullRequest.getRASRequest()) {
            String sMessage = "i_fullRequest.getRASRequest() is null";
            LOG.error((Object)"i_fullRequest.getRASRequest() is null");
            throw new IllegalArgumentException("i_fullRequest.getRASRequest() is null");
        }
        if (null == i_fullRequest.getProcessingRequest()) {
            String sMessage = "i_fullRequest.getProcessingRequest() is null";
            LOG.error((Object)"i_fullRequest.getProcessingRequest() is null");
            throw new IllegalArgumentException("i_fullRequest.getProcessingRequest() is null");
        }
        try {
            IServerSerializer szer = this.m_serializerFactory.createSerializer();
            i_fullRequest.getRASRequest().serialize(szer);
            String sRASRequest = szer.getSerializedString();
            String sProcRequest = i_fullRequest.getProcessingRequest();
            byte[] requestData = i_fullRequest.getData() == null ? new byte[]{} : i_fullRequest.getData();
            StringHolder rasResultHolder = new StringHolder();
            StringHolder procResultHolder = new StringHolder();
            SeqOctetHolder resultDataHolder = new SeqOctetHolder();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("RAS Server Request is " + sRASRequest));
                LOG.info((Object)("Processing Request is " + sProcRequest));
            }
            this.m_docConnection.post(sRASRequest, sProcRequest, requestData, rasResultHolder, procResultHolder, resultDataHolder);
            IServerDeserializer dszer = this.m_deserializerFactory.createDeserializer();
            Locale locale = this.m_getConnection.getLocale();
            dszer.initFromSerializedString(rasResultHolder.value, locale);
            Result result = new Result();
            result.deserialize(dszer, locale);
            io_fullResult.setRASResult(result);
            io_fullResult.setProcessingResult(procResultHolder.value);
            io_fullResult.setData(resultDataHolder.value);
            if (result.getIsSaveAsRequest()) {
                this.m_docConnection.free();
                this.m_getConnection = new GetConnection(this.m_getConnection.getLocale(), this.m_getConnection.getSecuritySession(), result.getSaveAsDocumentId(), this.m_getConnection.getConfiguration());
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Request is a save-as request, so opening document " + this.m_getConnection.getDocumentId().toString()));
                }
                this.init(null, this.m_getConnection.getConfiguration());
            }
        }
        catch (NumberFormatException except) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"processRequest(): ", (Throwable)except);
            }
            throw new RASConnectionException(3, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_FAILED_REQUEST, this.m_getConnection.getLocale()), "RASLIB9029", except.getMessage());
        }
        catch (SerializationException except) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"processRequest(): ", (Throwable)except);
            }
            throw new RASConnectionException(3, except.getMessage(), except.getRootCause(), except.getDebugString());
        }
        catch (oca_abuse except) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"processRequest(): ", (Throwable)except);
            }
            SDKException sdkExcept = SDKException.map(except);
            throw new RASConnectionException(3, sdkExcept.getMessage(this.m_getConnection.getLocale()), "RASLIB9000", except.getMessage());
        }
        catch (StubHelperException except) {
            RASConnectionException ex = except.getRealCause();
            if (ex instanceof RASConnectionException) {
                throw ex;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"processRequest(): ", (Throwable)ex);
            }
            throw new RASConnectionException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_INTERNAL, this.m_getConnection.getLocale()), "RASLIB9028", ex.getMessage());
        }
        catch (IManagedService.ManagedExpiredException except) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"processRequest(): ", (Throwable)except);
            }
            throw new RASConnectionException(3, except.getMessage(this.m_getConnection.getLocale()), "RASLIB9038", except.getMessage());
        }
        catch (RuntimeException except) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"processRequest(): ", (Throwable)except);
            }
            throw new RASConnectionException(3, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_INTERNAL, this.m_getConnection.getLocale()), "RASLIB9001", except.getMessage());
        }
        catch (Error except) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"processRequest(): ", (Throwable)except);
            }
            throw except;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"EXIT: processRequest()");
        }
    }

    public void free() throws RASConnectionException {
        this.m_docConnection.free();
    }

    public GetConnection getGetConnection() {
        return new GetConnection(this.m_getConnection);
    }

    public String getServerKind() {
        return this.m_sServerKind;
    }

    public IRASConnectionInitService getInitService() {
        if (null == this.m_connServiceHelper) {
            return null;
        }
        return new RASConnectionInitService(this.m_connServiceHelper.getCORBAService());
    }

    public InetSocketAddress[] getUnmanagedServers() {
        return this.m_unmanagedServers;
    }

    private void initServerSpec(ServerSpec serverSpec) throws RASConnectionException {
        String sDocType = this.m_getConnection.getDocumentId().getIdType();
        String sDocId = this.m_getConnection.getDocumentId().getId();
        if (sDocType.equals("4") || sDocType.equals("3")) {
            String sCMSName = this.m_getConnection.getSecuritySession().getAPSName();
            InternalInfoStoreFactory iStoreFactory = InternalInfoStoreFactory.getFactory();
            IInternalInfoStore infoStore = null;
            try {
                infoStore = (IInternalInfoStore)iStoreFactory.makeOCCA(sCMSName, this.m_getConnection.getSecuritySession());
            }
            catch (SDKException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"initServerSpec(): ", (Throwable)((Object)e));
                }
                throw new RASConnectionException(3, e.getMessage(this.m_getConnection.getLocale()), "RASLIB9030", "RASConnection.initServerSpec() " + e.getDetail(), (Throwable)((Object)e));
            }
            StringBuffer queryBuf = new StringBuffer();
            queryBuf.append("SELECT SI_MACHINE, SI_MACHINECHOICE from CI_INFOOBJECTS WHERE ");
            if (sDocType.equals("4")) {
                queryBuf.append("SI_ID=" + sDocId);
            } else {
                queryBuf.append("SI_CUID='" + sDocId + "'");
            }
            String sQuery = queryBuf.toString();
            IInfoObjects objs = null;
            try {
                objs = infoStore.query(sQuery);
            }
            catch (SDKException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"initServerSpec(): ", (Throwable)((Object)e));
                }
                throw new RASConnectionException(3, e.getMessage(this.m_getConnection.getLocale()), "RASLIB9031", "RASConnection.initServerSpec() " + e.getDetail(), (Throwable)((Object)e));
            }
            if (objs.getResultSize() != 1) {
                LOG.warn((Object)"objs.getResultSize() is not 1");
                throw new RASConnectionException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_DOCUMENT_NOT_FOUND, this.m_getConnection.getLocale(), sDocId), "RASLIB9032", "RASConnection.initServerSpec()");
            }
            IInfoObject infoObj = (IInfoObject)objs.get(0);
            IProperties props = infoObj.properties();
            IProperty prop = props.getProperty(PropertyIDs.SI_MACHINECHOICE);
            if (prop == null) {
                return;
            }
            Integer servergroupChoice = (Integer)prop.getValue();
            prop = props.getProperty(PropertyIDs.SI_MACHINE);
            if (prop == null) {
                return;
            }
            Integer servergroupID = (Integer)prop.getValue();
            serverSpec.setGroup(servergroupID);
            serverSpec.setGroupMode(servergroupChoice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(IRASConnectionInitService i_initService, Map i_configuration) throws RASConnectionException {
        String key;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"ENTER: init()");
        }
        if (null != i_initService && !(i_initService instanceof RASConnectionInitService)) {
            LOG.warn((Object)"i_initService is not valid");
            throw new RASConnectionException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_INTERNAL, this.m_getConnection.getLocale()), "RASLIB9004", "RASConnection.init()");
        }
        RASConnectionInitService initService = (RASConnectionInitService)i_initService;
        BlockingDocumentConnection initDocConn = null == initService ? null : initService.getService();
        String sLocale = this.m_getConnection.getSerializedLocale();
        Object object = s_mutex;
        synchronized (object) {
            long nextKey = s_nextKey++;
            key = Long.toString(nextKey);
        }
        GetConnection.DocumentId documentId = this.m_getConnection.getDocumentId();
        if (this.m_unmanagedServers != null) {
            this.m_oscaUnmanagedMgr = new OSCAUnmanagedSimpleFactoryMgr(this.m_sServerKind);
            for (int i = 0; i < this.m_unmanagedServers.length; ++i) {
                this.m_oscaUnmanagedMgr.setMachPorts(this.m_unmanagedServers[i].getHostName(), this.m_unmanagedServers[i].getPort());
            }
            RASFactoryListenerImpl fac = new RASFactoryListenerImpl();
            this.m_oscaUnmanagedMgr.start(fac);
            BlockingDocumentConnectionRepositoryOperations docConnRepos = fac.getReposById(documentId.getId(), false);
            if (docConnRepos == null) {
                throw new RASConnectionException(3, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_INTERNAL, this.m_getConnection.getLocale()), "RASLIB9036", "RASConnection.init() getReposById returned null");
            }
            ConnectionHelperFactory connHelperFactory = new ConnectionHelperFactory(docConnRepos, this.m_getConnection, this.m_documentStream, initDocConn, this.m_serializerFactory);
            this.m_connServiceHelper = (ConnectionServiceHelper)connHelperFactory.makeHelper();
            try {
                this.m_docConnection = (BlockingDocumentConnectionOperations)this.m_connServiceHelper.getService(null, null, null, null);
            }
            catch (OCAFrameworkException except) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("init(): unmanaged, docID=" + this.m_getConnection.getDocumentId()), (Throwable)((Object)except));
                }
                if (except instanceof OCAFrameworkException.ServiceConnection) {
                    throw new RASConnectionException(2, except.getMessage(this.m_getConnection.getLocale()), "RASLIB9034", "RASConnection.init() " + except.getDetail(), (Throwable)((Object)except));
                }
                throw new RASConnectionException(3, except.getMessage(this.m_getConnection.getLocale()), "RASLIB9035", "RASConnection.init() " + except.getDetail(), (Throwable)((Object)except));
            }
        }
        String svckey = documentId.getId() + ":" + documentId.getIdType() + ":" + key + ":" + sLocale;
        ISecuritySession secSession = this.m_getConnection.getSecuritySession();
        String sUserURI = secSession == null ? "" : secSession.getUserURI();
        String sLogonToken = secSession == null ? "" : secSession.getLogonToken();
        ServerSpec serverSpec = new ServerSpec("", this.m_sServerKind, secSession.getAPSName());
        this.initServerSpec(serverSpec);
        ServerSpec serverSpecFinal = serverSpec;
        try {
            RepositoryHelperFactory reposHelperFactory = new RepositoryHelperFactory();
            IManagedService reposHandler = ServiceMgrFactory.getServiceMgr().getManagedService("", "BlockingDocumentConnectionRepository", serverSpecFinal, sUserURI, sLogonToken, reposHelperFactory);
            _BlockingDocumentConnectionRepositoryProxy docConnRepos = new _BlockingDocumentConnectionRepositoryProxy(reposHandler, i_configuration);
            ConnectionHelperFactory connHelperFactory = new ConnectionHelperFactory(docConnRepos, this.m_getConnection, this.m_documentStream, initDocConn, this.m_serializerFactory);
            IManagedService connHandler = ServiceMgrFactory.getServiceMgr().getManagedService(svckey, "BlockingDocumentConnectionRepository", serverSpecFinal, sUserURI, sLogonToken, connHelperFactory);
            this.m_docConnection = new _BlockingDocumentConnectionProxy(connHandler, i_configuration);
            this.m_connServiceHelper = (ConnectionServiceHelper)connHandler.getHelper();
        }
        catch (OCAFrameworkException except) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("init(): srv=" + serverSpecFinal + " docID=" + this.m_getConnection.getDocumentId()), (Throwable)((Object)except));
            }
            if (except instanceof OCAFrameworkException.ServiceConnection) {
                throw new RASConnectionException(2, except.getMessage(this.m_getConnection.getLocale()), "RASLIB9005", "RASConnection.init() " + except.getDetail(), (Throwable)((Object)except));
            }
            throw new RASConnectionException(3, except.getMessage(this.m_getConnection.getLocale()), "RASLIB9006", "RASConnection.init() " + except.getDetail(), (Throwable)((Object)except));
        }
        catch (StubHelperException except) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("init(): srv=" + serverSpecFinal + " docID=" + this.m_getConnection.getDocumentId()), (Throwable)except);
            }
            throw new RASConnectionException(except.getRealCause().getErrorCode(), except.getRealCause().getMessage(), except.getRealCause().getRootCause(), "RASConnection.init() " + except.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"EXIT: init()");
        }
    }

    private static class StubHelperException
    extends RuntimeException {
        private final RASConnectionException m_cause;

        public StubHelperException(RASConnectionException i_cause) {
            super(i_cause.getMessage());
            this.m_cause = i_cause;
        }

        public RASConnectionException getRealCause() {
            return this.m_cause;
        }
    }

    private static class RASConnectionInitService
    implements IRASConnectionInitService {
        private static final String CLASS_ID = "IS";
        private static final String SERVICE_IOR = "I";
        private BlockingDocumentConnection m_service;

        public RASConnectionInitService(BlockingDocumentConnection i_service) {
            this.m_service = i_service;
        }

        public RASConnectionInitService(RASConnectionInitService i_initService) {
            this.m_service = i_initService.m_service;
        }

        public RASConnectionInitService() {
        }

        public BlockingDocumentConnection getService() {
            return this.m_service;
        }

        public void serialize(IServerSerializer i_serializer) {
            i_serializer.setObjectName(CLASS_ID);
            ORB orb = ServiceMgrFactory.getServiceMgr().getORB();
            String sIOR = orb.object_to_string((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)this.m_service);
            i_serializer.setString(SERVICE_IOR, sIOR);
        }

        public void deserialize(IServerDeserializer i_deserializer, Locale i_locale) throws SerializationException {
            if (!i_deserializer.getObjectName().equals(CLASS_ID)) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"RASConnectionInitService.deserialize(): wrong class ID");
                }
                throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, i_locale, i_deserializer.getObjectName()), "RASLIB9025", "Wrong class ID");
            }
            String sIOR = i_deserializer.getString(SERVICE_IOR, i_locale);
            ORB orb = ServiceMgrFactory.getServiceMgr().getORB();
            this.m_service = BlockingDocumentConnectionHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)orb.string_to_object(sIOR));
            if (null == this.m_service) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"RASConnectionInitService.deserialize(): m_service is null");
                }
                throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, i_locale, SERVICE_IOR), "RASLIB9026", "Could not get service from IOR");
            }
        }
    }

    private static class ConnectionServiceHelper
    extends AbstractStubHelper
    implements IManagedService.IStubHelper {
        private static final ILogger LOG = LoggerManager.getLogger((Class)(class$com$crystaldecisions$sdk$occa$ras21$RASConnection$ConnectionServiceHelper == null ? (class$com$crystaldecisions$sdk$occa$ras21$RASConnection$ConnectionServiceHelper = RASConnection.class$("com.crystaldecisions.sdk.occa.ras21.RASConnection$ConnectionServiceHelper")) : class$com$crystaldecisions$sdk$occa$ras21$RASConnection$ConnectionServiceHelper));
        private final BlockingDocumentConnectionRepositoryOperations m_docConnRepos;
        private final GetConnection m_getConnection;
        private final InputStream m_documentStream;
        private final IServerSerializerFactory m_serializerFactory;
        private BlockingDocumentConnection m_service = null;
        private boolean m_bUseExistingService = false;

        public ConnectionServiceHelper(BlockingDocumentConnectionRepositoryOperations i_docConnRepos, GetConnection i_getConnection, InputStream i_documentStream, BlockingDocumentConnection i_initService, IServerSerializerFactory i_serializerFactory) {
            this.m_docConnRepos = i_docConnRepos;
            this.m_getConnection = i_getConnection;
            this.m_documentStream = i_documentStream;
            this.m_serializerFactory = i_serializerFactory;
            this.m_service = i_initService;
            this.m_bUseExistingService = null != this.m_service;
        }

        public BlockingDocumentConnection getCORBAService() {
            return this.m_service;
        }

        public Object narrow(com.crystaldecisions.thirdparty.org.omg.CORBA.Object object) {
            return BlockingDocumentConnectionHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)object);
        }

        public void release(Object object) {
            BlockingDocumentConnectionOperations bdc = (BlockingDocumentConnectionOperations)object;
            bdc.free();
        }

        public com.crystaldecisions.thirdparty.org.omg.CORBA.Object getService(String svc, ServerSpec spec, String uri, String token) throws OCAFrameworkException {
            if (this.m_bUseExistingService && null != this.m_service) {
                this.m_bUseExistingService = false;
                return this.m_service;
            }
            IServerSerializer szer = this.m_serializerFactory.createSerializer();
            this.m_getConnection.serializeForServer(szer);
            String sGetConnection = szer.getSerializedString();
            if (null == this.m_docConnRepos) {
                String sMessage = "m_docConnRepos is null";
                LOG.assertTrue(false, "m_docConnRepos is null");
                throw new StubHelperException(new RASConnectionException(3, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_INTERNAL, this.m_getConnection.getLocale()), "RASLIB9033", "m_docConnRepos is null"));
            }
            try {
                BlockingDocumentConnectionHolder connHolder = new BlockingDocumentConnectionHolder();
                byte[] documentContents = null;
                if (null != this.m_documentStream) {
                    documentContents = this.getBytesFromStream(this.m_getConnection.getLocale(), this.m_documentStream);
                }
                if (null == documentContents) {
                    documentContents = new byte[]{};
                }
                this.m_docConnRepos.getBlockingDocumentConnection(sGetConnection, documentContents, connHolder);
                this.m_service = connHolder.value;
            }
            catch (RASConnectionException except) {
                throw new StubHelperException(except);
            }
            catch (oca_abuse except) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"ConnectionServiceHelper.getService(): ", (Throwable)except);
                }
                SDKException sdkExcept = SDKException.map(except);
                throw new StubHelperException(new RASConnectionException(3, sdkExcept.getMessage(this.m_getConnection.getLocale()), "RASLIB9002", except.getMessage()));
            }
            return this.m_service;
        }

        public boolean isRecoverable(Throwable t) {
            if (super.isRecoverable(t)) {
                return true;
            }
            if (t instanceof oca_abuse) {
                oca_abuse e = (oca_abuse)t;
                if (e.errCode == 2) {
                    return true;
                }
            }
            return false;
        }

        public boolean isStateful() {
            return false;
        }

        private byte[] getBytesFromStream(Locale i_locale, InputStream i_documentStream) throws RASConnectionException {
            byte[] retByteArray;
            try {
                BufferedInputStream bin = new BufferedInputStream(i_documentStream);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                boolean bDone = false;
                while (!bDone) {
                    int nNumToRead = Math.max(bin.available(), 1);
                    byte[] buf = new byte[nNumToRead];
                    int nNumRead = bin.read(buf, 0, nNumToRead);
                    if (nNumRead < 0) {
                        bDone = true;
                        continue;
                    }
                    bout.write(buf);
                }
                retByteArray = bout.toByteArray();
            }
            catch (IOException except) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"ConnectionServiceHelper.getBytesFromStream(): ", (Throwable)except);
                }
                throw new RASConnectionException(3, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_READ_DOCUMENT_FAILURE, i_locale), "RASLIB9003", "Could not read document file: " + except.getMessage(), except);
            }
            return retByteArray;
        }
    }

    private static class ConnectionHelperFactory
    implements IManagedService.IHelperFactory {
        private final BlockingDocumentConnectionRepositoryOperations m_docConnRepos;
        private final GetConnection m_getConnection;
        private final InputStream m_documentStream;
        private final BlockingDocumentConnection m_initService;
        private final IServerSerializerFactory m_serializerFactory;

        public ConnectionHelperFactory(BlockingDocumentConnectionRepositoryOperations i_docConnRepos, GetConnection i_getConnection, InputStream i_documentStream, BlockingDocumentConnection i_initService, IServerSerializerFactory i_serializerFactory) {
            this.m_docConnRepos = i_docConnRepos;
            this.m_getConnection = i_getConnection;
            this.m_documentStream = i_documentStream;
            this.m_initService = i_initService;
            this.m_serializerFactory = i_serializerFactory;
        }

        public IManagedService.IStubHelper makeHelper() {
            return new ConnectionServiceHelper(this.m_docConnRepos, this.m_getConnection, this.m_documentStream, this.m_initService, this.m_serializerFactory);
        }
    }

    private static class RepositoryServiceHelper
    extends AbstractStubHelper
    implements IManagedService.IStubHelper {
        private static final ILogger LOG = LoggerManager.getLogger((Class)(class$com$crystaldecisions$sdk$occa$ras21$RASConnection$RepositoryServiceHelper == null ? (class$com$crystaldecisions$sdk$occa$ras21$RASConnection$RepositoryServiceHelper = RASConnection.class$("com.crystaldecisions.sdk.occa.ras21.RASConnection$RepositoryServiceHelper")) : class$com$crystaldecisions$sdk$occa$ras21$RASConnection$RepositoryServiceHelper));

        private RepositoryServiceHelper() {
        }

        public Object narrow(com.crystaldecisions.thirdparty.org.omg.CORBA.Object object) {
            return BlockingDocumentConnectionRepositoryHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)object);
        }

        public void release(Object object) {
            BlockingDocumentConnectionRepositoryOperations bdcr = (BlockingDocumentConnectionRepositoryOperations)object;
            bdcr.free();
        }

        public com.crystaldecisions.thirdparty.org.omg.CORBA.Object getService(String svc, ServerSpec spec, String uri, String token) throws OCAFrameworkException {
            return super.getService(svc, spec, uri, token);
        }

        public boolean isRecoverable(Throwable t) {
            if (super.isRecoverable(t)) {
                return true;
            }
            if (t instanceof oca_abuse) {
                oca_abuse e = (oca_abuse)t;
                if (e.errCode == 2) {
                    return true;
                }
            }
            return false;
        }

        public boolean isStateful() {
            return false;
        }
    }

    private static class RepositoryHelperFactory
    implements IManagedService.IHelperFactory {
        private RepositoryHelperFactory() {
        }

        public IManagedService.IStubHelper makeHelper() {
            return new RepositoryServiceHelper();
        }
    }
}

