/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.ras21;

public class RASException
extends Exception {
    public static final int ErrorInternal = 0;
    public static final int ErrorTimeout = 1;
    public static final int ErrorTryAgain = 2;
    public static final int ErrorFailure = 3;
    private int m_errorCode;
    private String m_rootCause;
    private String m_debugMessage;

    public RASException(int nErrorCode, String message, String rootCause, String debugMessage) {
        super(message);
        this.m_errorCode = nErrorCode;
        this.m_rootCause = rootCause;
        this.m_debugMessage = debugMessage;
    }

    public RASException(int nErrorCode, String message, String rootCause, String debugMessage, Throwable cause) {
        super(message, cause);
        this.m_errorCode = nErrorCode;
        this.m_rootCause = rootCause;
        this.m_debugMessage = debugMessage;
    }

    public String getRootCause() {
        return this.m_rootCause;
    }

    public String getDebugString() {
        return this.m_debugMessage;
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }

    private String errorCodeAsString() {
        switch (this.m_errorCode) {
            case 0: {
                return "ErrorInternal";
            }
            case 1: {
                return "ErrorTimeout";
            }
            case 3: {
                return "ErrorFailure";
            }
            case 2: {
                return "ErrorTryAgain";
            }
        }
        return "Unknown ErrorCode";
    }

    public String toDebugString() {
        String returnString = this.errorCodeAsString() + "\n";
        for (Throwable current = this; current != null; current = current.getCause()) {
            if (current instanceof RASException) {
                RASException ex = current;
                returnString = returnString + ex.getMessage() + " [" + ex.getRootCause() + "] Debug: " + ex.getDebugString() + "\n";
                continue;
            }
            returnString = returnString + ((Throwable)current).toString();
        }
        return returnString;
    }

    public String toString() {
        return this.errorCodeAsString() + "\n" + this.getMessage() + " [" + this.getRootCause() + "]\n";
    }
}

