/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.ras21;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.collections.CaseInsensHashMap;
import com.crystaldecisions.enterprise.ocaframework.IOSCASimpleFactoryMgrListener;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactoryPackage.connection_failure;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAras21.BlockingDocumentConnectionRepository;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAras21.BlockingDocumentConnectionRepositoryHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAras21.BlockingDocumentConnectionRepositoryOperations;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class RASFactoryListenerImpl
implements IOSCASimpleFactoryMgrListener {
    private static final ILogger LOG = LoggerManager.getLogger((Class)RASFactoryListenerImpl.class);
    private Map m_mapSvr = Collections.synchronizedMap(new CaseInsensHashMap());
    private Map m_mapRepos = Collections.synchronizedMap(new HashMap());

    private static int addUnsigned(int a, int b) {
        int ret = a + b;
        if (ret < 0) {
            ret = Math.abs(Integer.MIN_VALUE - ret);
        }
        return ret;
    }

    public RASFactoryListenerImpl() {
        new Thread(new ReposCleanupThread(this)).start();
    }

    private BlockingDocumentConnectionRepositoryOperations callNewServiceOnServer(OSCAFactory i_facServer) {
        BlockingDocumentConnectionRepository repos = null;
        try {
            com.crystaldecisions.thirdparty.org.omg.CORBA.Object obj = i_facServer.newService("BlockingDocumentConnectionRepository", "");
            repos = BlockingDocumentConnectionRepositoryHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)obj);
        }
        catch (connection_failure e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"RASFactoryListenerImpl.callNewServiceOnServer ", (Throwable)e);
            }
            repos = null;
        }
        catch (SystemException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"RASFactoryListenerImpl.callNewServiceOnServer ", (Throwable)e);
            }
            repos = null;
        }
        return repos;
    }

    public synchronized boolean update(String i_serverName, OSCAFactory i_facServer, IOSCASimpleFactoryMgrListener.ServerState i_svrState) {
        if (i_svrState == IOSCASimpleFactoryMgrListener.ServerState.ServerStateUp) {
            BlockingDocumentConnectionRepositoryOperations reposProxy = this.callNewServiceOnServer(i_facServer);
            if (reposProxy != null) {
                this.m_mapSvr.put(i_serverName, reposProxy);
            }
        } else if (i_svrState == IOSCASimpleFactoryMgrListener.ServerState.ServerStateDown) {
            this.m_mapSvr.remove(i_serverName);
        }
        return true;
    }

    public synchronized BlockingDocumentConnectionRepositoryOperations getReposById(String s_docName, boolean i_bForceFailover) {
        int roundRobinGranularity = 10;
        int nServers = this.m_mapSvr.size();
        if (nServers == 0) {
            return null;
        }
        int iHashCode = s_docName.hashCode();
        ReposEntry reposEnt = (ReposEntry)this.m_mapRepos.get(new Integer(iHashCode));
        if (reposEnt == null) {
            reposEnt = new ReposEntry();
            reposEnt.m_lastAccess = new Date();
            reposEnt.m_numAccess = 1;
            this.m_mapRepos.put(new Integer(iHashCode), reposEnt);
        } else {
            reposEnt.m_lastAccess = new Date();
            reposEnt.m_numAccess = i_bForceFailover ? RASFactoryListenerImpl.addUnsigned(reposEnt.m_numAccess, 10) : RASFactoryListenerImpl.addUnsigned(reposEnt.m_numAccess, 1);
        }
        int serverIdx = (iHashCode + reposEnt.m_numAccess / 10) % nServers;
        BlockingDocumentConnectionRepositoryOperations[] arrRepos = new BlockingDocumentConnectionRepositoryOperations[this.m_mapSvr.size()];
        arrRepos = this.m_mapSvr.values().toArray(arrRepos);
        if (arrRepos == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"RASFactoryListenerImpl.getReposById() found null BlockingDocumentConnectionRepositoryOperations");
            }
            return null;
        }
        return arrRepos[serverIdx];
    }

    public synchronized void cleanupOldRepos() {
        int nNumExempt = 100;
        long maxTimeInReposMap = 86400000L;
        long now = new Date().getTime();
        if (this.m_mapRepos.size() > 100) {
            class QueueEntry
            implements Comparable {
                public long timeSinceLastAccess = 0L;
                public int hashCode = 0;

                QueueEntry() {
                }

                public int compareTo(Object o) {
                    long thisVal = this.timeSinceLastAccess;
                    long anotherVal = ((QueueEntry)o).timeSinceLastAccess;
                    return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
                }
            }
            LinkedList<QueueEntry> lQueueEntry = new LinkedList<QueueEntry>();
            Iterator iter = this.m_mapRepos.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry mapEnt = iter.next();
                Integer iHashCode = (Integer)mapEnt.getValue();
                ReposEntry reposEnt = (ReposEntry)mapEnt.getValue();
                long diff = now - reposEnt.m_lastAccess.getTime();
                if (diff < 86400000L) continue;
                QueueEntry qe = new QueueEntry();
                qe.timeSinceLastAccess = diff;
                qe.hashCode = iHashCode;
                lQueueEntry.add(qe);
            }
            Object[] arrQE = (QueueEntry[])lQueueEntry.toArray();
            Arrays.sort(arrQE);
            int arrLength = arrQE.length;
            int numToRemove = arrLength - 100;
            if (numToRemove > 0) {
                for (int i = arrLength - numToRemove; i < arrLength; ++i) {
                    this.m_mapRepos.remove(new Integer(((QueueEntry)arrQE[i]).hashCode));
                }
            }
        }
    }

    public synchronized int getNumberAvailable() {
        return this.m_mapSvr.size();
    }

    class ReposCleanupThread
    implements Runnable {
        private WeakReference m_weakRefFacListener;

        public ReposCleanupThread(RASFactoryListenerImpl i_facListener) {
            this.m_weakRefFacListener = new WeakReference<RASFactoryListenerImpl>(i_facListener);
        }

        public void run() {
            while (true) {
                long sleepMs = 3600000L;
                try {
                    Thread.sleep(3600000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                RASFactoryListenerImpl facListener = (RASFactoryListenerImpl)this.m_weakRefFacListener.get();
                if (facListener == null) break;
                facListener.cleanupOldRepos();
            }
        }
    }

    class ReposEntry {
        public Date m_lastAccess;
        public int m_numAccess;

        ReposEntry() {
        }
    }
}

