/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.ras21.serialization.oburl;

import com.crystaldecisions.sdk.occa.ras21.serialization.IServerDeserializerFactory;
import com.crystaldecisions.sdk.occa.ras21.serialization.ObjectDeserializer;
import com.crystaldecisions.sdk.occa.ras21.serialization.SerializationException;
import com.crystaldecisions.sdk.occa.ras21.serialization.oburl.URLDecoder;
import com.crystaldecisions.sdk.occa.ras21.serialization.oburl.URLUnpacker;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class URLServerDeserializer
extends ObjectDeserializer {
    private Map m_propMap = new HashMap();
    private String m_className;

    public URLServerDeserializer(IServerDeserializerFactory i_factory) {
        super(i_factory);
    }

    public Set getNames() {
        return this.m_propMap.keySet();
    }

    public String getString(String sName, Locale locale) throws SerializationException {
        Object o = this.m_propMap.get(sName);
        return (String)o;
    }

    public int getInteger(String sName, Locale locale) throws SerializationException {
        Object o = this.m_propMap.get(sName);
        return Integer.parseInt((String)o);
    }

    public boolean getBoolean(String sName, Locale locale) throws SerializationException {
        Object o = this.m_propMap.get(sName);
        return Integer.parseInt((String)o) != 0;
    }

    public String getObjectName() {
        return this.m_className;
    }

    public String[] getStringArray(String sName, Locale locale) throws SerializationException {
        int endIndex;
        String valuePairs = (String)this.m_propMap.get(sName);
        if (valuePairs == null) {
            return null;
        }
        if (valuePairs.length() == 0) {
            return new String[0];
        }
        int nValues = 1;
        int valueN = 0;
        int beginIndex = 0;
        while ((endIndex = valuePairs.indexOf(38, beginIndex)) >= 0) {
            beginIndex = endIndex + 1;
            ++nValues;
        }
        String[] list = new String[nValues];
        beginIndex = 0;
        String temp2 = null;
        while ((endIndex = valuePairs.indexOf(38, beginIndex)) >= 0 && valueN < nValues) {
            temp2 = valuePairs.substring(beginIndex, endIndex);
            beginIndex = endIndex + 1;
            try {
                list[valueN] = URLDecoder.decode(temp2.substring(temp2.indexOf(61) + 1));
            }
            catch (Throwable e) {
                // empty catch block
            }
            ++valueN;
        }
        temp2 = valuePairs.substring(beginIndex);
        try {
            list[valueN] = URLDecoder.decode(temp2.substring(temp2.indexOf(61) + 1));
        }
        catch (Throwable e) {
            // empty catch block
        }
        return list;
    }

    public void initFromSerializedString(String sSerialized, Locale locale) throws SerializationException {
        URLUnpacker unpacker = new URLUnpacker();
        String temp = sSerialized;
        int nQMarkIndex = temp.lastIndexOf(63);
        String queryString = nQMarkIndex > 0 ? temp.substring(temp.lastIndexOf(63) + 1) : "";
        this.m_className = nQMarkIndex > 0 ? temp.substring(0, nQMarkIndex) : temp;
        unpacker.initialize(queryString);
        while (unpacker.hasNext()) {
            URLUnpacker.Output out = unpacker.next();
            this.m_propMap.put(out.m_id, out.m_value);
        }
    }
}

