/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.ras21.serialization.oburl;

import com.crystaldecisions.sdk.occa.ras21.serialization.IServerSerializerFactory;
import com.crystaldecisions.sdk.occa.ras21.serialization.ObjectSerializer;
import com.crystaldecisions.sdk.occa.ras21.serialization.oburl.URLEncodingWriter;
import java.io.IOException;
import java.io.StringWriter;

public class URLServerSerializer
extends ObjectSerializer {
    private StringWriter m_sw = new StringWriter();
    private URLEncodingWriter m_uw = new URLEncodingWriter(this.m_sw);
    private String m_classname;
    private boolean m_bInitialPair = true;

    public URLServerSerializer(IServerSerializerFactory i_factory) {
        super(i_factory);
    }

    public void setString(String sName, String sValue) {
        try {
            if (sValue == null) {
                sValue = new String();
            }
            if (this.m_bInitialPair) {
                this.m_bInitialPair = false;
            } else {
                this.m_sw.write("&");
            }
            this.m_uw.write(sName);
            this.m_sw.write("=");
            this.m_uw.write(sValue);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setInteger(String sName, int nValue) {
        try {
            if (this.m_bInitialPair) {
                this.m_bInitialPair = false;
            } else {
                this.m_sw.write("&");
            }
            this.m_uw.write(sName);
            this.m_sw.write("=");
            this.m_uw.write(new Integer(nValue).toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setBoolean(String sName, boolean bValue) {
        try {
            if (this.m_bInitialPair) {
                this.m_bInitialPair = false;
            } else {
                this.m_sw.write("&");
            }
            this.m_uw.write(sName);
            this.m_sw.write("=");
            if (bValue) {
                this.m_uw.write("1");
            } else {
                this.m_uw.write("0");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setObjectName(String name) {
        this.m_classname = name;
    }

    public String getSerializedString() {
        String temp = this.m_classname + "?" + this.m_sw.toString();
        return temp;
    }
}

