/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.ras21.serialization.oburl;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.occa.ras21.serialization.oburl.URLDecoder;

public class URLUnpacker {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.managedreports.ps.internal.URLUnpacker");
    private String m_url;
    private int m_offset;
    private char m_delimiter;

    public URLUnpacker() {
        this.m_url = null;
        this.m_delimiter = (char)38;
    }

    public URLUnpacker(char delimiter) {
        this.m_delimiter = delimiter;
    }

    public void initialize(String url) {
        this.m_url = url;
        this.m_offset = 0;
    }

    public URLUnpacker getNestedUnpacker() {
        return this;
    }

    public boolean hasNext() {
        LOG.assertNotNull((Object)this.m_url, "m_url is null.");
        return this.m_offset < this.m_url.length();
    }

    public Output next() {
        if (this.hasNext()) {
            int eq = this.m_url.indexOf(61, this.m_offset);
            LOG.assertTrue(eq != -1, "next(): must have non-empty name");
            int amp = this.m_url.indexOf(this.m_delimiter, eq);
            if (amp == -1) {
                amp = this.m_url.length();
            }
            String name = this.m_url.substring(this.m_offset, eq);
            String valueStr = null;
            try {
                valueStr = URLDecoder.decode(this.m_url.substring(eq + 1, amp));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.m_offset = amp + 1;
            return new Output(name, valueStr, 0);
        }
        return null;
    }

    public void remove() {
    }

    public static class Output {
        public String m_id;
        public Object m_value;
        public int m_flags;

        private Output() {
        }

        public Output(String id, Object value, int flags) {
            this.m_id = id;
            this.m_value = value;
            this.m_flags = flags;
        }
    }
}

