/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.security.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.SessionBatchExOperations;
import com.crystaldecisions.sdk.exception.SDKException;
import java.util.ArrayList;
import java.util.List;

class BatchHelper {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.security.internal.BatchHelper");
    private List m_input;
    private List m_output;
    private SessionBatchExOperations m_batchStub;
    private boolean m_isActive;
    private BatchOutputListener m_listener;
    private BatchInputProcessor m_processor;

    BatchHelper(SessionBatchExOperations batchStub, BatchInputProcessor processor, BatchOutputListener listener) throws SDKException {
        if (processor == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The batch input processor cannot be null");
            }
            throw new SDKException.InvalidArg();
        }
        this.m_processor = processor;
        this.m_input = new ArrayList();
        this.m_batchStub = batchStub;
        this.m_listener = listener;
    }

    public int submit(Object chunk) throws SDKException {
        this.m_input.add(chunk);
        if (!this.m_isActive) {
            this.process();
            return 0;
        }
        return 2;
    }

    public void clear() {
        this.m_input.clear();
        this.m_isActive = false;
    }

    public List input() {
        return this.m_input;
    }

    public boolean isActive() {
        return this.m_isActive;
    }

    public List output() {
        return this.m_output;
    }

    public void process() throws SDKException {
        if (this.m_processor == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The batch input processor cannot be null");
            }
            throw new SDKException.InvalidArg();
        }
        if (this.m_input.size() > 0) {
            this.m_output = this.m_processor.batchProcess(this);
            if (this.m_listener != null) {
                this.m_listener.batchOutput(this);
            }
            this.clear();
        }
        this.m_isActive = false;
    }

    public void setActive(boolean active) {
        this.m_isActive = active;
    }

    static interface BatchOutputListener {
        public void batchOutput(BatchHelper var1) throws SDKException;
    }

    static interface BatchInputProcessor {
        public List batchProcess(BatchHelper var1) throws SDKException;
    }
}

