/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.security.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.collections.ArraysHelper;
import com.crystaldecisions.enterprise.ocaframework.IManagedService;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.AdmLoadCacheBoolOutStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.AdmLoadCacheDWordOutStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.AdmLoadCacheExplicitBoolOutStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.AdmLoadCacheExplicitBoolSeqElem;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.AdmLoadCacheExplicitDWordOutStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.AdmLoadCacheExplicitDWordSeqElem;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.AdmLoadCacheExplicitInStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.AdmLoadCacheInStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.AdmLoadCacheStringOutStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.AdmRightInfoOutStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.BatchInChunk;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.BatchOutChunk;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.BatchOutStreamHolder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.CallFailureOutStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.GrantRightBoolInStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.GrantRightDWordInStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.GrantRightStringInStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.LoadCacheBoolOutStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.LoadCacheDWordOutStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.LoadCacheInStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.LoadCacheStringOutStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.PrincipalsInStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.PrincipalsOutStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.ProgIdsWithCustomRightsInStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.ProgIdsWithCustomRightsOutStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.RemoveRightInStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.BatchPackage.RightInfoOutStruct;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.SessionBatchExOperations;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.holder.internal.ArrayHolder;
import com.crystaldecisions.sdk.holder.internal.BooleanHolder;
import com.crystaldecisions.sdk.holder.internal.IntHolder;
import com.crystaldecisions.sdk.occa.infostore.ISecurityLimit;
import com.crystaldecisions.sdk.occa.infostore.ISecurityRight;
import com.crystaldecisions.sdk.occa.security.IBatch;
import com.crystaldecisions.sdk.occa.security.internal.BatchHelper;
import com.crystaldecisions.sdk.occa.security.internal.ICacheController;
import com.crystaldecisions.sdk.occa.security.internal.ICacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.internal.IPrincipal;
import com.crystaldecisions.sdk.occa.security.internal.IRights;
import com.crystaldecisions.sdk.occa.security.internal.IRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.Principal;
import com.crystaldecisions.sdk.occa.security.internal.SecurityException;
import com.crystaldecisions.sdk.occa.security.internal._SessionBatchExProxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

class CacheController
implements IBatch,
ICacheControllerAdmin,
ICacheController,
IRights,
IRightsAdmin,
BatchHelper.BatchInputProcessor,
BatchHelper.BatchOutputListener {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.security.internal.CacheController");
    protected static final long MAX_CACHE_AGE = 60000L;
    private IManagedService m_handler;
    private SessionBatchExOperations m_batchStub;
    private BatchHelper m_checkHelper;
    private Map m_tl_loadBatchHelper;
    private Map m_map;
    private boolean m_useCache = false;
    private int m_epoch;
    private static final int EXPLICIT_RIGHTS_ID = 1;

    private CacheController() {
    }

    CacheController(IManagedService handler) throws SDKException {
        this.m_handler = handler;
        this.m_batchStub = new _SessionBatchExProxy(this.m_handler);
        this.m_checkHelper = new BatchHelper(this.m_batchStub, this, this);
        this.m_map = new Hashtable();
        this.m_tl_loadBatchHelper = new WeakHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BatchHelper getLoadHelper() throws SDKException {
        Map helperMap;
        Map map = helperMap = this.m_tl_loadBatchHelper;
        synchronized (map) {
            BatchHelper loadHelper = (BatchHelper)helperMap.get(Thread.currentThread());
            if (loadHelper == null) {
                loadHelper = new BatchHelper(this.m_batchStub, this, this);
                helperMap.put(Thread.currentThread(), loadHelper);
            }
            return loadHelper;
        }
    }

    public synchronized int batch() throws SDKException {
        return this.batch(false);
    }

    public synchronized int batch(boolean useCache) throws SDKException {
        BatchHelper loadHelper = this.getLoadHelper();
        if (loadHelper.isActive()) {
            throw new SecurityException.BatchState();
        }
        loadHelper.setActive(true);
        this.m_useCache = useCache;
        return 0;
    }

    public synchronized int commit() throws SDKException {
        BatchHelper loadHelper = this.getLoadHelper();
        if (!loadHelper.isActive()) {
            throw new SecurityException.BatchState();
        }
        loadHelper.process();
        this.m_useCache = false;
        return 0;
    }

    public synchronized int rollback() throws SDKException {
        BatchHelper loadHelper = this.getLoadHelper();
        if (!loadHelper.isActive()) {
            throw new SecurityException.BatchState();
        }
        loadHelper.clear();
        this.m_useCache = false;
        return 0;
    }

    public synchronized void cacheBool(int dwRightID, String szObjectID, String szObjectType) throws SDKException {
        CacheKey key;
        CacheEntry entry;
        if (this.m_useCache && (entry = (CacheEntry)this.m_map.get(key = new CacheKey(dwRightID, szObjectID, szObjectType))) != null && this.isDataStillValid(entry)) {
            return;
        }
        BatchInChunk chunk = new BatchInChunk();
        chunk.LoadCacheBool(new LoadCacheInStruct(dwRightID, szObjectID, szObjectType));
        this.getLoadHelper().submit(chunk);
    }

    public synchronized void cacheLong(int dwRightID, String szObjectID, String szObjectType) throws SDKException {
        CacheKey key;
        CacheEntry entry;
        if (this.m_useCache && (entry = (CacheEntry)this.m_map.get(key = new CacheKey(dwRightID, szObjectID, szObjectType))) != null && this.isDataStillValid(entry)) {
            return;
        }
        BatchInChunk chunk = new BatchInChunk();
        chunk.LoadCacheDWord(new LoadCacheInStruct(dwRightID, szObjectID, szObjectType));
        this.getLoadHelper().submit(chunk);
    }

    public synchronized void cacheString(int dwRightID, String szObjectID, String szObjectType) throws SDKException {
        CacheKey key;
        CacheEntry entry;
        if (this.m_useCache && (entry = (CacheEntry)this.m_map.get(key = new CacheKey(dwRightID, szObjectID, szObjectType))) != null && this.isDataStillValid(entry)) {
            return;
        }
        BatchInChunk chunk = new BatchInChunk();
        chunk.LoadCacheString(new LoadCacheInStruct(dwRightID, szObjectID, szObjectType));
        this.getLoadHelper().submit(chunk);
    }

    public synchronized void cacheBool(int dwRightID, String szGroupID, String szObjectID, String szObjectType) throws SDKException {
        BatchInChunk chunk = new BatchInChunk();
        chunk.AdmLoadCacheBool(new AdmLoadCacheInStruct(dwRightID, szGroupID, szObjectID, szObjectType));
        this.getLoadHelper().submit(chunk);
    }

    public synchronized void cacheLong(int dwRightID, String szGroupID, String szObjectID, String szObjectType) throws SDKException {
        BatchInChunk chunk = new BatchInChunk();
        chunk.AdmLoadCacheDWord(new AdmLoadCacheInStruct(dwRightID, szGroupID, szObjectID, szObjectType));
        this.getLoadHelper().submit(chunk);
    }

    public synchronized void cachePrincipals(String ObjectID, String ObjectType) throws SDKException {
        BatchInChunk chunk = new BatchInChunk();
        chunk.GetPrincipals(new PrincipalsInStruct(ObjectID, ObjectType));
        this.getLoadHelper().submit(chunk);
    }

    public synchronized void cacheExplicitPrincipalsAndRights(String objectID) throws SDKException {
        BatchInChunk chunk = new BatchInChunk();
        chunk.AdmLoadCacheExplicitBool(new AdmLoadCacheExplicitInStruct(objectID));
        this.getLoadHelper().submit(chunk);
        chunk = new BatchInChunk();
        chunk.AdmLoadCacheExplicitDWord(new AdmLoadCacheExplicitInStruct(objectID));
        this.getLoadHelper().submit(chunk);
    }

    public synchronized void cacheString(int dwRightID, String szGroupID, String szObjectID, String szObjectType) throws SDKException {
        BatchInChunk chunk = new BatchInChunk();
        chunk.AdmLoadCacheString(new AdmLoadCacheInStruct(dwRightID, szGroupID, szObjectID, szObjectType));
        this.getLoadHelper().submit(chunk);
    }

    public synchronized int checkBool(int right, String objectID, String objectType) throws SDKException {
        CacheKey key = new CacheKey(right, objectID, objectType);
        CacheEntry entry = (CacheEntry)this.m_map.get(key);
        if (entry == null) {
            BatchInChunk chunk = new BatchInChunk();
            chunk.LoadCacheBool(new LoadCacheInStruct(right, objectID, objectType));
            this.m_checkHelper.submit(chunk);
            entry = (CacheEntry)this.m_map.get(key);
            LOG.assertNotNull((Object)entry, "entry is null.");
        }
        entry.touchTimeStamp();
        if (entry instanceof NoEntry) {
            return 4;
        }
        if (((BooleanEntry)entry).getValue()) {
            return 2;
        }
        return 3;
    }

    public synchronized int checkLong(int right, String objectID, String objectType, IntHolder min, IntHolder max) throws SDKException {
        CacheKey key = new CacheKey(right, objectID, objectType);
        CacheEntry entry = (CacheEntry)this.m_map.get(key);
        if (entry == null) {
            BatchInChunk chunk = new BatchInChunk();
            chunk.LoadCacheDWord(new LoadCacheInStruct(right, objectID, objectType));
            this.m_checkHelper.submit(chunk);
            entry = (CacheEntry)this.m_map.get(key);
            LOG.assertNotNull((Object)entry, "entry is null.");
        }
        entry.touchTimeStamp();
        if (entry instanceof NoEntry) {
            return 4;
        }
        DWordEntry dwe = (DWordEntry)entry;
        min.set(dwe.getMinValue());
        max.set(dwe.getMaxValue());
        return 0;
    }

    public synchronized int checkString(int right, String objectID, String objectType, ArrayHolder out) throws SDKException {
        CacheKey key = new CacheKey(right, objectID, objectType);
        CacheEntry entry = (CacheEntry)this.m_map.get(key);
        if (entry == null) {
            BatchInChunk chunk = new BatchInChunk();
            chunk.LoadCacheString(new LoadCacheInStruct(right, objectID, objectType));
            this.m_checkHelper.submit(chunk);
            entry = (CacheEntry)this.m_map.get(key);
            LOG.assertNotNull((Object)entry, "entry is null.");
        }
        entry.touchTimeStamp();
        if (entry instanceof NoEntry) {
            return 4;
        }
        out.set(((StringEntry)entry).getValue());
        return 0;
    }

    public synchronized int checkBool(int right, String groupID, String objectID, String objectType, int aggregationMode) throws SDKException {
        int adjustedAggMode;
        CacheKey key = new CacheKey(right, groupID, objectID, objectType, false, false);
        CacheEntry entry = (CacheEntry)this.m_map.get(key);
        if (entry == null) {
            BatchInChunk chunk = new BatchInChunk();
            chunk.AdmLoadCacheBool(new AdmLoadCacheInStruct(right, groupID, objectID, objectType));
            this.m_checkHelper.submit(chunk);
            entry = (CacheEntry)this.m_map.get(key);
            LOG.assertNotNull((Object)entry, "entry is null.");
        }
        if ((entry = this.getAggregatedEntry(key, adjustedAggMode = this.AdjustEffectiveAggMode(key, aggregationMode))) == null) {
            return 4;
        }
        if (((BooleanEntry)entry).getValue()) {
            return 2;
        }
        return 3;
    }

    public synchronized int checkLong(int right, String groupID, String objectID, String objectType, int aggregationMode, IntHolder min, IntHolder max) throws SDKException {
        CacheKey key = new CacheKey(right, groupID, objectID, objectType, false, false);
        CacheEntry entry = (CacheEntry)this.m_map.get(key);
        if (entry == null) {
            BatchInChunk chunk = new BatchInChunk();
            chunk.AdmLoadCacheDWord(new AdmLoadCacheInStruct(right, groupID, objectID, objectType));
            this.m_checkHelper.submit(chunk);
            entry = (CacheEntry)this.m_map.get(key);
            LOG.assertNotNull((Object)entry, "entry is null.");
        }
        if ((entry = this.getAggregatedEntry(key, aggregationMode)) == null) {
            return 4;
        }
        DWordEntry dwe = (DWordEntry)entry;
        min.set(dwe.getMinValue());
        max.set(dwe.getMaxValue());
        return 0;
    }

    public synchronized int checkString(int right, String groupID, String objectID, String objectType, int aggregationMode, ArrayHolder out) throws SDKException {
        CacheKey key = new CacheKey(right, groupID, objectID, objectType, false, false);
        CacheEntry entry = (CacheEntry)this.m_map.get(key);
        if (entry == null) {
            BatchInChunk chunk = new BatchInChunk();
            chunk.AdmLoadCacheDWord(new AdmLoadCacheInStruct(right, groupID, objectID, objectType));
            this.m_checkHelper.submit(chunk);
            entry = (CacheEntry)this.m_map.get(key);
            LOG.assertNotNull((Object)entry, "entry is null.");
        }
        if ((entry = this.getAggregatedEntry(key, aggregationMode)) == null) {
            return 4;
        }
        out.set(((StringEntry)entry).getValue());
        return 0;
    }

    public synchronized int getPrincipals(String objectID, String objectType, ArrayHolder out) throws SDKException {
        CacheKey key = new CacheKey(objectID, objectType);
        CacheEntry entry = (CacheEntry)this.m_map.get(key);
        if (entry == null) {
            BatchInChunk chunk = new BatchInChunk();
            chunk.GetPrincipals(new PrincipalsInStruct(objectID, objectType));
            this.m_checkHelper.submit(chunk);
            entry = (CacheEntry)this.m_map.get(key);
            LOG.assertNotNull((Object)entry, "entry is null.");
        }
        entry.touchTimeStamp();
        if (entry instanceof NoEntry) {
            return 4;
        }
        out.set(((PrincipalsEntry)entry).getValue());
        return 0;
    }

    public synchronized int getExplicitPrincipals(String objectID, ArrayHolder out) throws SDKException {
        CacheKey key = new CacheKey(objectID, 1);
        CacheEntry entry = (CacheEntry)this.m_map.get(key);
        if (entry == null) {
            this.batch();
            try {
                BatchHelper loadHelper = this.getLoadHelper();
                BatchInChunk chunk = new BatchInChunk();
                chunk.AdmLoadCacheExplicitBool(new AdmLoadCacheExplicitInStruct(objectID));
                loadHelper.submit(chunk);
                chunk = new BatchInChunk();
                chunk.AdmLoadCacheExplicitDWord(new AdmLoadCacheExplicitInStruct(objectID));
                loadHelper.submit(chunk);
                this.commit();
            }
            catch (SDKException e) {
                this.rollback();
                throw e;
            }
            catch (Throwable e) {
                this.rollback();
                SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
                throw sdke;
            }
            entry = (CacheEntry)this.m_map.get(key);
            LOG.assertNotNull((Object)entry, "entry is null.");
        }
        entry.touchTimeStamp();
        if (entry instanceof NoEntry) {
            return 4;
        }
        out.set(((ExplicitPrincipalsEntry)entry).getValue());
        return 0;
    }

    public synchronized int remove(int right, String groupID, String objectID, String objectType) throws SDKException {
        BatchInChunk chunk = new BatchInChunk();
        chunk.RemoveRight(new RemoveRightInStruct(right, groupID, objectID, objectType));
        return this.getLoadHelper().submit(chunk);
    }

    public synchronized int setRightBool(int right, String groupID, String objectID, String objectType, boolean value) throws SDKException {
        BatchInChunk chunk = new BatchInChunk();
        chunk.GrantRightBool(new GrantRightBoolInStruct(right, groupID, objectID, objectType, value));
        return this.getLoadHelper().submit(chunk);
    }

    public synchronized int setRightLong(int right, String groupID, String objectID, String objectType, int value) throws SDKException {
        BatchInChunk chunk = new BatchInChunk();
        chunk.GrantRightDWord(new GrantRightDWordInStruct(right, groupID, objectID, objectType, value));
        return this.getLoadHelper().submit(chunk);
    }

    public synchronized int setRightString(int right, String groupID, String objectID, String objectType, String value) throws SDKException {
        BatchInChunk chunk = new BatchInChunk();
        chunk.GrantRightString(new GrantRightStringInStruct(right, groupID, objectID, objectType, value));
        return this.getLoadHelper().submit(chunk);
    }

    public synchronized int getProgIdsWithCustomRights(String objectID, String objectType, ArrayHolder out) throws SDKException {
        CacheKey key = new CacheKey(objectID, objectType);
        CacheEntry entry = (CacheEntry)this.m_map.get(key);
        if (entry == null) {
            BatchInChunk chunk = new BatchInChunk();
            chunk.GetProgIdsWithCustomRights(new ProgIdsWithCustomRightsInStruct(objectID, objectType));
            this.m_checkHelper.submit(chunk);
            entry = (CacheEntry)this.m_map.get(key);
            LOG.assertNotNull((Object)entry, "entry is null.");
        }
        entry.touchTimeStamp();
        if (entry instanceof NoEntry) {
            return 4;
        }
        out.set(((StringEntry)entry).getValue());
        return 0;
    }

    public List batchProcess(BatchHelper helper) throws SDKException {
        try {
            List input = helper.input();
            BatchInChunk[] inputArr = new BatchInChunk[input.size()];
            System.arraycopy(input.toArray(), 0, inputArr, 0, input.size());
            BatchOutStreamHolder outHolder = new BatchOutStreamHolder();
            this.m_batchStub.Process(inputArr, outHolder);
            BatchOutChunk[] output = outHolder.value;
            return Arrays.asList(output);
        }
        catch (oca_abuse e) {
            throw SDKException.map(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchOutput(BatchHelper helper) throws SDKException {
        int epoch;
        CacheController cacheController = this;
        synchronized (cacheController) {
            epoch = this.m_epoch++;
        }
        Iterator out = helper.output().iterator();
        Iterator in = helper.input().iterator();
        while (out.hasNext()) {
            LOG.assertTrue(in.hasNext(), "Assertion failed");
            BatchInChunk inChunk = (BatchInChunk)in.next();
            BatchOutChunk outChunk = (BatchOutChunk)out.next();
            int outputCount = this.getOutputEntries(outChunk);
            for (int i = 0; i < outputCount; ++i) {
                BooleanHolder aggregateParentObjectHolder = new BooleanHolder();
                BooleanHolder aggregateParentGroupHolder = new BooleanHolder();
                CacheEntry entry = this.makeCacheEntry(outChunk, aggregateParentObjectHolder, aggregateParentGroupHolder, epoch);
                if (entry != null) {
                    boolean aggregateParentGroup;
                    boolean aggregateParentObject = aggregateParentObjectHolder.get();
                    CacheKey key = this.makeCacheKey(inChunk, aggregateParentObject, aggregateParentGroup = aggregateParentGroupHolder.get());
                    CacheEntry old = (CacheEntry)this.m_map.get(key);
                    if (old == null || !old.isAggregable() || old.getEpoch() != entry.getEpoch()) {
                        this.m_map.put(key, entry);
                    } else {
                        old.aggregate(entry);
                    }
                }
                if (!out.hasNext() || i >= outputCount - 1) continue;
                outChunk = (BatchOutChunk)out.next();
            }
        }
    }

    private CacheKey makeCacheKey(BatchInChunk chunk, boolean aggregateParentObject, boolean aggregateParentGroup) {
        switch (chunk.discriminator().value()) {
            case 3: {
                AdmLoadCacheInStruct struct = chunk.AdmLoadCacheBool();
                return new CacheKey(struct.RightID, struct.GroupID, struct.ObjectID, struct.ObjectType, aggregateParentObject, aggregateParentGroup);
            }
            case 4: {
                AdmLoadCacheInStruct struct = chunk.AdmLoadCacheDWord();
                return new CacheKey(struct.RightID, struct.GroupID, struct.ObjectID, struct.ObjectType, aggregateParentObject, aggregateParentGroup);
            }
            case 5: {
                AdmLoadCacheInStruct struct = chunk.AdmLoadCacheString();
                return new CacheKey(struct.RightID, struct.GroupID, struct.ObjectID, struct.ObjectType, aggregateParentObject, aggregateParentGroup);
            }
            case 0: {
                LoadCacheInStruct struct = chunk.LoadCacheBool();
                return new CacheKey(struct.RightID, struct.ObjectID, struct.ObjectType);
            }
            case 1: {
                LoadCacheInStruct struct = chunk.LoadCacheDWord();
                return new CacheKey(struct.RightID, struct.ObjectID, struct.ObjectType);
            }
            case 2: {
                LoadCacheInStruct struct = chunk.LoadCacheDWord();
                return new CacheKey(struct.RightID, struct.ObjectID, struct.ObjectType);
            }
            case 10: {
                PrincipalsInStruct struct = chunk.GetPrincipals();
                return new CacheKey(struct.ObjectID, struct.ObjectType);
            }
            case 11: {
                ProgIdsWithCustomRightsInStruct struct = chunk.GetProgIdsWithCustomRights();
                return new CacheKey(struct.ObjectID, struct.ObjectType);
            }
            case 13: {
                AdmLoadCacheExplicitInStruct struct = chunk.AdmLoadCacheExplicitBool();
                return new CacheKey(struct.ObjectID, 1);
            }
            case 14: {
                AdmLoadCacheExplicitInStruct struct = chunk.AdmLoadCacheExplicitDWord();
                return new CacheKey(struct.ObjectID, 1);
            }
        }
        LOG.assertTrue(false, "Assertion failed");
        return null;
    }

    private CacheEntry makeCacheEntry(BatchOutChunk chunk, BooleanHolder aggregateParentObject, BooleanHolder aggregateParentGroup, int epoch) throws SDKException {
        switch (chunk.discriminator().value()) {
            case 6: {
                AdmLoadCacheBoolOutStruct outStruct = chunk.AdmLoadCacheBool();
                aggregateParentGroup.set(outStruct.AggregateParentGroup);
                aggregateParentObject.set(outStruct.AggregateParentObject);
                return new BooleanEntry(outStruct.Right);
            }
            case 7: {
                AdmLoadCacheDWordOutStruct outStruct = chunk.AdmLoadCacheDWord();
                aggregateParentGroup.set(outStruct.AggregateParentGroup);
                aggregateParentObject.set(outStruct.AggregateParentObject);
                return new DWordEntry(outStruct.MinRight, outStruct.MaxRight);
            }
            case 8: {
                AdmLoadCacheStringOutStruct outStruct = chunk.AdmLoadCacheString();
                aggregateParentGroup.set(outStruct.AggregateParentGroup);
                aggregateParentObject.set(outStruct.AggregateParentObject);
                return new StringEntry(outStruct.Right);
            }
            case 5: {
                AdmRightInfoOutStruct outStruct = chunk.AdmRightInfo();
                aggregateParentGroup.set(outStruct.AggregateParentGroup);
                aggregateParentObject.set(outStruct.AggregateParentObject);
                return new NoEntry(outStruct.Reason);
            }
            case 2: {
                LoadCacheBoolOutStruct outStruct = chunk.LoadCacheBool();
                return new BooleanEntry(outStruct.Right);
            }
            case 3: {
                LoadCacheDWordOutStruct outStruct = chunk.LoadCacheDWord();
                return new DWordEntry(outStruct.MinRight, outStruct.MaxRight);
            }
            case 4: {
                LoadCacheStringOutStruct outStruct = chunk.LoadCacheString();
                return new StringEntry(outStruct.Right);
            }
            case 9: {
                PrincipalsOutStruct outStruct = chunk.Principals();
                IPrincipal[] principals = new IPrincipal[outStruct.Principals.length];
                for (int i = 0; i < outStruct.Principals.length; ++i) {
                    principals[i] = new Principal(outStruct.Principals[i]);
                }
                return new PrincipalsEntry(principals);
            }
            case 1: {
                RightInfoOutStruct outStruct = chunk.RightInfo();
                return new NoEntry(outStruct.Reason);
            }
            case 10: {
                ProgIdsWithCustomRightsOutStruct outStruct = chunk.Progids();
                return new StringEntry(outStruct.Progids);
            }
            case 12: {
                AdmLoadCacheExplicitBoolOutStruct outStruct = chunk.ExplicitBool();
                AdmLoadCacheExplicitBoolSeqElem[] elements = outStruct.Elements;
                HashMap<String, ArrayList<SecurityRight>> principals = new HashMap<String, ArrayList<SecurityRight>>();
                for (int i = 0; i < elements.length; ++i) {
                    AdmLoadCacheExplicitBoolSeqElem element = elements[i];
                    ArrayList<SecurityRight> rights = (ArrayList<SecurityRight>)principals.get(element.PrincipalID);
                    if (rights == null) {
                        rights = new ArrayList<SecurityRight>();
                        principals.put(element.PrincipalID, rights);
                    }
                    rights.add(new SecurityRight(element.Allowed, false, element.Right));
                }
                ArrayList<Principal> ps = new ArrayList<Principal>(principals.size());
                Set entries = principals.entrySet();
                Iterator iterator = entries.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String principalID = (String)entry.getKey();
                    Principal princ = new Principal(principalID);
                    List rights = (List)entry.getValue();
                    ISecurityRight[] rightsArray = rights.toArray(new ISecurityRight[rights.size()]);
                    princ.setRights(rightsArray);
                    ps.add(princ);
                }
                IPrincipal[] princs = ps.toArray(new IPrincipal[ps.size()]);
                return new ExplicitPrincipalsEntry(princs, epoch);
            }
            case 13: {
                AdmLoadCacheExplicitDWordOutStruct outStruct = chunk.ExplicitDWord();
                AdmLoadCacheExplicitDWordSeqElem[] elements = outStruct.Elements;
                HashMap<String, ArrayList<SecurityLimit>> principals = new HashMap<String, ArrayList<SecurityLimit>>();
                for (int i = 0; i < elements.length; ++i) {
                    AdmLoadCacheExplicitDWordSeqElem element = elements[i];
                    ArrayList<SecurityLimit> rights = (ArrayList<SecurityLimit>)principals.get(element.PrincipalID);
                    if (rights == null) {
                        rights = new ArrayList<SecurityLimit>();
                        principals.put(element.PrincipalID, rights);
                    }
                    rights.add(new SecurityLimit(element.Right, element.Value, false));
                }
                ArrayList<Principal> ps = new ArrayList<Principal>(principals.size());
                Set entries = principals.entrySet();
                Iterator iterator = entries.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String principalID = (String)entry.getKey();
                    Principal princ = new Principal(principalID);
                    List limits = (List)entry.getValue();
                    ISecurityLimit[] limitsArray = limits.toArray(new ISecurityLimit[limits.size()]);
                    princ.setLimits(limitsArray);
                    ps.add(princ);
                }
                IPrincipal[] princs = ps.toArray(new IPrincipal[ps.size()]);
                return new ExplicitPrincipalsEntry(princs, epoch);
            }
            case 0: {
                CallFailureOutStruct error = chunk.CallFailure();
                LOG.error((Object)("(makeCacheEntry:973): reason of failure:" + error.Reason + ", index:" + error.Index + ", call type:" + error.CallType.value()));
                return new NoEntry(0);
            }
        }
        LOG.assertTrue(false, "Assertion failed");
        return null;
    }

    private int AdjustEffectiveAggModeHelper(CacheKey inkey, int right, int aggBits, int effectiveAggMode) {
        boolean rightAggr = false;
        boolean princpal0RightAggre = false;
        CacheKey key = new CacheKey(inkey);
        key.m_rightID = right;
        CacheEntry entry = (CacheEntry)this.m_map.get(key);
        if (entry != null && !(entry instanceof NoEntry) && entry instanceof BooleanEntry) {
            rightAggr = ((BooleanEntry)entry).getValue();
        }
        if (right == 64) {
            CacheKey principal0key = new CacheKey(inkey);
            principal0key.m_rightID = right;
            principal0key.m_groupID = "#0";
            CacheEntry principal0entry = (CacheEntry)this.m_map.get(principal0key);
            if (principal0entry != null && !(principal0entry instanceof NoEntry) && principal0entry instanceof BooleanEntry) {
                princpal0RightAggre = ((BooleanEntry)principal0entry).getValue();
            }
        }
        if (rightAggr || princpal0RightAggre) {
            return effectiveAggMode &= aggBits;
        }
        return effectiveAggMode;
    }

    private int AdjustEffectiveAggMode(CacheKey key, int aggregationMode) {
        boolean isEffectiveBitSet;
        boolean bl = isEffectiveBitSet = (aggregationMode & 0x10) != 0;
        if (!isEffectiveBitSet) {
            return aggregationMode;
        }
        int adjustedAggMode = aggregationMode;
        adjustedAggMode = this.AdjustEffectiveAggModeHelper(key, 64, 5, adjustedAggMode);
        adjustedAggMode = this.AdjustEffectiveAggModeHelper(key, 63, 3, adjustedAggMode);
        return adjustedAggMode;
    }

    private CacheEntry getAggregatedEntry(CacheKey key, int aggregationMode) {
        CacheEntry aggrEntry = null;
        for (int bit = 0; bit < 4; ++bit) {
            if ((aggregationMode & 1 << bit) == 0) continue;
            key.setAggregationModes((bit & 1) != 0, (bit & 2) != 0);
            CacheEntry entry = (CacheEntry)this.m_map.get(key);
            if (entry != null && !(entry instanceof NoEntry)) {
                if (aggrEntry == null) {
                    aggrEntry = (CacheEntry)entry.clone();
                } else {
                    aggrEntry.aggregate(entry);
                }
            }
            if (entry == null) continue;
            entry.touchTimeStamp();
        }
        return aggrEntry;
    }

    private int getOutputEntries(BatchOutChunk chunk) {
        int tag = chunk.discriminator().value();
        if (tag == 6 || tag == 7 || tag == 8 || tag == 5) {
            return 4;
        }
        return 1;
    }

    private boolean isDataStillValid(CacheEntry entry) {
        if (entry == null) {
            return false;
        }
        long timeDiff = System.currentTimeMillis() - entry.m_createTime;
        return timeDiff >= 0L && timeDiff <= 60000L;
    }

    static class SecurityLimit
    implements ISecurityLimit {
        private int m_id;
        private int m_value;
        private boolean m_inherited;

        public SecurityLimit(int id, int value, boolean inherited) {
            this.m_id = id;
            this.m_value = value;
            this.m_inherited = inherited;
        }

        public int getID() {
            return this.m_id;
        }

        public void setValue(int lVal) {
            this.m_value = lVal;
        }

        public int getValue() {
            return this.m_value;
        }

        public boolean isMaximumValueUsed() {
            return false;
        }

        public boolean isInherited() {
            return this.m_inherited;
        }

        public void setInherited(boolean inherited) {
            this.m_inherited = inherited;
        }

        public String getDescription(Locale locale) {
            return null;
        }
    }

    static class SecurityRight
    implements ISecurityRight {
        private boolean m_value;
        private boolean m_inherited;
        private int m_id;

        public SecurityRight(boolean value, boolean inherited, int id) {
            this.m_value = value;
            this.m_inherited = inherited;
            this.m_id = id;
        }

        public boolean isGranted() {
            return this.m_value;
        }

        public void setGranted(boolean granted) {
            this.m_value = granted;
        }

        public int getID() {
            return this.m_id;
        }

        public boolean isInherited() {
            return this.m_inherited;
        }

        public boolean isOwner() {
            return false;
        }

        public String getDescription(Locale locale) {
            return null;
        }
    }

    static class ExplicitPrincipalsEntry
    extends CacheEntry {
        IPrincipal[] m_value;

        ExplicitPrincipalsEntry(IPrincipal[] value, int epoch) {
            super(epoch);
            this.m_value = value;
        }

        void aggregate(CacheEntry entry) {
            IPrincipal principal;
            int i;
            LOG.assertTrue(entry instanceof ExplicitPrincipalsEntry, "Assertion failed");
            ExplicitPrincipalsEntry other = (ExplicitPrincipalsEntry)entry;
            IPrincipal[] value = other.m_value;
            HashMap<Integer, IPrincipal> merged = new HashMap<Integer, IPrincipal>(this.m_value.length);
            for (i = 0; i < this.m_value.length; ++i) {
                principal = this.m_value[i];
                merged.put(new Integer(principal.getID()), principal);
            }
            for (i = 0; i < value.length; ++i) {
                principal = (Principal)value[i];
                Principal found = (Principal)merged.get(new Integer(((Principal)principal).getID()));
                if (found == null) {
                    merged.put(new Integer(((Principal)principal).getID()), principal);
                    continue;
                }
                ISecurityRight[] rights = (ISecurityRight[])ArraysHelper.mergeArrays((Object[])found.getExplicitRights(), (Object[])((Principal)principal).getExplicitRights());
                found.setRights(rights);
                ISecurityLimit[] limits = (ISecurityLimit[])ArraysHelper.mergeArrays((Object[])found.getExplicitLimits(), (Object[])((Principal)principal).getExplicitLimits());
                found.setLimits(limits);
            }
            this.m_value = merged.values().toArray(new IPrincipal[merged.size()]);
        }

        IPrincipal[] getValue() {
            return this.m_value;
        }

        boolean isAggregable() {
            return true;
        }
    }

    static class PrincipalsEntry
    extends CacheEntry {
        IPrincipal[] m_value;

        PrincipalsEntry(IPrincipal[] value) {
            this.m_value = value;
        }

        void aggregate(CacheEntry entry) {
            LOG.assertTrue(false, "Assertion failed");
        }

        IPrincipal[] getValue() {
            return this.m_value;
        }
    }

    static class DWordEntry
    extends CacheEntry {
        int m_minValue;
        int m_maxValue;

        DWordEntry(int min, int max) {
            this.m_minValue = min;
            this.m_maxValue = max;
        }

        void aggregate(CacheEntry entry) {
            LOG.assertTrue(entry instanceof DWordEntry, "Assertion failed");
            DWordEntry other = (DWordEntry)entry;
            this.m_maxValue = Math.max(this.m_maxValue, other.m_maxValue);
            this.m_minValue = Math.min(this.m_minValue, other.m_minValue);
        }

        int getMinValue() {
            return this.m_minValue;
        }

        int getMaxValue() {
            return this.m_maxValue;
        }
    }

    static class StringEntry
    extends CacheEntry {
        String[] m_value;

        StringEntry(String[] value) {
            this.m_value = value;
        }

        void aggregate(CacheEntry entry) {
            LOG.assertTrue(entry instanceof StringEntry, "Assertion failed");
            StringEntry other = (StringEntry)entry;
            String[] result = new String[this.m_value.length + other.m_value.length];
            System.arraycopy(this.m_value, 0, result, 0, this.m_value.length);
            System.arraycopy(other.m_value, 0, result, this.m_value.length, other.m_value.length);
            this.m_value = result;
        }

        String[] getValue() {
            return this.m_value;
        }
    }

    static class BooleanEntry
    extends CacheEntry {
        boolean m_value;

        BooleanEntry(boolean value) {
            this.m_value = value;
        }

        void aggregate(CacheEntry entry) {
            LOG.assertTrue(entry instanceof BooleanEntry, "Assertion failed");
            BooleanEntry other = (BooleanEntry)entry;
            this.m_value = this.m_value && other.m_value;
        }

        boolean getValue() {
            return this.m_value;
        }
    }

    static class NoEntry
    extends CacheEntry {
        int m_reason;

        NoEntry(int reason) {
            this.m_reason = reason;
        }

        void aggregate(CacheEntry entry) {
            LOG.assertTrue(false, "Assertion failed");
        }

        int getReason() {
            return this.m_reason;
        }
    }

    static abstract class CacheEntry
    implements Cloneable {
        private long m_createTime;
        private long m_time;
        private int m_epoch;

        CacheEntry() {
            this.setCreateTimeStamp();
            this.touchTimeStamp();
        }

        protected CacheEntry(int epoch) {
            this.m_epoch = epoch;
        }

        abstract void aggregate(CacheEntry var1);

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                LOG.assertTrue(false, "Assertion failed");
                return null;
            }
        }

        void touchTimeStamp() {
            this.m_time = System.currentTimeMillis();
        }

        private void setCreateTimeStamp() {
            this.m_createTime = System.currentTimeMillis();
        }

        boolean isAggregable() {
            return false;
        }

        int getEpoch() {
            return this.m_epoch;
        }
    }

    static class CacheKey {
        private static final int NO_ID = 0;
        private int m_rightID;
        private String m_groupID;
        private String m_objectID;
        private String m_objectType;
        private boolean m_aggregateParentGroup;
        private boolean m_aggregateParentObject;
        private int m_id = 0;

        CacheKey(String objectID, int id) {
            this(objectID, "");
            this.m_id = id;
        }

        CacheKey(String objectID, String objectType) {
            this.m_rightID = 0;
            this.m_objectID = objectID;
            this.m_objectType = objectType;
            this.m_groupID = "";
            this.m_aggregateParentObject = false;
            this.m_aggregateParentGroup = false;
        }

        CacheKey(int rightID, String objectID, String objectType) {
            this.m_rightID = rightID;
            this.m_objectID = objectID;
            this.m_objectType = objectType;
            this.m_groupID = "";
            this.m_aggregateParentObject = false;
            this.m_aggregateParentGroup = false;
        }

        CacheKey(int rightID, String groupID, String objectID, String objectType, boolean aggregateParentObject, boolean aggregateParentGroup) {
            this.m_rightID = rightID;
            this.m_objectID = objectID;
            this.m_objectType = objectType;
            this.m_groupID = groupID;
            this.m_aggregateParentObject = aggregateParentObject;
            this.m_aggregateParentGroup = aggregateParentGroup;
        }

        CacheKey(CacheKey src) {
            this.m_rightID = src.m_rightID;
            this.m_objectID = src.m_objectID;
            this.m_objectType = src.m_objectType;
            this.m_groupID = src.m_groupID;
            this.m_aggregateParentObject = src.m_aggregateParentObject;
            this.m_aggregateParentGroup = src.m_aggregateParentGroup;
            this.m_id = src.m_id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheKey) {
                CacheKey other = (CacheKey)obj;
                if (this.m_rightID != other.m_rightID) {
                    return false;
                }
                if (!this.m_groupID.equals(other.m_groupID)) {
                    return false;
                }
                if (this.m_aggregateParentGroup != other.m_aggregateParentGroup) {
                    return false;
                }
                if (this.m_aggregateParentObject != other.m_aggregateParentObject) {
                    return false;
                }
                if (!this.m_objectID.equals(other.m_objectID)) {
                    return false;
                }
                if (!this.m_objectType.equals(other.m_objectType)) {
                    return false;
                }
                return this.m_id == other.m_id;
            }
            return false;
        }

        public int hashCode() {
            return (int)(((long)this.m_groupID.hashCode() + (long)this.m_objectID.hashCode() + (long)this.m_objectType.hashCode() + (long)this.m_rightID) % Integer.MAX_VALUE + (long)this.m_id);
        }

        public void setAggregationModes(boolean aggregateParentObject, boolean aggregateParentGroup) {
            this.m_aggregateParentObject = aggregateParentObject;
            this.m_aggregateParentGroup = aggregateParentGroup;
        }
    }
}

