/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.security.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class LogonCred {
    private String m_username;
    private String m_password;
    private GSSCredential m_credential;
    private GSSManager m_manager;
    private boolean m_usePassword;

    public LogonCred(String username, String password) {
        this.m_username = username;
        this.m_password = password;
        this.m_usePassword = true;
    }

    public LogonCred(GSSCredential credential, GSSManager manager) throws SDKException {
        this.m_credential = credential;
        this.m_manager = manager;
        this.m_usePassword = false;
        try {
            this.m_username = ((Object)credential.getName()).toString();
        }
        catch (GSSException e) {
            throw new SDKException.Unexpected(e);
        }
    }

    public boolean UsePassword() {
        return this.m_usePassword;
    }

    public String GetUsername() {
        return this.m_username;
    }

    public String GetPassword() {
        return this.m_password;
    }

    public GSSCredential GetGSSCredential() {
        return this.m_credential;
    }

    public GSSManager GetGSSManager() {
        return this.m_manager;
    }

    public String toString() {
        String s = "user:" + this.m_username + ",method:";
        s = this.m_usePassword ? s + "password" : s + "GSSCredential";
        return s;
    }
}

